/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.util.ThreadedTask;
import java.util.ArrayList;
import java.util.List;

public abstract class ThreadedListProcessor
implements Runnable {
    private Thread thr = null;
    private List list = null;
    private String name = null;
    protected static final long DEFAULT_TIME = 10000L;

    public ThreadedListProcessor() {
        this(null);
    }

    public ThreadedListProcessor(String string) {
        this.name = string == null ? this.toString() : string;
    }

    protected long getLifeTime() {
        return 10000L;
    }

    protected abstract boolean startThreading(ThreadedTask var1);

    protected abstract void process(ThreadedTask var1);

    protected final synchronized void add(ThreadedTask threadedTask) {
        if (this.thr == null && this.startThreading(threadedTask)) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.thr = new Thread((Runnable)this, this.name);
            this.thr.start();
        }
        if (this.thr != null) {
            this.list.add(threadedTask);
            this.notify();
        } else {
            this.process(threadedTask);
        }
    }

    public synchronized void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.thr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = this.getLifeTime();
        while (true) {
            ThreadedTask threadedTask = null;
            ThreadedListProcessor threadedListProcessor = this;
            synchronized (threadedListProcessor) {
                if (this.thr == null) {
                    break;
                }
                if (this.list.size() == 0) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.list.size() <= 0) {
                    this.thr = null;
                    break;
                }
                threadedTask = (ThreadedTask)this.list.remove(0);
                if (threadedTask != null) {
                    this.process(threadedTask);
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
    }
}

