/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.ServiceInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ServiceManager {
    public static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    private static final String DEFAULT_HANDLER = "dedicated";
    Hashtable services = null;
    Hashtable servicehandlers = null;
    BrokerConfig config = Globals.getConfig();
    ConnectionManager conmgr = null;

    public ServiceManager(ConnectionManager connectionManager) {
        this.services = new Hashtable();
        this.servicehandlers = new Hashtable();
        this.conmgr = connectionManager;
    }

    private ServiceFactory createServiceFactory(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string2 = this.config.getProperty("imq.service_handler." + string + ".class");
        if (string2 == null) {
            throw new ClassNotFoundException(Globals.getBrokerResources().getString("B4117", "Unable to locate class for " + string + ", property is " + "imq" + ".service_handler." + string + ".class" + " value is " + string2));
        }
        ServiceFactory serviceFactory = (ServiceFactory)Class.forName(string2).newInstance();
        serviceFactory.setConnectionManager(this.conmgr);
        return serviceFactory;
    }

    private int getServiceStateProp(String string) {
        String string2 = this.config.getProperty("imq." + string + ".state");
        if (string2 == null) {
            return -1;
        }
        return ServiceState.getStateFromString(string2);
    }

    private void removeServiceStateProp(String string) throws IOException {
        this.config.updateRemoveProperty("imq." + string + ".state", true);
    }

    private void setServiceStateProp(String string, int n) {
        try {
            if (n != 4) {
                this.removeServiceStateProp(string);
                return;
            }
            String string2 = ServiceState.getString(n);
            this.config.updateProperty("imq." + string + ".state", string2);
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "storing service state for " + string, (Throwable)exception);
        }
    }

    private String getHandlerName(String string) {
        return this.config.getProperty("imq." + string + ".threadpool_model", DEFAULT_HANDLER);
    }

    public Service createService(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, BrokerException {
        String string2 = this.getHandlerName(string);
        ServiceFactory serviceFactory = (ServiceFactory)this.servicehandlers.get(string2);
        if (serviceFactory == null) {
            serviceFactory = this.createServiceFactory(string2);
            this.servicehandlers.put(string2, serviceFactory);
        }
        String string3 = this.config.getProperty("imq." + string + ".servicetype");
        int n = ServiceType.getServiceType(string3);
        if (DEBUG) {
            logger.log(4, "Creating service {0} of type {1}", (Object)string, ServiceType.getString(n));
        }
        Service service = serviceFactory.createService(string, n);
        ServiceInfo serviceInfo = new ServiceInfo(service, serviceFactory);
        this.services.put(string, serviceInfo);
        return service;
    }

    public List getAllServiceNames() {
        return this.config.getList("imq.service.list");
    }

    public List getAllActiveServiceNames() {
        return this.config.getList("imq.service.activelist");
    }

    public Set getAllActiveServices() {
        return this.services.keySet();
    }

    public int getServiceState(String string) {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo == null) {
            return -1;
        }
        return serviceInfo.getState();
    }

    public int getServiceType(String string) {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo == null) {
            return -1;
        }
        return serviceInfo.getServiceType();
    }

    public Service getService(String string) {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getService();
    }

    public void startService(String string, boolean bl) throws BrokerException {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo != null) {
            serviceInfo.start(bl);
            this.setServiceStateProp(string, 3);
        }
    }

    public void stopService(String string, boolean bl) throws BrokerException {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo != null) {
            serviceInfo.stop(bl);
        }
    }

    public void pauseService(String string, boolean bl) throws BrokerException {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo != null) {
            serviceInfo.pause(bl);
            this.setServiceStateProp(string, 4);
        }
    }

    public void resumeService(String string) throws BrokerException {
        ServiceInfo serviceInfo = (ServiceInfo)this.services.get(string);
        if (serviceInfo != null) {
            serviceInfo.resume();
            this.setServiceStateProp(string, 3);
        }
    }

    public void stopAllActiveServices(boolean bl) throws BrokerException {
        Set set = this.getAllActiveServices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Service service = this.getService(string);
            this.stopService(string, bl);
        }
    }

    public void pauseAllActiveServices(int n, boolean bl) throws BrokerException {
        Set set = this.getAllActiveServices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Service service = this.getService(string);
            if (this.getServiceType(string) != n || service.getState() != 3) continue;
            this.pauseService(string, bl);
        }
    }

    public void resumeAllActiveServices(int n) throws BrokerException {
        Set set = this.getAllActiveServices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Service service = this.getService(string);
            if (this.getServiceType(string) != n || service.getState() != 4) continue;
            this.resumeService(string);
        }
    }

    public void updateServiceList(List list) {
        this.updateServiceList(list, -1);
    }

    public void updateServiceList(List list, int n) {
        this.updateServiceList(list, n, false);
    }

    public void updateServiceList(List list, int n, boolean bl) {
        Object object;
        Set set = this.getAllActiveServices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (n != -1 && this.getServiceType(string) != n || list.contains(string)) continue;
            if (DEBUG) {
                logger.log(4, "Destroying service {0}", string);
            }
            object = (ServiceInfo)this.services.get(string);
            try {
                ((ServiceInfo)object).stop(true);
            }
            catch (Exception exception) {
                logger.logStack(16, "B2017", string, (Throwable)exception);
            }
            try {
                ((ServiceInfo)object).destroy();
            }
            catch (Exception exception) {
                logger.logStack(16, "B2018", string, (Throwable)exception);
            }
            this.setServiceStateProp(string, -1);
            this.services.remove(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            object = (String)list.get(i);
            if (DEBUG) {
                logger.log(4, "Checking service {0}", object);
            }
            ServiceInfo serviceInfo = (ServiceInfo)this.services.get(object);
            try {
                int n2;
                int n3 = this.getServiceStateProp((String)object);
                if (serviceInfo == null || serviceInfo.getState() == 7) {
                    if (DEBUG) {
                        logger.log(4, "Creating service {0}", object);
                    }
                    this.createService((String)object);
                }
                if (n != -1 && this.getServiceType((String)object) != n) continue;
                int n4 = n2 = serviceInfo == null ? -1 : serviceInfo.getState();
                if (n2 < 3 || n2 > 4) {
                    this.startService((String)object, bl);
                }
                if (n3 != 4 || n2 == 4) continue;
                logger.log(8, "B1124", object);
                this.pauseService((String)object, true);
                continue;
            }
            catch (BrokerException brokerException) {
                String string = brokerException.getMessage();
                if (brokerException.getCause() != null) {
                    string = string + ": " + brokerException.getCause().getMessage();
                }
                logger.log(32, "B3009", (String)object + ": " + string);
                logger.log(4, "", brokerException);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                logger.log(32, "B3009", object, throwable);
            }
        }
    }
}

