/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

class ServiceInfo {
    Service service;
    ServiceFactory handler;

    public ServiceInfo(Service service, ServiceFactory serviceFactory) {
        this.service = service;
        this.handler = serviceFactory;
    }

    public Service getService() {
        return this.service;
    }

    public ServiceFactory getServiceFactory() {
        return this.handler;
    }

    public int getState() {
        return this.service.getState();
    }

    public int getServiceType() {
        return this.service.getServiceType();
    }

    public void start(boolean bl) throws BrokerException {
        this.handler.updateService(this.service);
        this.handler.startMonitoringService(this.service);
        this.service.startService(bl);
    }

    public void stop(boolean bl) throws BrokerException {
        this.service.stopService(bl);
        this.handler.stopMonitoringService(this.service);
    }

    public void pause(boolean bl) throws BrokerException {
        this.service.pauseService(bl);
    }

    public void resume() throws BrokerException {
        this.service.resumeService();
    }

    public void destroy() throws BrokerException {
        this.stop(true);
        this.service.destroyService();
    }
}

