/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class Util
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    static int insertDstDIDIndex = 1;
    static int insertDstDestIndex = 2;
    static int insertMsgMIDIndex = 1;
    static int insertMsgDIDIndex = 2;
    static int insertMsgSizeIndex = 3;
    static int insertMsgMsgIndex = 4;
    static int deleteStatesMIDIndex = 1;
    static int insertMsgStateMIDIndex = 1;
    static int insertMsgStateCUIDIndex = 2;
    static int insertMsgStateDIDIndex = 3;
    static int insertMsgStateStateIndex = 4;
    static int insertInterestCUIDIndex = 1;
    static int insertInterestIntIndex = 2;
    static int insertTxnTidIndex = 1;
    static int insertTxnStateIndex = 2;
    static int insertTxnStateObjIndex = 3;
    static int insertTxnAckTidIndex = 1;
    static int insertTxnAckAckIndex = 2;
    static int insertCCRTimeIndex = 1;
    static int insertCCRRecordIndex = 2;
    static int insertPropertyNameIndex = 1;
    static int insertPropertyValueIndex = 2;

    Util() {
    }

    static ByteArrayInputStream setObject(PreparedStatement preparedStatement, int n, Object object) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return Util.setBytes(preparedStatement, n, byArray);
    }

    static ByteArrayInputStream setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
        return byteArrayInputStream;
    }

    static Object readObject(ResultSet resultSet, int n) throws IOException, SQLException, ClassNotFoundException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    static byte[] readBytes(ResultSet resultSet, int n) throws IOException, SQLException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, 256)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (EOFException eOFException) {
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String getInsertDestinationSQL(String string) {
        return "INSERT INTO " + string + " (" + "DID" + ", " + "DEST" + ") VALUES ( ?,? )";
    }

    static String getInsertMessageSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "DID" + ", " + "MSGSIZE" + ", " + "MSG" + ") VALUES ( ?,?,?,? )";
    }

    static String getDeleteStatesSQL(String string) {
        return "DELETE FROM " + string + " WHERE " + "MID" + "=?";
    }

    static String getInsertMessageStateSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "CUID" + ", " + "DID" + ", " + "STATE" + ") " + "VALUES ( ?,?,?,? )";
    }

    static String getInsertInterestSQL(String string) {
        return "INSERT INTO " + string + " (" + "CUID" + ", " + "INTEREST" + ") VALUES ( ?,? )";
    }

    static PreparedStatement getPreparedStatement(Connection connection, String string) throws BrokerException {
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4151", (Object)string, (Throwable)sQLException);
            throw new BrokerException(br.getString("B4151", string), sQLException);
        }
    }

    static String getInsertTxnSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "STATE" + ", " + "TSTATEOBJ" + ") VALUES ( ?,?,? )";
    }

    static String getInsertTxnAckSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "TXNACK" + ") VALUES ( ?,? )";
    }

    static String getInsertConfigRecordSQL(String string) {
        return "INSERT INTO " + string + " ( " + "RECORDTIME" + ", " + "RECORD" + ") " + "VALUES ( ?,? )";
    }

    static String getInsertPropertySQL(String string) {
        return "INSERT INTO " + string + " (" + "PROPNAME" + ", " + "PROPVALUE" + ") VALUES ( ?,? )";
    }
}

