/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

class DestTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private JDBCStore store = null;
    private HashMap destinationMap = new HashMap();

    DestTable(JDBCStore jDBCStore, boolean bl) throws BrokerException {
        this.store = jDBCStore;
        if (bl) {
            this.clearAll();
        } else {
            this.loadDestinations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeDestination(Destination destination) throws BrokerException {
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            if (this.destinationMap.get(destination.getUniqueName()) != null) {
                logger.log(32, "B3012", destination.getUniqueName());
                throw new BrokerException(br.getString("B3012", destination.getUniqueName()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.insertDstStmt.setString(1, destination.getUniqueName());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(dBConnection.insertDstStmt, 2, destination);
                    dBConnection.insertDstStmt.executeUpdate();
                    byteArrayInputStream.close();
                    this.destinationMap.put(destination.getUniqueName(), destination);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.insertDstSQL + "]", iOException);
                    logger.log(32, "B4014", (Object)destination.getUniqueName(), (Throwable)iOException2);
                    throw new BrokerException(br.getString("B4014", destination.getUniqueName()), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.insertDstSQL + "]", sQLException);
                    logger.log(32, "B4014", (Object)destination.getUniqueName(), (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4014", destination.getUniqueName()), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDestination(Destination destination) throws BrokerException {
        this.checkDestination(destination.getUniqueName());
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(dBConnection.updateDstStmt, 1, destination);
                    dBConnection.updateDstStmt.setString(2, destination.getUniqueName());
                    dBConnection.updateDstStmt.executeUpdate();
                    byteArrayInputStream.close();
                    this.destinationMap.put(destination.getUniqueName(), destination);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.updateDstSQL + "]", iOException);
                    logger.log(32, "B4014", (Object)destination.getUniqueName(), (Throwable)iOException2);
                    throw new BrokerException(br.getString("B4014", destination.getUniqueName()), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.updateDstSQL + "]", sQLException);
                    logger.log(32, "B4014", (Object)destination.getUniqueName(), (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4014", destination.getUniqueName()), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(Destination destination) throws BrokerException {
        Object var2_2 = null;
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            Object v = this.destinationMap.remove(destination.getUniqueName());
            var2_2 = v;
            if (v == null) {
                logger.log(32, "B3013", destination.getUniqueName());
                throw new BrokerException(br.getString("B3013", destination.getUniqueName()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(false);
                    dBConnection.deleteDstStmt.setString(1, destination.getUniqueName());
                    dBConnection.deleteDstStmt.executeUpdate();
                    this.store.getMsgTable().removeDestination(dBConnection, destination.getUniqueName());
                    dBConnection.getConnection().commit();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    try {
                        dBConnection.getConnection().rollback();
                    }
                    catch (SQLException sQLException2) {
                        logger.log(32, sQLException.getMessage(), sQLException2);
                    }
                    SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.deleteDstSQL + "]", sQLException);
                    logger.log(32, "B4014", (Object)destination.getUniqueName(), (Throwable)sQLException3);
                    throw new BrokerException(br.getString("B4014", destination.getUniqueName()), sQLException3);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Destination[] getAllDestinations() {
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            return this.destinationMap.values().toArray(new Destination[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getAllDestinationNames() {
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            return ((HashMap)this.destinationMap.clone()).keySet();
        }
    }

    private void loadDestinations() throws BrokerException {
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            ResultSet resultSet = dBConnection.selectAllDstsStmt.executeQuery();
            while (resultSet.next()) {
                try {
                    Destination destination = (Destination)Util.readObject(resultSet, 1);
                    this.destinationMap.put(destination.getUniqueName(), destination);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.selectAllDstsSQL + "]", iOException);
                    logger.logStack(32, "B4124", iOException2);
                }
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + new Integer(this.destinationMap.size()) + " DESTINATIONS FROM DATABASE");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4031", classNotFoundException);
            throw new BrokerException(br.getString("B4031"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllDstsSQL + "]", sQLException);
            logger.log(32, "B4031", sQLException2);
            throw new BrokerException(br.getString("B4031"), sQLException2);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Destinations(IMQDEST35)", String.valueOf(this.destinationMap.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "DestTable.clearAll() called");
        }
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAllDstsStmt.executeUpdate();
                    this.destinationMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllDstsSQL + "]", sQLException);
                    logger.log(32, "B4081", sQLException2);
                    throw new BrokerException(br.getString("B4081"), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "DestTable.close() called");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDestination(String string) throws BrokerException {
        HashMap hashMap = this.destinationMap;
        synchronized (hashMap) {
            if (!this.destinationMap.containsKey(string)) {
                logger.log(32, "B3013", string);
                throw new BrokerException(br.getString("B3013", string));
            }
        }
    }
}

