/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.JMQByteBufferOutputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MessageInfo {
    static final short PENDING = -1;
    static final short DONE = 0;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int ENTRY_SIZE = 12;
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private SysMessageID mid;
    private int packetSize;
    private DstMsgStore parent = null;
    private VRecordRAF vrecord = null;
    private HashMap iidMap = null;
    private int[] statearray = null;

    MessageInfo(DstMsgStore dstMsgStore, byte[] byArray, byte[] byArray2) throws IOException {
        this.parent = dstMsgStore;
        try {
            Packet packet;
            this.msg = packet = this.parseMessage(byArray);
            this.mid = (SysMessageID)packet.getSysMessageID().clone();
            this.parseInterestList(byArray2);
        }
        catch (IOException iOException) {
            logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", iOException);
            throw iOException;
        }
    }

    MessageInfo(DstMsgStore dstMsgStore, VRecordRAF vRecordRAF) throws IOException {
        this.parent = dstMsgStore;
        this.vrecord = vRecordRAF;
        try {
            Packet packet;
            this.msg = packet = this.parseMessage(vRecordRAF);
            this.mid = (SysMessageID)packet.getSysMessageID().clone();
            this.parseInterestList(vRecordRAF);
        }
        catch (IOException iOException) {
            this.parent.getVRFile().free(this.vrecord);
            throw iOException;
        }
    }

    MessageInfo(DstMsgStore dstMsgStore, VRFileRAF vRFileRAF, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException {
        this.parent = dstMsgStore;
        this.mid = (SysMessageID)packet.getSysMessageID().clone();
        this.packetSize = packet.getPacketSize();
        int n = 4 + this.packetSize + 4 + consumerUIDArray.length * 12;
        this.vrecord = (VRecordRAF)vRFileRAF.allocate(n);
        this.vrecord.setCookie((short)-1);
        this.vrecord.writeInt(this.packetSize);
        if (DstMsgStore.useFileChannel) {
            packet.writePacket(this.vrecord.getChannel(), false);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.packetSize);
            packet.writePacket(byteArrayOutputStream);
            this.vrecord.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.close();
        }
        this.storeStates(this.vrecord, consumerUIDArray, nArray, false);
        this.vrecord.setCookie((short)0);
        if (bl) {
            this.vrecord.force();
        }
    }

    MessageInfo(DstMsgStore dstMsgStore, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        this.parent = dstMsgStore;
        this.mid = (SysMessageID)packet.getSysMessageID().clone();
        this.packetSize = packet.getPacketSize();
        ByteBuffer byteBuffer = this.serializeStates(consumerUIDArray, nArray);
        byteBuffer.rewind();
        if (DstMsgStore.useFileChannel) {
            RandomAccessFile randomAccessFile = this.parent.getRAF(this.mid);
            DstMsgStore.markWriting(randomAccessFile);
            randomAccessFile.writeLong(this.packetSize);
            packet.writePacket(randomAccessFile.getChannel(), false);
            long l = randomAccessFile.getFilePointer();
            if (byteBuffer != null) {
                randomAccessFile.writeLong(byteBuffer.remaining());
                randomAccessFile.getChannel().write(byteBuffer);
            } else {
                randomAccessFile.writeLong(0L);
            }
            long l2 = randomAccessFile.getFilePointer();
            DstMsgStore.markGood(randomAccessFile);
            if (bl) {
                randomAccessFile.getChannel().force(false);
            }
            this.parent.releaseRAF(this.mid, randomAccessFile, l, l2);
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(new byte[this.packetSize]);
            JMQByteBufferOutputStream jMQByteBufferOutputStream = new JMQByteBufferOutputStream(byteBuffer2);
            packet.writePacket(jMQByteBufferOutputStream);
            jMQByteBufferOutputStream.close();
            byte[] byArray = byteBuffer != null ? byteBuffer.array() : null;
            this.parent.writeData(this.mid, byteBuffer2.array(), byArray, bl);
        }
    }

    synchronized Packet getMessage() throws IOException {
        if (this.msg == null) {
            if (this.vrecord != null) {
                try {
                    return this.parseMessage(this.vrecord);
                }
                catch (IOException iOException) {
                    logger.log(32, this.parent.myDestination + ":failed to parse message from vrecord(" + this.vrecord + ")", iOException);
                    throw iOException;
                }
            }
            try {
                byte[] byArray = this.parent.loadData(this.mid);
                return this.parseMessage(byArray);
            }
            catch (IOException iOException) {
                logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", iOException);
                throw iOException;
            }
        }
        Packet packet = this.msg;
        this.msg = null;
        return packet;
    }

    int getSize() {
        return this.packetSize;
    }

    SysMessageID getID() {
        return this.mid;
    }

    synchronized void free(boolean bl) throws IOException {
        if (this.vrecord != null) {
            this.parent.getVRFile().free(this.vrecord);
            if (bl) {
                this.parent.getVRFile().force();
            }
            this.vrecord = null;
        } else {
            this.parent.removeData(this.mid, bl);
        }
        this.mid = null;
        this.statearray = null;
        if (this.iidMap != null) {
            this.iidMap.clear();
            this.iidMap = null;
        }
    }

    synchronized void storeStates(ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (this.iidMap.size() != 0) {
            logger.log(16, "B3084", this.mid.toString());
            throw new BrokerException(br.getString("B3084", this.mid.toString()));
        }
        if (this.vrecord != null) {
            int n = 4 + this.packetSize + 4 + consumerUIDArray.length * 12;
            if (this.vrecord.getDataCapacity() < n) {
                this.vrecord.rewind();
                byte[] byArray = new byte[4 + this.packetSize];
                this.vrecord.read(byArray);
                VRecordRAF vRecordRAF = (VRecordRAF)this.parent.getVRFile().allocate(n);
                vRecordRAF.write(byArray);
                this.parent.getVRFile().free(this.vrecord);
                this.vrecord = vRecordRAF;
            }
            this.storeStates(this.vrecord, consumerUIDArray, nArray, bl);
        } else {
            byte[] byArray = this.serializeStates(consumerUIDArray, nArray).array();
            if (!this.parent.writeAttachment(this.mid, byArray, bl)) {
                this.iidMap = null;
                this.statearray = null;
                logger.log(32, "B3007", this.mid.toString());
                throw new BrokerException(br.getString("B3007", this.mid.toString()));
            }
        }
    }

    synchronized void updateState(ConsumerUID consumerUID, int n, boolean bl) throws IOException, BrokerException {
        Integer n2 = null;
        if (this.iidMap == null || (n2 = (Integer)this.iidMap.get(consumerUID)) == null) {
            logger.log(32, "B3014", (Object)consumerUID.toString(), this.mid.toString());
            throw new BrokerException(br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        int n3 = n2;
        if (this.statearray[n3] != n) {
            this.statearray[n3] = n;
            if (this.vrecord != null) {
                long l = 4 + this.packetSize + 4 + n3 * 12 + 8;
                this.vrecord.writeInt((int)l, n);
                if (bl) {
                    this.vrecord.force();
                }
            } else {
                long l = 4 + n3 * 12 + 8;
                if (!this.parent.writeAttachmentData(this.mid, l, n, bl)) {
                    logger.log(32, "B3007", this.mid.toString());
                    throw new BrokerException(br.getString("B3007", this.mid.toString()));
                }
            }
        }
    }

    synchronized int getInterestState(ConsumerUID consumerUID) throws BrokerException {
        Integer n = null;
        if (this.iidMap == null || (n = (Integer)this.iidMap.get(consumerUID)) == null) {
            logger.log(32, "B3014", (Object)consumerUID.toString(), this.mid.toString());
            throw new BrokerException(br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        return this.statearray[n];
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] consumerUIDArray = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList arrayList = new ArrayList();
            Set set = this.iidMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Integer n = (Integer)entry.getValue();
                if (this.statearray[n] == 2) continue;
                arrayList.add(entry.getKey());
            }
            consumerUIDArray = arrayList.toArray(consumerUIDArray);
        }
        return consumerUIDArray;
    }

    private void parseInterestList(VRecordRAF vRecordRAF) throws IOException {
        int n = 0;
        try {
            vRecordRAF.position(4 + this.packetSize);
            n = vRecordRAF.readInt();
            long l = (long)(4 + this.packetSize + 4) + (long)n * 12L;
            if (l > (long)vRecordRAF.getDataCapacity()) {
                throw new Exception("size of interest list is corrupted");
            }
            this.iidMap = new HashMap(n);
            this.statearray = new int[n];
            for (int i = 0; i < n; ++i) {
                ConsumerUID consumerUID = new ConsumerUID(vRecordRAF.readLong());
                this.statearray[i] = vRecordRAF.readInt();
                this.iidMap.put(consumerUID, new Integer(i));
            }
            if (Store.DEBUG) {
                logger.log(4, "loaded " + n + " interest states");
            }
        }
        catch (Throwable throwable) {
            logger.log(32, "failed to parse interest list(size=" + n + ") for msg(size=" + this.packetSize + ") from vrecord(" + vRecordRAF + ")", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    void parseInterestList(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            if (Store.DEBUG) {
                logger.log(1, "No interest list to load");
            }
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        this.iidMap = new HashMap(n);
        this.statearray = new int[n];
        for (int i = 0; i < n; ++i) {
            ConsumerUID consumerUID = new ConsumerUID(dataInputStream.readLong());
            this.statearray[i] = dataInputStream.readInt();
            this.iidMap.put(consumerUID, new Integer(i));
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        if (Store.DEBUG) {
            logger.log(4, "loaded " + n + " interest states");
        }
    }

    private Packet parseMessage(byte[] byArray) throws IOException {
        this.packetSize = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
        Packet packet = new Packet(false);
        packet.generateTimestamp(false);
        packet.generateSequenceNumber(false);
        packet.readPacket(jMQByteBufferInputStream);
        jMQByteBufferInputStream.close();
        return packet;
    }

    private Packet parseMessage(VRecordRAF vRecordRAF) throws IOException {
        try {
            vRecordRAF.rewind();
            this.packetSize = vRecordRAF.readInt();
            Packet packet = new Packet();
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            if (DstMsgStore.useFileChannel) {
                packet.readPacket(vRecordRAF.getChannel(), false);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[this.packetSize]);
                vRecordRAF.read(byteBuffer.array());
                JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
                packet.readPacket(jMQByteBufferInputStream);
                jMQByteBufferInputStream.close();
            }
            return packet;
        }
        catch (Throwable throwable) {
            logger.log(32, this.parent.myDestination + ":failed to parse message(size=" + this.packetSize + ") from vrecord(" + vRecordRAF + ")", throwable);
            IOException iOException = new IOException(throwable.toString());
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
    }

    private void storeStates(VRecordRAF vRecordRAF, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.serializeStates(consumerUIDArray, nArray);
        byteBuffer.rewind();
        vRecordRAF.position(4 + this.packetSize);
        vRecordRAF.write(byteBuffer);
        if (bl) {
            vRecordRAF.force();
        }
    }

    ByteBuffer serializeStates(ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException {
        int n = consumerUIDArray.length;
        this.iidMap = new HashMap(n);
        this.statearray = new int[n];
        int n2 = 4 + n * 12;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n2]);
        byteBuffer.putInt(n);
        for (int i = 0; i < n; ++i) {
            byteBuffer.putLong(consumerUIDArray[i].longValue());
            byteBuffer.putInt(nArray[i]);
            this.iidMap.put(consumerUIDArray[i], new Integer(i));
            this.statearray[i] = nArray[i];
        }
        return byteBuffer;
    }
}

