/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.ConfigChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.file.DestinationList;
import com.sun.messaging.jmq.jmsserver.persist.file.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.PropertiesFile;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class FileStore
extends Store {
    static final String FILE_PROP_PREFIX = "imq.persist.file.";
    static final String SYNC_ENABLED_PROP = "imq.persist.file.sync.enabled";
    static final String SYNC_ALL_PROP = "imq.persist.file.sync.all";
    static final boolean DEFAULT_SYNC_ENABLED = false;
    static final boolean DEFAULT_SYNC_ALL = false;
    static final String FILESTORE_BASENAME = "fs";
    static final String FILESTORE_TOP = "fs350";
    static final String FILESTORE200_TOP = "filestore";
    static final String VERSIONFILE = "version";
    static boolean syncEnabled = false;
    static boolean syncAll = false;
    private File rootDir = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private DestinationList dstList = null;
    private TidList tidList = null;
    private ConfigChangeRecord configStore = null;
    private PropertiesFile propFile = null;
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private static FilenameFilter storeFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory() && string.startsWith(FileStore.FILESTORE_BASENAME);
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileStore() throws BrokerException {
        File file;
        syncEnabled = this.config.getBooleanProperty(SYNC_ENABLED_PROP, false);
        String string = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        this.logger.logToAll(8, this.br.getString("B1141", string));
        if (Store.DEBUG) {
            this.logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        syncAll = this.config.getBooleanProperty(SYNC_ALL_PROP, false);
        if (Store.DEBUG) {
            this.logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        File file2 = new File(string2);
        boolean bl = this.checkFileStore(file2);
        this.rootDir = new File(file2, FILESTORE_TOP);
        if (this.removeStore) {
            try {
                FileUtil.removeFiles(this.rootDir, true);
                return;
            }
            catch (IOException iOException) {
                this.logger.log(32, "B3120", (Object)this.rootDir, (Throwable)iOException);
                throw new BrokerException(this.br.getString("B3120", this.rootDir), iOException);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            this.logger.log(32, "B3017", this.rootDir.toString());
            throw new BrokerException(this.br.getString("B3017", this.rootDir.toString()));
        }
        File file3 = file = bl ? new File(file2, FILESTORE200_TOP) : null;
        if (bl) {
            try {
                Object[] objectArray = new Object[]{new Integer(350), FILESTORE_TOP};
                this.logger.logToAll(8, "B1105", objectArray);
                if (this.resetMessage) {
                    this.logger.logToAll(8, "B1101");
                    this.logger.logToAll(8, "B1102");
                } else if (this.resetInterest) {
                    this.logger.logToAll(8, "B1103");
                    this.logger.logToAll(8, "B1102");
                }
                this.dstList = new DestinationList(this, this.rootDir, file);
                this.msgStore = new MsgStore(this, this.rootDir, file, this.resetMessage);
                this.intStore = new InterestStore(this, this.rootDir, file, this.resetInterest);
                this.tidList = new TidList(this, this.rootDir, file);
                this.propFile = new PropertiesFile(this, this.rootDir, file);
                this.configStore = new ConfigChangeRecord(this, this.rootDir, file);
                if (Store.DEBUG) {
                    this.logger.log(4, "FileStore upgraded successfully.");
                }
                if (this.upgradeNoBackup) {
                    try {
                        FileUtil.removeFiles(file, true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.logger.logToAll(8, "B1106");
                if (this.upgradeNoBackup) return;
                Object[] objectArray2 = new Object[]{file};
                this.logger.logToAll(8, "B1099", objectArray2);
                return;
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "B1110", this.rootDir);
                try {
                    FileUtil.removeFiles(this.rootDir, true);
                    throw brokerException;
                }
                catch (IOException iOException) {
                    this.logger.log(32, "B3120", (Object)this.rootDir, (Throwable)brokerException);
                }
                throw brokerException;
            }
        }
        this.dstList = new DestinationList(this, this.rootDir, this.resetStore);
        this.msgStore = new MsgStore(this, this.rootDir, this.resetStore || this.resetMessage);
        this.intStore = new InterestStore(this.rootDir, this.resetStore || this.resetInterest);
        this.tidList = new TidList(this.rootDir, this.resetStore);
        this.configStore = new ConfigChangeRecord(this.rootDir, this.resetStore);
        this.propFile = new PropertiesFile(this.rootDir, this.resetStore);
        if (!Store.DEBUG) return;
        this.logger.log(4, "FileStore instantiated successfully.");
    }

    public LoadException getLoadDestinationException() {
        return this.dstList.getLoadException();
    }

    public LoadException getLoadConsumerException() {
        return this.intStore.getLoadException();
    }

    public LoadException getLoadPropertyException() {
        return this.propFile.getLoadException();
    }

    public LoadException getLoadTransactionException() {
        return this.tidList.getLoadException();
    }

    public LoadException getLoadTransactionAckException() {
        return this.tidList.getLoadTransactionAckException();
    }

    public void close(boolean bl) {
        super.setClosedAndWait();
        this.dstList.close(bl);
        this.tidList.close(bl);
        this.configStore.close(bl);
        this.propFile.close(bl);
        this.intStore.close(bl);
        this.msgStore.close(bl);
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.close(" + bl + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.clearAll() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll(bl);
            this.intStore.clearAll(bl);
            this.dstList.clearAll(bl, false);
            this.tidList.clearAll(bl);
            this.configStore.clearAll(bl);
            this.propFile.clearAll(bl);
            if (Store.DEBUG) {
                this.logger.log(4, "File store cleared");
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        DestinationUID destinationUID = DestinationUID.getUID(packet.getDestination(), packet.getIsQueue());
        this.storeMessage(destinationUID, packet, consumerUIDArray, nArray, bl);
    }

    public void storeMessage(Packet packet, boolean bl) throws IOException, BrokerException {
        DestinationUID destinationUID = DestinationUID.getUID(packet.getDestination(), packet.getIsQueue());
        this.storeMessage(destinationUID, packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeMessage() called for " + packet.getSysMessageID());
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null || packet == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(this.br.getString("B3085"));
            }
            this.msgStore.storeMessage(destinationUID, packet, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeMessage() called for " + packet.getSysMessageID());
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.storeMessage(destinationUID, packet, emptyiid, emptystate, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeMessage(SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        this.removeMessage(null, sysMessageID, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeMessage() called for " + destinationUID + ";" + sysMessageID);
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeMessage(destinationUID, sysMessageID, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.moveMessage() called for: " + packet.getSysMessageID() + " from " + destinationUID + " to " + destinationUID2);
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray == null) {
            consumerUIDArray = emptyiid;
            nArray = emptystate;
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(packet, destinationUID, destinationUID2, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeAllMessages(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.messageEnumeration() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration();
            return enumeration;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.messageEnumeration(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(destination.getDestinationUID());
            return enumeration;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public Packet getMessage(SysMessageID sysMessageID) throws BrokerException {
        return this.getMessage(null, sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getMessage() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(destinationUID, sysMessageID);
            return packet;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        this.storeInterestStates(null, sysMessageID, consumerUIDArray, nArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeInterestStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(this.br.getString("B3085"));
            }
            this.msgStore.storeInterestStates(destinationUID, sysMessageID, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        this.updateInterestState(null, sysMessageID, consumerUID, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.updateInterestState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, n, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public int getInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        return this.getInterestState(null, sysMessageID, consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getInterestState() called");
        }
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(destinationUID, sysMessageID, consumerUID);
            return n;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public ConsumerUID[] getConsumerUIDs(SysMessageID sysMessageID) throws BrokerException {
        return this.getConsumerUIDs(null, sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getConsumerUIDs() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(destinationUID, sysMessageID);
            return consumerUIDArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(consumer, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(consumer, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getAllInterests() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            return consumerArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.storeDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.updateDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.updateDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.removeDestination(destination, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getAllDestinations() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstList.getAllDestinations();
            return destinationArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionState == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransaction(transactionUID, transactionState, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.removeTransaction(transactionUID, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.updateTransactionState( id=" + transactionUID + ", ts=" + n + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.updateTransactionState(transactionUID, n, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getAllTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllTransactionStates();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllTransactions(boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.clearAllTransactions() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.clearAll(bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransactions(int n, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.clearTransactions(state=" + n + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.clear(n, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeTransactionAck() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionAcknowledgement == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransactionAck(transactionUID, transactionAcknowledgement, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.removeTransactionAck() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.removeTransactionAck(transactionUID, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.tidList.getTransactionAcks(transactionUID);
            return transactionAcknowledgementArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getAllTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.updateProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            this.propFile.updateProperty(string, object, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            Object object = this.propFile.getProperty(string);
            return object;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyNames() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getPropertyNames() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propFile.getPropertyNames();
            return stringArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.storeConfigChangeRecord() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (l <= 0L) {
                this.logger.log(32, "B3074", new Long(l));
                throw new BrokerException(this.br.getString("B3074", new Long(l)));
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.configStore.storeConfigChangeRecord(l, byArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConfigChangeRecordsSince(long l) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getConfigChangeRecordsSince() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList arrayList = this.configStore.getConfigChangeRecordsSince(l);
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllConfigRecords() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getAllConfigRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Object[] objectArray = this.configStore.getAllConfigRecords();
            return objectArray;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.clearAllConfigChangeRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.configStore.clearAll(bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getMessageCount(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getMessageCount(destination.getDestinationUID());
            return n;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getByteCount(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getByteCount(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            long l = this.msgStore.getByteCount(destination.getDestinationUID());
            return l;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public String getStoreType() {
        return "file";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.getStorageInfo(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            return hashMap;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("File-based store", this.rootDir.getPath());
        hashtable.put("Store version", String.valueOf(350));
        hashtable.putAll(this.dstList.getDebugState());
        hashtable.putAll(this.msgStore.getDebugState());
        hashtable.putAll(this.intStore.getDebugState());
        hashtable.putAll(this.tidList.getDebugState());
        hashtable.putAll(this.propFile.getDebugState());
        hashtable.putAll(this.configStore.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactDestination(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "FileStore.compactDestination(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.compactDestination(destination);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public int getNumberOfTxnAcks() {
        return this.tidList.getNumberOfTxnAcks();
    }

    MsgStore getMsgStore() {
        return this.msgStore;
    }

    DestinationList getDstStore() {
        return this.dstList;
    }

    private boolean checkFileStore(File file) throws BrokerException {
        String[] stringArray;
        boolean bl = false;
        if (Store.DEBUG) {
            this.logger.log(4, "topDir=" + file);
        }
        if ((stringArray = file.list(storeFilter)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(FILESTORE_TOP) || stringArray[i].equals(FILESTORE200_TOP)) continue;
                File file2 = new File(file, stringArray[i]);
                this.logger.log(32, "B3129", file2);
                throw new BrokerException(this.br.getString("B3129", file2));
            }
        }
        File file3 = new File(file, FILESTORE_TOP);
        File file4 = new File(file, FILESTORE200_TOP);
        if (file3.exists()) {
            if (file4.exists() && !this.removeStore) {
                Object[] objectArray = new Object[]{file4};
                this.logger.logToAll(8, "B1107", objectArray);
            }
        } else if (file4.exists()) {
            this.checkOldVersion(new File(file4, VERSIONFILE), 200);
            if (this.removeStore) {
                Object[] objectArray = new Object[]{file4};
                this.logger.logToAll(8, "B1104", objectArray);
            } else if (this.resetStore) {
                Object[] objectArray = new Object[]{file4};
                this.logger.logToAll(8, "B1100", objectArray);
                this.logger.logToAll(8, "B1114");
                try {
                    FileUtil.removeFiles(file4, true);
                }
                catch (IOException iOException) {
                    this.logger.log(32, "B3117", (Object)file4, (Throwable)iOException);
                    throw new BrokerException(this.br.getString("B3117", file4), iOException);
                }
            } else {
                Object[] objectArray = new Object[]{new Integer(200)};
                this.logger.logToAll(8, "B1109", objectArray);
                if (this.upgradeNoBackup && !Broker.force) {
                    this.getConfirmation();
                }
                bl = true;
            }
        }
        return bl;
    }

    private void checkOldVersion(File file, int n) throws BrokerException {
        if (!file.exists()) {
            this.logger.log(32, "B3126", file);
            throw new BrokerException(this.br.getString("B3126", file));
        }
        RandomAccessFile randomAccessFile = null;
        int n2 = 0;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string = randomAccessFile.readLine();
            randomAccessFile.close();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, "B3125", string, Integer.toString(200), numberFormatException);
                throw new BrokerException(this.br.getString("B3125", string, Integer.toString(200)), numberFormatException);
            }
            if (n2 != n) {
                this.logger.log(32, "B3125", (Object)string, Integer.toString(200));
                throw new BrokerException(this.br.getString("B3125", string, Integer.toString(200)));
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4114", iOException);
            throw new BrokerException(this.br.getString("B4114"), iOException);
        }
    }
}

