/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DstMsgStore
extends RandomAccessStore {
    static BrokerConfig config = Globals.getConfig();
    static final String USE_FILE_CHANNEL_PROP = "imq.persist.file.message.use_file_channel";
    static final boolean DEFAULT_USE_FILE_CHANNEL = false;
    static String VRFILE_NAME = "vrfile";
    static boolean useFileChannel = config.getBooleanProperty("imq.persist.file.message.use_file_channel", false);
    DestinationUID myDestination = null;
    private MsgStore parent = null;
    private HashMap messageMap = new HashMap();
    private boolean loaded = false;
    private Object loadlock = new Object();
    private static FilenameFilter vrfileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return !string.equals(VRFILE_NAME);
        }
    };
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private VRFileRAF vrfile = null;
    int maxRecordSize = 0;
    private static final Enumeration emptyEnum = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    DstMsgStore(MsgStore msgStore, DestinationUID destinationUID, File file) throws BrokerException {
        this(msgStore, destinationUID, file, false);
    }

    DstMsgStore(MsgStore msgStore, DestinationUID destinationUID, File file, boolean bl) throws BrokerException {
        super(file, msgStore.msgfdlimit, msgStore.poollimit, msgStore.cleanratio);
        this.parent = msgStore;
        this.myDestination = destinationUID;
        try {
            long l = msgStore.initialFileSize.getBytes();
            if (l > 0L) {
                this.maxRecordSize = (int)msgStore.maxRecordSize.getBytes();
                this.vrfile = new VRFileRAF(new File(file, VRFILE_NAME), l);
                this.vrfile.setBlockSize(msgStore.blockSize);
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning vRFileWarning) {
                    logger.log(16, "possible data loss for " + this.myDestination, vRFileWarning);
                }
            }
            this.initCounts();
        }
        catch (IOException iOException) {
            logger.log(32, "B4147", file, destinationUID, iOException);
            throw new BrokerException(br.getString("B4147", file, destinationUID), iOException);
        }
        catch (Throwable throwable) {
            logger.log(32, "B4147", file, destinationUID, throwable);
            throw new BrokerException(br.getString("B4147", file, destinationUID), throwable);
        }
        if (bl) {
            this.loadMessages();
        }
    }

    public HashMap getStorageInfo() throws BrokerException {
        if (this.vrfile == null) {
            return new HashMap();
        }
        HashMap<String, Number> hashMap = new HashMap<String, Number>(3);
        long l = this.vrfile.getBytesUsed();
        long l2 = this.vrfile.getBytesFree();
        hashMap.put(DestMetricsCounters.DISK_USED, new Long(l));
        hashMap.put(DestMetricsCounters.DISK_RESERVED, new Long(l + l2));
        hashMap.put(DestMetricsCounters.DISK_UTILIZATION_RATIO, new Integer((int)(this.vrfile.getUtilizationRatio() * 100.0f)));
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compact() throws BrokerException {
        if (this.vrfile == null) {
            return;
        }
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            try {
                this.vrfile.close();
                try {
                    this.vrfile.compact();
                }
                catch (VRFileWarning vRFileWarning) {
                    logger.log(16, "possible data loss for " + this.myDestination, vRFileWarning);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning vRFileWarning) {
                    logger.log(16, "possible data loss for " + this.myDestination, vRFileWarning);
                }
                this.messageMap.clear();
                Iterator iterator = this.vrfile.getRecords().iterator();
                MsgEnumeration msgEnumeration = new MsgEnumeration(this, iterator, emptyEnum);
                while (msgEnumeration.hasMoreElements()) {
                    msgEnumeration.nextElement();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException("Failed to compact file: " + this.vrfile.getFile(), iOException);
            }
        }
    }

    MessageInfo storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        Object var6_6 = null;
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            var6_6 = this.messageMap.get(sysMessageID);
            if (var6_6 != null) {
                logger.log(32, "B3008", sysMessageID.toString());
                throw new BrokerException(br.getString("B3008", sysMessageID.toString()));
            }
            try {
                int n = packet.getPacketSize();
                MessageInfo messageInfo = null;
                messageInfo = this.vrfile != null && (this.maxRecordSize == 0 || n < this.maxRecordSize) ? new MessageInfo(this, this.vrfile, packet, consumerUIDArray, nArray, bl) : new MessageInfo(this, packet, consumerUIDArray, nArray, bl);
                this.messageMap.put(messageInfo.getID(), messageInfo);
                this.incrMsgCount(n);
                return messageInfo;
            }
            catch (IOException iOException) {
                logger.log(32, "B4004", (Object)sysMessageID.toString(), (Throwable)iOException);
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessage(SysMessageID sysMessageID, boolean bl) throws IOException, BrokerException {
        MessageInfo messageInfo = null;
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            messageInfo = (MessageInfo)this.messageMap.remove(sysMessageID);
            if (messageInfo == null) {
                logger.log(32, "B3007", sysMessageID.toString());
                throw new BrokerException(br.getString("B3007", sysMessageID.toString()));
            }
            messageInfo.free(bl);
        }
        this.decrMsgCount(messageInfo.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllMessages(boolean bl) throws IOException, BrokerException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            if (this.vrfile != null) {
                this.vrfile.clear(false);
            }
            this.removeAllData(bl);
            this.messageMap.clear();
            this.clearCounts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMessageDir(boolean bl) throws IOException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            if (this.vrfile != null) {
                this.vrfile.clear(false);
                this.vrfile.close();
                this.vrfile = null;
            }
            this.reset(true);
            super.close(false);
            this.messageMap.clear();
            this.clearCounts();
        }
    }

    Enumeration messageEnumeration() {
        if (this.getLoadedFlag()) {
            return new MsgEnumeration(this, this.getMessageIterator());
        }
        Iterator iterator = null;
        if (this.vrfile != null) {
            iterator = this.vrfile.getRecords().iterator();
        }
        return new MsgEnumeration(this, iterator, this.getEnumeration(false));
    }

    int getMessageCount() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(4, "DstMsgStore:getMessageCount()");
        }
        return this.msgCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(4, "DstMsgStore:getByteCount()");
        }
        return this.byteCount;
    }

    protected void close(boolean bl) {
        if (this.vrfile != null) {
            this.vrfile.close();
        }
        super.close(bl);
        this.messageMap.clear();
    }

    VRFileRAF getVRFile() {
        return this.vrfile;
    }

    void loadMessages() throws BrokerException {
        Enumeration enumeration = this.messageEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
        logger.log(4, "loaded " + this.messageMap.size() + " messages");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageInfo getMessageInfo(SysMessageID sysMessageID) throws BrokerException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
            if (messageInfo == null) {
                logger.log(32, "B3007", sysMessageID.toString());
                throw new BrokerException(br.getString("B3007", sysMessageID.toString()));
            }
            return messageInfo;
        }
    }

    Object parseData(byte[] byArray, byte[] byArray2) throws IOException {
        MessageInfo messageInfo = new MessageInfo(this, byArray, byArray2);
        SysMessageID sysMessageID = messageInfo.getID();
        this.messageMap.put(sysMessageID, messageInfo);
        return sysMessageID;
    }

    FilenameFilter getFilenameFilter() {
        return vrfileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMessageInfo(MessageInfo messageInfo) {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            this.messageMap.put(messageInfo.getID(), messageInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getMessageIterator() {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            return this.messageMap.keySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLoadedFlag() {
        Object object = this.loadlock;
        synchronized (object) {
            return this.loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLoadedFlag(boolean bl) {
        Object object = this.loadlock;
        synchronized (object) {
            this.loaded = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.DEBUG) {
            logger.log(4, "DstMsgStore:clearCounts for " + this.myDestination);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() throws BrokerException {
        Object object;
        Object object2;
        if (this.vrfile != null) {
            object2 = this.vrfile.getRecords();
            object = object2.iterator();
            while (object.hasNext()) {
                VRecordRAF vRecordRAF = (VRecordRAF)object.next();
                short s = vRecordRAF.getCookie();
                if (s == -1 || s != 0) {
                    String string = this.myDestination + ": found a " + "corrupted message at vrecord(" + vRecordRAF + "), a message might be lost";
                    logger.log(16, string);
                    try {
                        this.vrfile.free(vRecordRAF);
                    }
                    catch (IOException iOException) {
                        logger.log(32, "Failed to free the corrupted vrecord: " + iOException);
                    }
                    continue;
                }
                try {
                    ++this.msgCount;
                    this.byteCount += (long)vRecordRAF.readInt();
                }
                catch (Throwable throwable) {
                    logger.log(32, "B4148", (Object)this.vrfile.getFile(), throwable);
                    throw new BrokerException(br.getString("B4148", this.vrfile.getFile()), throwable);
                }
            }
        }
        object2 = super.getEnumeration(true);
        while (object2.hasMoreElements()) {
            ++this.msgCount;
            object = (Long)object2.nextElement();
            this.byteCount += ((Long)object).longValue();
        }
        if (Store.DEBUG) {
            logger.log(4, "DstMsgStore: initialized msg count=" + this.msgCount + "; byte count = " + this.byteCount);
        }
    }

    Hashtable getDebugState() {
        int n = 0;
        if (this.vrfile != null) {
            n = this.vrfile.getNRecords();
        }
        int n2 = this.msgCount - n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(this.myDestination + ":messages in vrfile", String.valueOf(n));
        hashtable.put(this.myDestination + ":messages in its own file", String.valueOf(n2));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            this.getMessageInfo(sysMessageID).storeStates(consumerUIDArray, nArray, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws IOException, BrokerException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            this.getMessageInfo(sysMessageID).updateState(consumerUID, n, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMsg(SysMessageID sysMessageID) {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            return this.messageMap.containsKey(sysMessageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet getMessage(SysMessageID sysMessageID) throws IOException, BrokerException {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            MessageInfo messageInfo = (MessageInfo)this.messageMap.get(sysMessageID);
            if (messageInfo == null) {
                logger.log(32, "B3007", sysMessageID);
                throw new BrokerException(br.getString("B3007", sysMessageID));
            }
            return messageInfo.getMessage();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Iterator recitr = null;
        Enumeration enum = null;
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore dstMsgStore, Iterator iterator) {
            this.parent = dstMsgStore;
            this.itr = iterator;
        }

        MsgEnumeration(DstMsgStore dstMsgStore, Iterator iterator, Enumeration enumeration) {
            this.parent = dstMsgStore;
            this.recitr = iterator;
            this.enum = enumeration;
        }

        public boolean hasMoreElements() {
            Object var1_1 = null;
            if (this.itr != null) {
                if (this.itr.hasNext()) {
                    this.objToReturn = this.itr.next();
                    return true;
                }
                return false;
            }
            if (this.recitr != null) {
                while (this.recitr.hasNext()) {
                    try {
                        MessageInfo messageInfo = new MessageInfo(this.parent, (VRecordRAF)this.recitr.next());
                        this.objToReturn = messageInfo.getMessage();
                        this.parent.cacheMessageInfo(messageInfo);
                        return true;
                    }
                    catch (IOException iOException) {
                        RandomAccessStore.logger.log(32, "B4143", (Object)this.parent.myDestination, (Throwable)iOException);
                    }
                }
            }
            if (this.enum.hasMoreElements()) {
                this.objToReturn = this.enum.nextElement();
                return true;
            }
            this.parent.setLoadedFlag(true);
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object object = null;
                if (this.objToReturn instanceof SysMessageID) {
                    try {
                        object = this.parent.getMessage((SysMessageID)this.objToReturn);
                    }
                    catch (IOException iOException) {
                        RandomAccessStore.logger.log(32, "B4005", this.objToReturn, this.parent.myDestination, iOException);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException brokerException) {
                        RandomAccessStore.logger.log(32, "B4005", this.objToReturn, this.parent.myDestination, brokerException);
                        throw new NoSuchElementException();
                    }
                } else {
                    object = this.objToReturn;
                }
                this.objToReturn = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

