/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class StoreManager {
    private static final String PERSIST_PROP = "imq.persist.";
    private static final String CLASS_PROP = ".class";
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    private static final String DEFAULT_STORE_TYPE = "file";
    private static final String DEFAULT_FILESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.file.FileStore";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore";
    private static Store store = null;
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Store getStore() throws BrokerException {
        String string;
        if (store != null) {
            return store;
        }
        BrokerConfig brokerConfig = Globals.getConfig();
        String string2 = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (Store.DEBUG) {
            logger.log(4, "imq.persist.store=" + string2);
        }
        if ((string = brokerConfig.getProperty(PERSIST_PROP + string2 + CLASS_PROP)) == null || string.equals("")) {
            string = string2.equals(DEFAULT_STORE_TYPE) ? DEFAULT_FILESTORE_CLASS : (string2.equals("jdbc") ? DEFAULT_JDBCSTORE_CLASS : null);
        }
        if (string == null) {
            logger.log(32, "B3005", string2);
            throw new BrokerException(br.getString("B3005", string2));
        }
        if (Store.DEBUG) {
            logger.log(4, PERSIST_PROP + string2 + CLASS_PROP + "=" + string);
        }
        Throwable throwable = null;
        try {
            try {
                store = (Store)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                Object var6_8 = null;
                if (classNotFoundException2 == null) return store;
                if (classNotFoundException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)classNotFoundException2);
                }
                throw new BrokerException(br.getString("B3006"), classNotFoundException2);
            }
            catch (InstantiationException instantiationException) {
                InstantiationException instantiationException2 = instantiationException;
                Object var6_9 = null;
                if (instantiationException2 == null) return store;
                if (instantiationException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)instantiationException2);
                }
                throw new BrokerException(br.getString("B3006"), instantiationException2);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                Object var6_10 = null;
                if (illegalAccessException2 == null) return store;
                if (illegalAccessException2 instanceof BrokerException) {
                    throw (BrokerException)((Object)illegalAccessException2);
                }
                throw new BrokerException(br.getString("B3006"), illegalAccessException2);
            }
            Object var6_7 = null;
            if (throwable == null) return store;
        }
        catch (Throwable throwable2) {
            Object var6_11 = null;
            if (throwable == null) {
                throw throwable2;
            }
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException(br.getString("B3006"), throwable);
        }
        if (throwable instanceof BrokerException) {
            throw (BrokerException)throwable;
        }
        throw new BrokerException(br.getString("B3006"), throwable);
    }

    public static synchronized void releaseStore(boolean bl) throws BrokerException {
        if (store != null) {
            if (!store.closed()) {
                store.close(bl);
            }
            store = null;
        }
    }
}

