/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RemDurableHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public RemDurableHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "RemDurableHandler");
        }
        if (gPacket.getType() == 7) {
            this.handleRemDurableInterest(brokerAddress, gPacket);
        } else if (gPacket.getType() == 8) {
            this.handleRemDurableInterestAck(brokerAddress, gPacket);
        } else {
            logger.log(16, "RemDurableHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleRemDurableInterest(BrokerAddress brokerAddress, GPacket gPacket) {
        boolean bl = false;
        if (gPacket.getProp("M") != null) {
            bl = (Boolean)gPacket.getProp("M");
        }
        if (!this.p.getConfigSyncComplete() && !bl) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Dropping the G_REM_DURABLE_INTEREST packet from {0}. Not ready yet.", brokerAddress);
            }
            return;
        }
        int n = (Integer)gPacket.getProp("C");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gPacket.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                Subscription subscription = Subscription.findDurableSubscription(string2, string);
                if (subscription == null) continue;
                this.cbDispatcher.unsubscribe(subscription);
            }
        }
        catch (IOException iOException) {
            logger.logStack(4, "Exception processing packet ", iOException);
        }
        if (gPacket.getBit(1)) {
            GPacket gPacket2 = GPacket.getInstance();
            gPacket2.setType((short)2);
            gPacket2.putProp("S", new Integer(200));
            try {
                this.c.unicast(brokerAddress, gPacket2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleRemDurableInterestAck(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received G_REM_DURABLE_INTEREST_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

