/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class NewInterestHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public NewInterestHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "NewInterestHandler");
        }
        if (gPacket.getType() == 5) {
            this.handleNewInterest(brokerAddress, gPacket);
        } else if (gPacket.getType() == 6) {
            this.handleNewInterestAck(brokerAddress, gPacket);
        } else if (gPacket.getType() == 35) {
            this.handleAttachDurable(brokerAddress, gPacket);
        } else if (gPacket.getType() == 36) {
            this.handleAttachDurableReply(brokerAddress, gPacket);
        } else {
            logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleNewInterest(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "handleNewInterest from : " + brokerAddress);
        }
        boolean bl = false;
        if (gPacket.getProp("M") != null) {
            bl = (Boolean)gPacket.getProp("M");
        }
        if (!this.p.getConfigSyncComplete() && !bl) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Dropping the  ClusterGlobals.MB_INTEREST_UPDATE. Not ready yet.");
            }
            return;
        }
        int n = (Integer)gPacket.getProp("C");
        if (DEBUG) {
            logger.log(4, "handleNewInterest count : " + n);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gPacket.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            for (int i = 0; i < n; ++i) {
                Consumer consumer = this.p.readConsumer(dataInputStream);
                DestinationUID destinationUID = consumer.getDestinationUID();
                int n2 = destinationUID.isQueue() ? 1 : 2;
                Destination destination = Destination.getDestination(destinationUID.getName(), n2, true, true);
                this.cbDispatcher.interestCreated(consumer);
            }
        }
        catch (Exception exception) {
            logger.logStack(4, "Exception processing packet ", exception);
        }
        if (gPacket.getBit(1)) {
            GPacket gPacket2 = GPacket.getInstance();
            gPacket2.setType((short)6);
            gPacket2.putProp("S", new Integer(200));
            try {
                this.c.unicast(brokerAddress, gPacket2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleNewInterestAck(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received G_NEW_INTEREST_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }

    public void handleAttachDurable(BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        if (DEBUG) {
            logger.log(4, "handleAttachDurable from : " + brokerAddress);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gPacket.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            boolean bl;
            object = (String)gPacket.getProp("N");
            String string = (String)gPacket.getProp("I");
            Boolean bl2 = (Boolean)gPacket.getProp("allowsNonDurable");
            boolean bl3 = bl = bl2 == null ? false : bl2;
            if (string == null || !bl && object == null) {
                logger.log(8, "Internal Error in handleAttachDurable : " + (String)object + ":" + string);
                return;
            }
            Consumer consumer = this.p.readConsumer(dataInputStream);
            Subscription subscription = null;
            if (object == null) {
                DestinationUID destinationUID = consumer.getDestinationUID();
                String string2 = consumer.getSelectorStr();
                subscription = Subscription.findNonDurableSubscription(string, destinationUID, string2);
            } else {
                subscription = Subscription.findDurableSubscription(string, (String)object);
            }
            if (subscription == null) {
                logger.log(8, "Internal Error in handleAttachDurable.  Subscription not found : " + (String)object + ":" + string);
                return;
            }
            try {
                subscription.attachConsumer(consumer);
                this.cbDispatcher.interestCreated(consumer);
            }
            catch (Exception exception) {
                logger.logStack(8, "Internal Error: Unable to attach consumer ", exception);
            }
        }
        catch (IOException iOException) {
            logger.logStack(4, "Exception processing packet ", iOException);
        }
        if (gPacket.getBit(1)) {
            object = GPacket.getInstance();
            ((GPacket)object).setType((short)36);
            ((GPacket)object).putProp("S", new Integer(200));
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleAttachDurableReply(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received G_DURABLE_ATTACH_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

