/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class InterestUpdateHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public InterestUpdateHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "InterestUpdateHandler");
        }
        if (gPacket.getType() == 9) {
            this.handleInterestUpdate(brokerAddress, gPacket);
        } else if (gPacket.getType() == 10) {
            this.handleInterestUpdateReply(brokerAddress, gPacket);
        } else {
            logger.log(16, "InterestUpdateHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    private void handleInterestUpdate(BrokerAddress brokerAddress, GPacket gPacket) {
        int n = (Integer)gPacket.getProp("C");
        int n2 = (Integer)gPacket.getProp("T");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gPacket.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            switch (n2) {
                case 3: {
                    for (int i = 0; i < n; ++i) {
                        ConsumerUID consumerUID = this.p.readConsumerUID(dataInputStream);
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer == null) continue;
                        this.cbDispatcher.interestRemoved(consumer);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        ConsumerUID consumerUID = this.p.readConsumerUID(dataInputStream);
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer == null) continue;
                        this.cbDispatcher.interestRemoved(consumer);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n; ++i) {
                        ConsumerUID consumerUID = this.p.readConsumerUID(dataInputStream);
                        this.p.notifyPrimaryInterestChanged(consumerUID);
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            logger.logStack(4, "Exception processing packet ", iOException);
        }
    }

    private void handleInterestUpdateReply(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received G_INTEREST_UPDATE_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

