/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import javax.net.ssl.SSLServerSocketFactory;

class ClusterListener
extends Thread {
    private static final BrokerResources br = Globals.getBrokerResources();
    private static final Logger logger = Globals.getLogger();
    ClusterImpl callback = null;
    boolean done = false;
    ServerSocket ss = null;

    public ClusterListener(ClusterImpl clusterImpl) throws IOException {
        this.callback = clusterImpl;
        this.setName("ClusterListener");
        this.setDaemon(true);
        if (clusterImpl.getTransport().equalsIgnoreCase("ssl")) {
            this.initSSLListener();
        } else {
            this.initTCPListener();
        }
        this.start();
    }

    private void initSSLListener() throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (ClusterImpl.DEBUG) {
            logger.log(4, "\nClusterImpl.initSSLListener");
        }
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            object3 = Globals.getCurrentLicense(null);
            if (!((LicenseBase)object3).getBooleanProperty("imq.enable_ssl", false)) {
                logger.log(32, "B3123", br.getString("B0073"));
                throw new BrokerException(br.getKString("B3123", br.getString("B0073")));
            }
            Class<?> clazz = Class.forName("com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol");
            object2 = clazz.getMethod("registerSSLProvider", null);
            ((Method)object2).invoke(null, null);
            if (ClusterImpl.DEBUG) {
                logger.log(4, "ClusterImpl.initSSLListener. Initializing SSLServerSocketFactory");
            }
            object2 = clazz.getMethod("getServerSocketFactory", null);
            sSLServerSocketFactory = (SSLServerSocketFactory)((Method)object2).invoke(null, null);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof InvocationTargetException) {
                throwable = exception.getCause();
                if (throwable == null) {
                    throwable = exception;
                }
                if (ClusterImpl.DEBUG && throwable != exception) {
                    logger.logStack(32, exception.getMessage(), exception);
                }
            }
            logger.logStack(32, throwable.getMessage(), throwable);
            throw new IOException(throwable.getMessage());
        }
        object3 = this.callback.getListenHost();
        int n = this.callback.getListenPort();
        object2 = null;
        if (ClusterImpl.DEBUG) {
            logger.log(4, "ClusterImpl.initSSLListener. Initializing ServerSocket");
        }
        if (object3 == null) {
            this.ss = sSLServerSocketFactory.createServerSocket(n);
        } else {
            object = InetAddress.getByName((String)object3);
            this.ss = sSLServerSocketFactory.createServerSocket(n, 50, (InetAddress)object);
            object2 = new HashMap();
            ((HashMap)object2).put("hostname", object3);
        }
        Globals.getPortMapper().addService("cluster", "ssl", "CLUSTER", this.ss.getLocalPort(), (HashMap)object2);
        object = Globals.getClusterDiscoveryService();
        if (object != null) {
            ((ClusterDiscoveryService)object).addService("cluster", "ssl", "CLUSTER", this.ss.getLocalPort(), (String)object3);
        }
    }

    private void initTCPListener() throws IOException {
        Object object;
        logger.log(4, "ClusterImpl.initTCPListener");
        String string = this.callback.getListenHost();
        int n = this.callback.getListenPort();
        HashMap<String, String> hashMap = null;
        if (string == null) {
            this.ss = new ServerSocket(n);
        } else {
            object = InetAddress.getByName(string);
            this.ss = new ServerSocket(n, 50, (InetAddress)object);
            hashMap = new HashMap<String, String>();
            hashMap.put("hostname", string);
        }
        Globals.getPortMapper().addService("cluster", "tcp", "CLUSTER", this.ss.getLocalPort(), hashMap);
        object = Globals.getClusterDiscoveryService();
        if (object != null) {
            ((ClusterDiscoveryService)object).addService("cluster", "tcp", "CLUSTER", this.ss.getLocalPort(), string);
        }
    }

    public synchronized void shutdown() {
        this.done = true;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.done) {
                    break;
                }
            }
            try {
                object = this.ss.accept();
                this.callback.acceptConnection((Socket)object);
            }
            catch (Exception exception) {}
        }
    }
}

