/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLink;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;

class BrokerLinkWriter
extends Thread {
    private OutputStream os = null;
    private LinkedList q = null;
    private boolean stopThread = false;
    private BrokerLink parent;
    private BrokerAddressImpl remote = null;
    private boolean flowControl = false;
    private ArrayList backupQ = null;
    private final int MAX_BUFFER_SIZE = 8192;
    private Logger logger = Globals.getLogger();

    public BrokerLinkWriter(BrokerAddressImpl brokerAddressImpl, BrokerLink brokerLink) {
        this.remote = brokerAddressImpl;
        this.parent = brokerLink;
        this.setName("BrokerLinkWriter:" + brokerAddressImpl);
        this.setDaemon(true);
    }

    public void startWriterThread(OutputStream outputStream) {
        this.os = new BufferedOutputStream(outputStream, 8192);
        this.q = new LinkedList();
        this.flowControl = false;
        this.backupQ = new ArrayList();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.q == null) {
            return;
        }
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            this.stopThread = true;
            this.q.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowControl(boolean bl) {
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            this.flowControl = bl;
            if (!this.flowControl && !this.backupQ.isEmpty()) {
                this.q.addAll(0, this.backupQ);
                this.backupQ.clear();
                this.q.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(GPacket gPacket) throws IOException {
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            if (this.stopThread) {
                throw new IOException("Packet send failed. Unreachable BrokerAddress : " + this.remote);
            }
            this.q.add(gPacket);
            this.q.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws IOException {
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            if (this.stopThread) {
                throw new IOException("Packet send failed. Unreachable BrokerAddress : " + this.remote);
            }
            this.q.add(packet);
            this.q.notify();
        }
    }

    public void sendPacketDirect(GPacket gPacket, boolean bl) {
        if (this.os == null) {
            return;
        }
        try {
            gPacket.write(this.os);
            if (bl) {
                this.os.flush();
            }
        }
        catch (IOException iOException) {
            this.os = null;
        }
    }

    public void sendPacketDirect(GPacket gPacket) {
        this.sendPacketDirect(gPacket, true);
    }

    public void sendPacketDirect(Packet packet, boolean bl) {
        if (this.os == null) {
            return;
        }
        try {
            packet.writePacket(this.os);
            if (bl) {
                this.os.flush();
            }
        }
        catch (IOException iOException) {
            this.os = null;
        }
    }

    public void sendPacketDirect(Packet packet) {
        this.sendPacketDirect(packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = new ArrayList<Object>();
        while (true) {
            var1_1.clear();
            var2_2 = this.q;
            synchronized (var2_2) {
                while (this.q.isEmpty() && !this.stopThread) {
                    try {
                        this.q.wait();
                    }
                    catch (Exception var3_5) {}
                }
                if (this.stopThread) {
                    return;
                }
                var3_6 = 0;
                var4_9 = false;
                while (!this.q.isEmpty()) {
                    block24: {
                        block23: {
                            var5_11 = this.q.getFirst();
                            var6_12 = null;
                            var7_13 = null;
                            try {
                                var6_12 = (GPacket)var5_11;
                            }
                            catch (ClassCastException var8_14) {
                                var7_13 = (Packet)var5_11;
                            }
                            if (var6_12 == null) break block23;
                            if (!this.flowControl) ** GOTO lbl-1000
                            if (var6_12.getBit(32)) {
                                this.backupQ.add(var6_12);
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (var3_6 + var6_12.getSize() > 8192) {
                                    var4_9 = true;
                                    break;
                                }
                                var1_1.add(var6_12);
                                var3_6 += var6_12.getSize();
                            }
                            break block24;
                        }
                        if (!this.flowControl) ** GOTO lbl-1000
                        if (var7_13.getFlag(1)) {
                            this.backupQ.add(var7_13);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (var3_6 + var7_13.getPacketSize() > 8192) {
                                var4_9 = true;
                                break;
                            }
                            var1_1.add(var7_13);
                            var3_6 += var7_13.getPacketSize();
                        }
                    }
                    this.q.removeFirst();
                }
                if (var1_1.size() == 0 && var4_9 && !this.q.isEmpty()) {
                    var1_1.add(this.q.removeFirst());
                }
            }
            try {
                for (var2_3 = 0; var2_3 < var1_1.size(); ++var2_3) {
                    try {
                        var3_7 = (GPacket)var1_1.get(var2_3);
                        this.sendPacketDirect(var3_7, false);
                        continue;
                    }
                    catch (ClassCastException var3_8) {
                        var4_10 = (Packet)var1_1.get(var2_3);
                        this.sendPacketDirect(var4_10, false);
                    }
                }
                if (this.os == null) continue;
                this.os.flush();
                continue;
            }
            catch (IOException var2_4) {
                this.os = null;
                continue;
            }
            break;
        }
    }
}

