/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.falcon;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HAWatchdog
extends Thread {
    public static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private MessageBusCallback cb = null;
    private CallbackDispatcher cbDispatcher = null;
    private Cluster c = null;
    private Protocol mbus = null;
    private ClusterDiscoveryService cds = null;
    private BrokerAddress currentActiveBroker = null;
    private Object eventObject = null;
    private int state;
    private static final int HA_WAITING = 1;
    private static final int HA_UPDATE = 2;
    private static final int HA_ACTIVATE = 3;
    private static final int HA_ACTIVE = 4;
    private static final int HA_ADVERTIZE = 5;
    private static final int HA_SHUTDOWN = 6;
    private static final long HA_LEASE_TIMEOUT = 90000L;
    private static final long HA_ACTIVE_UPDATE_TIMEOUT = 30000L;

    public HAWatchdog(MessageBusCallback messageBusCallback, CallbackDispatcher callbackDispatcher, Cluster cluster, Protocol protocol) {
        if (DEBUG) {
            logger.log(4, "HAWatchdog started");
        }
        this.cb = messageBusCallback;
        this.cbDispatcher = callbackDispatcher;
        this.c = cluster;
        this.mbus = protocol;
        this.cds = Globals.getClusterDiscoveryService();
        this.eventObject = new Object();
        this.updateActiveBroker(null);
        this.switchState(3, false);
        this.setName("HAWatchdog");
        this.start();
    }

    public void shutdown() {
        this.switchState(6, true);
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            switch (this.state) {
                case 1: {
                    this.waitTimerEvent(90000L, 3);
                    break;
                }
                case 2: {
                    this.switchState(1, false);
                    break;
                }
                case 3: {
                    this.electActiveBroker();
                    break;
                }
                case 4: {
                    this.waitTimerEvent(30000L, 5);
                    break;
                }
                case 5: {
                    this.sendActiveBrokerUpdate();
                    this.switchState(4, false);
                    break;
                }
                case 6: {
                    bl = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTimerEvent(long l, int n) {
        Object object = this.eventObject;
        synchronized (object) {
            if (DEBUG) {
                logger.log(4, "HAWatchdog sleeping. Current state = {0}, active = {1}", (Object)Integer.toString(this.state), this.currentActiveBroker);
            }
            int n2 = this.state;
            while (this.state == n2 && l > 0L) {
                long l2 = System.currentTimeMillis();
                try {
                    this.eventObject.wait(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l -= System.currentTimeMillis() - l2;
            }
            if (l <= 0L) {
                this.switchState(n, false);
            }
        }
    }

    private void electActiveBroker() {
        int n;
        if (DEBUG) {
            logger.log(4, "HAWatchdog: electActiveBroker.");
        }
        if ((n = this.mbus.lockResource("HA:ActiveBroker", 0L, null)) == 0) {
            this.updateActiveBroker(Globals.getMyAddress());
            this.switchState(5, false);
            this.cbDispatcher.goHAActive();
        } else {
            this.switchState(1, false);
        }
    }

    private void sendActiveBrokerUpdate() {
        if (DEBUG) {
            logger.log(4, "HAWatchdog: sendActiveBrokerUpdate.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(210);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.broadcast(15, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBrokerDown(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "HAWatchdog: broker down = {0}. Active Broker = {1}", (Object)brokerAddress, this.currentActiveBroker);
        }
        this.cds.removeRemoteService(brokerAddress);
        Object object = this.eventObject;
        synchronized (object) {
            if (this.currentActiveBroker == null || this.currentActiveBroker.equals(brokerAddress)) {
                this.updateActiveBroker(null);
                this.switchState(3, true);
            }
        }
    }

    public void handleBrokerUp(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "HAWatchdog: broker started = {0}. Active Broker = {1}", (Object)brokerAddress, this.currentActiveBroker);
        }
        this.cds.addRemoteService(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleActiveBrokerUpdate(BrokerAddress brokerAddress, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "HAWatchdog: Active broker update from : {0}", brokerAddress);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > 210) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(15));
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        Object object = this.eventObject;
        synchronized (object) {
            this.updateActiveBroker(brokerAddress);
            this.switchState(2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchState(int n, boolean bl) {
        if (DEBUG) {
            logger.log(2, "HAWatchdog: State transition. Old = {0}, New = {1}.", (Object)Integer.toString(this.state), Integer.toString(n));
        }
        Object object = this.eventObject;
        synchronized (object) {
            this.state = n;
            if (bl) {
                this.eventObject.notify();
            }
        }
    }

    private void updateActiveBroker(BrokerAddress brokerAddress) {
        this.currentActiveBroker = brokerAddress;
        this.cds.setActiveBroker(brokerAddress);
    }
}

