/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.falcon;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.UpdateProperties;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.HAWatchdog;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.InterestUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.Resource;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class FalconProtocol
implements Protocol {
    protected static final long ConsumerVersionUID = 99353142765567461L;
    public static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    protected static boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    protected static boolean DEBUG_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty("imq.cluster.debug.lock");
    protected static boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn");
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected CallbackDispatcher cbDispatcher = null;
    protected int version = 300;
    protected HashMap brokerList = null;
    protected int lockTimeout = Globals.getConfig().getIntProperty("imq.cluster.locktimeout", 60);
    protected HashMap resTable = null;
    protected Random r = null;
    protected long startTime = 0L;
    protected boolean configSyncComplete = false;
    protected boolean storeDirtyFlag = false;
    protected boolean isMasterBroker = false;
    protected Object eventLogLockObject;
    protected int eventLogStatus;
    protected long eventLogXid;
    protected long eventLogTimestamp;
    protected Object cfgSrvWaitObject = null;
    protected int cfgSrvRequestCount = 0;
    protected boolean cfgSrvRequestErr = false;
    protected Store store = null;
    protected HAWatchdog haWatchdog = null;

    public FalconProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress) throws BrokerException {
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
        this.cbDispatcher = new CallbackDispatcher(messageBusCallback);
        this.store = Globals.getStore();
        this.resTable = new HashMap();
        this.r = new Random();
        this.brokerList = new HashMap();
        this.cfgSrvWaitObject = new Object();
        this.eventLogLockObject = new Object();
    }

    public int getClusterVersion() {
        return this.version;
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        switch (n) {
            case 1: {
                try {
                    this.receiveMessage(brokerAddress, byArray);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Globals.handleGlobalError(outOfMemoryError, br.getKString("B0019"));
                    this.receiveMessage(brokerAddress, byArray);
                }
                break;
            }
            case 2: {
                this.receiveMessageAck(brokerAddress, byArray);
                break;
            }
            case 3: {
                this.receiveInterestUpdate(brokerAddress, byArray, false);
                break;
            }
            case 6: {
                this.receiveLockResponse(brokerAddress, byArray);
                break;
            }
            case 7: {
                this.receiveConfigChangeEvent(brokerAddress, byArray);
                break;
            }
            case 8: {
                this.receiveConfigChangeEventAck(brokerAddress, byArray);
                break;
            }
            case 9: {
                this.receiveConfigChangesRequest(brokerAddress, byArray);
                break;
            }
            case 10: {
                this.receiveConfigChangesResponse(brokerAddress, byArray);
                break;
            }
            case 14: {
                this.receiveRequestInterestUpdate(brokerAddress, byArray);
                break;
            }
            default: {
                logger.log(16, "B2028", Integer.toString(n));
            }
        }
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        this.receiveBroadcast(brokerAddress, n, byArray, false);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) {
        switch (n) {
            case 3: {
                this.receiveInterestUpdate(brokerAddress, byArray, bl);
                break;
            }
            case 5: {
                this.receiveLockRequest(brokerAddress, byArray);
                break;
            }
            case 4: {
                this.receiveClientClosedUpdate(brokerAddress, byArray);
                break;
            }
            case 11: {
                this.receiveDestinationUpdate(brokerAddress, byArray);
                break;
            }
            case 12: {
                this.receiveResetPersistence(brokerAddress, byArray);
                break;
            }
            case 13: {
                this.receiveRestartCluster(brokerAddress, byArray);
                break;
            }
            case 15: {
                if (this.haWatchdog == null) break;
                this.haWatchdog.handleActiveBrokerUpdate(brokerAddress, byArray);
                break;
            }
            default: {
                logger.log(16, "B2029", Integer.toString(n));
            }
        }
    }

    public BrokerInfo getBrokerInfo() {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerAddr(this.selfAddress);
        brokerInfo.setStartTime(this.startTime);
        brokerInfo.setStoreDirtyFlag(this.storeDirtyFlag);
        return brokerInfo;
    }

    public void setMatchProps(Properties properties) {
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null) {
                this.configSyncComplete = true;
            } else if (brokerAddress.equals(this.selfAddress)) {
                this.initConfigServer();
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest(this.selfAddress, l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Globals.getHAEnabled()) {
            this.haWatchdog = new HAWatchdog(this.cb, this.cbDispatcher, this.c, this);
        }
    }

    public void stopClusterIO() {
        if (this.haWatchdog != null) {
            this.haWatchdog.shutdown();
        }
    }

    public void shutdown() {
        this.cbDispatcher.shutdown();
    }

    private void initConfigServer() {
        this.isMasterBroker = true;
        logger.log(8, "B1069");
        try {
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray[1];
            if (arrayList.size() == 0) {
                logger.log(8, "B1068");
                byte[] byArray = this.prepareResetPersistenceRecord();
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadCluster() {
        logger.log(8, "B1074");
        this.sendRestartCluster();
        this.c.reloadCluster();
    }

    public void stopMessageFlow() throws IOException {
        this.c.stopMessageFlow();
    }

    public void resumeMessageFlow() throws IOException {
        this.c.resumeMessageFlow();
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        return !this.configSyncComplete;
    }

    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        Cloneable cloneable;
        Object object;
        Object object2;
        HashMap<Object, Cloneable> hashMap = new HashMap<Object, Cloneable>();
        if (DEBUG) {
            logger.log(2, "MessageBus: sending message {0} to {1} targets.", (Object)packetReference.getSysMessageID(), Integer.toString(collection.size()));
        }
        String string = "\n";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object2 = (Consumer)iterator.next();
            object = ((Consumer)object2).getConsumerUID().getBrokerAddress();
            cloneable = (ArrayList)hashMap.get(object);
            if (cloneable == null) {
                cloneable = new ArrayList();
                hashMap.put(object, cloneable);
            }
            ((ArrayList)cloneable).add(object2);
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Local Targets = {0}", string);
        }
        object2 = null;
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            cloneable = (BrokerAddress)object.next();
            ArrayList arrayList = (ArrayList)hashMap.get(cloneable);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            string = "\n";
            try {
                dataOutputStream.writeInt(this.version);
                dataOutputStream.writeInt(arrayList.size());
                dataOutputStream.writeBoolean(bl);
                for (int i = 0; i < arrayList.size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)arrayList.get(i)).getConsumerUID();
                    ConsumerUID consumerUID2 = ((Consumer)arrayList.get(i)).getStoredConsumerUID();
                    try {
                        packetReference.delivered(consumerUID, consumerUID2, consumerUID.isUnsafeAck(), true);
                    }
                    catch (Exception exception) {
                        logger.logStack(16, "B3100", "saving redeliver flag for " + packetReference.getSysMessageID() + " to " + consumerUID, (Throwable)exception);
                    }
                    this.writeConsumerUID(consumerUID, dataOutputStream);
                    if (!DEBUG) continue;
                    string = string + "\t" + consumerUID + "\n";
                }
                if (object2 == null) {
                    object2 = packetReference.getPacket();
                }
                ((Packet)object2).generateTimestamp(false);
                ((Packet)object2).generateSequenceNumber(false);
                ((Packet)object2).writePacket(dataOutputStream);
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                logger.logStack(4, "Exception writing packet ", exception);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                this.c.unicast((BrokerAddress)cloneable, 1, byArray, true);
                if (!DEBUG) continue;
                logger.log(1, "MessageBus: Broker {0} Targets = {1}", (Object)cloneable, string);
            }
            catch (IOException iOException) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)arrayList.get(i)).getConsumerUID();
                    this.cb.processRemoteAck(packetReference.getSysMessageID(), consumerUID, 2);
                }
                if (!DEBUG) continue;
                logger.log(1, "FalconProtocol: Could not deliver message to broker {0}", cloneable);
            }
        }
    }

    protected void writeConsumer(Consumer consumer, DataOutputStream dataOutputStream) throws IOException {
        String string = consumer.getDestinationUID().getName();
        ConsumerUID consumerUID = consumer.getConsumerUID();
        String string2 = null;
        String string3 = null;
        String string4 = consumer.getSelectorStr();
        boolean bl = consumer.getNoLocal();
        boolean bl2 = consumer.getDestinationUID().isQueue();
        boolean bl3 = true;
        if (consumer.getSubscription() != null) {
            string2 = consumer.getSubscription().getDurableName();
            string3 = consumer.getSubscription().getClientID();
            if (!consumer.getSubscription().isActive()) {
                bl3 = false;
            }
        }
        dataOutputStream.writeLong(99353142765567461L);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeBoolean(consumerUID != null);
        if (consumerUID != null) {
            this.writeConsumerUID(consumerUID, dataOutputStream);
        }
        dataOutputStream.writeBoolean(string3 != null);
        if (string3 != null) {
            dataOutputStream.writeUTF(string3);
        }
        dataOutputStream.writeBoolean(string2 != null);
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
        dataOutputStream.writeBoolean(string4 != null);
        if (string4 != null) {
            dataOutputStream.writeUTF(string4);
        }
        dataOutputStream.writeBoolean(bl2);
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeBoolean(bl3);
        dataOutputStream.writeBoolean(true);
    }

    public void writeConsumerUID(ConsumerUID consumerUID, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(consumerUID.longValue());
        dataOutputStream.writeLong(consumerUID.getConnectionUID().longValue());
        BrokerAddress brokerAddress = consumerUID.getBrokerAddress();
        if (brokerAddress == null) {
            brokerAddress = Globals.getMyAddress();
        }
        brokerAddress.writeBrokerAddress(dataOutputStream);
    }

    public static Consumer readConsumer(DataInputStream dataInputStream, CallbackDispatcher callbackDispatcher) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ConsumerUID consumerUID = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = dataInputStream.readLong();
        if (l != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + l + " expected " + 99353142765567461L);
        }
        string = dataInputStream.readUTF();
        boolean bl4 = dataInputStream.readBoolean();
        if (bl4) {
            consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
        }
        if (bl3 = dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        if (bl2 = dataInputStream.readBoolean()) {
            string3 = dataInputStream.readUTF();
        }
        if (bl = dataInputStream.readBoolean()) {
            string4 = dataInputStream.readUTF();
        }
        boolean bl5 = dataInputStream.readBoolean();
        boolean bl6 = dataInputStream.readBoolean();
        boolean bl7 = dataInputStream.readBoolean();
        DestinationUID destinationUID = DestinationUID.getUID(string, bl5);
        try {
            Consumer consumer = new Consumer(destinationUID, string4, bl6, consumerUID);
            if (string3 != null) {
                Subscription subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string4, bl6);
                int n = destinationUID.isQueue() ? 1 : 2;
                Destination destination = Destination.getDestination(destinationUID.getName(), n, true, true);
                if (callbackDispatcher != null) {
                    callbackDispatcher.interestCreated(subscription);
                }
                subscription.attachConsumer(consumer);
            }
            return consumer;
        }
        catch (SelectorFormatException selectorFormatException) {
            logger.log(8, "L10N-XXX Got bad selector[" + string4 + "] ", selectorFormatException);
            throw new IOException("bad selector " + string4);
        }
        catch (BrokerException brokerException) {
            logger.log(8, "L10N-XXX error creating consumer ", brokerException);
            throw new IOException("error creating consumer ");
        }
    }

    protected static ConsumerUID readConsumerUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        ConnectionUID connectionUID = new ConnectionUID(dataInputStream.readLong());
        BrokerAddress brokerAddress = Globals.getMyAddress();
        if (brokerAddress == null) {
            try {
                brokerAddress = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BrokerAddress brokerAddress2 = (BrokerAddress)brokerAddress.clone();
        brokerAddress2.readBrokerAddress(dataInputStream);
        ConsumerUID consumerUID = new ConsumerUID(l);
        consumerUID.setConnectionUID(connectionUID);
        consumerUID.setBrokerAddress(brokerAddress2);
        return consumerUID;
    }

    protected void writeDestination(Destination destination, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(destination.getDestinationName());
        dataOutputStream.writeInt(destination.getType());
    }

    protected Destination readDestination(DataInputStream dataInputStream) throws IOException, BrokerException {
        int n;
        String string = dataInputStream.readUTF();
        DestinationUID destinationUID = DestinationUID.getUID(string, n = dataInputStream.readInt());
        Destination destination = Destination.getDestination(destinationUID);
        if (destination == null) {
            destination = Destination.createDestination(string, n, !DestType.isTemporary(n), false, this.selfAddress);
            this.cbDispatcher.notifyCreateDestination(destination);
        }
        return destination;
    }

    private void receiveMessage(BrokerAddress brokerAddress, byte[] byArray) {
        int n;
        PacketReference packetReference;
        ArrayList<Serializable> arrayList;
        ArrayList<Consumer> arrayList2;
        block19: {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            arrayList2 = new ArrayList<Consumer>();
            arrayList = new ArrayList<Serializable>();
            packetReference = null;
            if (DEBUG) {
                logger.log(2, "MessageBus: receiving message.");
            }
            try {
                Consumer consumer;
                int n2;
                int n3 = dataInputStream.readInt();
                if (n3 > this.version) {
                    logger.log(16, "B2027", (Object)Integer.toString(n3), Integer.toString(1));
                    return;
                }
                n = dataInputStream.readInt();
                boolean bl = dataInputStream.readBoolean();
                for (n2 = 0; n2 < n; ++n2) {
                    ConsumerUID consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
                    consumer = Consumer.getConsumer(consumerUID);
                    if (consumer != null) {
                        arrayList2.add(consumer);
                        continue;
                    }
                    arrayList.add(consumerUID);
                }
                Packet packet = new Packet(false);
                packet.generateTimestamp(false);
                packet.generateSequenceNumber(false);
                packet.readPacket(dataInputStream);
                n2 = 0;
                packetReference = Destination.get(packet.getSysMessageID());
                if (packetReference != null) {
                    n2 = 1;
                } else {
                    packetReference = PacketReference.createReference(packet, null);
                    packetReference.setBrokerAddress(brokerAddress);
                }
                if (bl) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        consumer = (Consumer)arrayList2.get(i);
                        packetReference.addMessageDeliveredAck(consumer.getConsumerUID());
                    }
                }
                try {
                    if (packetReference == null) {
                        return;
                    }
                    Destination destination = Destination.getDestination(packetReference.getDestinationUID().getName(), packetReference.getDestinationUID().isQueue() ? 1 : 2, true, true);
                    if (destination == null) {
                        arrayList.addAll(arrayList2);
                        break block19;
                    }
                    if (n2 == 0) {
                        destination.queueMessage(packetReference, false);
                        packetReference.setNeverStore(true);
                        packetReference.store(arrayList2);
                        break block19;
                    }
                    packetReference.add(arrayList2);
                }
                catch (BrokerException brokerException) {
                    arrayList.addAll(arrayList2);
                }
            }
            catch (IOException iOException) {
                logger.log(8, "Internal Exception, unable to process message " + packetReference, iOException);
                return;
            }
        }
        String string = "\n";
        for (n = 0; n < arrayList2.size(); ++n) {
            Consumer consumer = (Consumer)arrayList2.get(n);
            consumer.routeMessage(packetReference, false);
            if (!DEBUG) continue;
            string = string + "\t" + consumer.getConsumerUID() + "\n";
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Delivering message to : {0}", string);
        }
        string = "\n";
        for (n = 0; n < arrayList.size(); ++n) {
            this.sendMessageAck(brokerAddress, packetReference, (ConsumerUID)arrayList.get(n), 1);
            if (!DEBUG) continue;
            string = string + "\t" + arrayList.get(n) + "\n";
        }
        if (DEBUG && arrayList.size() > 0) {
            logger.log(1, "MessageBus: Invalid targets : {0}", string);
        }
    }

    public void sendMessageAck(BrokerAddress brokerAddress, PacketReference packetReference, ConsumerUID consumerUID, int n) {
        Object object;
        if (DEBUG) {
            object = "\n\tackType = " + n + "\n\tSysMessageID = " + packetReference.getSysMessageID() + "\n\tConsumerUID = " + consumerUID + "\n\tMessageHome = " + brokerAddress + "\n";
            logger.log(1, "MessageBus: Sending message acknowledgement : {0}", object);
        }
        object = packetReference.getSysMessageID();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            ((SysMessageID)object).writeID(dataOutputStream);
            this.writeConsumerUID(consumerUID, dataOutputStream);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 2, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveMessageAck(BrokerAddress brokerAddress, byte[] byArray) {
        int n;
        ConsumerUID consumerUID;
        SysMessageID sysMessageID;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n2 = dataInputStream.readInt();
            if (n2 > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n2), Integer.toString(2));
                return;
            }
            sysMessageID = new SysMessageID();
            sysMessageID.readID(dataInputStream);
            consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
            n = dataInputStream.readInt();
        }
        catch (Exception exception) {
            logger.logStack(4, "Exception reading packet ", exception);
            return;
        }
        if (DEBUG) {
            String string = "\n\tackType = " + n + "\n\tSysMessageID = " + sysMessageID + "\n\tConsumerUID = " + consumerUID + "\n\tSender = " + brokerAddress + "\n";
            logger.log(1, "MessageBus: Received message acknowledgement : {0}", string);
        }
        this.cb.processRemoteAck(sysMessageID, consumerUID, n);
    }

    private byte[] prepareInterestUpdate(Collection collection, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(collection.size());
            if (n == 1) {
                Consumer consumer;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    consumer = (Consumer)iterator.next();
                    if (consumer instanceof Subscription || consumer.getSubscription() != null) {
                        Subscription subscription = null;
                        subscription = consumer instanceof Subscription ? (Subscription)consumer : consumer.getSubscription();
                        dataOutputStream.writeBoolean(true);
                        dataOutputStream.writeUTF(subscription.getDurableName());
                        dataOutputStream.writeUTF(subscription.getClientID());
                        continue;
                    }
                    dataOutputStream.writeBoolean(false);
                }
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    consumer = (Consumer)iterator.next();
                    this.writeConsumer(consumer, dataOutputStream);
                }
            } else if (n == 5) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Consumer consumer = (Consumer)iterator.next();
                    Subscription subscription = null;
                    subscription = consumer instanceof Subscription ? (Subscription)consumer : consumer.getSubscription();
                    dataOutputStream.writeUTF(subscription.getDurableName());
                    dataOutputStream.writeUTF(subscription.getClientID());
                }
            } else {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Consumer consumer = (Consumer)iterator.next();
                    this.writeConsumerUID(consumer.getConsumerUID(), dataOutputStream);
                }
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void sendInterestUpdate(Consumer consumer, int n) {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        this.sendInterestUpdate(hashSet, n);
    }

    public void sendInterestUpdate(Collection collection, int n) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Broadcasting interest update. Count = {0}, Type = {1}", (Object)Integer.toString(collection.size()), Integer.toString(n));
        }
        byte[] byArray = this.prepareInterestUpdate(collection, n);
        try {
            this.c.broadcast(3, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInterestUpdate(BrokerAddress brokerAddress, Collection collection, int n) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Sending interest update to {0}. Count = {1}", (Object)brokerAddress, Integer.toString(collection.size()));
        }
        byte[] byArray = this.prepareInterestUpdate(collection, n);
        try {
            this.c.unicast(brokerAddress, 3, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveInterestUpdate(BrokerAddress brokerAddress, byte[] byArray, boolean bl) {
        if (!this.configSyncComplete && !bl) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Dropping the  ClusterGlobals.MB_INTEREST_UPDATE. Not ready yet.");
            }
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(3));
                return;
            }
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (DEBUG) {
                logger.log(4, "MessageBus: Receiving interest update from {0}. Type = {1}", (Object)brokerAddress, Integer.toString(n2));
            }
            switch (n2) {
                case 1: {
                    int n4;
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (!dataInputStream.readBoolean()) continue;
                        dataInputStream.readUTF();
                        dataInputStream.readUTF();
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        Consumer consumer = FalconProtocol.readConsumer(dataInputStream, this.cbDispatcher);
                        this.cbDispatcher.interestCreated(consumer);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n3; ++i) {
                        ConsumerUID consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer == null) continue;
                        this.cbDispatcher.interestRemoved(consumer);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < n3; ++i) {
                        String string = dataInputStream.readUTF();
                        String string2 = dataInputStream.readUTF();
                        Subscription subscription = Subscription.findDurableSubscription(string2, string);
                        if (subscription == null) continue;
                        this.cbDispatcher.interestRemoved(subscription);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n3; ++i) {
                        ConsumerUID consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        this.cbDispatcher.interestRemoved(consumer);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n3; ++i) {
                        ConsumerUID consumerUID = FalconProtocol.readConsumerUID(dataInputStream);
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer != null) {
                            this.notifyPrimaryInterestChanged(consumer);
                            continue;
                        }
                        logger.log(16, "B2033", consumerUID);
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            logger.logStack(4, "Exception processing packet ", iOException);
        }
    }

    private void sendClientClosedUpdate(ConnectionUID connectionUID) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (DEBUG) {
            logger.log(4, "MessageBus: Client closed notification. Client = {0}", connectionUID);
        }
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeLong(connectionUID.longValue());
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.broadcast(4, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveClientClosedUpdate(BrokerAddress brokerAddress, byte[] byArray) {
        ConnectionUID connectionUID;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(4));
                return;
            }
            connectionUID = new ConnectionUID(dataInputStream.readLong());
        }
        catch (Exception exception) {
            return;
        }
        if (DEBUG) {
            logger.log(4, "MessageBus: Received Client closed notification from {0}. Client = {1}", (Object)brokerAddress, connectionUID);
        }
        this.cbDispatcher.clientDown(connectionUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            object = this.resTable.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                if (!connectionUID.equals(resource.getOwner())) continue;
                arrayList.add(string);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            this.unlockResource((String)object);
        }
        if (bl) {
            this.sendClientClosedUpdate(connectionUID);
            this.cbDispatcher.clientDown(connectionUID);
        }
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        throw new UnsupportedOperationException("Shared locks are not supported.");
    }

    public int lockResource(String string, ConnectionUID connectionUID) {
        return this.lockResource(string, 0L, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        int n = 1;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.tryLockResource(string, l, connectionUID)) == 0 || n3 == 1) {
                return n3;
            }
            if (++n2 == 10) break;
            int n4 = this.r.nextInt(n *= 2);
            try {
                Thread.sleep(n4 * 1000);
            }
            catch (Exception exception) {}
        }
        logger.log(16, "B2034", string);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryLockResource(String string, long l, ConnectionUID connectionUID) {
        Resource resource;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
            if (resource != null) {
                return 1;
            }
            resource = new Resource(string);
            resource.setOwner(connectionUID);
            if (l != 0L) {
                resource.setTimestamp(l);
            }
            this.resTable.put(string, resource);
        }
        resource.setLockState(0);
        block15: while (true) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Trying to lock resource {0}", string);
            }
            this.sendLockRequest(resource);
            int n = resource.waitForStatusChange(this.lockTimeout);
            if (DEBUG) {
                logger.log(4, "MessageBus: Lock attempt status = {0} for resource {1}", (Object)Integer.toString(n), string);
            }
            switch (n) {
                case 0: {
                    resource.setLockState(1);
                    return n;
                }
                case 1: 
                case 2: {
                    HashMap hashMap2 = this.resTable;
                    synchronized (hashMap2) {
                        this.resTable.remove(string);
                    }
                    return n;
                }
                case -1: {
                    logger.log(16, "B2062", (Object)resource.getResId(), resource.showRecipients());
                    HashMap hashMap3 = this.resTable;
                    synchronized (hashMap3) {
                        this.resTable.remove(string);
                    }
                    return 1;
                }
                case 3: {
                    if (!DEBUG_CLUSTER_ALL && !DEBUG_CLUSTER_LOCK) continue block15;
                    logger.log(4, "Active brokerlist changed. Restarting Lock election for {0}." + resource.getResId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResource(String string) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Unlocking resource = {0}", string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Resource resource = (Resource)this.resTable.remove(string);
            if (resource != null) {
                resource.impliedFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLockRequest(Resource resource) {
        Object object;
        int n;
        long l = System.currentTimeMillis();
        BrokerAddress[] brokerAddressArray = null;
        Object object2 = this.brokerList;
        synchronized (object2) {
            brokerAddressArray = new BrokerAddress[this.brokerList.size()];
            n = 0;
            object = this.brokerList.values();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BrokerInfo brokerInfo = (BrokerInfo)iterator.next();
                brokerAddressArray[n++] = brokerInfo.getBrokerAddr();
            }
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            object2 = "";
            for (n = 0; n < brokerAddressArray.length; ++n) {
                object2 = (String)object2 + "\n\t" + brokerAddressArray[n];
            }
            logger.log(4, "Sending resource lock request for : " + resource.getResId() + "\nExpecting responses from : " + (String)object2);
        }
        resource.prepareLockRequest(brokerAddressArray, l);
        object2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object2);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF(resource.getResId());
            dataOutputStream.writeLong(resource.getTimestamp());
            dataOutputStream.writeLong(l);
            dataOutputStream.flush();
            ((OutputStream)object2).flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = ((ByteArrayOutputStream)object2).toByteArray();
        try {
            this.c.broadcast(5, (byte[])object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveLockRequest(BrokerAddress brokerAddress, byte[] byArray) {
        long l;
        long l2;
        String string;
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(5));
                return;
            }
            string = dataInputStream.readUTF();
            l2 = dataInputStream.readLong();
            l = dataInputStream.readLong();
        }
        catch (Exception exception) {
            return;
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null) {
            n = 0;
        } else if (resource.getLockState() == 1) {
            n = 1;
        } else if (l2 < resource.getTimestamp()) {
            resource.impliedFailure();
            n = 0;
        } else {
            n = l2 > resource.getTimestamp() ? 1 : 2;
        }
        this.sendLockResponse(brokerAddress, string, l, n);
    }

    private void sendLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 6, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveLockResponse(BrokerAddress brokerAddress, byte[] byArray) {
        int n;
        long l;
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n2 = dataInputStream.readInt();
            if (n2 > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n2), Integer.toString(6));
                return;
            }
            string = dataInputStream.readUTF();
            l = dataInputStream.readLong();
            n = dataInputStream.readInt();
        }
        catch (Exception exception) {
            return;
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null) {
            return;
        }
        if ((DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) && resource.getXid() == l) {
            logger.log(4, "Received Lock Response.\n\tSender = " + brokerAddress + "\n\tResource = " + resource.getResId() + "\n\tResponse = " + ClusterGlobals.lockResponseStrings[n]);
        }
        resource.consumeResponse(l, brokerAddress, n);
    }

    public int recordAddDurableEvent(Subscription subscription) throws BrokerException {
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        hashSet.add(subscription);
        byte[] byArray = this.prepareInterestUpdate(hashSet, 1);
        return this.recordConfigChangeEvent(3, byArray);
    }

    public int recordRemDurableEvent(Subscription subscription) throws BrokerException {
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        hashSet.add(subscription);
        byte[] byArray = this.prepareInterestUpdate(hashSet, 5);
        return this.recordConfigChangeEvent(3, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordConfigChangeEvent(int n, byte[] byArray) throws BrokerException {
        if (this.c.getConfigServer() == null) {
            return 2;
        }
        Object object = this.eventLogLockObject;
        synchronized (object) {
            this.eventLogStatus = 0;
            this.eventLogXid = System.currentTimeMillis();
            this.sendConfigChangeEvent(this.eventLogXid, n, byArray);
            while (this.eventLogStatus == 0) {
                try {
                    this.eventLogLockObject.wait();
                }
                catch (Exception exception) {}
            }
            if (this.eventLogStatus == 1) {
                this.storeDirtyFlag = true;
            }
            return this.eventLogStatus;
        }
    }

    private void sendConfigChangeEvent(long l, int n, byte[] byArray) throws BrokerException {
        BrokerAddress brokerAddress = this.c.getConfigServer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(byArray.length + 4);
            dataOutputStream.writeInt(n);
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 7, byArray2);
        }
        catch (Exception exception) {
            throw new BrokerException(br.getKString("B4094"), "B4094", null, 403);
        }
    }

    private void receiveConfigChangeEvent(BrokerAddress brokerAddress, byte[] byArray) {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        long l = -1L;
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(7));
                return;
            }
            l = dataInputStream.readLong();
            int n2 = dataInputStream.readInt();
            byArray2 = new byte[n2];
            dataInputStream.readFully(byArray2, 0, n2);
        }
        catch (Exception exception) {
            return;
        }
        try {
            this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray2, false);
            this.sendConfigChangeEventAck(brokerAddress, l, 1);
        }
        catch (Exception exception) {
            this.sendConfigChangeEventAck(brokerAddress, l, 2);
            return;
        }
    }

    private void sendConfigChangeEventAck(BrokerAddress brokerAddress, long l, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 8, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveConfigChangeEventAck(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(8));
                return;
            }
            long l = dataInputStream.readLong();
            int n2 = dataInputStream.readInt();
            Object object = this.eventLogLockObject;
            synchronized (object) {
                if (l != this.eventLogXid) {
                    return;
                }
                this.eventLogStatus = n2;
                this.eventLogLockObject.notify();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeLong(l);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            try {
                this.c.unicast(brokerAddress, 9, byArray);
                ++this.cfgSrvRequestCount;
                this.cfgSrvRequestErr = false;
            }
            catch (Exception exception) {
                this.cfgSrvRequestCount = 0;
                this.cfgSrvRequestErr = true;
                this.cfgSrvWaitObject.notifyAll();
            }
        }
    }

    private void receiveConfigChangesRequest(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(9));
                return;
            }
            long l = dataInputStream.readLong();
            long l2 = System.currentTimeMillis();
            ArrayList arrayList = this.store.getConfigChangeRecordsSince(l);
            this.sendConfigChangesResponse(brokerAddress, l2, arrayList);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void sendConfigChangesResponse(BrokerAddress brokerAddress, long l, ArrayList arrayList) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 10, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveConfigChangesResponse(BrokerAddress brokerAddress, byte[] byArray) {
        boolean bl = false;
        BrokerAddress brokerAddress2 = this.getLastConfigServer();
        if (brokerAddress2 != null && !brokerAddress2.equals(brokerAddress)) {
            bl = true;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(10));
                return;
            }
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readInt();
            if (bl && l2 == 0L) {
                logger.log(32, "B3095");
                System.exit(1);
            }
            boolean bl2 = false;
            ArrayList<byte[]> arrayList = null;
            int n2 = 0;
            while ((long)n2 < l2) {
                Object object;
                byte[] byArray2;
                int n3 = dataInputStream.readInt();
                if (n2 == 0) {
                    dataInputStream.mark(n3);
                    byArray2 = new byte[n3];
                    dataInputStream.readFully(byArray2, 0, n3);
                    object = ChangeRecord.makeChangeRecord(byArray2);
                    if (object.eventDestId == 12) {
                        bl2 = true;
                        arrayList = new ArrayList<byte[]>();
                    }
                    if (bl && !bl2) {
                        logger.log(32, "B3095");
                        System.exit(1);
                    }
                    dataInputStream.reset();
                }
                if (bl2) {
                    byArray2 = new byte[n3];
                    dataInputStream.readFully(byArray2, 0, n3);
                    arrayList.add(byArray2);
                } else {
                    int n4 = dataInputStream.readInt();
                    object = new byte[n3 - 4];
                    dataInputStream.readFully((byte[])object, 0, n3 - 4);
                    this.receiveBroadcast(brokerAddress, n4, (byte[])object, true);
                }
                ++n2;
            }
            if (bl2) {
                this.applyPersistentStateChanges(brokerAddress, arrayList);
            }
            if (!this.configSyncComplete) {
                this.configSyncComplete = true;
                this.cbDispatcher.configSyncComplete();
                this.sendRequestInterestUpdate(brokerAddress);
                logger.log(8, "B1075");
            }
            Object object = this.cfgSrvWaitObject;
            synchronized (object) {
                --this.cfgSrvRequestCount;
                if (this.cfgSrvRequestCount == 0) {
                    this.cfgSrvWaitObject.notifyAll();
                }
            }
            this.storeLastRefreshTime(l - 120000L);
            this.storeLastConfigServer(brokerAddress);
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitConfigChangesResponse() {
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            while (this.cfgSrvRequestCount > 0) {
                try {
                    this.cfgSrvWaitObject.wait();
                }
                catch (Exception exception) {}
            }
            return !this.cfgSrvRequestErr;
        }
    }

    private void applyPersistentStateChanges(BrokerAddress brokerAddress, ArrayList arrayList) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<DestinationUID, Serializable> hashMap2 = new HashMap<DestinationUID, Serializable>();
        Set set = Subscription.getAllSubscriptions(null);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (Subscription)iterator.next();
            object2 = ((Consumer)serializable).getConsumerUID();
            object = ((Subscription)serializable).getDurableName() + ":" + ((Subscription)serializable).getClientID();
            hashMap.put(object, object2);
        }
        set = null;
        iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            serializable = (Destination)iterator.next();
            if (((Destination)serializable).isAutoCreated() || ((Destination)serializable).isInternal()) continue;
            hashMap2.put(((Destination)serializable).getDestinationUID(), serializable);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object3;
            ChangeRecord changeRecord;
            object2 = (byte[])arrayList.get(i);
            object = ChangeRecord.makeChangeRecord((byte[])object2);
            if (((ChangeRecord)object).eventDestId == 12) continue;
            if (((ChangeRecord)object).eventDestId == 3) {
                this.receiveBroadcast(brokerAddress, ((ChangeRecord)object).eventDestId, ((ChangeRecord)object).rec, true);
                changeRecord = (InterestUpdateChangeRecord)object;
                object3 = ((InterestUpdateChangeRecord)changeRecord).dname + ":" + ((InterestUpdateChangeRecord)changeRecord).cid;
                hashMap.remove(object3);
                continue;
            }
            if (((ChangeRecord)object).eventDestId != 11) continue;
            changeRecord = (DestinationUpdateChangeRecord)object;
            object3 = DestinationUID.getUID(((DestinationUpdateChangeRecord)changeRecord).name, DestType.isQueue(((DestinationUpdateChangeRecord)changeRecord).type));
            Destination destination = (Destination)hashMap2.get(object3);
            if (((DestinationUpdateChangeRecord)changeRecord).isAddOp() && destination != null && destination.getType() != ((DestinationUpdateChangeRecord)changeRecord).type) {
                DestinationUID destinationUID = DestinationUID.getUID(destination.getDestinationName(), DestType.isQueue(destination.getType()));
                this.cbDispatcher.notifyDestroyDestination(destinationUID);
            }
            this.receiveBroadcast(brokerAddress, ((ChangeRecord)object).eventDestId, ((ChangeRecord)object).rec, true);
            hashMap2.remove(object3);
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            object2 = Consumer.getConsumer(consumerUID);
            if (object2 == null) continue;
            this.cbDispatcher.interestRemoved((Consumer)object2);
        }
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            DestinationUID destinationUID = (DestinationUID)iterator.next();
            this.cbDispatcher.notifyDestroyDestination(destinationUID);
        }
    }

    public static byte[] upgradeConfigChangeRecord(byte[] byArray) throws IOException {
        ChangeRecord changeRecord = ChangeRecord.makeChangeRecord(byArray);
        if (changeRecord.eventDestId == 12) {
            return RaptorProtocol.prepareResetPersistenceRecord();
        }
        if (changeRecord.eventDestId == 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(changeRecord.rec);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 == 1) {
                dataInputStream.readBoolean();
                dataInputStream.readUTF();
                dataInputStream.readUTF();
                Consumer consumer = FalconProtocol.readConsumer(dataInputStream, null);
                Subscription subscription = consumer.getSubscription();
                return RaptorProtocol.generateAddDurableRecord(subscription);
            }
            if (n2 == 5) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                Subscription subscription = Subscription.findDurableSubscription(string2, string);
                return RaptorProtocol.generateRemDurableRecord(subscription);
            }
        } else if (changeRecord.eventDestId == 11) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(changeRecord.rec);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            int n5 = dataInputStream.readInt();
            if (n4 == 1) {
                DestinationUID destinationUID = DestinationUID.getUID(string, n5);
                Destination destination = Destination.getDestination(destinationUID);
                return RaptorProtocol.generateAddDestinationRecord(destination);
            }
            if (n4 == 2) {
                return RaptorProtocol.generateRemDestinationRecord(string, n5);
            }
        }
        logger.log(8, "Internal error : upgradeConfigChangeRecord conversion failed.");
        return byArray;
    }

    private byte[] prepareDestinationUpdate(String string, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "FalconProtocol.recordUpdateDestination");
        }
        this.recordAddDestinationEvent(destination.getDestinationName(), destination.getType());
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "FalconProtocol.recordRemoveDestination");
        }
        this.recordRemDestinationEvent(destination.getDestinationName(), destination.getType());
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        logger.log(4, "Sending New Destination " + destination);
        this.sendDestinationUpdate(destination.getDestinationName(), destination.getType(), 1);
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        logger.log(4, "Sending New Destination " + destination);
        this.sendDestinationUpdate(destination.getDestinationName(), destination.getType(), 2);
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        this.recordAddDurableEvent(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        this.recordRemDurableEvent(subscription);
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        this.sendNewConsumer(subscription, bl);
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        this.sendInterestUpdate(consumer, 1);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendRemovedConsumer(Consumer consumer) throws BrokerException {
        if (consumer instanceof Subscription) {
            this.sendInterestUpdate(consumer, 5);
        } else if (consumer.getSubscription() != null) {
            this.sendInterestUpdate(consumer, 3);
        } else {
            this.sendInterestUpdate(consumer, 2);
        }
    }

    public void sendActivateConsumer(Consumer consumer) throws BrokerException {
        this.sendInterestUpdate(consumer, 4);
    }

    protected int recordAddDestinationEvent(String string, int n) throws BrokerException {
        byte[] byArray = this.prepareDestinationUpdate(string, n, 1);
        return this.recordConfigChangeEvent(11, byArray);
    }

    protected int recordRemDestinationEvent(String string, int n) throws BrokerException {
        byte[] byArray = this.prepareDestinationUpdate(string, n, 2);
        return this.recordConfigChangeEvent(11, byArray);
    }

    protected void sendDestinationUpdate(String string, int n, int n2) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Broadcasting destination update. Name = {0}, Type = {1}", (Object)string, DestType.toString(n));
        }
        byte[] byArray = this.prepareDestinationUpdate(string, n, n2);
        try {
            this.c.broadcast(11, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveDestinationUpdate(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(11));
                return;
            }
            int n2 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            if (DEBUG) {
                logger.log(4, "MessageBus: Receiving destination update from {0}. Name = {1}", (Object)brokerAddress, string);
            }
            switch (n2) {
                case 1: {
                    Destination destination = Destination.createDestination(string, n3, !DestType.isTemporary(n3), false, this.selfAddress);
                    this.cbDispatcher.notifyCreateDestination(destination);
                    break;
                }
                case 2: {
                    DestinationUID destinationUID = DestinationUID.getUID(string, DestType.isQueue(n3));
                    this.cbDispatcher.notifyDestroyDestination(destinationUID);
                    break;
                }
                default: {
                    logger.log(32, "B3096");
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] prepareResetPersistenceRecord() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(12);
            dataOutputStream.writeInt(this.version);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void receiveResetPersistence(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(12));
                return;
            }
            if (DEBUG) {
                logger.log(4, "MessageBus: Receiving reset persistence command from {0}", brokerAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendRestartCluster() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.broadcast(13, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveRestartCluster(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(13));
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (DEBUG) {
            logger.log(4, "MessageBus: Received reset cluster notification from {0}.", brokerAddress);
        }
        logger.log(8, "B1074");
        this.c.reloadCluster();
    }

    private void sendRequestInterestUpdate(BrokerAddress brokerAddress) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.version);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            this.c.unicast(brokerAddress, 14, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void receiveRequestInterestUpdate(BrokerAddress brokerAddress, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n > this.version) {
                logger.log(16, "B2027", (Object)Integer.toString(n), Integer.toString(14));
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (DEBUG) {
            logger.log(4, "MessageBus: Received request for a full interest update from {0}.", brokerAddress);
        }
        this.forwardLocalInterests(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBrokerInfo(BrokerInfo brokerInfo) {
        long l;
        BrokerInfo brokerInfo2;
        Cloneable cloneable;
        block15: {
            cloneable = this.brokerList;
            synchronized (cloneable) {
                brokerInfo2 = this.brokerList.put(brokerInfo.getBrokerAddr(), brokerInfo);
            }
            if (!this.configSyncComplete) {
                try {
                    cloneable = this.c.getConfigServer();
                    if (cloneable != null && ((BrokerAddress)cloneable).equals(brokerInfo.getBrokerAddr())) {
                        l = -1L;
                        l = this.getLastRefreshTime();
                        this.sendConfigChangesRequest((BrokerAddress)cloneable, l);
                        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
                            logger.log(8, "B1070");
                        }
                        break block15;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (brokerInfo2 == null) {
            if (DEBUG) {
                logger.log(4, "MessageBus: New Broker : {0}", brokerInfo);
            }
            try {
                cloneable = this.c.getConfigServer();
                if (brokerInfo.getStoreDirtyFlag() && cloneable != null && !((BrokerAddress)cloneable).equals(brokerInfo.getBrokerAddr())) {
                    l = -1L;
                    l = this.getLastRefreshTime();
                    this.sendConfigChangesRequest((BrokerAddress)cloneable, l);
                    if (!this.waitConfigChangesResponse()) {
                        return 2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.forwardLocalInterests(brokerInfo.getBrokerAddr());
            this.restartElections(brokerInfo.getBrokerAddr());
            logger.log(8, "B1071", brokerInfo.getBrokerAddr().toString());
        }
        this.updateActivelistProperty();
        if (this.haWatchdog != null) {
            this.haWatchdog.handleBrokerUp(brokerInfo.getBrokerAddr());
        }
        return 0;
    }

    private void forwardLocalInterests(BrokerAddress brokerAddress) {
        Serializable serializable;
        Iterator iterator = Destination.getTempDestinations(this.selfAddress);
        while (iterator.hasNext()) {
            serializable = (Destination)iterator.next();
            this.sendDestinationUpdate(((Destination)serializable).getDestinationName(), ((Destination)serializable).getType(), 1);
        }
        serializable = new HashSet();
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            DestinationUID destinationUID;
            Destination destination;
            Consumer consumer = (Consumer)iterator.next();
            if (consumer instanceof Subscription) continue;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (this.selfAddress == consumerUID.getBrokerAddress()) {
                serializable.add(consumer);
            }
            if (!consumer.getIsActiveConsumer() || (destination = Destination.getDestination(destinationUID = consumer.getDestinationUID())) == null || destination.getMaxActiveConsumers() != 1) continue;
            hashSet.add(consumer);
        }
        if (!serializable.isEmpty()) {
            this.sendInterestUpdate(brokerAddress, (Collection)((Object)serializable), 1);
        }
        if (!hashSet.isEmpty()) {
            this.sendInterestUpdate(brokerAddress, hashSet, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartElections(BrokerAddress brokerAddress) {
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set set = this.resTable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                resource.brokerAdded(brokerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBrokerInfo(BrokerAddress brokerAddress) {
        Object object;
        block18: {
            BrokerInfo brokerInfo;
            object = this.brokerList;
            synchronized (object) {
                brokerInfo = (BrokerInfo)this.brokerList.remove(brokerAddress);
            }
            if (DEBUG) {
                logger.log(4, "MessageBus: Broker down : {0}", brokerInfo);
            }
            try {
                if (!this.c.getConfigServer().equals(brokerAddress)) break block18;
                object = this.eventLogLockObject;
                synchronized (object) {
                    this.eventLogStatus = 2;
                    this.eventLogLockObject.notify();
                }
                object = this.cfgSrvWaitObject;
                synchronized (object) {
                    if (this.cfgSrvRequestCount > 0) {
                        this.cfgSrvRequestCount = 0;
                        this.cfgSrvRequestErr = true;
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.log(8, "B1072", brokerAddress.toString());
        this.cbDispatcher.brokerDown(brokerAddress);
        object = this.resTable;
        synchronized (object) {
            Set set = this.resTable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                resource.brokerRemoved(brokerAddress);
            }
        }
        this.updateActivelistProperty();
        if (this.haWatchdog != null) {
            this.haWatchdog.handleBrokerDown(brokerAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivelistProperty() {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(this.selfAddress.toString());
        Object object3 = this.brokerList;
        synchronized (object3) {
            object2 = this.brokerList.values();
            object = object2.iterator();
            while (object.hasNext()) {
                BrokerInfo brokerInfo = (BrokerInfo)object.next();
                treeSet.add(brokerInfo.getBrokerAddr().toString());
            }
        }
        object3 = null;
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            if (object3 == null) {
                object3 = (String)object2.next();
                continue;
            }
            object3 = (String)object3 + ", " + (String)object2.next();
        }
        object = Globals.getConfig();
        ((UpdateProperties)object).putOne("imq.cluster.brokerlist.active", (String)object3);
    }

    public void notifyInterestCreated(Consumer consumer) {
        this.cbDispatcher.interestCreated(consumer);
    }

    public void notifyInterestRemoved(Consumer consumer) {
        this.cbDispatcher.interestRemoved(consumer);
    }

    public void notifyPrimaryInterestChanged(Consumer consumer) {
        this.cbDispatcher.activeStateChanged(consumer);
    }

    private void configServerBackup(String string) {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            logger.log(16, "B2054");
            return;
        }
        if (brokerAddress == null || !brokerAddress.equals(this.selfAddress)) {
            logger.log(16, "B2054");
            return;
        }
        try {
            ChangeRecord changeRecord;
            File file = new File(string);
            if (!file.createNewFile()) {
                logger.log(16, "B2055", string);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray[1];
            ArrayList<ChangeRecord> arrayList2 = new ArrayList<ChangeRecord>();
            HashMap<String, ChangeRecord> hashMap = new HashMap<String, ChangeRecord>();
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                changeRecord = ChangeRecord.makeChangeRecord(byArray);
                arrayList2.add(changeRecord);
                ChangeRecord changeRecord2 = (ChangeRecord)hashMap.get(changeRecord.getUniqueKey());
                if (changeRecord2 != null) {
                    changeRecord2.discard = true;
                }
                if (!changeRecord.isAddOp()) {
                    changeRecord.discard = true;
                }
                hashMap.put(changeRecord.getUniqueKey(), changeRecord);
            }
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF("imq.cluster.masterbroker.backup");
            byte[] byArray = this.prepareResetPersistenceRecord();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            for (int i = 0; i < arrayList2.size(); ++i) {
                changeRecord = (ChangeRecord)arrayList2.get(i);
                if (changeRecord.discard) continue;
                dataOutputStream.writeInt(changeRecord.rec.length + 4);
                dataOutputStream.writeInt(changeRecord.eventDestId);
                dataOutputStream.write(changeRecord.rec, 0, changeRecord.rec.length);
            }
            dataOutputStream.writeInt(0);
        }
        catch (Exception exception) {
            logger.logStack(16, "B2056", exception);
        }
    }

    private void configServerRestore(String string) {
        try {
            int n;
            File file = new File(string);
            if (!file.exists()) {
                logger.log(16, "B2057", string);
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n2 = dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            if (!string2.equals("imq.cluster.masterbroker.backup")) {
                logger.log(16, "B2058", string);
                return;
            }
            if (n2 > this.version) {
                logger.log(16, "B2059");
                return;
            }
            this.store.clearAllConfigChangeRecords(false);
            while ((n = dataInputStream.readInt()) != 0) {
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            logger.logStack(16, "B2060", exception);
            return;
        }
    }

    private void storeLastConfigServer(BrokerAddress brokerAddress) throws BrokerException {
        this.store.updateProperty("MessageBus.lastConfigServer", brokerAddress, false);
    }

    private BrokerAddress getLastConfigServer() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = (BrokerAddress)this.store.getProperty("MessageBus.lastConfigServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brokerAddress;
    }

    private void storeLastRefreshTime(long l) throws BrokerException {
        Long l2 = new Long(l);
        this.store.updateProperty("MessageBus.lastRefreshTime", l2, false);
    }

    private long getLastRefreshTime() {
        Long l = null;
        try {
            l = (Long)this.store.getProperty("MessageBus.lastRefreshTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == null) {
            return -1L;
        }
        return l;
    }
}

