/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerDownCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEventListener;
import com.sun.messaging.jmq.jmsserver.multibroker.ClientDownCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCreateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterDestroyDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterUpdateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ConfigSyncCompleteCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.DeliverMessageCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GoHAActiveCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestCreatedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestRemovedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.PrimaryInterestChangedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ProcessAckCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.UnsubscribeCallbackEvent;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class CallbackDispatcher
extends Thread
implements MessageBusCallback {
    protected static final Logger logger = Globals.getLogger();
    private MessageBusCallback cb = null;
    private LinkedList eventQ = null;
    private boolean stopThread = false;

    public CallbackDispatcher(MessageBusCallback messageBusCallback) {
        this.cb = messageBusCallback;
        this.eventQ = new LinkedList();
        this.setName("MessageBusCallbackDispatcher");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configSyncComplete() {
        ConfigSyncCompleteCallbackEvent configSyncCompleteCallbackEvent = new ConfigSyncCompleteCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(configSyncCompleteCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteAck(SysMessageID sysMessageID, ConsumerUID consumerUID, int n) {
        ProcessAckCallbackEvent processAckCallbackEvent = new ProcessAckCallbackEvent(sysMessageID, consumerUID, n);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(processAckCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverMessage(PacketReference packetReference, ConsumerUID consumerUID, BrokerAddress brokerAddress, boolean bl) {
        DeliverMessageCallbackEvent deliverMessageCallbackEvent = new DeliverMessageCallbackEvent(packetReference, consumerUID, brokerAddress, bl);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(deliverMessageCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestCreated(Consumer consumer) {
        InterestCreatedCallbackEvent interestCreatedCallbackEvent = new InterestCreatedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestCreatedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRemoved(Consumer consumer) {
        InterestRemovedCallbackEvent interestRemovedCallbackEvent = new InterestRemovedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestRemovedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Subscription subscription) {
        UnsubscribeCallbackEvent unsubscribeCallbackEvent = new UnsubscribeCallbackEvent(subscription);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(unsubscribeCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(ConsumerUID consumerUID) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumerUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(Consumer consumer) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientDown(ConnectionUID connectionUID) {
        ClientDownCallbackEvent clientDownCallbackEvent = new ClientDownCallbackEvent(connectionUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(clientDownCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress brokerAddress) {
        BrokerDownCallbackEvent brokerDownCallbackEvent = new BrokerDownCallbackEvent(brokerAddress);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(brokerDownCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreateDestination(Destination destination) {
        ClusterCreateDestinationCallbackEvent clusterCreateDestinationCallbackEvent = new ClusterCreateDestinationCallbackEvent(destination, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore create destination event on " + destination);
                return;
            }
            this.eventQ.add(clusterCreateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterCreateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDestroyDestination(DestinationUID destinationUID) {
        ClusterDestroyDestinationCallbackEvent clusterDestroyDestinationCallbackEvent = new ClusterDestroyDestinationCallbackEvent(destinationUID, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore destroy destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterDestroyDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterDestroyDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdateDestination(DestinationUID destinationUID, Map map) {
        ClusterUpdateDestinationCallbackEvent clusterUpdateDestinationCallbackEvent = new ClusterUpdateDestinationCallbackEvent(destinationUID, map, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore update destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterUpdateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterUpdateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goHAActive() {
        GoHAActiveCallbackEvent goHAActiveCallbackEvent = new GoHAActiveCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(goHAActiveCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.stopThread = true;
            this.eventQ.notify();
        }
        try {
            this.join(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LinkedList linkedList;
        CallbackEvent callbackEvent = null;
        try {
            while (true) {
                CallbackEventListener callbackEventListener;
                Object var6_4;
                LinkedList linkedList2 = this.eventQ;
                synchronized (linkedList2) {
                    while (!this.stopThread && this.eventQ.isEmpty()) {
                        try {
                            this.eventQ.wait();
                        }
                        catch (Exception exception) {}
                    }
                    if (this.stopThread) {
                        break;
                    }
                    callbackEvent = (CallbackEvent)this.eventQ.removeFirst();
                }
                try {
                    callbackEvent.dispatch(this.cb);
                    var6_4 = null;
                    callbackEventListener = callbackEvent.getEventListener();
                    if (callbackEventListener == null) continue;
                    callbackEventListener.eventProcessed();
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    callbackEventListener = callbackEvent.getEventListener();
                    if (callbackEventListener != null) {
                        callbackEventListener.eventProcessed();
                    }
                    throw throwable;
                }
            }
            Object var9_8 = null;
            linkedList = this.eventQ;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            LinkedList linkedList3 = this.eventQ;
            synchronized (linkedList3) {
                try {
                    callbackEvent = (CallbackEvent)this.eventQ.removeFirst();
                    while (callbackEvent != null) {
                        CallbackEventListener callbackEventListener = callbackEvent.getEventListener();
                        if (callbackEventListener != null) {
                            callbackEventListener.eventProcessed();
                        }
                        callbackEvent = (CallbackEvent)this.eventQ.removeFirst();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                this.stopThread = true;
            }
            throw throwable;
        }
        synchronized (linkedList) {
            try {
                callbackEvent = (CallbackEvent)this.eventQ.removeFirst();
                while (callbackEvent != null) {
                    CallbackEventListener callbackEventListener = callbackEvent.getEventListener();
                    if (callbackEventListener != null) {
                        callbackEventListener.eventProcessed();
                    }
                    callbackEvent = (CallbackEvent)this.eventQ.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.stopThread = true;
        }
    }
}

