/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Hashtable;

public class ShutdownHandler
extends AdminCmdHandler {
    public ShutdownHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Boolean bl;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Shutting down broker: " + hashtable);
        }
        Broker.shuttingDown = true;
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        ShutdownHandler.setProperties(packet2, 39, 200, null);
        Boolean bl2 = (Boolean)hashtable.get("JMQKill");
        if (bl2 != null && bl2.booleanValue()) {
            Broker.removeShutdownHook(Broker.shutdownHook);
            System.exit(1);
        }
        boolean bl3 = (bl = (Boolean)hashtable.get("JMQRestart")) == null ? false : bl;
        Globals.getAuditSession().brokerOperation(iMQConnection.getUserName(), iMQConnection.remoteHostString(), bl3 ? "broker restart" : "broker shutdown");
        this.waitForHandlersToComplete(20);
        Broker.shuttingDownBroker();
        this.parent.sendReply(iMQConnection, packet, packet2);
        iMQConnection.flush(1000L);
        if (bl3) {
            this.logger.log(8, "B1094");
        } else {
            this.logger.log(8, "B1093");
        }
        try {
            Broker.shutdownBroker(bl3);
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, "B3063", brokerException);
        }
        return true;
    }
}

