/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class TransactionHandler
extends PacketHandler {
    private static final Object lock = TransactionHandler.class;
    private TransactionList translist = null;
    public static boolean DEBUG = false;

    public TransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, long l, String string) {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
    }

    public void sendReplyBody(IMQConnection iMQConnection, Packet packet, int n, int n2, Hashtable hashtable, byte[] byArray) {
        Packet packet2;
        block6: {
            block5: {
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(n);
                packet2.setConsumerID(packet.getConsumerID());
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Integer>();
                }
                hashtable.put("JMQStatus", new Integer(n2));
                if (IMQConnection.DUMP_PACKET) break block5;
                if (!IMQConnection.OUT_DUMP_PACKET) break block6;
            }
            hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
        }
        packet2.setProperties(hashtable);
        if (byArray != null) {
            packet2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage(packet2);
    }

    public long getJMQTransactionID(Hashtable hashtable) {
        if (hashtable != null) {
            Object v = hashtable.get("JMQTransactionID");
            if (v != null && v instanceof Integer) {
                return ((Integer)v).intValue();
            }
            if (v != null) {
                return (Long)v;
            }
        }
        return 0L;
    }

    public static void convertPacketTid(IMQConnection iMQConnection, Packet packet) {
        long l = packet.getTransactionID();
        HashMap hashMap = (HashMap)iMQConnection.getClientData("tidmap");
        if (hashMap == null) {
            return;
        }
        TransactionUID transactionUID = (TransactionUID)hashMap.get(new Long(l));
        if (transactionUID == null) {
            return;
        }
        packet.setTransactionID(transactionUID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        HashMap<Long, TransactionUID> hashMap;
        ByteBuffer byteBuffer;
        ArrayList<TransactionUID> arrayList;
        long l = 0L;
        TransactionUID transactionUID = null;
        TransactionState transactionState = null;
        JMQXid jMQXid = null;
        Integer n = null;
        boolean bl = false;
        boolean bl2 = true;
        Hashtable hashtable = null;
        String string = null;
        try {
            hashtable = packet.getProperties();
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
        }
        catch (Exception exception) {
            logger.log(8, "Internal Error: unable to retrieve  properties from transaction message " + packet, exception);
            hashtable = new Hashtable();
        }
        Boolean bl3 = (Boolean)hashtable.get("JMQRedeliver");
        bl = bl3 == null ? false : bl3;
        Boolean bl4 = (Boolean)hashtable.get("JMQSetRedelivered");
        boolean bl5 = bl2 = bl4 == null ? true : bl4;
        if (DEBUG) {
            logger.log(4, "JMQRedeliver flag is " + bl3);
        }
        if ((arrayList = (ArrayList<TransactionUID>)iMQConnection.getClientData("transaction")) == null) {
            arrayList = new ArrayList<TransactionUID>();
            iMQConnection.addClientData("transaction", arrayList);
        }
        if ((byteBuffer = packet.getMessageBody()) != null) {
            hashMap = new JMQByteBufferInputStream(byteBuffer);
            try {
                jMQXid = JMQXid.read(new DataInputStream((InputStream)((Object)hashMap)));
            }
            catch (IOException iOException) {
                logger.log(32, "B3100", "Could not decode xid from packet: " + iOException + " Ignoring " + PacketType.getString(packet.getPacketType()));
                string = iOException.getMessage();
                this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, 400, 0L, string);
                return true;
            }
        }
        if (hashtable != null) {
            n = (Integer)hashtable.get("JMQXAFlags");
        }
        hashMap = null;
        Object object = lock;
        synchronized (object) {
            hashMap = (HashMap)iMQConnection.getClientData("tidmap");
            if (hashMap == null) {
                hashMap = new HashMap<Long, TransactionUID>();
                iMQConnection.addClientData("tidmap", hashMap);
            }
        }
        l = this.getJMQTransactionID(hashtable);
        if (packet.getPacketType() == 44 && (n == null || TransactionState.isFlagSet(0, n))) {
            transactionUID = new TransactionUID();
        } else if (packet.getPacketType() == 60) {
            if (l != 0L) {
                transactionUID = new TransactionUID(l);
            }
            jMQXid = null;
        } else {
            block69: {
                if (l == 0L && jMQXid != null) {
                    transactionUID = this.translist.xidToUID(jMQXid);
                    if (transactionUID != null) {
                        l = transactionUID.longValue();
                        break block69;
                    } else {
                        logger.log(16, PacketType.getString(packet.getPacketType()) + ": Ignoring unknown XID=" + jMQXid + " broker will " + (packet.getSendAcknowledge() ? "notify the client" : " not notify the client"));
                        if (!packet.getSendAcknowledge()) return true;
                        string = "Uknown XID " + jMQXid;
                        this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, 404, 0L, string);
                        return true;
                    }
                }
                if (l != 0L) {
                    if (iMQConnection.getClientProtocolVersion() == 100) {
                        object = lock;
                        synchronized (object) {
                            transactionUID = (TransactionUID)hashMap.get(new Long(l));
                        }
                    } else {
                        transactionUID = new TransactionUID(l);
                    }
                }
            }
            if (transactionUID == null) {
                logger.log(8, "InternalError: Transaction ID was not passed by the jms api on a method that reqires an existing transaction ");
                this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, 500, 0L, "Internal Error: bad MQ protocol, missing TransactionID");
                return true;
            }
            transactionState = this.translist.retrieveState(transactionUID);
            if (transactionState == null) {
                transactionState = this.cacheGetState(transactionUID, iMQConnection);
                if (transactionState != null) {
                    logger.log(32, "Transaction ID " + transactionUID + " has already been resolved. Ignoring request: " + PacketType.getString(packet.getPacketType()) + ". Last state of this transaction: " + transactionState.toString() + " broker will " + (packet.getSendAcknowledge() ? "notify the client" : " not notify the client"));
                } else {
                    logger.log(Broker.quiescent ? 4 : 32, "B3100", "Unknown transaction: " + transactionUID + "(" + l + ")" + " broker will " + (packet.getSendAcknowledge() ? "notify the client" : " not notify the client") + " Ignoring " + PacketType.getString(packet.getPacketType()) + "\n" + PacketUtil.dumpPacket(packet));
                }
                if (!packet.getSendAcknowledge()) return true;
                string = "Unknown transaction " + transactionUID;
                this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, 404, transactionUID.longValue(), string);
                return true;
            }
        }
        int n2 = 200;
        if (DEBUG) {
            logger.log(4, this.getClass().getName() + ": " + PacketType.getString(packet.getPacketType()) + ": " + "TUID=" + transactionUID + " XAFLAGS=" + TransactionState.xaFlagToString(n) + " State=" + transactionState + " Xid=" + jMQXid);
        }
        if (!(jMQXid == null || transactionState == null || transactionState.getXid() != null && jMQXid.equals(transactionState.getXid()))) {
            logger.log(32, "B3100", "Transaction Xid mismatch. " + PacketType.getString(packet.getPacketType()) + " Packet has tuid=" + transactionUID + " xid=" + jMQXid + ", transaction table has tuid=" + transactionUID + " xid=" + transactionState.getXid() + ". Using values from table.");
            jMQXid = transactionState.getXid();
        }
        if (jMQXid == null && transactionState != null && transactionState.getXid() != null && packet.getPacketType() != 60) {
            jMQXid = transactionState.getXid();
            logger.log(16, "B3100", "Transaction Xid not found in " + PacketType.getString(packet.getPacketType()) + " packet for tuid " + transactionUID + ". Will use " + jMQXid);
        }
        switch (packet.getPacketType()) {
            case 44: {
                SessionUID sessionUID = null;
                Long l2 = (Long)hashtable.get("JMQSessionID");
                if (l2 != null) {
                    sessionUID = new SessionUID(l2);
                }
                if (n != null && !TransactionState.isFlagSet(0, n)) {
                    try {
                        int n3 = transactionState.nextState(packet.getPacketType(), n);
                        this.translist.updateState(transactionUID, n3, true);
                    }
                    catch (BrokerException brokerException) {
                        logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
                        string = brokerException.getMessage();
                        n2 = brokerException.getStatusCode();
                    }
                } else {
                    Object object2 = lock;
                    synchronized (object2) {
                        try {
                            if (iMQConnection.getClientProtocolVersion() == 100) {
                                hashMap.put(new Long(l), transactionUID);
                            }
                            transactionState = new TransactionState();
                            transactionState.setState(1);
                            transactionState.setUser(iMQConnection.getUserName());
                            transactionState.setClientID((String)iMQConnection.getClientData("client id"));
                            transactionState.setXid(jMQXid);
                            if (iMQConnection instanceof IMQConnection) {
                                transactionState.setConnectionString(iMQConnection.userReadableString());
                            }
                            this.translist.addTransactionID(transactionUID, transactionState);
                            arrayList.add(transactionUID);
                        }
                        catch (BrokerException brokerException) {
                            logger.log(16, "Exception starting new transaction: " + brokerException.toString());
                            string = brokerException.getMessage();
                            n2 = brokerException.getStatusCode();
                        }
                    }
                }
                this.sendReply(iMQConnection, packet, 45, n2, transactionUID.longValue(), string);
                return true;
            }
            case 56: 
            case 58: {
                try {
                    int n4 = transactionState.nextState(packet.getPacketType(), n);
                    this.translist.updateState(transactionUID, n4, true);
                }
                catch (BrokerException brokerException) {
                    logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
                    string = brokerException.getMessage();
                    n2 = brokerException.getStatusCode();
                }
                this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, n2, transactionUID.longValue(), string);
                return true;
            }
            case 60: {
                Vector vector = null;
                if (transactionUID != null) {
                    vector = new Vector();
                    transactionState = this.translist.retrieveState(transactionUID);
                    if (transactionState.getState() == 5) {
                        vector.add(transactionUID);
                    }
                } else {
                    if (n == null || !TransactionState.isFlagSet(0x1000000, n)) {
                        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                        hashtable2.put("JMQQuantity", new Integer(0));
                        this.sendReplyBody(iMQConnection, packet, 61, 200, hashtable2, null);
                        return true;
                    }
                    vector = this.translist.getTransactions(5);
                }
                int n5 = vector.size();
                int n6 = 0;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5 * JMQXid.size());
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n5; ++i) {
                    TransactionUID transactionUID2 = (TransactionUID)vector.get(i);
                    TransactionState transactionState2 = this.translist.retrieveState(transactionUID2);
                    if (transactionState2 == null) {
                        logger.log(32, "B3100", "Could not find state for TUID " + transactionUID2);
                        continue;
                    }
                    JMQXid jMQXid2 = transactionState2.getXid();
                    if (jMQXid2 == null) continue;
                    try {
                        jMQXid2.write(dataOutputStream);
                        ++n6;
                        continue;
                    }
                    catch (Exception exception) {
                        logger.log(32, "B3100", "Could not write Xid " + jMQXid2 + " to message body: " + exception.toString());
                    }
                }
                Hashtable<String, Number> hashtable3 = new Hashtable<String, Number>();
                hashtable3.put("JMQQuantity", new Integer(n6));
                if (transactionUID != null) {
                    hashtable3.put("JMQTransactionID", new Long(transactionUID.longValue()));
                }
                this.sendReplyBody(iMQConnection, packet, 61, 200, hashtable3, byteArrayOutputStream.toByteArray());
                return true;
            }
            case 46: {
                try {
                    this.doCommit(transactionUID, jMQXid, n, transactionState, arrayList, true, iMQConnection, packet);
                    return true;
                }
                catch (BrokerException brokerException) {
                    n2 = brokerException.getStatusCode();
                    string = brokerException.getMessage();
                    if (!packet.getSendAcknowledge()) return true;
                    this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, n2, transactionUID.longValue(), string);
                    return true;
                }
            }
            case 48: {
                try {
                    if (bl) {
                        if (DEBUG) {
                            logger.log(8, "Redelivering msgs for " + transactionUID);
                        }
                        boolean bl6 = bl;
                        this.redeliverUnacked(transactionUID, bl6, bl2);
                    }
                }
                catch (BrokerException brokerException) {
                    logger.log(32, "B3100", "REDELIVER: " + brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
                    string = brokerException.getMessage();
                    n2 = brokerException.getStatusCode();
                }
                try {
                    this.doRollback(transactionUID, jMQXid, n, transactionState, arrayList, iMQConnection);
                }
                catch (BrokerException brokerException) {
                    string = brokerException.getMessage();
                    n2 = brokerException.getStatusCode();
                }
                if (!packet.getSendAcknowledge()) return true;
                this.sendReply(iMQConnection, packet, packet.getPacketType() + 1, n2, transactionUID.longValue(), string);
                return true;
            }
        }
        return true;
    }

    private void cacheSetState(TransactionUID transactionUID, TransactionState transactionState, IMQConnection iMQConnection) {
        CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
        if (cacheHashMap == null) {
            cacheHashMap = new CacheHashMap(4);
            iMQConnection.addClientData("txncache", cacheHashMap);
        }
        cacheHashMap.put(transactionUID, transactionState);
    }

    private TransactionState cacheGetState(TransactionUID transactionUID, IMQConnection iMQConnection) {
        CacheHashMap cacheHashMap = (CacheHashMap)iMQConnection.getClientData("txncache");
        if (cacheHashMap == null) {
            return null;
        }
        return (TransactionState)cacheHashMap.get(transactionUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommit(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, boolean bl, IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        PacketReference packetReference;
        SysMessageID sysMessageID;
        int n2 = 200;
        try {
            int n3 = jMQXid == null ? 6 : transactionState.nextState(46, n);
            transactionState = this.translist.updateState(transactionUID, n3, false);
        }
        catch (BrokerException brokerException) {
            logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
            throw brokerException;
        }
        List list2 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        BrokerException brokerException = null;
        Object object2 = lock;
        synchronized (object2) {
            try {
                list2 = this.translist.retrieveSentMessages(transactionUID);
                hashMap = this.translist.retrieveConsumedMessages(transactionUID);
                hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
                this.cacheSetState(transactionUID, transactionState, iMQConnection);
                this.translist.removeTransactionID(transactionUID);
            }
            catch (BrokerException brokerException2) {
                n2 = brokerException2.getStatusCode();
                brokerException = brokerException2;
            }
            if (list != null) {
                list.remove(transactionUID);
            }
        }
        if (n2 != 200) {
            throw brokerException;
        }
        if (bl) {
            this.sendReply(iMQConnection, packet, 47, n2, transactionUID.longValue(), null);
        }
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            sysMessageID = (SysMessageID)list2.get(i);
            packetReference = Destination.get(sysMessageID);
            if (packetReference == null) {
                logger.log(32, "B3100", "transacted message removed too early " + sysMessageID);
                continue;
            }
            try {
                object = Destination.getDestination(packetReference.getDestinationUID());
                Set set = ((Destination)object).routeNewMessage(packetReference);
                ((Destination)object).forwardMessage(set, packetReference);
                continue;
            }
            catch (Exception exception) {
                logger.logStack(Broker.quiescent ? 4 : 32, "B3100", "unable to route/send transaction message " + sysMessageID, (Throwable)exception);
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                sysMessageID = (SysMessageID)iterator.next();
                if (sysMessageID == null) continue;
                packetReference = Destination.get(sysMessageID);
                object = (List)hashMap.get(sysMessageID);
                for (int i = 0; i < object.size(); ++i) {
                    ConsumerUID consumerUID = (ConsumerUID)object.get(i);
                    try {
                        Destination destination;
                        Object object3;
                        if (packetReference == null || packetReference.isDestroyed() || packetReference.isInvalid()) continue;
                        Session session = Session.getSession(consumerUID);
                        if (session != null) {
                            object3 = session.ackMessage(consumerUID, sysMessageID);
                            if (object3 == null) continue;
                            destination = Destination.getDestination(packetReference.getDestinationUID());
                            destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                            continue;
                        }
                        object3 = (ConsumerUID)hashMap2.get(consumerUID);
                        if (object3 == null) {
                            object3 = consumerUID;
                        }
                        try {
                            if (!packetReference.acknowledged(consumerUID, (ConsumerUID)object3, true, true)) continue;
                            destination = Destination.getDestination(packetReference.getDestinationUID());
                            destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                        catch (BrokerException brokerException3) {
                            logger.log(16, "Internal error", brokerException3);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        logger.logStack(32, "B3100", "-------------------------------------------Processing Acknowledgement during committ [" + sysMessageID + ":" + consumerUID + ":" + iMQConnection.getConnectionUID() + "]\nReference is " + (packetReference == null ? null : packetReference.getSysMessageID()) + "\n" + PacketUtil.dumpPacket(packet) + "--------------------------------------------", (Throwable)exception);
                    }
                }
            }
        }
        Object object4 = lock;
        synchronized (object4) {
            this.translist.removeTransactionAck(transactionUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRollback(TransactionUID transactionUID, JMQXid jMQXid, Integer n, TransactionState transactionState, List list, IMQConnection iMQConnection) throws BrokerException {
        Object object;
        Object object2;
        PacketReference packetReference;
        SysMessageID sysMessageID;
        Iterator iterator;
        int n2;
        int n3 = 200;
        try {
            n2 = jMQXid == null ? 7 : transactionState.nextState(48, n);
        }
        catch (BrokerException brokerException) {
            logger.log(32, "B3100", brokerException.toString() + ": TUID=" + transactionUID + " Xid=" + jMQXid);
            throw brokerException;
        }
        Object object3 = lock;
        synchronized (object3) {
            iterator = this.translist.retrieveSentMessages(transactionUID);
            for (int i = 0; iterator != null && i < iterator.size(); ++i) {
                sysMessageID = (SysMessageID)iterator.get(i);
                if (DEBUG) {
                    logger.log(4, "Removing " + sysMessageID + " because of rollback");
                }
                if ((packetReference = Destination.get(sysMessageID)) == null) continue;
                object2 = packetReference.getDestinationUID();
                object = Destination.getDestination((DestinationUID)object2);
                ((Destination)object).removeMessage(sysMessageID, RemoveReason.ROLLBACK);
            }
            if (list != null) {
                list.remove(transactionUID);
            }
        }
        object3 = this.translist.getOrphanAck(transactionUID);
        if (object3 != null) {
            iterator = object3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                sysMessageID = (SysMessageID)entry.getKey();
                packetReference = Destination.get(sysMessageID);
                if (packetReference == null) {
                    logger.log(4, transactionUID + ":Unknown orphan " + sysMessageID);
                    continue;
                }
                object2 = (List)entry.getValue();
                object = object2.iterator();
                while (object.hasNext()) {
                    ConsumerUID consumerUID = (ConsumerUID)object.next();
                    packetReference.getDestination().forwardOrphanMessage(packetReference, consumerUID);
                }
            }
        }
        iterator = lock;
        synchronized (iterator) {
            this.translist.removeTransactionAck(transactionUID);
        }
        try {
            transactionState.setState(n2);
            this.cacheSetState(transactionUID, transactionState, iMQConnection);
            this.translist.removeTransactionID(transactionUID);
        }
        catch (BrokerException brokerException) {
            logger.logStack(32, "B3100", "exception removing transaction", (Throwable)brokerException);
            throw brokerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redeliverUnacked(TransactionUID transactionUID, boolean bl, boolean bl2) throws BrokerException {
        Set<Object> set;
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        Object var4_4 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        Object var7_7 = null;
        HashMap hashMap3 = lock;
        synchronized (hashMap3) {
            hashMap = this.translist.retrieveConsumedMessages(transactionUID);
            hashMap2 = this.translist.retrieveStoredConsumerUIDs(transactionUID);
        }
        hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object4 = (SysMessageID)iterator.next();
                if (object4 == null || (object3 = Destination.get((SysMessageID)object4)) == null || ((PacketReference)object3).isDestroyed() || ((PacketReference)object3).isInvalid()) continue;
                object2 = (List)hashMap.get(object4);
                for (int i = 0; i < object2.size(); ++i) {
                    serializable = (ConsumerUID)object2.get(i);
                    object = (ConsumerUID)hashMap2.get(serializable);
                    if (object == null) {
                        object = serializable;
                    }
                    if ((set = (TreeSet<Object>)hashMap3.get(serializable)) == null) {
                        set = new TreeSet<Object>(new RefCompare());
                        hashMap3.put(serializable, set);
                    }
                    try {
                        if (bl2) {
                            ((PacketReference)object3).consumed((ConsumerUID)object, false, false);
                        } else {
                            ((PacketReference)object3).removeDelivered((ConsumerUID)object, true);
                        }
                    }
                    catch (IOException iOException) {
                        logger.log(16, "Internal error", iOException);
                    }
                    set.add(object3);
                }
            }
        }
        iterator = hashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (ConsumerUID)iterator.next();
            object3 = Consumer.getConsumer((ConsumerUID)object4);
            if (object3 == null) {
                if (!DEBUG) continue;
                logger.log(8, transactionUID + ":Can not redeliver messages to " + object4 + " consumer is gone");
                continue;
            }
            object2 = (SortedSet)hashMap3.get(object4);
            if (DEBUG) {
                logger.log(8, transactionUID + ":Redelivering " + object2.size() + " msgs to " + object4);
            }
            if (!bl) {
                iterator.remove();
                continue;
            }
            if (((Consumer)object3).routeMessages((Collection)object2, true)) {
                if (DEBUG) {
                    logger.log(8, "Sucessfully routed msgs to " + object3);
                }
                iterator.remove();
                continue;
            }
            if (!DEBUG) continue;
            logger.log(8, "Could not route messages to " + object3);
        }
        if (DEBUG) {
            logger.log(8, transactionUID + ":after redeliver, " + hashMap3.size() + " inactive consumers remaining");
        }
        iterator = hashMap3.keySet().iterator();
        while (iterator.hasNext()) {
            Object object5;
            object4 = (ConsumerUID)iterator.next();
            object3 = (ConsumerUID)hashMap2.get(object4);
            if (object3 == null || object4 == object3) {
                iterator.remove();
                continue;
            }
            if (object3 == PacketReference.queueUID) {
                object2 = (SortedSet)hashMap3.get(object4);
                if (object2.isEmpty()) {
                    if (!DEBUG) continue;
                    logger.log(8, "Internal Error:  empty set");
                    continue;
                }
                object5 = (PacketReference)object2.first();
                if (object5 == null) {
                    if (!DEBUG) continue;
                    logger.log(8, "Internal Error:  null reterence");
                    continue;
                }
                try {
                    if (bl2) {
                        ((PacketReference)object5).consumed((ConsumerUID)object3, false, false);
                    } else {
                        ((PacketReference)object5).removeDelivered((ConsumerUID)object3, false);
                    }
                }
                catch (IOException iOException) {
                    logger.log(16, "Internal error", iOException);
                }
                serializable = ((PacketReference)object5).getDestination();
                if (serializable == null) {
                    if (!DEBUG) continue;
                    logger.log(8, "Internal Error:  unknown destination for reference: " + object5);
                    continue;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    object5 = (PacketReference)object.next();
                    try {
                        set = ((Destination)serializable).routeNewMessage((PacketReference)object5);
                        ((Destination)serializable).forwardMessage(set, (PacketReference)object5);
                    }
                    catch (Exception exception) {
                        logger.log(8, "Internal Error: Unable to re-queue message  to queue " + serializable, exception);
                    }
                }
                continue;
            }
            object2 = Consumer.getConsumer((ConsumerUID)object3);
            if (object2 == null) {
                if (!DEBUG) continue;
                logger.log(8, "Internal Error:  unknown consumer " + object3);
                continue;
            }
            object5 = (SortedSet)hashMap3.get(object4);
            if (object5 == null || object5.isEmpty() || !((Consumer)object2).routeMessages((Collection)object5, true)) continue;
            iterator.remove();
        }
        if (DEBUG && hashMap3.size() > 0) {
            logger.log(8, transactionUID + ":after all processing, " + hashMap3.size() + " inactive consumers remaining");
        }
    }
}

