/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.auth.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.Properties;

public class HelloHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    public static boolean DEBUG;
    private static boolean ALLOW_C_CLIENTS;
    private static boolean CAN_RECONNECT;

    public HelloHandler(ConnectionManager connectionManager) {
        this.connectionList = connectionManager;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        byte[] byArray;
        int n;
        Hashtable<String, Integer> hashtable;
        Object object;
        block50: {
            block49: {
                Object object2;
                Hashtable hashtable2;
                block48: {
                    block47: {
                        if (DEBUG) {
                            this.logger.log(1, "HelloHandler: handle() [ Received Hello Message]");
                        }
                        String string = null;
                        hashtable2 = null;
                        try {
                            hashtable2 = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: error  retrieving properties from hello message ", exception);
                            hashtable2 = new Hashtable();
                        }
                        boolean bl = iMQConnection.isStarted();
                        boolean bl2 = iMQConnection.isAuthenticated();
                        int n2 = 0;
                        int n3 = iMQConnection.getHighestSupportedProtocol();
                        int n4 = 100;
                        Integer n5 = null;
                        boolean bl3 = false;
                        if (hashtable2 != null) {
                            Long l;
                            Integer n6 = (Integer)hashtable2.get("JMQProtocolLevel");
                            n2 = n6 == null ? 100 : n6;
                            n5 = (Integer)hashtable2.get("JMQSize");
                            if (n5 == null) {
                                n5 = (Integer)hashtable2.get("JMQRBufferSize");
                            }
                            object = (Boolean)hashtable2.get("JMQReconnectable");
                            hashtable = (String)hashtable2.get("JMQUserAgent");
                            if (!ALLOW_C_CLIENTS && hashtable != null && ((String)((Object)hashtable)).indexOf("C;") != -1) {
                                bl3 = true;
                            }
                            if (hashtable != null) {
                                iMQConnection.addClientData("useragent", hashtable);
                            }
                            if ((l = (Long)hashtable2.get("JMQConnectionID")) != null) {
                                object2 = iMQConnection.getConnectionUID();
                                ConnectionUID connectionUID = new ConnectionUID(l);
                                this.logger.log(8, "B1122", connectionUID);
                                iMQConnection.setConnectionUID(connectionUID);
                                Globals.getConnectionManager().updateConnectionUID(connectionUID, (ConnectionUID)object2);
                            }
                            iMQConnection.getConnectionUID().setCanReconnect(object == null ? false : (Boolean)object);
                            object2 = (Long)hashtable2.get("JMQInterval");
                            long l2 = object2 == null ? 10000L : (long)((Long)object2).intValue();
                            iMQConnection.setReconnectInterval(l2);
                        } else {
                            n2 = 100;
                        }
                        int n7 = 0;
                        n7 = n2 > n3 ? n3 : (n2 < n4 ? n4 : n2);
                        iMQConnection.setClientProtocolVersion(n7);
                        if (n5 != null) {
                            this.logger.log(4, "Received JMQRBufferSize -" + n5);
                            iMQConnection.setFlowCount(n5);
                        }
                        object = new Packet(iMQConnection.useDirectBuffers());
                        ((Packet)object).setPacketType(11);
                        ((Packet)object).setConsumerID(packet.getConsumerID());
                        hashtable = new Hashtable();
                        string = "unavailable";
                        n = 503;
                        if (iMQConnection.getRemoteIP() == null) {
                            iMQConnection.setRemoteIP(packet.getIP());
                        }
                        if (bl2 || bl) {
                            n = 500;
                            string = "Connection reuse not allowed";
                            if (bl2) {
                                this.logger.log(16, "Internal Error:  received HELLO on already authenticated connection " + iMQConnection.getRemoteConnectionString() + " " + iMQConnection.getConnectionUID());
                            } else {
                                this.logger.log(16, "Internal Error:  received HELLO on already started connection " + iMQConnection.getRemoteConnectionString() + " " + iMQConnection.getConnectionUID());
                            }
                        } else if (bl3) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0046"));
                            string = "C clients not allowed on this version";
                            n = 503;
                        } else if (!CAN_RECONNECT && iMQConnection.getConnectionUID().getCanReconnect()) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0047"));
                            string = "Client Failover not allowed on this version";
                        } else if (n2 != n7) {
                            this.logger.log(16, "B2052", (Object)Integer.toString(n2), Integer.toString(n7));
                            string = "bad version";
                            n = 505;
                        } else if (iMQConnection.getConnectionState() != -1) {
                            if (iMQConnection.setConnectionState(1)) {
                                string = null;
                                n = 200;
                            } else {
                                n = 503;
                            }
                        } else {
                            n = 503;
                        }
                        if (!iMQConnection.isAdminConnection()) {
                            hashtable.put("JMQSize", new Integer(Globals.getMemManager().getJMQSize()));
                            hashtable.put("JMQBytes", (Integer)((Object)new Long(Globals.getMemManager().getJMQBytes())));
                            hashtable.put("JMQMaxMsgBytes", (Integer)((Object)new Long(Globals.getMemManager().getJMQMaxMsgBytes())));
                        }
                        if (string != null) {
                            hashtable.put("JMQReason", (Integer)((Object)string));
                        }
                        hashtable.put("JMQService", (Integer)((Object)iMQConnection.getService().getName()));
                        hashtable.put("JMQStatus", new Integer(n));
                        hashtable.put("JMQConnectionID", (Integer)((Object)new Long(iMQConnection.getConnectionUID().longValue())));
                        hashtable.put("JMQProtocolLevel", new Integer(n7));
                        hashtable.put("JMQVersion", (Integer)((Object)Globals.getVersion().getProductVersion()));
                        if (IMQConnection.DUMP_PACKET) break block47;
                        if (!IMQConnection.OUT_DUMP_PACKET) break block48;
                    }
                    hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
                }
                try {
                    object2 = Globals.getCurrentLicense(null);
                    hashtable.put("JMQLicense", (Integer)((Object)((LicenseBase)object2).getProperty("imq.license_type")));
                    hashtable.put("JMQLicenseDesc", (Integer)((Object)((LicenseBase)object2).getProperty("description")));
                }
                catch (BrokerException brokerException) {
                    hashtable.put("JMQLicenseDesc", (Integer)((Object)brokerException.toString()));
                }
                ((Packet)object).setProperties(hashtable);
                iMQConnection.sendControlMessage((Packet)object);
                if (n != 200) {
                    iMQConnection.closeConnection(true, Globals.getBrokerResources().getKString("B0063"));
                    this.connectionList.removeConnection(iMQConnection, false, Globals.getBrokerResources().getKString("B0063"));
                    return true;
                }
                n = 503;
                object2 = null;
                if (hashtable2 != null) {
                    object2 = (String)hashtable2.get("JMQAuthType");
                }
                AccessController accessController = iMQConnection.getAccessController();
                object = new Packet(iMQConnection.useDirectBuffers());
                ((Packet)object).setPacketType(38);
                ((Packet)object).setConsumerID(packet.getConsumerID());
                hashtable = new Hashtable<String, Integer>();
                hashtable.put("JMQSequence", new Integer(packet.getSequence()));
                hashtable.put("JMQChallenge", (Integer)((Object)new Boolean(true)));
                Properties properties = new Properties();
                properties.setProperty("imq.clientIP", packet.getIPString());
                properties.setProperty("imq.connectionID", iMQConnection.getConnectionUID().toString());
                byArray = null;
                try {
                    AuthCacheData authCacheData = ((IMQService)iMQConnection.getService()).getAuthCacheData();
                    byArray = accessController.getChallenge(packet.getSequence(), properties, authCacheData.getCacheData(), authCacheData.isStaled(), (String)object2);
                    hashtable.put("JMQAuthType", (Integer)((Object)accessController.getAuthType()));
                    if (iMQConnection.setConnectionState(2)) {
                        n = 200;
                    }
                }
                catch (FailedLoginException failedLoginException) {
                    this.logger.log(16, failedLoginException.getMessage(), failedLoginException);
                    n = 403;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    this.logger.log(32, Globals.getBrokerResources().getKString("B3060") + " - " + throwable.getMessage(), throwable);
                    n = 403;
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (IMQConnection.DUMP_PACKET) break block49;
                if (!IMQConnection.OUT_DUMP_PACKET) break block50;
            }
            hashtable.put("JMQReqID", (Integer)((Object)packet.getSysMessageID().toString()));
        }
        ((Packet)object).setProperties(hashtable);
        if (byArray != null) {
            ((Packet)object).setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage((Packet)object);
        if (DEBUG) {
            this.logger.log(4, "HelloHandler: handle() [ sent challenge ]:status=" + Status.getString(n));
        }
        if (n != 200) {
            iMQConnection.closeConnection(true, Globals.getBrokerResources().getKString("B0063"));
            this.connectionList.removeConnection(iMQConnection, false, Globals.getBrokerResources().getKString("B0063"));
        }
        return true;
    }

    static {
        LicenseBase licenseBase;
        DEBUG = false;
        ALLOW_C_CLIENTS = false;
        CAN_RECONNECT = false;
        try {
            licenseBase = Globals.getCurrentLicense(null);
            ALLOW_C_CLIENTS = licenseBase.getBooleanProperty("imq.enable_c_api", false);
        }
        catch (BrokerException brokerException) {
            ALLOW_C_CLIENTS = false;
        }
        try {
            licenseBase = Globals.getCurrentLicense(null);
            CAN_RECONNECT = licenseBase.getBooleanProperty("imq.enable_reconnect", false);
        }
        catch (BrokerException brokerException) {
            CAN_RECONNECT = false;
        }
    }
}

