/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class AckHandler
extends PacketHandler {
    static final int ACK_BLOCK_SIZE = 40;
    private TransactionList translist = null;
    private static final Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
    public static int ACKNOWLEDGE_REQUEST = 0;
    public static int UNDELIVERABLE_REQUEST = 1;
    public static int DEAD_REQUEST = 2;

    public static void checkRequestType(int n) throws BrokerException {
        if (n > DEAD_REQUEST || n < ACKNOWLEDGE_REQUEST) {
            throw new BrokerException("Internal Error: unknown ackType " + n);
        }
    }

    public AckHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        ConsumerUID[] consumerUIDArray;
        Object object;
        Object object2;
        Object object3;
        block25: {
            block27: {
                block26: {
                    String string;
                    int n;
                    block24: {
                        int n2 = packet.getMessageBodySize();
                        int n3 = n2 / 40;
                        int n4 = n2 % 40;
                        n = 200;
                        string = null;
                        if (DEBUG) {
                            logger.log(4, "AckHandler: processing message {0} {1}", (Object)packet.toString(), iMQConnection.getConnectionUID().toString());
                        }
                        if (n3 == 0) {
                            logger.log(32, "B3100", "Internal Error: Empty Ack Message " + packet.getSysMessageID().toString());
                            string = "Empty ack message";
                            n = 500;
                        }
                        if (n4 != 0) {
                            logger.log(32, "B3100", "Internal Error: Invalid Ack Message Size " + String.valueOf(n2) + " for message " + packet.getSysMessageID().toString());
                            string = "corrupted ack message";
                            n = 500;
                        }
                        TransactionUID transactionUID = null;
                        if (packet.getTransactionID() != 0L) {
                            try {
                                transactionUID = new TransactionUID(packet.getTransactionID());
                            }
                            catch (Exception exception) {
                                logger.log(32, "B3100", (Object)("Internal Error: can not create transactionID for " + packet), (Throwable)exception);
                                n = 500;
                            }
                        }
                        boolean bl = false;
                        Hashtable hashtable = null;
                        Throwable throwable = null;
                        String string2 = null;
                        int n5 = 0;
                        int n6 = ACKNOWLEDGE_REQUEST;
                        try {
                            hashtable = packet.getProperties();
                            object3 = hashtable == null ? null : (Integer)hashtable.get("JMQAckType");
                            n6 = object3 == null ? ACKNOWLEDGE_REQUEST : (Integer)object3;
                            AckHandler.checkRequestType(n6);
                            if (n6 == DEAD_REQUEST) {
                                throwable = (Throwable)hashtable.get("JMQException");
                                string2 = (String)hashtable.get("JMQComment");
                                object2 = (Integer)hashtable.get("JMSXDeliveryCount");
                                n5 = object2 == null ? -1 : (Integer)object2;
                            }
                        }
                        catch (Exception exception) {
                            logger.logStack(8, "Internal Error: bad protocol", exception);
                            n6 = ACKNOWLEDGE_REQUEST;
                        }
                        object3 = null;
                        try {
                            if (n == 200) {
                                object2 = new DataInputStream(packet.getMessageBodyStream());
                                object = new SysMessageID[n3];
                                consumerUIDArray = new ConsumerUID[n3];
                                for (int i = 0; i < n3; ++i) {
                                    long l = ((DataInputStream)object2).readLong();
                                    consumerUIDArray[i] = new ConsumerUID(l);
                                    consumerUIDArray[i].setConnectionUID(iMQConnection.getConnectionUID());
                                    object[i] = new SysMessageID();
                                    ((SysMessageID)object[i]).readID((DataInputStream)object2);
                                }
                                object3 = n6 == DEAD_REQUEST ? this.handleDeadMsgs((SysMessageID[])object, consumerUIDArray, throwable, string2, n5) : (n6 == UNDELIVERABLE_REQUEST ? this.handleUndeliverableMsgs((SysMessageID[])object, consumerUIDArray) : (transactionUID != null ? this.handleTransaction(transactionUID, (SysMessageID[])object, consumerUIDArray) : this.handleAcks(iMQConnection, (SysMessageID[])object, consumerUIDArray)));
                            }
                        }
                        catch (Throwable throwable2) {
                            n = 500;
                            if (throwable2 instanceof BrokerException) {
                                n = ((BrokerException)throwable2).getStatusCode();
                            }
                            string = throwable2.getMessage();
                            if (n != 500) break block24;
                            logger.logStack(32, "B3100", "-------------------------------------------Internal Error: Invalid Acknowledge Packet processing\n " + (packet.getSendAcknowledge() ? " notifying client\n" : " can not notify the client") + PacketUtil.dumpPacket(packet) + "--------------------------------------------", throwable2);
                        }
                    }
                    if (!packet.getSendAcknowledge()) break block25;
                    object2 = new Packet(iMQConnection.useDirectBuffers());
                    ((Packet)object2).setPacketType(25);
                    ((Packet)object2).setConsumerID(packet.getConsumerID());
                    object = new Hashtable();
                    ((Hashtable)object).put("JMQStatus", new Integer(n));
                    if (string != null) {
                        ((Hashtable)object).put("JMQReason", string);
                    }
                    if (IMQConnection.DUMP_PACKET) break block26;
                    if (!IMQConnection.OUT_DUMP_PACKET) break block27;
                }
                ((Hashtable)object).put("JMQReqID", packet.getSysMessageID().toString());
            }
            ((Packet)object2).setProperties((Hashtable)object);
            iMQConnection.sendControlMessage((Packet)object2);
        }
        if (object3 != null && !object3.isEmpty()) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (PacketReference)object2.next();
                consumerUIDArray = ((PacketReference)object).getDestination();
                try {
                    if (((PacketReference)object).isDead()) {
                        consumerUIDArray.removeDeadMessage((PacketReference)object);
                        continue;
                    }
                    consumerUIDArray.removeMessage(((PacketReference)object).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
                catch (Exception exception) {
                    logger.log(8, "Internal Error: unable to clean up message " + object + " after ack " + "processing");
                }
            }
        }
        return true;
    }

    public List handleAcks(IMQConnection iMQConnection, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException, IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            Object object;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                object = Consumer.getConsumer(consumerUIDArray[i]);
                if (object == null) {
                    if (!iMQConnection.isValid() || iMQConnection.isBeingDestroyed()) {
                        logger.log(4, "Received ack for consumer " + consumerUIDArray[i] + " on closing connection " + iMQConnection);
                        continue;
                    }
                    throw new BrokerException("Internal Error: Unable to complete processing acks: Unknown consumer " + consumerUIDArray[i]);
                }
                if (((Consumer)object).getConsumerUID().getBrokerAddress() != Globals.getClusterBroadcast().getMyAddress()) {
                    ConsumerUID consumerUID;
                    PacketReference packetReference = Destination.get(sysMessageIDArray[i]);
                    if (!packetReference.acknowledged(consumerUID = ((Consumer)object).getConsumerUID(), ((Consumer)object).getStoredConsumerUID(), !consumerUID.isDupsOK(), true)) continue;
                    linkedList.add(packetReference);
                    continue;
                }
                logger.log(8, Globals.getBrokerResources().getString("B3100", "local consumer does not have associated session " + object));
                throw new BrokerException("Unknown local consumer " + consumerUIDArray[i]);
            }
            object = session.ackMessage(consumerUIDArray[i], sysMessageIDArray[i]);
            if (object == null) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    public List handleTransaction(TransactionUID transactionUID, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            try {
                ConsumerUID consumerUID;
                Session session = Session.getSession(consumerUIDArray[i]);
                Consumer consumer = Consumer.getConsumer(consumerUIDArray[i]);
                ConsumerUID consumerUID2 = consumerUID = consumer != null ? consumer.getStoredConsumerUID() : null;
                if (session == null && consumer != null) {
                    SessionUID sessionUID = consumer.getSessionUID();
                    session = Session.getSession(sessionUID);
                }
                if (session == null) {
                    throw new BrokerException("Internal Error: Unable to complete processing transaction: Unknown consumer/session " + consumerUIDArray[i]);
                }
                this.translist.addAcknowledgement(transactionUID, sysMessageIDArray[i], consumerUIDArray[i], consumerUID);
                session.acknowledgeInTransaction(consumerUIDArray[i], sysMessageIDArray[i], transactionUID);
                continue;
            }
            catch (Exception exception) {
                logger.log(8, "Internal Exception processing trans acknowledge [" + transactionUID + "," + sysMessageIDArray[i] + "," + consumerUIDArray[i] + "]", exception);
                throw new BrokerException("Internal Error: Unable to  complete processing acknowledgements in a tranaction: " + exception, exception);
            }
        }
        return null;
    }

    public List handleDeadMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Throwable throwable, String string, int n) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                logger.log(4, "Dead message for Unknown Consumer/Session" + consumerUIDArray[i]);
                continue;
            }
            if (DEBUG) {
                logger.log(4, "Handling Dead Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleDead(consumerUIDArray[i], sysMessageIDArray[i], throwable, string, n)) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }

    public List handleUndeliverableMsgs(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException {
        ArrayList<PacketReference> arrayList = new ArrayList<PacketReference>();
        for (int i = 0; i < sysMessageIDArray.length; ++i) {
            PacketReference packetReference;
            Session session = Session.getSession(consumerUIDArray[i]);
            if (session == null) {
                logger.log(4, "Undeliverable message for Unknown Consumer/Session" + consumerUIDArray[i]);
            }
            if (DEBUG) {
                logger.log(4, "Handling Undeliverable Message " + consumerUIDArray[i] + ":" + sysMessageIDArray[i]);
            }
            if ((packetReference = session.handleUndeliverable(consumerUIDArray[i], sysMessageIDArray[i])) == null) continue;
            arrayList.add(packetReference);
        }
        return arrayList;
    }
}

