/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TransactionList {
    List inuse_translist = null;
    Hashtable translist = null;
    Logger logger = Globals.getLogger();
    Hashtable xidTable = null;
    Store store = null;

    public TransactionList(Store store) {
        this.store = store;
        this.translist = new Hashtable();
        this.xidTable = new Hashtable();
        this.inuse_translist = new ArrayList();
        try {
            this.loadTransactions();
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B2096", exception);
        }
    }

    public synchronized Hashtable getDebugState(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(transactionUID.toString(), "UNKNOWN TID");
            return hashtable;
        }
        return transactionInformation.getDebugState();
    }

    public Hashtable getDebugState() {
        Object object;
        Object object2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TransactionCount", new Integer(this.translist.size()));
        Iterator iterator = this.translist.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            String string = object2.getKey().toString();
            object = (TransactionInformation)object2.getValue();
            if (object == null) continue;
            hashtable.put(string, ((TransactionInformation)object).getDebugState());
        }
        object2 = new Vector();
        for (int i = 0; i < this.inuse_translist.size(); ++i) {
            ((Vector)object2).add(this.inuse_translist.get(i).toString());
        }
        if (((Vector)object2).size() > 0) {
            hashtable.put("inUse", object2);
        } else {
            hashtable.put("inUse", "none");
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        iterator = this.xidTable.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashtable2.put(object.getKey().toString(), object.getValue().toString());
        }
        if (hashtable2.size() > 0) {
            hashtable.put("XIDs", object2);
        } else {
            hashtable.put("XIDs", "none");
        }
        return hashtable;
    }

    public synchronized void addTransactionID(TransactionUID transactionUID, TransactionState transactionState) throws BrokerException {
        this.addTransactionID(transactionUID, transactionState, true);
    }

    public synchronized void addTransactionID(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        if (this.inuse_translist.contains(transactionUID)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString()), "B4061", null, 409);
        }
        JMQXid jMQXid = transactionState.getXid();
        if (jMQXid != null) {
            if (this.xidTable.get(jMQXid) != null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", transactionUID.toString() + "[Xid=" + jMQXid.toString() + "]"), "B4061", null, 409);
            }
            this.xidTable.put(jMQXid, transactionUID);
        }
        try {
            if (bl) {
                this.store.storeTransaction(transactionUID, transactionState, false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4062", transactionUID.toString()), "B4062", exception, 500);
        }
        this.inuse_translist.add(transactionUID);
        this.translist.put(transactionUID, new TransactionInformation(transactionUID, transactionState));
    }

    public void removeTransactionID(TransactionUID transactionUID) throws BrokerException {
        this.removeTransactionID(transactionUID, true);
    }

    public synchronized void removeTransactionID(TransactionUID transactionUID, boolean bl) throws BrokerException {
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState != null && transactionState.getXid() != null) {
            this.xidTable.remove(transactionState.getXid());
        }
        this.translist.remove(transactionUID);
        try {
            if (bl) {
                this.store.removeTransaction(transactionUID, false);
            }
        }
        catch (IOException iOException) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "unable to remove the transaction id " + transactionUID), iOException);
        }
    }

    public void removeTransactionAck(TransactionUID transactionUID) throws BrokerException {
        this.removeTransactionAck(transactionUID, true);
    }

    public synchronized void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        try {
            if (bl) {
                this.store.removeTransactionAck(transactionUID, false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", ": unable to remove the transaction ack for " + transactionUID), exception);
        }
        this.inuse_translist.remove(transactionUID);
    }

    public synchronized void addMessage(TransactionUID transactionUID, SysMessageID sysMessageID) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received message with Unknown Transaction ID " + transactionUID + ": ignoring message"));
        }
        transactionInformation.addPublishedMessage(sysMessageID);
    }

    public synchronized void addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) throws BrokerException {
        this.addAcknowledgement(transactionUID, sysMessageID, consumerUID, consumerUID2, true);
    }

    public synchronized void addAcknowledgement(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + transactionUID + ": ignoring message"));
        }
        transactionInformation.addConsumedMessage(sysMessageID, consumerUID, consumerUID2);
        if (bl) {
            this.store.storeTransactionAck(transactionUID, new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID2), false);
        }
    }

    public synchronized List retrieveSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getPublishedMessages();
    }

    public synchronized int retrieveNSentMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNPublishedMessages();
    }

    public synchronized HashMap retrieveConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getConsumedMessages();
    }

    public synchronized HashMap retrieveStoredConsumerUIDs(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getStoredConsumerUIDs();
    }

    public synchronized int retrieveNConsumedMessages(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return 0;
        }
        return transactionInformation.getNConsumedMessages();
    }

    public synchronized TransactionState retrieveState(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            return null;
        }
        return transactionInformation.getState();
    }

    public synchronized TransactionState updateState(TransactionUID transactionUID, int n, boolean bl) throws BrokerException {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): Unknown transaction: " + transactionUID));
        }
        TransactionState transactionState = transactionInformation.getState();
        if (transactionState == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): No state for transaction: " + transactionUID));
        }
        transactionState.setState(n);
        if (bl) {
            try {
                this.store.updateTransactionState(transactionUID, transactionState.getState(), Destination.PERSIST_SYNC);
            }
            catch (IOException iOException) {
                throw new BrokerException(null, iOException);
            }
        }
        return transactionState;
    }

    public synchronized TransactionUID xidToUID(JMQXid jMQXid) {
        return (TransactionUID)this.xidTable.get(jMQXid);
    }

    public synchronized TransactionUID slowXidToUID(JMQXid jMQXid) {
        Set set = this.translist.entrySet();
        Iterator iterator = set.iterator();
        TransactionState transactionState = null;
        JMQXid jMQXid2 = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TransactionInformation transactionInformation = (TransactionInformation)entry.getValue();
            transactionState = transactionInformation.getState();
            jMQXid2 = transactionState.getXid();
            if (jMQXid2 == null || !jMQXid.equals(jMQXid2)) continue;
            return (TransactionUID)entry.getKey();
        }
        return null;
    }

    public synchronized JMQXid UIDToXid(TransactionUID transactionUID) {
        TransactionState transactionState = this.retrieveState(transactionUID);
        if (transactionState != null) {
            return transactionState.getXid();
        }
        return null;
    }

    public synchronized Vector getTransactions(int n) {
        Set set = this.translist.keySet();
        Iterator iterator = set.iterator();
        TransactionUID transactionUID = null;
        TransactionState transactionState = null;
        Vector<TransactionUID> vector = new Vector<TransactionUID>();
        while (iterator.hasNext()) {
            transactionUID = (TransactionUID)iterator.next();
            if (n < 0) {
                vector.add(transactionUID);
                continue;
            }
            transactionState = this.retrieveState(transactionUID);
            if (transactionState == null || transactionState.getState() != n) continue;
            vector.add(transactionUID);
        }
        return vector;
    }

    public void addOrphanAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation != null) {
            transactionInformation.addOrphanAck(sysMessageID, consumerUID);
        }
    }

    public Map getOrphanAck(TransactionUID transactionUID) {
        TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(transactionUID);
        if (transactionInformation != null) {
            return transactionInformation.getOrphanAck();
        }
        return null;
    }

    public void loadTransactions() throws BrokerException, IOException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Serializable serializable2;
        Serializable serializable3;
        boolean bl = Globals.getConfig().getBooleanProperty("imq.transaction.autorollback", false);
        LoadException loadException = Globals.getStore().getLoadTransactionException();
        if (loadException != null) {
            serializable3 = loadException;
            while (serializable3 != null) {
                serializable2 = (TransactionUID)((LoadException)serializable3).getKey();
                object4 = (TransactionAcknowledgement[])((LoadException)serializable3).getValue();
                if (serializable2 == null && object4 == null) {
                    this.logger.log(16, "B3044", "both key and value for a Transactions entry are corrupted");
                    continue;
                }
                if (serializable2 == null) {
                    this.logger.log(16, "B2098", ((TransactionState)object4).toString());
                } else {
                    this.logger.log(16, "B2097", serializable2);
                    serializable = new TransactionState();
                    ((TransactionState)serializable).setState(5);
                    try {
                        this.store.storeTransaction((TransactionUID)serializable2, (TransactionState)serializable, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", "Error updating transaction " + serializable2, (Throwable)exception);
                    }
                }
                serializable3 = ((LoadException)serializable3).getNextException();
            }
        }
        if ((loadException = Globals.getStore().getLoadTransactionAckException()) != null) {
            serializable3 = loadException;
            while (serializable3 != null) {
                serializable2 = (TransactionUID)((LoadException)serializable3).getKey();
                object4 = (TransactionAcknowledgement[])((LoadException)serializable3).getValue();
                if (serializable2 == null && object4 == null) {
                    this.logger.log(16, "B3044", "both key and value for a Transaction Ack entry are corrupted");
                    continue;
                }
                if (serializable2 == null) {
                    this.logger.log(16, "B2098", object4.toString());
                } else {
                    this.logger.log(16, "B2099", ((TransactionUID)serializable2).toString());
                    try {
                        this.store.removeTransactionAck((TransactionUID)serializable2, false);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "B3044", "Error updating transaction ack " + serializable2, (Throwable)exception);
                    }
                }
                serializable3 = ((LoadException)serializable3).getNextException();
            }
        }
        this.logger.log(8, "B1136");
        serializable3 = this.store.getAllTransactionStates();
        TransactionList.logTransactionInfo((HashMap)serializable3, bl);
        if (((HashMap)serializable3).size() <= 0) {
            return;
        }
        serializable2 = new HashSet(((HashMap)serializable3).size());
        object4 = new HashMap();
        serializable = new HashMap();
        this.logger.log(4, "Broker left open transactions when it crashed");
        Iterator<Object> iterator = ((HashMap)serializable3).keySet().iterator();
        while (iterator.hasNext()) {
            try {
                object3 = (TransactionUID)iterator.next();
                object2 = (TransactionState)((HashMap)serializable3).get(object3);
                object = this.store.getTransactionAcks((TransactionUID)object3);
                int n = ((TransactionState)object2).getState();
                switch (n) {
                    case 0: {
                        ((HashSet)serializable2).add(object3);
                        break;
                    }
                    case 5: {
                        if (!bl) {
                            this.addTransactionID((TransactionUID)object3, (TransactionState)object2, false);
                            ((HashMap)object4).put(object3, Boolean.TRUE);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        this.addTransactionID((TransactionUID)object3, (TransactionState)object2, false);
                        ((HashMap)object4).put(object3, Boolean.FALSE);
                        ((HashSet)serializable2).add(object3);
                        break;
                    }
                    case 6: {
                        ((HashSet)serializable2).add(object3);
                    }
                }
                for (int i = 0; i < ((TransactionAcknowledgement[])object).length; ++i) {
                    ConsumerUID consumerUID = ((TransactionAcknowledgement)object[i]).getConsumerUID();
                    ConsumerUID consumerUID2 = ((TransactionAcknowledgement)object[i]).getStoredConsumerUID();
                    SysMessageID sysMessageID = ((TransactionAcknowledgement)object[i]).getSysMessageID();
                    HashMap<ConsumerUID, Object> hashMap = (HashMap<ConsumerUID, Object>)((HashMap)serializable).get(sysMessageID);
                    if (consumerUID == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + object);
                        consumerUID = consumerUID2;
                        if (object == null) {
                            this.logger.log(16, "Internal Error:  no consumerUID stored w/ the transaction:" + object);
                            continue;
                        }
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<ConsumerUID, Object>();
                        ((HashMap)serializable).put(sysMessageID, hashMap);
                    }
                    hashMap.put(((TransactionAcknowledgement)object[i]).getStoredConsumerUID(), object3);
                    if (((HashMap)object4).get(object3) == null) continue;
                    TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(object3);
                    if (transactionInformation == null) {
                        this.logger.log(8, "Unable to retrieve  transaction information " + transactionInformation + " for " + object3 + " we may be clearing the transaction");
                        continue;
                    }
                    if (((HashMap)object4).get(object3) == Boolean.TRUE) {
                        transactionInformation.addConsumedMessage(sysMessageID, consumerUID, consumerUID2);
                    }
                    transactionInformation.addOrphanAck(sysMessageID, consumerUID);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, "L10N: Error parsing transaction ", exception);
            }
        }
        if (!(((HashMap)object4).size() <= 0 && ((HashMap)serializable).size() <= 0 || (object3 = Destination.processTransactions((Map)((Object)serializable), (Map)object4)) == null || object3.isEmpty())) {
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                TransactionInformation transactionInformation = (TransactionInformation)this.translist.get(object.getValue());
                transactionInformation.addPublishedMessage((SysMessageID)object.getKey());
            }
        }
        iterator = ((HashSet)serializable2).iterator();
        while (iterator.hasNext()) {
            object3 = (TransactionUID)iterator.next();
            this.logger.log(4, "Clearing transaction " + object3);
            this.removeTransactionID((TransactionUID)object3);
        }
    }

    public static void logTransactionInfo(HashMap hashMap, boolean bl) {
        Logger logger = Globals.getLogger();
        int n = 0;
        int n2 = 0;
        if (hashMap != null && hashMap.size() > 0) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                TransactionState transactionState = (TransactionState)iterator.next();
                if (transactionState.getState() == 5) {
                    ++n2;
                    if (!bl) continue;
                    ++n;
                    continue;
                }
                ++n;
            }
            logger.log(8, "B1079", (Object)new Integer(hashMap.size()), new Integer(n));
            if (n2 > 0) {
                logger.log(8, "B1080", (Object)new Integer(hashMap.size()), new Integer(n2));
                if (bl) {
                    logger.log(8, "B1081");
                } else {
                    logger.log(8, "B1082");
                }
            }
        }
    }
}

