/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class DefaultHandler
extends ErrHandler {
    Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;

    public void sendError(IMQConnection iMQConnection, int n, String string, Packet packet) {
        this.logger.log(32, string);
        this.sendError(iMQConnection, packet);
    }

    public void sendError(IMQConnection iMQConnection, BrokerException brokerException, Packet packet) {
        this.logger.logStack(32, "B3100", "Uncaught Exception", (Throwable)brokerException);
        this.sendError(iMQConnection, packet);
    }

    private void sendError(IMQConnection iMQConnection, Packet packet) {
        if (packet.getSendAcknowledge()) {
            Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
            packet2.setPacketType(packet.getPacketType() + 1);
            packet2.setConsumerID(packet.getConsumerID());
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("JMQStatus", new Integer(500));
            packet2.setProperties(hashtable);
            iMQConnection.sendControlMessage(packet2);
        }
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        if (packet.getSendAcknowledge()) {
            if (DEBUG) {
                this.logger.log(4, "DefaultHandler: replying to unknown packet type: " + packet.getPacketType());
            }
            Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
            packet2.setPacketType(packet.getPacketType() + 1);
            packet2.setConsumerID(packet.getConsumerID());
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("JMQStatus", new Integer(501));
            packet2.setProperties(hashtable);
            iMQConnection.sendControlMessage(packet2);
        } else if (DEBUG) {
            this.logger.log(4, "DefaultHandler: ignoring unknown packet type : " + packet.getPacketType());
        }
        return true;
    }
}

