/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.LoadComparator;
import com.sun.messaging.jmq.jmsserver.core.LowPriorityComparator;
import com.sun.messaging.jmq.jmsserver.core.OldestComparator;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.Topic;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.FeatureUnavailableException;
import com.sun.messaging.jmq.jmsserver.util.lists.AddReason;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SimpleNFLHashMap;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public abstract class Destination
implements Serializable,
EventListener {
    public static int LOAD_COUNT;
    static final long serialVersionUID = 4399175316523022128L;
    public static boolean PERSIST_SYNC;
    public static boolean DEBUG;
    public static boolean NO_PRODUCER_FLOW;
    public static int DEFAULT_MAX_PRODUCER_BATCH;
    public static int DEFAULT_DESTINATION_SIZE;
    public static int DEFAULT_MAX_PRODUCERS;
    public static int DEFAULT_PREFETCH;
    public static int ALL_DESTINATIONS_MASK;
    public static int TEMP_DESTINATIONS_MASK;
    public static final int UNLIMITED = -1;
    public static final int NONE = 0;
    private static final String AUTO_QUEUE_STR = "imq.autocreate.queue";
    private static final String AUTO_TOPIC_STR = "imq.autocreate.topic";
    private static final String DST_REAP_STR = "imq.autocreate.reaptime";
    private static final String MSG_REAP_STR = "imq.message.expiration.interval";
    private static final long DEFAULT_TIME = 120L;
    private static boolean ALLOW_QUEUE_AUTOCREATE;
    private static boolean ALLOW_TOPIC_AUTOCREATE;
    public static long AUTOCREATE_EXPIRE;
    public static long MESSAGE_EXPIRE;
    public static int MAX_PRODUCER_BATCH;
    public static int MAX_PRODUCER_BYTES_BATCH;
    protected static final Logger logger;
    protected transient boolean destvalid = true;
    protected transient boolean startedDestroy = false;
    transient Set pausedProducerSet = null;
    transient int activeProducerCount = 0;
    transient Set BehaviorSet = null;
    protected transient BrokerMonitor bm = null;
    protected transient boolean stored = false;
    protected transient boolean neverStore = false;
    protected transient SimpleNFLHashMap destMessages = null;
    private boolean dest_inited = false;
    private transient int refCount = 0;
    private static boolean CAN_MONITOR_DEST;
    private static boolean CAN_USE_LOCAL_DEST;
    protected int expiredCnt = 0;
    protected int purgedCnt = 0;
    protected int ackedCnt = 0;
    protected int discardedCnt = 0;
    protected int overflowCnt = 0;
    protected int errorCnt = 0;
    protected int rollbackCnt = 0;
    transient int size = 0;
    transient long bytes = 0L;
    transient boolean loaded = false;
    protected transient SimpleNFLHashMap consumers = new SimpleNFLHashMap();
    protected transient SimpleNFLHashMap producers = new SimpleNFLHashMap();
    private static JMQTimer timer;
    transient JMQTimerTask task = null;
    protected DestinationUID uid = null;
    protected int type = -1;
    protected transient int state = -1;
    protected int scope = 1;
    protected int limit = 2;
    protected ConnectionUID id = null;
    protected SizeString msgSizeLimit = null;
    protected int countLimit = 0;
    protected SizeString memoryLimit = null;
    private static final String AUTO_MAX_NUM_MSGS = "imq.autocreate.destination.maxNumMsgs";
    private static final String AUTO_MAX_TOTAL_BYTES = "imq.autocreate.destination.maxTotalMsgBytes";
    private static final String AUTO_MAX_BYTES_MSG = "imq.autocreate.destination.maxBytesPerMsg";
    private static final String AUTO_MAX_NUM_PRODUCERS = "imq.autocreate.destination.maxNumProducers";
    private static final String AUTO_LOCAL_ONLY = "imq.autocreate.destination.isLocalOnly";
    private static final String AUTO_LIMIT_BEHAVIOR = "imq.autocreate.destination.limitBehavior";
    protected static int defaultMaxMsgCnt;
    protected static int defaultProducerCnt;
    private static final long _defbytes = 0xA00000L;
    protected static SizeString defaultMaxMsgBytes;
    private static final long _defMbytes = 10240L;
    protected static SizeString defaultMaxBytesPerMsg;
    protected static boolean defaultIsLocal;
    protected static int defaultLimitBehavior;
    protected int maxConsumerLimit = -1;
    protected int maxProducerLimit = defaultProducerCnt;
    protected int maxPrefetch = DEFAULT_PREFETCH;
    protected transient int producerMsgBatchSize = MAX_PRODUCER_BATCH;
    protected transient long producerMsgBatchBytes = -1L;
    private long clientReconnectInterval = 0L;
    private transient ReconnectReaperTask reconnectReaper = null;
    private static int reconnectMultiplier;
    public static String USE_DMQ_STR;
    public static String TRUNCATE_BODY_STR;
    public static String LOG_MSGS_STR;
    public static boolean defaultUseDMQ;
    public static boolean defaultTruncateBody;
    public static boolean defaultVerbose;
    private static Queue DeadMessageQueue;
    private boolean unloadMessagesAtStore = false;
    public static final String DMQ_NAME = "mq.sys.dmq";
    public static boolean autocreateUseDMQ;
    boolean useDMQ = autocreateUseDMQ;
    static boolean storeBodyWithDMQ;
    static boolean verbose;
    boolean isDMQ = false;
    private static String TEMP_CNT;
    public int seqCnt = 0;
    transient Object behaviorListener = null;
    transient MsgExpirationReaper expireReaper = new MsgExpirationReaper();
    protected transient Filter filter = new DestFilter();
    protected transient DestMetricsCounters dmc = new DestMetricsCounters();
    transient long lastMetricsTime;
    transient int msgsIn = 0;
    transient int msgsOut = 0;
    transient int lastMsgsIn = 0;
    transient int lastMsgsOut = 0;
    transient long msgBytesIn = 0L;
    transient long msgBytesOut = 0L;
    transient long lastMsgBytesIn = 0L;
    transient long lastMsgBytesOut = 0L;
    public static final String SCOPE_PROPERTY = "scope";
    public static final String MAX_CONSUMERS = "max_consumers";
    public static final String MAX_PRODUCERS = "max_producers";
    public static final String MAX_PREFETCH = "max_prefetch";
    public static final String MAX_MESSAGES = "max_messages";
    public static final String MAX_BYTES = "max_bytes";
    public static final String MAX_MSG_BYTES = "max_msg_bytes";
    public static final String BEHAVIOUR = "behaviour";
    public static final String STATE = "state";
    public static final String NAME = "name";
    public static final String IS_QUEUE = "queue";
    public static final String IS_INTERNAL = "internal";
    public static final String IS_AUTOCREATED = "autocreated";
    public static final String IS_TEMPORARY = "temporary";
    public static final String IS_ADMIN = "admin";
    public static final String IS_LOCAL = "local";
    public static final String REAL_TYPE = "type";
    public static final String USE_DMQ = "useDMQ";
    transient Filter unloadfilter = new UnloadFilter();
    boolean overrideP = false;
    boolean overridePvalue = false;
    boolean overrideTTL = false;
    long overrideTTLvalue = 0L;
    boolean hasPausedProducers = false;
    private static Map destinationList;
    static boolean destsLoaded;
    protected static boolean valid;
    private static SizeString individual_max_size;
    private static SizeString max_size;
    private static long message_max_count;
    private static long totalbytes;
    private static int totalcnt;
    private static Map packetlist;
    public static final String SYSTEM_MAX_SIZE = "imq.system.max_size";
    public static final String SYSTEM_MAX_COUNT = "imq.system.max_count";
    public static final String MAX_MESSAGE_SIZE = "imq.message.max_size";
    private static ConfigListener cl;
    private static boolean inited;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setUseDMQ(boolean bl) throws BrokerException {
        if (bl && this.isDMQ) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4189"));
        }
        this.useDMQ = bl;
    }

    public boolean getUseDMQ() {
        return this.useDMQ;
    }

    public void storeBodyInDMQ(boolean bl) {
        storeBodyWithDMQ = bl;
    }

    public boolean getStoreBodyInDMQ() {
        return storeBodyWithDMQ;
    }

    public void setVerbose(boolean bl) {
        verbose = bl;
    }

    public boolean getVerbose() {
        return verbose;
    }

    public static Queue getDMQ() {
        return DeadMessageQueue;
    }

    protected Destination(DestinationUID destinationUID) {
        this.uid = destinationUID;
    }

    private static synchronized Queue createDMQ() throws BrokerException, IOException {
        DestinationUID destinationUID = DestinationUID.getUID(DMQ_NAME, true);
        Queue queue = null;
        queue = (Queue)destinationList.get(destinationUID);
        if (queue == null) {
            logger.log(8, "B1144");
            queue = (Queue)Destination.createDestination(DMQ_NAME, 4097, true, false, null, false, false);
            queue.maxProducerLimit = 0;
            queue.scope = 0;
            queue.msgSizeLimit = null;
            queue.setLimitBehavior(1);
            queue.memoryLimit = new SizeString(10240L);
            queue.countLimit = 1000;
            queue.maxPrefetch = 1000;
            queue.isDMQ = true;
            queue.useDMQ = false;
            queue.update();
        }
        queue.load(true, null, null);
        return queue;
    }

    public void removeDeadMessage(PacketReference packetReference) throws IOException, BrokerException {
        this.removeDeadMessage(packetReference, packetReference.getDeadComment(), packetReference.getDeadException(), packetReference.getDeadDeliverCnt(), packetReference.getDeadReason());
    }

    public static void removeDeadMessage(SysMessageID sysMessageID, String string, Throwable throwable, int n, Reason reason) throws IOException, BrokerException {
        PacketReference packetReference = Destination.get(sysMessageID);
        Destination destination = packetReference.getDestination();
        destination.removeDeadMessage(packetReference, string, throwable, n, reason);
    }

    public void removeDeadMessage(PacketReference packetReference, String string, Throwable throwable, int n, Reason reason) throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "Calling removeDeadMessage on " + packetReference + " [" + string + "," + throwable + "," + n + "," + reason + "]");
        }
        if (packetReference.isInvalid()) {
            logger.log(4, "Internal Error: message is already dead");
            return;
        }
        Destination destination = packetReference.getDestination();
        if (destination == DeadMessageQueue) {
            throw new RuntimeException("Already dead");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", string);
        }
        if (n != -1) {
            hashtable.put(TEMP_CNT, new Integer(n));
        }
        if (throwable != null) {
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", throwable);
        }
        if (reason == null) {
            reason = RemoveReason.ERROR;
        }
        this.removeMessage(packetReference.getSysMessageID(), reason, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void markDead(PacketReference packetReference, Reason reason, Hashtable hashtable) throws BrokerException {
        Object[] objectArray;
        PacketReference packetReference2;
        long l;
        long l2;
        boolean bl;
        boolean bl2;
        block42: {
            Integer n;
            boolean bl3;
            Hashtable hashtable2;
            Packet packet;
            block41: {
                block45: {
                    Object v;
                    block40: {
                        block44: {
                            block39: {
                                block43: {
                                    packet = packetReference.getPacket();
                                    if (packet == null) {
                                        logger.log(4, "Internal Error: null packet for DMQ");
                                        return;
                                    }
                                    hashtable2 = null;
                                    try {
                                        hashtable2 = packet.getProperties();
                                        if (hashtable2 == null) {
                                            hashtable2 = new Hashtable();
                                        }
                                    }
                                    catch (Exception exception) {
                                        logger.logStack(4, "could not get props ", exception);
                                        hashtable2 = new Hashtable();
                                    }
                                    bl2 = false;
                                    v = hashtable2.get("JMS_SUN_LOG_DEAD_MESSAGES");
                                    if (v == null) break block43;
                                    if (v instanceof Boolean) {
                                        bl2 = (Boolean)v;
                                        break block39;
                                    } else if (v instanceof String) {
                                        bl2 = Boolean.valueOf((String)v);
                                        break block39;
                                    } else {
                                        logger.log(16, "L10N-XXX: Unknown type for verbose " + v.getClass());
                                        bl2 = verbose;
                                    }
                                    break block39;
                                }
                                bl2 = verbose;
                            }
                            if (this.isDMQ) {
                                if (!DEBUG) {
                                    if (!bl2) return;
                                }
                                logger.log(8, "B1145", (Object)packetReference.getSysMessageID(), DestinationUID.getUID(packet.getDestination(), packet.getIsQueue()).toString());
                                return;
                            }
                            bl = false;
                            v = hashtable2.get("JMS_SUN_PRESERVE_UNDELIVERED");
                            if (v == null) break block44;
                            if (v instanceof Boolean) {
                                bl = (Boolean)v;
                                break block40;
                            } else if (v instanceof String) {
                                bl = Boolean.valueOf((String)v);
                                break block40;
                            } else {
                                logger.log(16, "L10N-XXX: Unknown type for preserve undelivered " + v.getClass());
                                bl = this.useDMQ;
                            }
                            break block40;
                        }
                        bl = this.useDMQ;
                    }
                    l2 = packetReference.getTime();
                    l = packetReference.getExpireTime();
                    if (!bl) {
                        if (!DEBUG) {
                            if (!bl2) return;
                        }
                        Object[] objectArray2 = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), this.lookupReasonString(reason, l2, l)};
                        logger.log(8, "B1146", objectArray2);
                        return;
                    }
                    bl3 = false;
                    v = hashtable2.get("JMS_SUN_TRUNCATE_MSG_BODY");
                    if (v == null) break block45;
                    if (v instanceof Boolean) {
                        bl3 = (Boolean)v;
                        break block41;
                    } else if (v instanceof String) {
                        bl3 = Boolean.valueOf((String)v);
                        break block41;
                    } else {
                        logger.log(16, "L10N-XXX: Unknown type for preserve undelivered " + v.getClass());
                        bl3 = !storeBodyWithDMQ;
                    }
                    break block41;
                }
                boolean bl4 = bl3 = !storeBodyWithDMQ;
            }
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            if ((n = (Integer)hashtable.remove(TEMP_CNT)) != null) {
                hashtable.put("JMSXDeliveryCount", n);
            }
            hashtable.putAll(hashtable2);
            if (hashtable.get("JMS_SUN_DMQ_UNDELIVERED_COMMENT") == null) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", this.lookupReasonString(reason, l2, l));
            }
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_TIMESTAMP", new Long(System.currentTimeMillis()));
            hashtable.put("JMS_SUN_DMQ_BODY_TRUNCATED", new Boolean(bl3));
            Object var15_15 = null;
            if (reason == RemoveReason.EXPIRED) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "EXPIRED");
            } else if (reason == RemoveReason.REMOVED_LOW_PRIORITY) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "LOW_PRIORITY");
            } else if (reason == RemoveReason.REMOVED_OLDEST) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "OLDEST");
            } else if (reason == RemoveReason.UNDELIVERABLE) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "UNDELIVERABLE");
            } else {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "ERROR");
            }
            if (packetReference.getAddress() != null) {
                hashtable.put("JMS_SUN_DMQ_PRODUCING_BROKER", packetReference.getAddress().toString());
            }
            Packet packet2 = new Packet();
            boolean bl5 = false;
            packetReference2 = null;
            try {
                packet2.generateSequenceNumber(false);
                packet2.generateTimestamp(false);
                packet2.fill(packet);
                packet2.setProperties(hashtable);
                if (bl3) {
                    packet2.setMessageBody(new byte[0]);
                }
                packetReference2 = PacketReference.createReference(packet2, DeadMessageQueue.getDestinationUID(), null);
                packetReference2.overrideExpireTime(0L);
                packetReference2.clearExpirationInfo();
                packetReference2.setTimestamp(System.currentTimeMillis());
                objectArray = DeadMessageQueue;
                // MONITORENTER : DeadMessageQueue
                packetReference2.setSequence(Destination.DeadMessageQueue.seqCnt++);
                // MONITOREXIT : objectArray
                Destination.routeMoveAndForwardMessage(packetReference, packetReference2, DeadMessageQueue);
            }
            catch (Exception exception) {
                if (reason == RemoveReason.UNDELIVERABLE || reason == RemoveReason.ERROR) {
                    if (!(exception instanceof BrokerException)) throw new BrokerException(Globals.getBrokerResources().getKString("B4190"), exception);
                    throw (BrokerException)exception;
                }
                if (!DEBUG && !bl2) break block42;
                logger.logStack(16, "B2090", packetReference.getSysMessageID().toString(), (Throwable)exception);
            }
        }
        if ((DEBUG || bl2) && bl) {
            objectArray = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), this.lookupReasonString(reason, l2, l)};
            logger.log(8, "B1147", objectArray);
        }
        packetReference2.unload();
    }

    public static void routeMoveAndForwardMessage(PacketReference packetReference, PacketReference packetReference2, Destination destination) throws IOException, BrokerException {
        Set set;
        boolean bl = destination.queueMessage(packetReference2, false);
        if (bl && (set = destination.routeAndMoveMessage(packetReference, packetReference2)) != null) {
            destination.forwardMessage(set, packetReference2);
        }
    }

    public abstract Set routeAndMoveMessage(PacketReference var1, PacketReference var2) throws IOException, BrokerException;

    public void setReconnectInterval(long l) {
        this.clientReconnectInterval = l * (long)reconnectMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientReconnect() {
        Destination destination = this;
        synchronized (destination) {
            if (this.reconnectReaper != null) {
                this.reconnectReaper.cancel();
                this.reconnectReaper = null;
            }
        }
    }

    private void updateProducerBatch(boolean bl) {
        int n = this.producerMsgBatchSize;
        long l = this.producerMsgBatchBytes;
        boolean bl2 = bl = bl && this.limit == 0;
        if (this.limit == 0) {
            this.producerMsgBatchSize = Destination.calcProducerBatchCnt(this.destMessages.capacity(), this.maxProducerLimit);
            this.producerMsgBatchBytes = Destination.calcProducerBatchBytes(this.destMessages.byteCapacity(), this.maxProducerLimit);
        } else {
            this.producerMsgBatchSize = MAX_PRODUCER_BATCH;
            this.producerMsgBatchBytes = -1L;
        }
        if (bl && (n != this.producerMsgBatchSize || l != this.producerMsgBatchBytes) && this.state != 2 && this.state != 3) {
            this.flowControlAllProducers(true, "update batch");
        }
    }

    private static int calcProducerBatchCnt(int n, int n2) {
        int n3;
        if (n == -1) {
            return MAX_PRODUCER_BATCH;
        }
        int n4 = n2;
        if (n4 <= 0) {
            n4 = DEFAULT_MAX_PRODUCERS;
        }
        if ((n3 = n / n4) <= 0) {
            n3 = 1;
        }
        if (n3 > MAX_PRODUCER_BATCH) {
            return MAX_PRODUCER_BATCH;
        }
        return n3;
    }

    private static long calcProducerBatchBytes(long l, int n) {
        long l2;
        if (l == -1L) {
            return -1L;
        }
        int n2 = n;
        if (n2 <= 0) {
            n2 = DEFAULT_MAX_PRODUCERS;
        }
        if ((l2 = l / (long)n2) <= 0L) {
            l2 = 1L;
        }
        if (MAX_PRODUCER_BYTES_BATCH != -1 && l2 > (long)MAX_PRODUCER_BYTES_BATCH) {
            return MAX_PRODUCER_BYTES_BATCH;
        }
        return l2;
    }

    private boolean sendClusterUpdate() {
        return !this.isInternal() && !this.isAdmin();
    }

    protected void handleLimitBehavior(int n) {
        if (n == 0) {
            this.destMessages.enforceLimits(false);
            FlowListener flowListener = new FlowListener();
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(flowListener, EventType.FULL, null);
            this.flowControlAllProducers(false, "change limit");
        } else if (n == 1) {
            Set set = this.destMessages.subSet(new OldestComparator());
            RemoveBehaviorListener removeBehaviorListener = new RemoveBehaviorListener(set, RemoveReason.REMOVED_OLDEST);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(removeBehaviorListener, EventType.SET_CHANGED_REQUEST, null);
            this.destMessages.enforceLimits(false);
        } else if (n == 2) {
            this.destMessages.enforceLimits(true);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
        } else if (n == 3) {
            this.destMessages.enforceLimits(false);
            Set set = this.destMessages.subSet(new LowPriorityComparator());
            RemoveBehaviorListener removeBehaviorListener = new RemoveBehaviorListener(set, RemoveReason.REMOVED_LOW_PRIORITY);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(removeBehaviorListener, EventType.SET_CHANGED_REQUEST, null);
        }
    }

    private void initialize() {
        try {
            if (this.stored) {
                this.size = Globals.getStore().getMessageCount(this);
                this.bytes = Globals.getStore().getByteCount(this);
            }
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error ", exception);
        }
        this.dest_inited = true;
    }

    public void initializeOldDestination() {
        this.overridePersistence(true);
        this.stored = true;
        this.dest_inited = false;
        this.loaded = false;
    }

    public boolean getIsDMQ() {
        return this.isDMQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pausedProducerSet = Collections.synchronizedSet(new LinkedHashSet());
        this.activeProducerCount = 0;
        this.isDMQ = DestType.isDMQ(this.type);
        if (!this.isDMQ) {
            this.expireReaper = new MsgExpirationReaper();
        }
        this.dest_inited = false;
        this.loaded = false;
        this.destvalid = true;
        this.destMessages = new SimpleNFLHashMap();
        this.consumers = new SimpleNFLHashMap();
        this.producers = new SimpleNFLHashMap();
        if (this.maxConsumerLimit > -1) {
            this.consumers.setCapacity(this.maxConsumerLimit);
        }
        if (this.maxProducerLimit > -1) {
            this.producers.setCapacity(this.maxProducerLimit);
        }
        this.filter = new DestFilter();
        this.unloadfilter = new UnloadFilter();
        this.dmc = new DestMetricsCounters();
        this.stored = true;
        this.setMaxPrefetch(this.maxPrefetch);
        this.handleLimitBehavior(this.limit);
        if (this.memoryLimit != null) {
            this.setByteCapacity(this.memoryLimit);
        }
        if (this.countLimit > 0) {
            this.setCapacity(this.countLimit);
        }
        if (this.msgSizeLimit != null) {
            this.setMaxByteSize(this.msgSizeLimit);
        }
        if (DestType.isInternal(this.type) && !DestType.destNameIsInternalLogging(this.getDestinationName())) {
            if (!CAN_MONITOR_DEST) {
                throw new IOException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0048"), this.getName()));
            }
            try {
                this.bm = new BrokerMonitor(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.log(8, "B3100", (Object)("Unknown Monitor destination " + this.getDestinationName()), (Throwable)illegalArgumentException);
            }
            catch (BrokerException brokerException) {
                logger.log(8, "B3100", (Object)("Monitor destination Error  " + this.getDestinationName()), (Throwable)brokerException);
            }
        }
        this.updateProducerBatch(false);
        if (this.clientReconnectInterval > 0L) {
            Destination destination = this;
            synchronized (destination) {
                if (this.clientReconnectInterval > 0L) {
                    this.reconnectReaper = new ReconnectReaperTask(this.getDestinationUID(), this.clientReconnectInterval);
                    try {
                        timer.schedule((JMQTimerTask)this.reconnectReaper, this.clientReconnectInterval);
                    }
                    catch (IllegalStateException illegalStateException) {
                        logger.log(8, "B3100", (Object)"Can not reschedule task, timer has been canceled, the broker is probably shutting down", (Throwable)illegalStateException);
                    }
                }
            }
        }
        logger.log(4, "Loading Stored destinstion  " + this + " connectionUID=" + this.id);
    }

    protected Destination(String string, int n, boolean bl, ConnectionUID connectionUID, boolean bl2) throws FeatureUnavailableException, BrokerException, IOException {
        int n2;
        this.uid = new DestinationUID(string, DestType.isQueue(n));
        this.id = connectionUID;
        this.pausedProducerSet = Collections.synchronizedSet(new LinkedHashSet());
        this.activeProducerCount = 0;
        this.producers.setCapacity(this.maxProducerLimit);
        this.consumers.setCapacity(this.maxConsumerLimit);
        this.destMessages = new SimpleNFLHashMap();
        this.destMessages.enforceLimits(true);
        if (bl2) {
            if (!DestType.isAdmin(n)) {
                if (defaultMaxMsgCnt > 0) {
                    this.setCapacity(defaultMaxMsgCnt);
                }
                this.setByteCapacity(defaultMaxMsgBytes);
                this.setMaxByteSize(defaultMaxBytesPerMsg);
                this.setLimitBehavior(defaultLimitBehavior);
                if (defaultIsLocal) {
                    this.scope = 0;
                }
            }
            if (!(DestType.isAdmin(n) || Destination.canAutoCreate(DestType.isQueue(n)) || BrokerMonitor.isInternal(string))) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2083", this.getName()), "B2083", null, 403);
            }
            n2 = DestType.isAdmin(n) ? 4 : 8;
            logger.log(n2, "B1132", this.getName());
            this.type = n | 0x20;
        } else {
            n2 = DestType.isAdmin(n) ? 4 : 8;
            this.type = n;
            if ((n & 0x10) == 16) {
                logger.log(n2, "B1160", (Object)connectionUID.toString(), this.getName());
            } else {
                logger.log(n2, "B1158", this.getName());
            }
        }
        if ((n & 0x1000) == 0 && BrokerMonitor.isInternal(string)) {
            if (DestType.isQueue(n)) {
                throw new BrokerException("Internal Exception: Only topics are supported for monitoring");
            }
            this.type = n | 0x40;
            this.scope = 0;
            try {
                if (!DestType.destNameIsInternalLogging(this.getDestinationName())) {
                    if (!CAN_MONITOR_DEST) {
                        throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0048"), this.getName()), "B4180", null, 403);
                    }
                    this.bm = new BrokerMonitor(this);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2084", this.getName()), "B2084", illegalArgumentException, 400);
            }
        }
        this.loaded = true;
        if (!bl) {
            this.neverStore = true;
            this.overridePersistence(false);
        }
        this.handleLimitBehavior(this.limit);
        this.updateProducerBatch(false);
        this.state = 0;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public DestinationUID getDestinationUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseDestination(int n) {
        if (!$assertionsDisabled && n == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.state != 0) {
            throw new AssertionError();
        }
        this.state = n;
        if (this.state == 2 || this.state == 3) {
            this.stopFlow("Destination is paused");
        }
        if (this.state == 1 || this.state == 3) {
            SimpleNFLHashMap simpleNFLHashMap = this.consumers;
            synchronized (simpleNFLHashMap) {
                Iterator iterator = this.consumers.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    Consumer consumer = (Consumer)v;
                    consumer.pause("Destination PAUSE");
                }
            }
        }
    }

    public boolean isPaused() {
        return this.state > 0 && this.state <= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDestination() {
        if (!($assertionsDisabled || this.state > 0 && this.state <= 3)) {
            throw new AssertionError();
        }
        if (this.state == 2 || this.state == 3) {
            this.resumeFlow("resumeDestination");
        }
        if (this.state == 1 || this.state == 3) {
            SimpleNFLHashMap simpleNFLHashMap = this.consumers;
            synchronized (simpleNFLHashMap) {
                Iterator iterator = this.consumers.values().iterator();
                while (iterator.hasNext()) {
                    Consumer consumer = (Consumer)iterator.next();
                    consumer.resume("Destination.RESUME");
                }
            }
        }
        this.state = 0;
    }

    public void compact() throws BrokerException {
        Globals.getStore().compactDestination(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.lastMetricsTime) / 1000L;
            this.dmc.timeStamp = l;
            this.dmc.setMessagesIn(this.msgsIn);
            this.dmc.setMessagesOut(this.msgsOut);
            this.dmc.setHighWaterMessages(this.destMessages.highWaterCount());
            this.dmc.setHighWaterMessageBytes(this.destMessages.highWaterBytes());
            this.dmc.setHighWaterLargestMsgBytes(this.destMessages.highWaterLargestMessageBytes());
            this.dmc.setActiveConsumers(this.consumers.size());
            this.dmc.setNumConsumers(this.consumers.size());
            this.dmc.setFailoverConsumers(0);
            this.dmc.setHWActiveConsumers(this.consumers.highWaterCount());
            this.dmc.setHWNumConsumers(this.consumers.highWaterCount());
            this.dmc.setHWFailoverConsumers(0);
            this.dmc.setAvgActiveConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgNumConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgFailoverConsumers(0);
            this.dmc.setMessageBytesIn(this.msgBytesIn);
            this.dmc.setMessageBytesOut(this.msgBytesOut);
            this.dmc.setCurrentMessages(this.destMessages.size());
            this.dmc.setCurrentMessageBytes(this.destMessages.byteSize());
            this.dmc.setAverageMessages((int)this.destMessages.averageCount());
            this.dmc.setAverageMessageBytes((long)this.destMessages.averageBytes());
            if (this.isStored()) {
                try {
                    if (Globals.getStore().getStoreType().equals("file")) {
                        HashMap hashMap = Globals.getStore().getStorageInfo(this);
                        Object var7_6 = null;
                        Object v = hashMap.get(DestMetricsCounters.DISK_RESERVED);
                        var7_6 = v;
                        if (v != null) {
                            this.dmc.setDiskReserved((Long)var7_6);
                        }
                        Object v2 = hashMap.get(DestMetricsCounters.DISK_USED);
                        var7_6 = v2;
                        if (v2 != null) {
                            this.dmc.setDiskUsed((Long)var7_6);
                        }
                        Object v3 = hashMap.get(DestMetricsCounters.DISK_UTILIZATION_RATIO);
                        var7_6 = v3;
                        if (v3 != null) {
                            this.dmc.setUtilizationRatio((Integer)var7_6);
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    logger.log(32, brokerException.getMessage(), brokerException);
                }
            }
            this.dmc.setExpiredMsgCnt(this.expiredCnt);
            this.dmc.setPurgedMsgCnt(this.purgedCnt);
            this.dmc.setAckedMsgCnt(this.ackedCnt);
            this.dmc.setDiscardedMsgCnt(this.discardedCnt);
            this.dmc.setRejectedMsgCnt(this.overflowCnt + this.errorCnt);
            this.dmc.setRollbackMsgCnt(this.rollbackCnt);
            this.lastMetricsTime = l;
            this.lastMsgsIn = this.msgsIn;
            this.lastMsgsOut = this.msgsOut;
            this.lastMsgBytesIn = this.msgBytesIn;
            this.lastMsgBytesOut = this.msgBytesOut;
            return this.dmc;
        }
    }

    public int getState() {
        return this.state;
    }

    protected void setState(int n) {
        this.state = n;
    }

    public void setIsLocal(boolean bl) throws BrokerException {
        int n = 0;
        n = bl ? 0 : 1;
        this.setScope(n);
    }

    public void setScope(int n) throws BrokerException {
        if (!CAN_USE_LOCAL_DEST && n == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0049"), this.getName()), "B4180", null, 403);
        }
        this.scope = n;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean getIsLocal() {
        return this.scope == 0;
    }

    public void setLimitBehavior(int n) throws BrokerException {
        if (this.isDMQ && n == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4191"));
        }
        this.limit = n;
        this.handleLimitBehavior(this.limit);
    }

    public int getLimitBehavior() {
        return this.limit;
    }

    public void setClusterDeliveryPolicy(int n) {
        throw new UnsupportedOperationException(" cluster delivery policy not supported for this type of destination ");
    }

    public int getClusterDeliveryPolicy() {
        return 0;
    }

    public boolean isStored() {
        return !this.neverStore || this.stored;
    }

    public synchronized boolean store() throws BrokerException, IOException {
        if (this.neverStore || this.stored) {
            return false;
        }
        Globals.getStore().storeDestination(this, PERSIST_SYNC);
        this.stored = true;
        return this.stored;
    }

    public boolean shouldSync() {
        return PERSIST_SYNC;
    }

    public void update() throws BrokerException, IOException {
        this.update(true);
    }

    public void update(boolean bl) throws BrokerException, IOException {
        boolean bl2;
        boolean bl3 = bl2 = !this.getIsDMQ() && bl && this.sendClusterUpdate() && !this.isTemporary();
        if (bl2) {
            Globals.getClusterBroadcast().recordUpdateDestination(this);
        }
        if (!this.neverStore && this.stored) {
            Globals.getStore().updateDestination(this, PERSIST_SYNC);
        }
        this.updateProducerBatch(true);
        if (bl2) {
            Globals.getClusterBroadcast().updateDestination(this);
        }
    }

    public HashMap getDestinationProperties() {
        HashMap hashMap = new HashMap();
        this.getDestinationProps(hashMap);
        return hashMap;
    }

    protected void getDestinationProps(Map map) {
        map.put(NAME, this.getDestinationName());
        map.put(IS_QUEUE, new Boolean(this.isQueue()));
        map.put(IS_INTERNAL, new Boolean(this.isInternal()));
        map.put(IS_AUTOCREATED, new Boolean(this.isAutoCreated()));
        map.put(IS_TEMPORARY, new Boolean(this.isTemporary()));
        map.put(IS_ADMIN, new Boolean(this.isAdmin()));
        map.put(IS_LOCAL, new Boolean(this.getIsLocal()));
        map.put(REAL_TYPE, new Integer(this.type));
        map.put(SCOPE_PROPERTY, new Integer(this.scope));
        map.put(MAX_CONSUMERS, new Integer(this.maxConsumerLimit));
        map.put(MAX_PRODUCERS, new Integer(this.maxProducerLimit));
        map.put(MAX_PREFETCH, new Integer(this.maxPrefetch));
        map.put(MAX_MESSAGES, new Integer(this.countLimit));
        map.put(USE_DMQ, new Boolean(this.useDMQ));
        if (this.memoryLimit != null) {
            map.put(MAX_BYTES, new Long(this.memoryLimit.getBytes()));
        }
        if (this.msgSizeLimit != null) {
            map.put(MAX_MSG_BYTES, new Long(this.msgSizeLimit.getBytes()));
        }
        map.put(BEHAVIOUR, new Integer(this.limit));
        map.put(STATE, new Integer(this.scope));
    }

    public void setDestinationProperties(Map map) throws BrokerException {
        SizeString sizeString;
        if (DEBUG) {
            logger.log(4, "Setting destination properties for " + this + " to " + map);
        }
        if (map.get(MAX_CONSUMERS) != null) {
            try {
                this.setMaxConsumers((Integer)map.get(MAX_CONSUMERS));
            }
            catch (BrokerException brokerException) {
                logger.log(8, "Internal Error ", brokerException);
            }
        }
        if (map.get(MAX_PRODUCERS) != null) {
            try {
                this.setMaxProducers((Integer)map.get(MAX_PRODUCERS));
            }
            catch (BrokerException brokerException) {
                logger.log(8, "Internal Error ", brokerException);
            }
        }
        if (map.get(MAX_PREFETCH) != null) {
            this.setMaxPrefetch((Integer)map.get(MAX_PREFETCH));
        }
        if (map.get(MAX_MESSAGES) != null) {
            this.setCapacity((Integer)map.get(MAX_MESSAGES));
        }
        if (map.get(MAX_BYTES) != null) {
            sizeString = new SizeString();
            sizeString.setBytes((Long)map.get(MAX_BYTES));
            this.setByteCapacity(sizeString);
        }
        if (map.get(MAX_MSG_BYTES) != null) {
            sizeString = new SizeString();
            sizeString.setBytes((Long)map.get(MAX_MSG_BYTES));
            this.setMaxByteSize(sizeString);
        }
        if (map.get(BEHAVIOUR) != null) {
            this.setLimitBehavior((Integer)map.get(BEHAVIOUR));
        }
        if (map.get(IS_LOCAL) != null) {
            this.setIsLocal((Boolean)map.get(IS_LOCAL));
        }
        if (map.get(USE_DMQ) != null) {
            this.setUseDMQ((Boolean)map.get(USE_DMQ));
        }
        try {
            this.update(false);
        }
        catch (Exception exception) {
            logger.log(16, "Internal error:  Unable to update destination {0}", (Object)this.getName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "All Destinations");
        hashtable.put("maxMsgSize", individual_max_size == null ? "null" : individual_max_size.toString());
        hashtable.put("maxTotalSize", max_size == null ? "null" : max_size.toString());
        hashtable.put("maxCount", String.valueOf(message_max_count));
        hashtable.put("totalBytes", String.valueOf(totalbytes));
        hashtable.put("totalCnt", String.valueOf(totalcnt));
        hashtable.put("sync", String.valueOf(PERSIST_SYNC));
        hashtable.put("allProducerFlow", String.valueOf(!NO_PRODUCER_FLOW));
        hashtable.put("autoCreateTopics", String.valueOf(ALLOW_TOPIC_AUTOCREATE));
        hashtable.put("autoCreateQueue", String.valueOf(ALLOW_QUEUE_AUTOCREATE));
        hashtable.put("messageExpiration", String.valueOf(MESSAGE_EXPIRE));
        hashtable.put("producerBatch", String.valueOf(MAX_PRODUCER_BATCH));
        hashtable.put("QueueSpecific", Queue.getAllDebugState());
        hashtable.put("msgCnt", packetlist == null ? "null" : String.valueOf(packetlist.size()));
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Map map = destinationList;
        synchronized (map) {
            hashtable.put("destinationCnt", destinationList == null ? "null" : String.valueOf(destinationList.size()));
            if (destinationList != null) {
                Iterator iterator = destinationList.keySet().iterator();
                while (iterator.hasNext()) {
                    DestinationUID destinationUID = (DestinationUID)iterator.next();
                    Destination destination = Destination.getDestination(destinationUID);
                    if (destination == null) {
                        hashtable2.put(destinationUID.getLocalizedName(), "Unknown");
                        continue;
                    }
                    hashtable2.put(destinationUID.getLocalizedName(), destination.getDebugState());
                }
            }
        }
        hashtable.put("destinations", hashtable2);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "Destination[" + this.uid.toString() + "]");
        this.getDestinationProps(hashtable);
        hashtable.putAll(this.getMetrics());
        hashtable.put("Consumers", String.valueOf(this.consumers.size()));
        Iterator<Object> iterator = this.consumers.values().iterator();
        Hashtable hashtable2 = new Hashtable();
        ArrayList arrayList = new ArrayList(this.destMessages.values());
        while (iterator.hasNext()) {
            serializable2 = (Consumer)iterator.next();
            serializable = ((Consumer)serializable2).getConsumerUID();
            object = ((Consumer)serializable2).getStoredConsumerUID();
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                PacketReference packetReference = (PacketReference)arrayList.get(i);
                if (!packetReference.matches((ConsumerUID)object)) continue;
                ++n2;
                if (packetReference.isAcknowledged((ConsumerUID)object)) {
                    ++n4;
                }
                if (!packetReference.isDelivered((ConsumerUID)object)) continue;
                ++n3;
            }
            String string = n2 + " of " + n + "[ d=" + n3 + ", a=" + n4 + "]";
            hashtable.put("Consumer[" + String.valueOf(((UID)serializable).longValue()) + "]", string);
        }
        serializable2 = null;
        serializable = this.producers;
        synchronized (serializable) {
            serializable2 = new HashSet(this.producers.keySet());
        }
        iterator = serializable2.iterator();
        serializable = new Vector();
        while (iterator.hasNext()) {
            object = (ProducerUID)iterator.next();
            ((Vector)serializable).add(String.valueOf(((UID)object).longValue()));
        }
        hashtable.put("Producers", serializable);
        hashtable.put("_stored", String.valueOf(this.stored));
        hashtable.put("_neverStore", String.valueOf(this.neverStore));
        hashtable.put("_destvalid", String.valueOf(this.destvalid));
        hashtable.put("_loaded", String.valueOf(this.loaded));
        hashtable.put("_state", DestState.toString(this.state));
        hashtable.put("producerMsgBatchSize", String.valueOf(this.producerMsgBatchSize));
        hashtable.put("producerMsgBatchBytes", String.valueOf(this.producerMsgBatchBytes));
        if (this.reconnectReaper != null) {
            hashtable.put("_reconnectReaper", this.reconnectReaper.toString());
        }
        hashtable.put("_clientReconnectInterval", String.valueOf(this.clientReconnectInterval));
        hashtable.put("TrueType", DestType.toString(this.type));
        if (this.id != null) {
            hashtable.put("ConnectionUID", String.valueOf(this.id.longValue()));
        }
        hashtable.put("activeProducerCount", String.valueOf(this.activeProducerCount));
        hashtable.put("pausedProducerCount", String.valueOf(this.activeProducerCount));
        iterator = this.pausedProducerSet.iterator();
        serializable = new Vector();
        while (iterator.hasNext()) {
            object = iterator.next();
            ProducerUID producerUID = object instanceof Producer ? ((Producer)iterator.next()).getProducerUID() : (ProducerUID)iterator.next();
            ((Vector)serializable).add(String.valueOf(producerUID.longValue()));
        }
        hashtable.put("pausedProducerSet", serializable);
        iterator = this.destMessages.keySet().iterator();
        serializable = new Vector();
        while (iterator.hasNext()) {
            object = (SysMessageID)iterator.next();
            ((Vector)serializable).add(((SysMessageID)object).toString());
        }
        hashtable.put("Messages", serializable);
        if (this.destMessages != null) {
            hashtable.put("Size", String.valueOf(this.destMessages.size()));
        }
        return hashtable;
    }

    public Hashtable getDebugMessages(boolean bl) {
        Object object;
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                logger.log(8, "Internal Error: loading before purging {0}", (Object)this.getName(), (Throwable)exception);
            }
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        try {
            object = new HashSet(this.destMessages.values()).iterator();
            while (object.hasNext()) {
                PacketReference packetReference = (PacketReference)object.next();
                Hashtable hashtable = packetReference.getDebugState();
                hashtable.put("ID", packetReference.getSysMessageID().toString());
                if (bl) {
                    hashtable.put("PACKET", packetReference.getPacket().dumpPacketString("        "));
                }
                vector.add(hashtable);
            }
        }
        catch (Throwable throwable) {
            logger.log(4, "Error getting debugMessages ", throwable);
        }
        object = new Hashtable();
        ((Hashtable)object).put("  ", vector);
        return object;
    }

    public String getName() {
        return this.uid.getLocalizedName();
    }

    public String getDestinationName() {
        return this.uid.getName();
    }

    public ConnectionUID getConnectionUID() {
        return this.id;
    }

    public boolean isAutoCreated() {
        return (this.type & 0x20) > 0;
    }

    public boolean isTemporary() {
        return (this.type & 0x10) > 0;
    }

    public boolean isQueue() {
        return (this.type & 1) > 0;
    }

    public int getType() {
        return this.type;
    }

    public Collection getAllMessages() throws UnsupportedOperationException {
        return this.destMessages.values();
    }

    public void purgeDestination() throws UnsupportedOperationException, BrokerException {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                logger.logStack(4, "Error loading " + this + " for purge ", exception);
            }
        }
        try {
            HashSet hashSet = new HashSet(this.destMessages.keySet());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.removeMessage((SysMessageID)iterator.next(), RemoveReason.PURGED);
            }
            if (this.isStored()) {
                Globals.getStore().removeAllMessages(this, false);
            }
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error: purging {0}", this.getName(), (Throwable)exception);
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException("Internal Error:purging " + this.getName(), exception);
        }
    }

    public void purgeDestination(Filter filter) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                logger.log(8, "Internal Error: loading before purging {0}", (Object)this.getName(), (Throwable)exception);
            }
        }
        Map map = this.destMessages.getAll(filter);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                this.removeMessage((SysMessageID)iterator.next(), RemoveReason.PURGED);
            }
            catch (Exception exception) {
                logger.logStack(8, "Internal Error purging", exception);
            }
        }
    }

    public Map getAll(Filter filter) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                logger.log(8, "Internal Error: loading {0}", (Object)this.getName(), (Throwable)exception);
            }
        }
        return this.destMessages.getAll(filter);
    }

    public int size() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.size;
        }
        return this.destMessages.size();
    }

    public long byteSize() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.bytes;
        }
        return this.destMessages.byteSize();
    }

    public abstract int getUnackSize();

    public long getHighWaterBytes() {
        return this.destMessages.highWaterBytes();
    }

    public int getHighWaterCount() {
        return this.destMessages.highWaterCount();
    }

    public long highWaterLargestMessageBytes() {
        return this.destMessages.highWaterLargestMessageBytes();
    }

    public double getAverageBytes() {
        return this.destMessages.averageBytes();
    }

    public float getAverageCount() {
        return this.destMessages.averageCount();
    }

    public double averageMessageBytes() {
        return this.destMessages.averageMessageBytes();
    }

    public SizeString getMaxByteSize() {
        return this.msgSizeLimit;
    }

    public int getCapacity() {
        return this.countLimit;
    }

    public SizeString getByteCapacity() {
        return this.memoryLimit;
    }

    public void setMaxByteSize(SizeString sizeString) throws UnsupportedOperationException {
        if (DEBUG) {
            logger.log(4, "attempting to set Message Size Limit to " + sizeString + " for destination " + this);
        }
        this.msgSizeLimit = sizeString;
        long l = 0L;
        l = sizeString == null ? -1L : sizeString.getBytes();
        if (l == 0L) {
            l = -1L;
        }
        this.destMessages.setMaxByteSize(l);
    }

    public void setCapacity(int n) throws UnsupportedOperationException {
        if (DEBUG) {
            logger.log(4, "attempting to set Message Count Limit to " + n + " for destination " + this);
        }
        if (n == 0) {
            n = -1;
        }
        this.countLimit = n;
        this.destMessages.setCapacity(n);
        this.updateProducerBatch(false);
    }

    public void setByteCapacity(SizeString sizeString) throws UnsupportedOperationException {
        if (DEBUG) {
            logger.log(4, "attempting to set Message Bytes Limit to " + sizeString + " for destination " + this);
        }
        this.memoryLimit = sizeString;
        long l = 0L;
        l = sizeString == null ? -1L : sizeString.getBytes();
        if (l == 0L) {
            l = -1L;
        }
        this.destMessages.setByteCapacity(l);
        this.updateProducerBatch(false);
    }

    public int getMaxActiveConsumers() {
        return -1;
    }

    public int getMaxFailoverConsumers() {
        return 0;
    }

    public void setMaxProducers(int n) throws BrokerException {
        if (this.isDMQ) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4192"));
        }
        if (n == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4178", this.getName()), "B4178", null, 500);
        }
        this.maxProducerLimit = n;
        this.producers.setCapacity(this.maxProducerLimit);
    }

    public int getMaxProducers() {
        return this.maxProducerLimit;
    }

    public int getActiveConsumerCount() {
        return this.getConsumerCount();
    }

    public int getFailoverConsumerCount() {
        return 0;
    }

    public void setMaxConsumers(int n) throws BrokerException {
        if (n == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4179", this.getName()), "B4179", null, 500);
        }
        this.maxConsumerLimit = n;
        this.consumers.setCapacity(this.maxConsumerLimit);
    }

    public void setMaxActiveConsumers(int n) throws BrokerException {
        throw new UnsupportedOperationException("setting max active consumers not supported on this destination type");
    }

    public void setMaxFailoverConsumers(int n) throws BrokerException {
        throw new UnsupportedOperationException("setting max failover consumers not supported on this destination type");
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Destination) {
            if (this.uid == ((Destination)object).uid) {
                return true;
            }
            return this.uid.equals(((Destination)object).uid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueMessage(PacketReference packetReference, boolean bl) throws BrokerException {
        if (!valid) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B1157", this.getName()));
        }
        Destination destination = this;
        synchronized (destination) {
            ++this.msgsIn;
            this.msgBytesIn += packetReference.byteSize();
        }
        try {
            boolean bl2 = !this.isAdmin() && !this.isInternal();
            boolean bl3 = Destination.addNewMessage(bl2, packetReference);
            if (!bl3 && !this.isDMQ) {
                if (!this.isInternal()) {
                    packetReference.setDestination(this);
                    this.markDead(packetReference, RemoveReason.EXPIRED, null);
                    Destination.removePacketList(packetReference.getSysMessageID(), this.getDestinationUID());
                }
                return false;
            }
        }
        catch (BrokerException brokerException) {
            packetReference.destroy();
            throw brokerException;
        }
        packetReference.setDestination(this);
        try {
            if (!valid) {
                packetReference.destroy();
                throw new BrokerException(Globals.getBrokerResources().getKString("B1157", this.getName()));
            }
            this.putMessage(packetReference, AddReason.QUEUED);
            if (this.overrideP) {
                packetReference.overridePersistence(this.overridePvalue);
            }
            if (this.overrideTTL) {
                packetReference.overrideExpireTime(System.currentTimeMillis() + this.overrideTTLvalue);
            }
            ExpirationInfo expirationInfo = packetReference.getExpiration();
            if (this.expireReaper != null && expirationInfo != null) {
                if (!valid) {
                    RuntimeException runtimeException = new RuntimeException("Destination " + this + " destroyed");
                    runtimeException.fillInStackTrace();
                    logger.logStack(4, "Removing message to invalid dst", runtimeException);
                    this.removeMessage(packetReference.getSysMessageID(), null);
                    throw runtimeException;
                }
                if (this.expireReaper == null) {
                    RuntimeException runtimeException = new RuntimeException("No Reaper");
                    runtimeException.fillInStackTrace();
                    logger.logStack(8, "Internal Error, Unknown  destination " + this + " isValid= " + this.isValid(), runtimeException);
                    return true;
                }
                this.expireReaper.addExpiringMessage(expirationInfo);
            }
        }
        catch (OutOfLimitsException outOfLimitsException) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.OVERFLOW);
            Object object = outOfLimitsException.getLimit();
            boolean bl4 = false;
            if (object != null) {
                if (object instanceof Integer) {
                    bl4 = (Integer)outOfLimitsException.getLimit() <= 0;
                } else if (object instanceof Long) {
                    bl4 = (Long)outOfLimitsException.getLimit() <= 0L;
                }
            }
            Object[] objectArray = new String[]{packetReference.getSysMessageID().toString(), this.getName(), outOfLimitsException.getValue().toString(), bl4 ? Globals.getBrokerResources().getString("B0012") : outOfLimitsException.getLimit().toString()};
            String string = "B4117";
            int n = 414;
            switch (outOfLimitsException.getType()) {
                case 0: {
                    string = "B4120";
                    break;
                }
                case 1: {
                    string = "B4121";
                    break;
                }
                case 2: {
                    string = "B4122";
                    n = 423;
                }
            }
            throw new BrokerException(Globals.getBrokerResources().getKString(string, objectArray), string, outOfLimitsException, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.ERROR);
            throw illegalArgumentException;
        }
        return true;
    }

    public abstract Set routeNewMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void forwardOrphanMessage(PacketReference var1, ConsumerUID var2) throws BrokerException;

    public abstract void forwardMessage(Set var1, PacketReference var2) throws BrokerException;

    protected abstract ConsumerUID[] routeLoadedTransactionMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public void putMessage(PacketReference packetReference, Reason reason) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.destMessages.put(packetReference.getSysMessageID(), packetReference, reason);
        this._messageAdded(packetReference.byteSize(), reason);
    }

    public boolean removeMessage(SysMessageID sysMessageID, Reason reason) throws BrokerException {
        return this.removeMessage(sysMessageID, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(SysMessageID sysMessageID, Reason reason, Hashtable hashtable) throws BrokerException {
        PacketReference packetReference = null;
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                logger.logStack(8, "B2085", this.getName(), (Throwable)exception);
            }
        }
        if ((packetReference = (PacketReference)this.destMessages.get(sysMessageID)) == null) {
            logger.log(4, "Reference already gone for " + sysMessageID);
            return false;
        }
        PacketReference packetReference2 = packetReference;
        synchronized (packetReference2) {
            if (packetReference.getLBitSet()) {
                packetReference.setInvalid();
                logger.log(4, "LBit set for " + sysMessageID);
                return false;
            }
        }
        boolean bl = false;
        if (!(this.isInternal() || reason != RemoveReason.EXPIRED && reason != RemoveReason.REMOVED_LOW_PRIORITY && reason != RemoveReason.REMOVED_OLDEST && reason != RemoveReason.ERROR && reason != RemoveReason.UNDELIVERABLE)) {
            this.markDead(packetReference, reason, hashtable);
        }
        packetReference.setInvalid();
        packetReference = (PacketReference)this.destMessages.remove((Object)sysMessageID, reason);
        if (!$assertionsDisabled && packetReference == null) {
            throw new AssertionError();
        }
        if (packetReference == null) {
            logger.log(8, "Ref null for " + sysMessageID);
            return false;
        }
        long l = packetReference.byteSize();
        ExpirationInfo expirationInfo = packetReference.getExpiration();
        this._messageRemoved(packetReference, packetReference.byteSize(), reason);
        packetReference.destroy();
        Destination destination = this;
        synchronized (destination) {
            ++this.msgsOut;
            this.msgBytesOut += packetReference.byteSize();
            if (expirationInfo != null && reason != RemoveReason.EXPIRED && expirationInfo != null && this.expireReaper != null) {
                this.expireReaper.removeMessage(expirationInfo);
            }
        }
        return true;
    }

    public String lookupReasonString(Reason reason, long l, long l2) {
        String string = null;
        if (reason == RemoveReason.EXPIRED) {
            string = l != 0L && l2 != 0L && l2 <= l ? Globals.getBrokerResources().getKString("B0065", this.getDestinationUID().toString()) : Globals.getBrokerResources().getKString("B0053", this.getDestinationUID().toString());
        } else if (reason == RemoveReason.REMOVED_LOW_PRIORITY || reason == RemoveReason.REMOVED_OLDEST) {
            String string2 = this.countLimit <= 0 ? Globals.getBrokerResources().getString("B0012") : String.valueOf(this.countLimit);
            String string3 = this.memoryLimit == null || this.memoryLimit.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : this.memoryLimit.toString();
            Object[] objectArray = new String[]{this.getDestinationUID().toString(), string2, string3};
            string = Globals.getBrokerResources().getKString("B0054", objectArray);
        } else {
            string = reason == RemoveReason.UNDELIVERABLE ? Globals.getBrokerResources().getKString("B0055", this.getDestinationUID().toString()) : Globals.getBrokerResources().getKString("B0056", this.getDestinationUID().toString());
        }
        return string;
    }

    public void primaryInterestChanged(Consumer consumer) {
    }

    private ConnectionUID getConnectionUID(Consumer consumer) {
        return consumer.getConsumerUID().getConnectionUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer addConsumer(Consumer consumer, boolean bl) throws BrokerException, SelectorFormatException {
        if (this.isInternal() && !BrokerMonitor.ENABLED) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4181", this.getName()));
        }
        consumer.attachToDestination(this);
        consumer.addRemoveListener(this.destMessages);
        if (!this.loaded && consumer.isActive()) {
            this.load();
        }
        Serializable serializable = this.consumers;
        synchronized (serializable) {
            if (this.maxConsumerLimit != -1 && this.maxConsumerLimit <= this.consumers.size()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4182", this.getName(), String.valueOf(this.maxConsumerLimit)), "B4182", null, 409);
            }
            this.consumers.put(consumer.getConsumerUID(), consumer);
            if (this.bm != null && this.consumers.size() == 1) {
                this.bm.start();
            }
            if (this.state == 1 || this.state == 3) {
                consumer.pause("Destination PAUSE2");
            }
        }
        serializable = this;
        synchronized (serializable) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            this.clientReconnect();
        }
        if (this.bm != null) {
            this.bm.updateNewConsumer(consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID, boolean bl) throws BrokerException {
        Consumer consumer = null;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            consumer = (Consumer)this.consumers.remove(consumerUID);
            Destination destination = this;
            synchronized (destination) {
                if (this.bm != null && this.consumers.size() == 0) {
                    this.bm.stop();
                }
                if (this.isAutoCreated() && !this.isTemporary() && this.size == 0 && this.consumers.isEmpty() && this.producers.isEmpty() && this.task == null) {
                    if (this.task != null) {
                        this.task.cancel();
                        this.task = null;
                    }
                    this.task = new DestReaperTask(this.uid);
                    try {
                        timer.schedule(this.task, AUTOCREATE_EXPIRE);
                    }
                    catch (IllegalStateException illegalStateException) {
                        logger.log(4, "Can not reschedule task, timer has been canceled, the broker  is probably shutting down", illegalStateException);
                    }
                }
            }
        }
        if (consumer != null) {
            consumer.removeRemoveListener(this.destMessages);
        }
        if (consumer != null && this.sendClusterUpdate() && bl) {
            Globals.getClusterBroadcast().destroyConsumer(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProducer(Producer producer) throws BrokerException {
        if (this.isInternal()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4184", this.getName()));
        }
        if (this.maxProducerLimit != -1 && this.producers.size() >= this.maxProducerLimit) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", null, 409);
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
        if (!this.loaded) {
            this.load();
        }
        try {
            serializable = this.producers;
            synchronized (serializable) {
                this.producers.put(producer.getProducerUID(), producer);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", indexOutOfBoundsException, 409);
        }
        serializable = this;
        synchronized (serializable) {
            ++this.activeProducerCount;
        }
        if (this.state == 2 || this.state == 3) {
            this.flowControlSpecificProducer(producer, true, false);
            return false;
        }
        int n = this.destMessages.freeSpace();
        long l = this.destMessages.freeBytes();
        if (this.limit != 0 || this.pausedProducerSet.isEmpty() && (n == -1 || n >= this.activeProducerCount * this.producerMsgBatchSize) && (l == -1L || l >= (long)(this.activeProducerCount * this.producerMsgBatchSize))) {
            this.flowControlSpecificProducer(producer, false, false);
            return true;
        }
        this.flowControlSpecificProducer(producer, true, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProducer(ProducerUID producerUID) {
        Producer producer = null;
        Serializable serializable = this.producers;
        synchronized (serializable) {
            producer = (Producer)this.producers.remove(producerUID);
        }
        if (producer == null) {
            return;
        }
        serializable = this;
        synchronized (serializable) {
            if (!this.pausedProducerSet.remove(producer)) {
                --this.activeProducerCount;
            }
        }
        if (this.isAutoCreated() && !this.isTemporary() && this.size == 0 && this.consumers.isEmpty() && this.producers.isEmpty()) {
            serializable = this;
            synchronized (serializable) {
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = new DestReaperTask(this.uid);
                try {
                    timer.schedule(this.task, AUTOCREATE_EXPIRE);
                }
                catch (IllegalStateException illegalStateException) {
                    logger.log(4, "Can not reschedule task, timer has been canceled, the broker is probably shutting down", illegalStateException);
                }
            }
        }
    }

    private void dumpStoredSet(Set set) {
        logger.log(8, "DEBUG: Dumping order");
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PacketReference packetReference = (PacketReference)iterator.next();
            logger.log(8, packetReference.getPriority() + " : " + packetReference.getTime() + " :" + packetReference.getSequence() + "  " + packetReference.getSysMessageID() + " : " + packetReference.getPacket().getTimestamp());
        }
    }

    public synchronized void load() throws BrokerException {
        this.load(false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Map load(boolean bl, Map map, Map map2) throws BrokerException {
        Object object;
        Object object2;
        logger.log(4, "Loading " + this.size + " messages from destination " + this);
        if (this.loaded) {
            return null;
        }
        logger.log(8, "B1151", (Object)this.toString(), String.valueOf(this.size));
        HashMap<SysMessageID, TransactionUID> hashMap = null;
        boolean bl2 = true;
        HashSet<PacketReference> hashSet = new HashSet<PacketReference>();
        int n = this.size;
        int n2 = 0;
        try {
            Object[] objectArray;
            PacketReference packetReference;
            Object object3;
            bl2 = this.destMessages.getEnforceLimits();
            this.destMessages.enforceLimits(false);
            object2 = Globals.getStore();
            object = ((Store)object2).messageEnumeration(this);
            TreeSet<PacketReference> treeSet = new TreeSet<PacketReference>(new LoadComparator());
            while (object.hasMoreElements()) {
                block42: {
                    object3 = (Packet)object.nextElement();
                    packetReference = PacketReference.createReference((Packet)object3, this.uid, null);
                    if (bl) {
                        packetReference.overrideExpireTime(0L);
                    }
                    packetReference.setLoaded();
                    if (DEBUG) {
                        logger.log(8, "Loaded Message " + object3 + " into destination " + this);
                    }
                    try {
                        if (this.isDMQ || Destination.addNewMessage(false, packetReference)) break block42;
                        hashSet.add(packetReference);
                    }
                    catch (Exception exception) {
                        Object[] objectArray2 = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), exception.getMessage()};
                        logger.log(16, "B2089", objectArray2);
                        continue;
                    }
                }
                treeSet.add(packetReference);
                Destination.packetlistAdd(packetReference.getSysMessageID(), packetReference.getDestinationUID());
                if (++n2 <= 0 || n2 % LOAD_COUNT != 0 && (n2 <= LOAD_COUNT || n2 != this.size)) continue;
                objectArray = new String[]{this.toString(), String.valueOf(n2), String.valueOf(n), String.valueOf(n2 * 100 / n)};
                logger.log(8, "B1153", objectArray);
            }
            object3 = treeSet.iterator();
            while (object3.hasNext()) {
                Object object4;
                Object object5;
                packetReference = (PacketReference)object3.next();
                objectArray = ((Store)object2).getConsumerUIDs(this.getDestinationUID(), packetReference.getSysMessageID());
                if (objectArray == null) {
                    objectArray = new ConsumerUID[]{};
                }
                boolean bl3 = false;
                if (packetReference.getTransactionID() != null) {
                    object5 = map2 == null ? null : map2.get(packetReference.getTransactionID());
                    if (object5 == null) {
                        if (objectArray.length == 0) {
                            try {
                                objectArray = this.routeLoadedTransactionMessage(packetReference);
                            }
                            catch (Exception exception) {
                                logger.log(8, "Internal Error loading/routing transacted message, throwing out message " + packetReference.getSysMessageID(), exception);
                            }
                            if (objectArray.length > 0) {
                                int[] nArray = new int[objectArray.length];
                                for (int i = 0; i < nArray.length; ++i) {
                                    nArray[i] = 0;
                                }
                                Globals.getStore().storeInterestStates(this.getDestinationUID(), packetReference.getSysMessageID(), (ConsumerUID[])objectArray, nArray, true);
                            } else {
                                packetReference.destroy();
                                continue;
                            }
                        }
                    } else if (object5 == Boolean.TRUE) {
                        if (hashMap == null) {
                            hashMap = new HashMap<SysMessageID, TransactionUID>();
                        }
                        hashMap.put(packetReference.getSysMessageID(), packetReference.getTransactionID());
                        bl3 = true;
                    } else {
                        packetReference.destroy();
                        continue;
                    }
                }
                if (objectArray.length == 0) {
                    logger.log(4, "Unrouted packet " + packetReference);
                    object5 = this;
                    synchronized (object5) {
                        --this.size;
                        long l = packetReference.byteSize();
                        this.bytes -= l;
                        if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                            object4 = this.getClass();
                            synchronized (object4) {
                                totalbytes -= l;
                                --totalcnt;
                            }
                        }
                    }
                    packetReference.destroy();
                    continue;
                }
                object5 = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    object5[i] = ((Store)object2).getInterestState(this.getDestinationUID(), packetReference.getSysMessageID(), objectArray[i]);
                }
                packetReference.update((ConsumerUID[])objectArray, (int[])object5);
                try {
                    this.putMessage(packetReference, AddReason.LOADED);
                }
                catch (OutOfLimitsException outOfLimitsException) {
                    Object[] objectArray3 = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), outOfLimitsException.getMessage()};
                    logger.log(16, "B2089", objectArray3);
                    continue;
                }
                ExpirationInfo expirationInfo = packetReference.getExpiration();
                if (expirationInfo != null && this.expireReaper != null) {
                    this.expireReaper.addExpiringMessage(expirationInfo);
                }
                List<ConsumerUID> list = Arrays.asList(objectArray);
                object4 = map == null ? null : map.get(packetReference.getSysMessageID());
                if (object4 != null) {
                    list = new ArrayList<ConsumerUID>(list);
                    Iterator<ConsumerUID> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ConsumerUID consumerUID = iterator.next();
                        TransactionUID transactionUID = (TransactionUID)object4.get(consumerUID);
                        Boolean bl4 = map2 == null ? null : map2.get(transactionUID);
                        if (bl4 == null) {
                            if (packetReference.acknowledged(consumerUID, consumerUID, false, true)) {
                                packetReference.destroy();
                                continue;
                            }
                            iterator.remove();
                            continue;
                        }
                        if (bl4 == Boolean.TRUE) {
                            iterator.remove();
                            continue;
                        }
                        if (bl4 != Boolean.FALSE) continue;
                    }
                }
                this.loaded = true;
                if (bl3) continue;
                this.routeLoadedMessage(packetReference, list);
            }
        }
        catch (Throwable throwable) {
            logger.logStack(32, "B2085", this.getName(), throwable);
            this.unload(true);
        }
        this.destMessages.enforceLimits(bl2);
        this.loaded = true;
        object2 = hashSet.iterator();
        while (true) {
            if (!object2.hasNext()) {
                logger.log(8, "B1152", (Object)this.toString(), String.valueOf(this.size));
                return hashMap;
            }
            object = (PacketReference)object2.next();
            try {
                if (hashMap != null) {
                    hashMap.remove(((PacketReference)object).getSysMessageID());
                }
                this.removeMessage(((PacketReference)object).getSysMessageID(), RemoveReason.EXPIRED);
            }
            catch (Exception exception) {
                logger.logStack(8, "Internal Error  processing " + object + " while loading destination " + this, exception);
                continue;
            }
            break;
        }
    }

    protected void routeLoadedMessage(PacketReference packetReference, List list) throws BrokerException, SelectorFormatException {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            if (consumerUID == PacketReference.queueUID) {
                object = this.routeNewMessage(packetReference);
                this.forwardMessage((Set)object, packetReference);
                continue;
            }
            object = (Consumer)this.consumers.get(consumerUID);
            if (object == null) {
                Set set = this.routeNewMessage(packetReference);
                this.forwardMessage(set, packetReference);
                continue;
            }
            ((Consumer)object).routeMessage(packetReference, false);
        }
    }

    protected Consumer getConsumer(ConsumerUID consumerUID) {
        return (Consumer)this.consumers.get(consumerUID);
    }

    public void unload(boolean bl) {
        if (DEBUG) {
            logger.log(4, "Unloading " + this);
        }
        if (!this.loaded) {
            return;
        }
        this.bytes = this.destMessages.byteSize();
        this.size = this.destMessages.size();
        Map map = this.destMessages.getAll(this.unloadfilter);
        try {
            if (bl) {
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    this.destMessages.remove((Object)packetReference.getSysMessageID(), RemoveReason.UNLOADED);
                    packetReference.clear();
                    iterator.remove();
                }
                this.destMessages = new SimpleNFLHashMap();
                this.loaded = false;
                this.initialize();
            } else {
                Iterator iterator = this.destMessages.values().iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    packetReference.unload();
                }
            }
        }
        catch (Throwable throwable) {
            logger.logStack(16, "Internal Error processing destination " + this, throwable);
            this.destMessages = null;
            this.destMessages = new SimpleNFLHashMap();
            this.loaded = false;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(String string) throws IOException, BrokerException {
        Object object = destinationList;
        synchronized (object) {
            this.destvalid = false;
        }
        object = this;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if (this.expireReaper != null) {
                this.expireReaper.destroy();
                this.expireReaper = null;
            }
            this.purgeDestination();
            if (!this.neverStore || this.stored) {
                Globals.getStore().removeDestination(this, PERSIST_SYNC);
                this.stored = false;
            }
        }
    }

    public String toString() {
        return this.uid.getLocalizedName();
    }

    public String getUniqueName() {
        return this.uid.toString();
    }

    public static String getUniqueName(boolean bl, String string) {
        return DestinationUID.getUniqueString(string, bl);
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _messageAdded(long l, Reason reason) {
        if (reason == AddReason.LOADED) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            ++this.size;
            this.bytes += l;
        }
        if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
            serializable = this.getClass();
            synchronized (serializable) {
                totalbytes += l;
                ++totalcnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packetlistAdd(SysMessageID sysMessageID, DestinationUID destinationUID) {
        Class<?> clazz = packetlist.getClass();
        synchronized (clazz) {
            Set<DestinationUID> set = (Set<DestinationUID>)packetlist.get(sysMessageID);
            if (set == null) {
                set = Collections.synchronizedSet(new LinkedHashSet());
                packetlist.put(sysMessageID, set);
            }
            set.add(destinationUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DestinationUID getPacketListFirst(SysMessageID sysMessageID) {
        Set set = null;
        Object object = packetlist.getClass();
        synchronized (object) {
            set = (Set)packetlist.get(sysMessageID);
            if (set == null) {
                return null;
            }
        }
        object = set;
        synchronized (object) {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                return (DestinationUID)iterator.next();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object removePacketList(SysMessageID sysMessageID, DestinationUID destinationUID) {
        Class<?> clazz = packetlist.getClass();
        synchronized (clazz) {
            Set set = (Set)packetlist.get(sysMessageID);
            if (set == null) {
                return null;
            }
            if (set.contains(destinationUID)) {
                set.remove(destinationUID);
                if (set.isEmpty()) {
                    packetlist.remove(sysMessageID);
                }
                return destinationUID;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _messageRemoved(PacketReference packetReference, long l, Reason reason) {
        if (packetReference == null) {
            return;
        }
        if (Destination.removePacketList(packetReference.getSysMessageID(), this.getDestinationUID()) == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (reason == RemoveReason.REMOVED_LOW_PRIORITY || reason == RemoveReason.REMOVED_OLDEST || reason == RemoveReason.REMOVED_OTHER) {
                ++this.discardedCnt;
            } else if (reason == RemoveReason.EXPIRED) {
                ++this.expiredCnt;
            } else if (reason == RemoveReason.PURGED) {
                ++this.purgedCnt;
            } else if (reason == RemoveReason.ROLLBACK) {
                ++this.rollbackCnt;
            } else if (reason == RemoveReason.ACKNOWLEDGED) {
                ++this.ackedCnt;
            } else if (reason == RemoveReason.OVERFLOW) {
                ++this.overflowCnt;
            } else if (reason == RemoveReason.ERROR) {
                ++this.errorCnt;
            }
            this.bytes -= l;
            --this.size;
        }
        if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
            object = this.getClass();
            synchronized (object) {
                totalbytes -= l;
                --totalcnt;
            }
        }
        packetReference.remove();
        if (this.state != 2 && this.state != 3) {
            object = null;
            Set set = this.pausedProducerSet;
            synchronized (set) {
                if (!this.pausedProducerSet.isEmpty() && !this.destMessages.isFull()) {
                    int n = this.destMessages.freeSpace();
                    long l2 = this.destMessages.freeBytes();
                    if (!(n != -1 && n < (this.activeProducerCount + 1) * this.producerMsgBatchSize || l2 != -1L && l2 < (long)(this.activeProducerCount + 1) * this.producerMsgBatchBytes)) {
                        object = (Producer)this.pausedProducerSet.iterator().next();
                    }
                }
            }
            if (object != null) {
                this.flowControlSpecificProducer((Producer)object, false, true);
            }
        }
    }

    public boolean shouldDestroy() {
        return this.isAutoCreated() && this.producers.size() == 0 && this.consumers.size() == 0 && this.destMessages.isEmpty();
    }

    public void overridePersistence(boolean bl) {
        this.neverStore = !bl;
        this.overrideP = true;
        this.overridePvalue = bl;
    }

    public void clearOverridePersistence() {
        this.overrideP = false;
    }

    public void overrideTTL(long l) {
        this.overrideTTL = true;
        this.overrideTTLvalue = l;
    }

    public void clearOverrideTTL() {
        this.overrideTTL = false;
    }

    public boolean shouldOverridePersistence() {
        return this.overrideP;
    }

    public boolean getOverridePersistence() {
        return this.overridePvalue;
    }

    public boolean shouldOverrideTTL() {
        return this.overrideTTL;
    }

    public long getOverrideTTL() {
        return this.overrideTTLvalue;
    }

    public boolean isInternal() {
        boolean bl = DestType.isInternal(this.type);
        return bl;
    }

    public boolean isDMQ() {
        boolean bl = DestType.isDMQ(this.type);
        return bl;
    }

    public boolean isAdmin() {
        boolean bl = DestType.isAdmin(this.type);
        return bl;
    }

    public int getConsumerCount() {
        return this.consumers.size();
    }

    public Iterator getConsumers() {
        ArrayList arrayList = new ArrayList(this.consumers.values());
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getProducers() {
        ArrayList arrayList = null;
        SimpleNFLHashMap simpleNFLHashMap = this.producers;
        synchronized (simpleNFLHashMap) {
            arrayList = new ArrayList(this.producers.values());
        }
        return arrayList.iterator();
    }

    public int getProducerCount() {
        return this.producers.size();
    }

    public int getMaxPrefetch() {
        return this.maxPrefetch;
    }

    public void setMaxPrefetch(int n) {
        this.maxPrefetch = n;
    }

    public void setMaxSharedConsumers(int n) {
    }

    public void setSharedFlowLimit(int n) {
    }

    public int getMaxNumSharedConsumers() {
        return -1;
    }

    public int getSharedConsumerFlowLimit() {
        return 5;
    }

    public long getMsgBytesProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1L;
        }
        long l = 0L;
        l = this.msgSizeLimit == null || this.msgSizeLimit.getBytes() <= 0L ? -1L : this.msgSizeLimit.getBytes();
        return l;
    }

    public long getBytesProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1L;
        }
        return this.producerMsgBatchBytes;
    }

    public int getSizeProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1;
        }
        return this.producerMsgBatchSize;
    }

    private void stopFlow(String string) {
        this.flowControlAllProducers(true, "stopFlow " + string);
    }

    private void resumeFlow(String string) {
        this.flowControlAllProducers(false, "resumeFlow:" + string);
    }

    public void resumeFlow(Producer producer) {
        this.flowControlSpecificProducer(producer, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flowControlSpecificProducer(Producer producer, boolean bl, boolean bl2) {
        Object object;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        if (!bl) {
            n = this.producerMsgBatchSize;
            l = this.producerMsgBatchBytes;
            l2 = this.getMsgBytesProducerFlow();
            producer.resume();
            if (this.pausedProducerSet.contains(producer)) {
                ++this.activeProducerCount;
                this.pausedProducerSet.remove(producer);
            }
        }
        ConnectionUID connectionUID = null;
        Object object2 = producer;
        synchronized (object2) {
            if (bl && !producer.isPaused()) {
                object = this.pausedProducerSet;
                synchronized (object) {
                    if (!this.pausedProducerSet.contains(producer)) {
                        --this.activeProducerCount;
                        this.pausedProducerSet.add(producer);
                        producer.pause();
                    }
                }
            }
            if (!bl && producer.isPaused()) {
                object = this.pausedProducerSet;
                synchronized (object) {
                    if (this.pausedProducerSet.remove(producer)) {
                        ++this.activeProducerCount;
                        producer.resume();
                    }
                }
            }
            producer.setIsPaused(bl);
            if (!bl2) {
                return;
            }
            connectionUID = producer.getConnectionUID();
        }
        object2 = (IMQConnection)Globals.getConnectionManager().getConnection(connectionUID);
        object = new Hashtable();
        ((Hashtable)object).put("JMQSize", new Integer(n));
        ((Hashtable)object).put("JMQBytes", new Long(l));
        ((Hashtable)object).put("JMQMaxMsgBytes", new Long(l2));
        if (object2 == null) {
            object2 = (IMQConnection)Globals.getConnectionManager().getConnection(producer.getConnectionUID());
        }
        if (object2 != null) {
            Packet packet = new Packet(((IMQConnection)object2).useDirectBuffers());
            packet.setPacketType(52);
            ((Hashtable)object).put("JMQProducerID", new Long(producer.getProducerUID().longValue()));
            ((Hashtable)object).put("JMQDestinationID", this.getDestinationUID().toString());
            ((Hashtable)object).put("Reason", "Resuming specific Producer ");
            packet.setProperties((Hashtable)object);
            ((IMQConnection)object2).sendControlMessage(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flowControlAllProducers(boolean bl, String string) {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        if (!bl) {
            n = this.producerMsgBatchSize;
            l = this.producerMsgBatchBytes;
            l2 = this.getMsgBytesProducerFlow();
        }
        HashSet hashSet = null;
        Object object = this.producers;
        synchronized (object) {
            hashSet = new HashSet(this.producers.values());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Object object2;
            Producer producer = (Producer)object.next();
            ConnectionUID connectionUID = null;
            ProducerUID producerUID = null;
            Object object3 = producer;
            synchronized (object3) {
                producer.setIsPaused(bl);
                if (bl) {
                    object2 = this.pausedProducerSet;
                    synchronized (object2) {
                        if (!this.pausedProducerSet.contains(producer)) {
                            --this.activeProducerCount;
                            producer.pause();
                            this.pausedProducerSet.add(producer);
                        }
                    }
                }
                object2 = this.pausedProducerSet;
                synchronized (object2) {
                    if (this.pausedProducerSet.remove(producer)) {
                        producer.resume();
                        ++this.activeProducerCount;
                    }
                }
                producerUID = producer.getProducerUID();
                connectionUID = producer.getConnectionUID();
            }
            object3 = (IMQConnection)Globals.getConnectionManager().getConnection(connectionUID);
            if (object3 == null) continue;
            object2 = new Packet(((IMQConnection)object3).useDirectBuffers());
            ((Packet)object2).setPacketType(52);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("JMQSize", new Integer(n));
            hashtable.put("JMQBytes", new Long(l));
            hashtable.put("JMQMaxMsgBytes", new Long(l2));
            hashtable.put("JMQDestinationID", this.getDestinationUID().toString());
            hashtable.put("Reson", string + ":all Producers");
            hashtable.put("JMQProducerID", new Long(producerUID.longValue()));
            ((Packet)object2).setProperties(hashtable);
            ((IMQConnection)object3).sendControlMessage((Packet)object2);
        }
    }

    public boolean producerFlow(IMQConnection iMQConnection, Producer producer) {
        if (!$assertionsDisabled && this.pausedProducerSet.contains(producer)) {
            throw new AssertionError();
        }
        if (this.state == 2 || this.state == 3) {
            this.flowControlSpecificProducer(producer, true, false);
            return false;
        }
        int n = this.destMessages.freeSpace();
        long l = this.destMessages.freeBytes();
        if (this.limit != 0 || this.pausedProducerSet.isEmpty() && !this.destMessages.isFull() && (n == -1 || n >= this.activeProducerCount * this.producerMsgBatchSize) && (l == -1L || l >= (long)(this.activeProducerCount * this.producerMsgBatchSize))) {
            this.flowControlSpecificProducer(producer, false, true);
            return true;
        }
        this.flowControlSpecificProducer(producer, true, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDestination(Destination destination) {
        Map map = destinationList;
        synchronized (map) {
            if (destinationList.get(destination.getDestinationUID()) != null) {
                throw new RuntimeException("Destination " + destination + " is also being" + " created by another broker");
            }
            destinationList.put(destination.getDestinationUID(), destination);
        }
    }

    public static int destinationsSize() {
        return destinationList.size();
    }

    public static Map processTransactions(Map map, Map map2) throws BrokerException {
        Destination.loadDestinations();
        Subscription.initSubscriptions();
        HashMap hashMap = new HashMap();
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Map map3;
            Destination destination = (Destination)iterator.next();
            boolean bl = destination.loaded;
            if (bl) {
                destination.unload(true);
            }
            if ((map3 = destination.load(false, map, map2)) != null) {
                hashMap.putAll(map3);
            }
            destination.unload(false);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDestinations() throws BrokerException {
        Serializable serializable;
        Object object;
        if (destsLoaded) {
            return;
        }
        destsLoaded = true;
        if (defaultIsLocal && !CAN_USE_LOCAL_DEST) {
            Globals.getLogger().log(32, "B3123", Globals.getBrokerResources().getString("B0049"));
            Broker.exit(1);
        }
        if (Destination.canAutoCreate(true)) {
            logger.log(8, "B1013");
        }
        if (!Destination.canAutoCreate(false)) {
            logger.log(8, "B1014");
        }
        logger.log(4, "Loading All Stored Destinations ");
        Destination[] destinationArray = Globals.getStore().getLoadDestinationException();
        if (destinationArray != null) {
            object = destinationArray;
            while (object != null) {
                String string = (String)object.getKey();
                serializable = (Destination)object.getValue();
                if (string == null && serializable == null) {
                    logger.log(16, "B3044", "both key and value are corrupted");
                    continue;
                }
                if (string == null) {
                    try {
                        Globals.getStore().storeDestination((Destination)serializable, PERSIST_SYNC);
                    }
                    catch (Exception exception) {
                        logger.log(16, "B2091", (Object)serializable.toString(), (Throwable)exception);
                        try {
                            Globals.getStore().removeDestination((Destination)serializable, true);
                        }
                        catch (Exception exception2) {
                            logger.logStack(4, "Unable to remove dest", exception2);
                        }
                    }
                } else {
                    DestinationUID destinationUID = new DestinationUID(string);
                    String string2 = destinationUID.getName();
                    boolean bl = destinationUID.isQueue();
                    int n = bl ? 1 : 2;
                    try {
                        serializable = Destination.createDestination(string2, n);
                        serializable.store();
                        logger.log(16, "B2092", destinationUID.getLocalizedName());
                    }
                    catch (Exception exception) {
                        logger.log(16, "B2093", (Object)destinationUID, (Throwable)exception);
                        try {
                            serializable = destinationUID.isQueue() ? new Queue(destinationUID) : new Topic(destinationUID);
                            Globals.getStore().removeDestination((Destination)serializable, true);
                        }
                        catch (Exception exception3) {
                            logger.logStack(4, "Unable to remove dest", exception3);
                        }
                    }
                }
                object = object.getNextException();
            }
        }
        try {
            object = Globals.getStore().getAllDestinations();
            if (DEBUG) {
                logger.log(4, "Loaded {0} stored destinations", String.valueOf(((Destination[])object).length));
            }
            for (int i = 0; i < ((Destination[])object).length; ++i) {
                if (object[i] == null) continue;
                if (DEBUG) {
                    logger.log(8, "Destination: Loading destination {0}", object[i].toString());
                }
                if (!(object[i].isAdmin() || !object[i].getIsDMQ() && object[i].isInternal())) {
                    object[i].initialize();
                    serializable = class$com$sun$messaging$jmq$jmsserver$core$Destination == null ? Destination.class$("com.sun.messaging.jmq.jmsserver.core.Destination") : class$com$sun$messaging$jmq$jmsserver$core$Destination;
                    synchronized (serializable) {
                        totalcnt += object[i].size;
                        totalbytes += object[i].bytes;
                    }
                }
                if (object[i].isAutoCreated() && object[i].size == 0 && object[i].bytes == 0L) {
                    destinationList.remove(object[i].getDestinationUID());
                    object[i].destroy(Globals.getBrokerResources().getString("B0069"));
                    continue;
                }
                destinationList.put(object[i].getDestinationUID(), object[i]);
            }
            DeadMessageQueue = Destination.createDMQ();
        }
        catch (BrokerException brokerException) {
            logger.logStack(32, "B3100", "unable to load destinations", (Throwable)brokerException);
            throw brokerException;
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3100", "unable to load destinations", (Throwable)iOException);
            throw new BrokerException("B4031", iOException);
        }
    }

    public boolean isValid() {
        return valid && this.destvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefCount() throws BrokerException {
        Map map = destinationList;
        synchronized (map) {
            if (!valid) {
                throw new IllegalStateException("Broker Shutting down");
            }
            if (!this.isValid()) {
                throw new BrokerException("Destination already destroyed");
            }
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrementRefCount() {
        Map map = destinationList;
        synchronized (map) {
            --this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount() {
        Map map = destinationList;
        synchronized (map) {
            return this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination getDestination(DestinationUID destinationUID) {
        Destination destination = null;
        Map map = destinationList;
        synchronized (map) {
            destination = (Destination)destinationList.get(destinationUID);
        }
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    public static Destination getDestination(String string, boolean bl) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.getDestination(destinationUID);
    }

    public static Destination getDestination(String string, int n, boolean bl, boolean bl2) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, DestType.isQueue(n));
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (bl && destination == null) {
            try {
                destination = Destination.createDestination(string, n, bl2, true, null);
            }
            catch (ConflictException conflictException) {
                destination = (Destination)destinationList.get(destinationUID);
            }
        }
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    public static Destination createDestination(String string, int n) throws BrokerException, IOException {
        Destination destination = Destination.createDestination(string, n, true, false, null, false, false);
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    public static Destination createTempDestination(String string, int n, ConnectionUID connectionUID, boolean bl, long l) throws BrokerException, IOException {
        Destination destination = null;
        try {
            destination = Destination.createDestination(string, n, false, false, connectionUID);
            destination.setReconnectInterval(l);
            destination.overridePersistence(bl);
            destination.store();
        }
        catch (ConflictException conflictException) {
            destination = Destination.getDestination(string, n, false, false);
        }
        return destination;
    }

    public static void shutdown() {
        valid = false;
    }

    public static boolean isShutdown() {
        return valid;
    }

    public static Destination createDestination(String string, int n, boolean bl, boolean bl2, Object object) throws BrokerException, IOException {
        ConnectionUID connectionUID = null;
        boolean bl3 = false;
        if (object instanceof ConnectionUID) {
            connectionUID = (ConnectionUID)object;
        }
        if (object instanceof BrokerAddress) {
            bl3 = ((BrokerAddress)object).equals(Globals.getMyAddress());
        }
        return Destination.createDestination(string, n, bl, bl2, connectionUID, !bl3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Destination createDestination(String string, int n, boolean bl, boolean bl2, ConnectionUID connectionUID, boolean bl3, boolean bl4) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, DestType.isQueue(n));
        if (!valid) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", null, 500);
        }
        if (destinationList.get(destinationUID) != null) {
            throw new ConflictException(Globals.getBrokerResources().getKString("B4063", destinationUID));
        }
        Object var8_8 = null;
        ClusterBroadcast clusterBroadcast = Globals.getClusterBroadcast();
        boolean bl5 = false;
        Destination destination = null;
        try {
            destination = DestType.isQueue(n) ? new Queue(string, n, bl, connectionUID, bl2) : new Topic(string, n, bl, connectionUID, bl2);
            try {
                Map map = destinationList;
                synchronized (map) {
                    Destination destination2 = (Destination)destinationList.get(destinationUID);
                    if (destination2 != null) {
                        throw new BrokerException("Destination already exists");
                    }
                    if (!bl2) {
                        destination.setIsLocal(bl4);
                    }
                    if (bl) {
                        destination.store();
                    }
                    destinationList.put(destinationUID, destination);
                }
            }
            catch (BrokerException brokerException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4063", destination.getName()), "B4063", brokerException, 409);
            }
            boolean bl6 = bl5 = !destination.isAutoCreated() && destination.sendClusterUpdate() && bl3;
            if (clusterBroadcast != null && bl5 && !clusterBroadcast.lockDestination(destinationUID, connectionUID)) {
                throw new ConflictException("Internal Exception: Destination " + destinationUID + " is in the process" + " of being created");
            }
            if (bl5 && clusterBroadcast != null) {
                clusterBroadcast.createDestination(destination);
            }
            Object var16_16 = null;
            if (clusterBroadcast != null && bl5) {
                clusterBroadcast.unlockDestination(destinationUID, connectionUID);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (clusterBroadcast != null && bl5) {
                clusterBroadcast.unlockDestination(destinationUID, connectionUID);
            }
            throw throwable;
        }
        return destination;
    }

    public static Destination removeDestination(String string, boolean bl, String string2) throws IOException, BrokerException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.removeDestination(destinationUID, true, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination removeDestination(DestinationUID destinationUID, boolean bl, String string) throws IOException, BrokerException {
        Destination destination = Destination.getDestination(destinationUID);
        if (destination != null && destination.isDMQ) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4193"));
        }
        if (bl && destination != null && !destination.getIsDMQ() && destination.sendClusterUpdate()) {
            Globals.getClusterBroadcast().recordRemoveDestination(destination);
        }
        if (destination != null) {
            int n = DestType.isAdmin(destination.getType()) ? 4 : 8;
            logger.log(n, "B1159", destination.getName());
        }
        destination = (Destination)destinationList.remove(destinationUID);
        DestinationUID.clearUID(destinationUID);
        if (destination != null) {
            if (destination.producers.size() > 0) {
                Object[] objectArray = new String[]{destination.getName(), String.valueOf(destination.producers.size()), string};
                logger.log(16, "B2081", objectArray);
            }
            if (destination.consumers.size() > 0) {
                Object[] objectArray;
                int n = destination.consumers.size();
                boolean bl2 = false;
                HashSet hashSet = new HashSet(destination.consumers.values());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    objectArray = (Object[])iterator.next();
                    if (!(objectArray instanceof Subscription) || !((Subscription)objectArray).isDurable()) continue;
                    bl2 = true;
                    Subscription subscription = (Subscription)objectArray;
                    if (subscription.isActive()) {
                        n += subscription.getActiveSubscriberCnt();
                    }
                    Subscription.unsubscribeOnDestroy(subscription.getDurableName(), subscription.getClientID(), bl);
                    --n;
                }
                if (bl2) {
                    logger.log(8, "B1131", (Object)destination.toString(), string);
                }
                if (n > 0) {
                    objectArray = new String[]{destination.getName(), String.valueOf(n), string};
                    logger.log(16, "B2082", objectArray);
                }
            }
            destination.destroy(string);
            if (bl && destination.sendClusterUpdate()) {
                Globals.getClusterBroadcast().destroyDestination(destination);
            }
        }
        return destination;
    }

    public static boolean removeDestination(Destination destination, String string) throws IOException, BrokerException {
        return Destination.removeDestination(destination.getDestinationUID(), true, string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getDestinations(Object object, int n) {
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        Map map = destinationList;
        synchronized (map) {
            Collection collection = destinationList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Destination destination = (Destination)iterator.next();
                if ((destination.getType() & n) != n || object != null && !object.equals(destination.getConnectionUID())) continue;
                arrayList.add(destination);
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLocalTemporaryDestinations() {
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        Map map = destinationList;
        synchronized (map) {
            Set set = destinationList.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Destination destination = (Destination)iterator.next();
                if (!destination.isTemporary() || !destination.getIsLocal()) continue;
                arrayList.add(destination);
            }
        }
        if (DEBUG) {
            logger.log(1, "Matching destinations are: ");
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                logger.log(1, "\t {0}", arrayList.get(i).toString());
            }
            logger.log(1, "----------------------");
        }
        return arrayList;
    }

    public void updateDestination() throws BrokerException, IOException {
        this.update(true);
    }

    public static Iterator getAllDestinations() {
        return Destination.getAllDestinations(ALL_DESTINATIONS_MASK);
    }

    public static Iterator getAllDestinations(int n) {
        return Destination.getDestinations(null, n);
    }

    public static Iterator getTempDestinations(BrokerAddress brokerAddress) {
        return Destination.getDestinations(brokerAddress, TEMP_DESTINATIONS_MASK);
    }

    public static Iterator getStoredDestinations() {
        return Destination.getDestinations(null, ALL_DESTINATIONS_MASK & 0xFFFFFFEF);
    }

    public void debug() {
        logger.log(8, "Dumping state for destination " + this);
        logger.log(8, "Consumer Count " + this.consumers.size());
        logger.log(8, "Producer Count " + this.producers.size());
        logger.log(8, "Message count " + this.destMessages.size());
        logger.log(8, " --------- consumers");
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            consumer.debug("\t");
        }
    }

    public static void init() throws BrokerException {
        if (!$assertionsDisabled && inited) {
            throw new AssertionError();
        }
        inited = true;
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener(SYSTEM_MAX_SIZE, cl);
        brokerConfig.addListener(SYSTEM_MAX_COUNT, cl);
        brokerConfig.addListener(MAX_MESSAGE_SIZE, cl);
        brokerConfig.addListener(AUTO_QUEUE_STR, cl);
        brokerConfig.addListener(AUTO_TOPIC_STR, cl);
        brokerConfig.addListener(DST_REAP_STR, cl);
        brokerConfig.addListener(MSG_REAP_STR, cl);
        brokerConfig.addListener(AUTO_MAX_NUM_MSGS, cl);
        brokerConfig.addListener(AUTO_MAX_TOTAL_BYTES, cl);
        brokerConfig.addListener(AUTO_MAX_BYTES_MSG, cl);
        brokerConfig.addListener(AUTO_MAX_NUM_PRODUCERS, cl);
        brokerConfig.addListener(AUTO_LOCAL_ONLY, cl);
        brokerConfig.addListener(AUTO_LIMIT_BEHAVIOR, cl);
        brokerConfig.addListener(USE_DMQ_STR, cl);
        brokerConfig.addListener(TRUNCATE_BODY_STR, cl);
        brokerConfig.addListener(LOG_MSGS_STR, cl);
        Destination.setMaxSize(brokerConfig.getSizeProperty(SYSTEM_MAX_SIZE));
        Destination.setMaxMessages(brokerConfig.getIntProperty(SYSTEM_MAX_COUNT));
        Destination.setIndividualMessageMax(brokerConfig.getSizeProperty(MAX_MESSAGE_SIZE));
        Destination.loadDestinations();
    }

    public static void setIndividualMessageMax(SizeString sizeString) {
        if (sizeString == null) {
            sizeString = new SizeString();
        }
        individual_max_size = sizeString;
        long l = sizeString.getBytes();
        Packet.setMaxPacketSize(l);
        Globals.getMemManager().updateMaxMessageSize(l);
    }

    public static void setMaxMessages(long l) {
        message_max_count = l;
    }

    public static void setMaxSize(SizeString sizeString) {
        if (sizeString == null) {
            sizeString = new SizeString();
        }
        max_size = sizeString;
    }

    public static PacketReference get(SysMessageID sysMessageID) {
        DestinationUID destinationUID = Destination.getPacketListFirst(sysMessageID);
        if (destinationUID == null) {
            return null;
        }
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (destination == null) {
            return null;
        }
        return (PacketReference)destination.destMessages.get(sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addNewMessage(boolean bl, PacketReference packetReference) throws BrokerException {
        if (bl) {
            long l = individual_max_size.getBytes();
            if (l > 0L && packetReference.byteSize() > l) {
                String string = l <= 0L ? Globals.getBrokerResources().getString("B0012") : individual_max_size.toString();
                Object[] objectArray = new String[]{String.valueOf(packetReference.byteSize()), packetReference.getSysMessageID().toString(), string};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4026", objectArray), "B4026", null, 423);
            }
            long l2 = 0L;
            int n = 0;
            Object object = Destination.class;
            synchronized (object) {
                n = totalcnt + 1;
                l2 = totalbytes + packetReference.byteSize();
            }
            if (message_max_count > 0L && (long)n > message_max_count) {
                object = message_max_count <= 0L ? Globals.getBrokerResources().getString("B0012") : String.valueOf(message_max_count);
                throw new BrokerException(Globals.getBrokerResources().getKString("B4024", object, packetReference.getSysMessageID()), "B4024", null, 414);
            }
            if (max_size.getBytes() > 0L && l2 > max_size.getBytes()) {
                object = max_size.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : max_size.toString();
                throw new BrokerException(Globals.getBrokerResources().getKString("B4025", object, packetReference.getSysMessageID()), "B4025", null, 414);
            }
        }
        Destination.packetlistAdd(packetReference.getSysMessageID(), packetReference.getDestinationUID());
        return !packetReference.isExpired();
    }

    public static synchronized int totalCount() {
        if (!$assertionsDisabled && totalcnt < 0) {
            throw new AssertionError();
        }
        return totalcnt;
    }

    public static synchronized long totalBytes() {
        if (!$assertionsDisabled && totalbytes < 0L) {
            throw new AssertionError();
        }
        return totalbytes;
    }

    private static boolean removeExpiredMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (destinationUID == null) {
            throw new RuntimeException("expired messages");
        }
        if (destinationUID == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return true;
        }
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (destination != null && destination.removeMessage(sysMessageID, RemoveReason.EXPIRED)) {
            Destination.removePacketList(sysMessageID, destination.getDestinationUID());
            return true;
        }
        return false;
    }

    public static boolean canAutoCreate(boolean bl) {
        return bl ? ALLOW_QUEUE_AUTOCREATE : ALLOW_TOPIC_AUTOCREATE;
    }

    static {
        $assertionsDisabled = !Destination.class.desiredAssertionStatus();
        LOAD_COUNT = Globals.getConfig().getIntProperty("imq.destination.verbose.cnt", 10000);
        PERSIST_SYNC = Globals.getConfig().getBooleanProperty("imq.persist.file.sync.enabled", false);
        DEBUG = false;
        NO_PRODUCER_FLOW = Globals.getConfig().getBooleanProperty("imq.noProducerFlow", false);
        if (DEBUG) {
            Globals.getLogger().log(8, "Syncing message store:  " + PERSIST_SYNC);
        }
        if (NO_PRODUCER_FLOW) {
            Globals.getLogger().log(8, "Producer flow control is turned off ");
        }
        DEFAULT_MAX_PRODUCER_BATCH = 1000;
        DEFAULT_DESTINATION_SIZE = 100000;
        DEFAULT_MAX_PRODUCERS = 100;
        DEFAULT_PREFETCH = 1000;
        ALL_DESTINATIONS_MASK = 0;
        TEMP_DESTINATIONS_MASK = 16;
        ALLOW_QUEUE_AUTOCREATE = Globals.getConfig().getBooleanProperty(AUTO_QUEUE_STR, true);
        ALLOW_TOPIC_AUTOCREATE = Globals.getConfig().getBooleanProperty(AUTO_TOPIC_STR, true);
        AUTOCREATE_EXPIRE = Globals.getConfig().getLongProperty(DST_REAP_STR, 120L) * 1000L;
        MESSAGE_EXPIRE = Globals.getConfig().getLongProperty(MSG_REAP_STR, 120L) * 1000L;
        MAX_PRODUCER_BATCH = Globals.getConfig().getIntProperty("imq.producer.maxBatch", DEFAULT_MAX_PRODUCER_BATCH);
        MAX_PRODUCER_BYTES_BATCH = -1;
        logger = Globals.getLogger();
        CAN_MONITOR_DEST = false;
        CAN_USE_LOCAL_DEST = false;
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            CAN_MONITOR_DEST = licenseBase.getBooleanProperty("imq.enable_monitoring", false);
            CAN_USE_LOCAL_DEST = licenseBase.getBooleanProperty("imq.enable_localdest", false);
        }
        catch (BrokerException brokerException) {
            CAN_MONITOR_DEST = false;
            CAN_USE_LOCAL_DEST = false;
        }
        timer = Globals.getTimer();
        defaultMaxMsgCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_MSGS, DEFAULT_DESTINATION_SIZE);
        defaultProducerCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_PRODUCERS, DEFAULT_MAX_PRODUCERS);
        defaultMaxMsgBytes = Globals.getConfig().getSizeProperty(AUTO_MAX_TOTAL_BYTES, 0xA00000L);
        defaultMaxBytesPerMsg = Globals.getConfig().getSizeProperty(AUTO_MAX_BYTES_MSG, 10240L);
        defaultIsLocal = Globals.getConfig().getBooleanProperty(AUTO_LOCAL_ONLY, false);
        defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(AUTO_LIMIT_BEHAVIOR, "REJECT_NEWEST"));
        reconnectMultiplier = Globals.getConfig().getIntProperty("imq.reconnect.interval", 5);
        USE_DMQ_STR = "imq.autocreate.destination.useDMQ";
        TRUNCATE_BODY_STR = "imq.destination.DMQ.truncateBody";
        LOG_MSGS_STR = "imq.destination.logDeadMsgs";
        defaultUseDMQ = Globals.getConfig().getBooleanProperty(USE_DMQ_STR, true);
        defaultTruncateBody = Globals.getConfig().getBooleanProperty(TRUNCATE_BODY_STR, false);
        defaultVerbose = Globals.getConfig().getBooleanProperty(LOG_MSGS_STR, false);
        DeadMessageQueue = null;
        autocreateUseDMQ = defaultUseDMQ;
        storeBodyWithDMQ = !defaultTruncateBody;
        verbose = defaultVerbose;
        TEMP_CNT = "JMQ_SUN_JMSQ_TempRedeliverCnt";
        destinationList = Collections.synchronizedMap(new HashMap());
        destsLoaded = false;
        valid = true;
        individual_max_size = null;
        max_size = null;
        message_max_count = 0L;
        totalbytes = 0L;
        totalcnt = 0;
        packetlist = Collections.synchronizedMap(new HashMap());
        cl = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
            }

            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                if (string.equals(Destination.SYSTEM_MAX_SIZE)) {
                    Destination.setMaxSize(brokerConfig.getSizeProperty(Destination.SYSTEM_MAX_SIZE));
                } else if (string.equals(Destination.SYSTEM_MAX_COUNT)) {
                    Destination.setMaxMessages(brokerConfig.getIntProperty(Destination.SYSTEM_MAX_COUNT));
                } else if (string.equals(Destination.MAX_MESSAGE_SIZE)) {
                    Destination.setIndividualMessageMax(brokerConfig.getSizeProperty(Destination.MAX_MESSAGE_SIZE));
                } else if (string.equals(Destination.AUTO_QUEUE_STR)) {
                    ALLOW_QUEUE_AUTOCREATE = brokerConfig.getBooleanProperty(Destination.AUTO_QUEUE_STR);
                } else if (string.equals(Destination.AUTO_TOPIC_STR)) {
                    ALLOW_TOPIC_AUTOCREATE = brokerConfig.getBooleanProperty(Destination.AUTO_TOPIC_STR);
                } else if (string.equals(Destination.DST_REAP_STR)) {
                    AUTOCREATE_EXPIRE = brokerConfig.getIntProperty(Destination.DST_REAP_STR) * 1000;
                } else if (string.equals(Destination.MSG_REAP_STR)) {
                    MESSAGE_EXPIRE = brokerConfig.getIntProperty(Destination.MSG_REAP_STR) * 1000;
                } else if (string.equals(Destination.AUTO_MAX_NUM_MSGS)) {
                    defaultMaxMsgCnt = brokerConfig.getIntProperty(Destination.AUTO_MAX_NUM_MSGS);
                } else if (string.equals(Destination.AUTO_MAX_TOTAL_BYTES)) {
                    defaultMaxMsgBytes = brokerConfig.getSizeProperty(Destination.AUTO_MAX_TOTAL_BYTES);
                } else if (string.equals(Destination.AUTO_MAX_BYTES_MSG)) {
                    defaultMaxBytesPerMsg = brokerConfig.getSizeProperty(Destination.AUTO_MAX_BYTES_MSG);
                } else if (string.equals(Destination.AUTO_MAX_NUM_PRODUCERS)) {
                    defaultProducerCnt = brokerConfig.getIntProperty(Destination.AUTO_MAX_NUM_PRODUCERS);
                } else if (string.equals(Destination.AUTO_LOCAL_ONLY)) {
                    defaultIsLocal = brokerConfig.getBooleanProperty(Destination.AUTO_LOCAL_ONLY);
                } else if (string.equals(Destination.AUTO_LIMIT_BEHAVIOR)) {
                    defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(Destination.AUTO_LIMIT_BEHAVIOR));
                } else if (string.equals(USE_DMQ_STR)) {
                    autocreateUseDMQ = brokerConfig.getBooleanProperty(USE_DMQ_STR);
                } else if (string.equals(TRUNCATE_BODY_STR)) {
                    storeBodyWithDMQ = !brokerConfig.getBooleanProperty(TRUNCATE_BODY_STR);
                } else if (string.equals(LOG_MSGS_STR)) {
                    verbose = brokerConfig.getBooleanProperty(LOG_MSGS_STR);
                }
                return true;
            }
        };
        inited = false;
    }

    class UnloadFilter
    implements Filter {
        static final /* synthetic */ boolean $assertionsDisabled;

        UnloadFilter() {
        }

        public boolean matches(Object object) {
            if (!$assertionsDisabled && !(object instanceof PacketReference)) {
                throw new AssertionError();
            }
            return ((PacketReference)object).isPersistent();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Destination == null ? (class$com$sun$messaging$jmq$jmsserver$core$Destination = Destination.class$("com.sun.messaging.jmq.jmsserver.core.Destination")) : class$com$sun$messaging$jmq$jmsserver$core$Destination).desiredAssertionStatus();
        }
    }

    class DestFilter
    implements Filter {
        DestFilter() {
        }

        public boolean matches(Object object) {
            return Destination.this.uid.equals(((PacketReference)object).getDestinationUID());
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    class MsgExpirationReaper {
        SortedSet messages = new TreeSet(ExpirationInfo.getComparator());
        JMQTimerTask mytimer = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public synchronized void addExpiringMessage(ExpirationInfo expirationInfo) {
            this.messages.add(expirationInfo);
            if (this.mytimer == null || this.messages.size() == 1) {
                this.addTimer();
            }
        }

        public synchronized void removeMessage(ExpirationInfo expirationInfo) {
            boolean bl = this.messages.remove(expirationInfo);
            if (bl && this.messages.isEmpty()) {
                this.removeTimer();
            }
        }

        public synchronized void destroy() {
            if (this.mytimer != null) {
                this.removeTimer();
            }
            this.messages.clear();
        }

        void addTimer() {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mytimer != null) {
                throw new AssertionError();
            }
            this.mytimer = new MyExpireTimerTask();
            try {
                timer.schedule(this.mytimer, MESSAGE_EXPIRE, MESSAGE_EXPIRE);
            }
            catch (IllegalStateException illegalStateException) {
                logger.log(8, "B3100", (Object)("Canceling message expiration on " + this), (Throwable)illegalStateException);
            }
        }

        void removeTimer() {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            try {
                if (this.mytimer != null) {
                    this.mytimer.cancel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                logger.logStack(4, "timer canceled ", illegalStateException);
            }
            this.mytimer = null;
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Destination == null ? (class$com$sun$messaging$jmq$jmsserver$core$Destination = Destination.class$("com.sun.messaging.jmq.jmsserver.core.Destination")) : class$com$sun$messaging$jmq$jmsserver$core$Destination).desiredAssertionStatus();
        }

        class MyExpireTimerTask
        extends JMQTimerTask {
            MyExpireTimerTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                long l = System.currentTimeMillis();
                int n = 0;
                LinkedHashSet<ExpirationInfo> linkedHashSet = new LinkedHashSet<ExpirationInfo>();
                DestinationUID destinationUID = ((MsgExpirationReaper)MsgExpirationReaper.this).Destination.this.uid;
                Object object2 = MsgExpirationReaper.this;
                synchronized (object2) {
                    ExpirationInfo expirationInfo;
                    object = MsgExpirationReaper.this.messages.iterator();
                    while (object.hasNext() && (expirationInfo = (ExpirationInfo)object.next()).getExpireTime() <= l) {
                        linkedHashSet.add(expirationInfo);
                    }
                }
                object2 = linkedHashSet.iterator();
                while (object2.hasNext()) {
                    object = (ExpirationInfo)object2.next();
                    try {
                        if (!Destination.removeExpiredMessage(destinationUID, ((ExpirationInfo)object).id)) continue;
                        MsgExpirationReaper.this.removeMessage((ExpirationInfo)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        logger.logStack(8, "Internal Error", exception);
                    }
                }
                if (n > 0) {
                    logger.log(8, "B1140", (Object)String.valueOf(n), destinationUID.getLocalizedName());
                }
                linkedHashSet.clear();
            }
        }
    }

    static class ReconnectReaperTask
    extends JMQTimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;
        private long time = 0L;

        public ReconnectReaperTask(DestinationUID destinationUID, long l) {
            this.uid = destinationUID;
            this.time = l;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReconnectReaperTask reconnectReaperTask = this;
            synchronized (reconnectReaperTask) {
                logger.log(4, "Destroying temp destination " + this.uid + " inactive for " + this.time / 1000L + " seconds");
                if (!this.canceled) {
                    try {
                        Destination.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0070"));
                    }
                    catch (Exception exception) {
                        logger.logStack(16, "B4144", this.uid.getLocalizedName(), (Throwable)exception);
                    }
                }
            }
        }
    }

    static class DestReaperTask
    extends JMQTimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;

        public DestReaperTask(DestinationUID destinationUID) {
            this.uid = destinationUID;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.canceled = true;
            }
            try {
                object = Destination.getDestination(this.uid);
                if (object == null) {
                    return;
                }
                Map map = destinationList;
                synchronized (map) {
                    if (((Destination)object).getRefCount() > 0) {
                        return;
                    }
                    int n = DestType.isAdmin(((Destination)object).getType()) ? 4 : 8;
                    logger.log(n, "B1130", (Object)this.uid.getLocalizedName(), String.valueOf(AUTOCREATE_EXPIRE / 1000L));
                    ((Destination)object).destvalid = false;
                    object = Destination.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0069"));
                }
            }
            catch (Exception exception) {
                logger.logStack(16, "B4144", this.uid.getLocalizedName(), (Throwable)exception);
            }
        }
    }

    class FlowListener
    implements EventListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        FlowListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            if (reason instanceof RemoveReason) {
                return;
            }
            if (!$assertionsDisabled && eventType != EventType.FULL) {
                throw new AssertionError();
            }
            if (reason != AddReason.LOADED) {
                if (!$assertionsDisabled && !(object3 instanceof Boolean)) {
                    throw new AssertionError();
                }
                boolean bl = Destination.this.destMessages.isFull();
                if (bl) {
                    logger.log(4, "Destination " + Destination.this + " is full, " + " producers are being stopped");
                    Destination.this.stopFlow("Destination is full " + Destination.this.destMessages.size());
                } else {
                    Destination.this.resumeFlow("Destination is no longer full " + Destination.this.destMessages.size());
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Destination == null ? (class$com$sun$messaging$jmq$jmsserver$core$Destination = Destination.class$("com.sun.messaging.jmq.jmsserver.core.Destination")) : class$com$sun$messaging$jmq$jmsserver$core$Destination).desiredAssertionStatus();
        }
    }

    class RemoveBehaviorListener
    implements EventListener {
        Set orderedSet = null;
        Reason r = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RemoveBehaviorListener(Set set, Reason reason) {
            this.orderedSet = set;
            this.r = reason;
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            if (!$assertionsDisabled && eventType != EventType.SET_CHANGED_REQUEST) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(object3 instanceof Boolean)) {
                throw new AssertionError();
            }
            boolean bl = Destination.this.destMessages.isFull();
            if (bl && object3 != null) {
                Iterator iterator;
                long l = ((Sized)object3).byteSize();
                while ((iterator = this.orderedSet.iterator()).hasNext()) {
                    Object e = iterator.next();
                    if (e == null) continue;
                    try {
                        Destination.this.removeMessage(((PacketReference)e).getSysMessageID(), this.r);
                    }
                    catch (Exception exception) {
                        logger.logStack(8, "Internal Error-XXX", exception);
                        iterator.remove();
                        continue;
                    }
                    if (Destination.this.destMessages.capacity() != -1 && Destination.this.destMessages.freeSpace() <= 0 || Destination.this.destMessages.byteCapacity() != -1L && Destination.this.destMessages.freeBytes() <= l) continue;
                    break;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Destination == null ? (class$com$sun$messaging$jmq$jmsserver$core$Destination = Destination.class$("com.sun.messaging.jmq.jmsserver.core.Destination")) : class$com$sun$messaging$jmq$jmsserver$core$Destination).desiredAssertionStatus();
        }
    }
}

