/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.LoginException;
import com.sun.messaging.jmq.auth.server.AccessControlContext;
import com.sun.messaging.jmq.auth.server.AccessControlException;
import com.sun.messaging.jmq.auth.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.server.model.Subject;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQPrincipalImpl;
import java.security.Principal;
import java.util.Properties;

public class JMQAccessControlContext
implements AccessControlContext {
    private Subject subject;
    private Properties authProps;
    private AccessControlModel acs = null;

    public JMQAccessControlContext(Subject subject, Properties properties) throws LoginException {
        this.subject = subject;
        this.authProps = properties;
        String string = this.authProps.getProperty("imq.accesscontrol.enabled");
        if (string != null && string.equals("false")) {
            return;
        }
        try {
            this.loadAccessControlModel();
        }
        catch (AccessControlException accessControlException) {
            throw new LoginException(accessControlException.getMessage());
        }
    }

    private void loadAccessControlModel() throws AccessControlException {
        String string = this.authProps.getProperty("imq.accesscontrol.type");
        if (string == null || string.trim().equals("")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4044"));
        }
        String string2 = this.authProps.getProperty("imq.accesscontrol." + string + ".class");
        if (string2 == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4045", string));
        }
        try {
            this.acs = (AccessControlModel)Class.forName(string2).newInstance();
            this.acs.initialize(string, this.authProps);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + classNotFoundException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "InstantiationExcetpion: " + instantiationException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + illegalAccessException.getMessage()));
        }
        catch (ClassCastException classCastException) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassCastException: " + classCastException.getMessage()));
        }
    }

    public Principal getPrincipal() {
        return new JMQPrincipalImpl(this.subject.getUser());
    }

    public void checkConnectionPermission(String string, String string2) throws AccessControlException {
        String string3;
        if (string2.equals("ADMIN") && (string3 = this.authProps.getProperty("imq.accesscontrol.enabled")) != null && string3.equals("false")) {
            if (!this.subject.isAdministrator()) {
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4052", this.subject.getUser()));
            }
            return;
        }
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkConnectionPermission(string, string2, this.subject);
    }

    public void checkDestinationPermission(String string, String string2, String string3, String string4, String string5) throws AccessControlException {
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkDestinationPermission(string, string2, this.subject, string3, string4, string5);
    }
}

