/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.ByteBufferPool;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.VMDiagnostics;
import com.sun.messaging.jmq.jmsserver.brokerShutdownHook;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.NoCluster;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.handlers.AckHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.AuthHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ConsumerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.FlowHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.FlowPausedHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GenerateUIDHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GetLicenseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.GoodbyeHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.HelloHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ProducerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.QBrowseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.RedeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.SessionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.StartStopHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.VerifyDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.license.FileLicense;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.license.LicenseManager;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.shutdownRunnable;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.util.Debug;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.Rlimit;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Broker
implements GlobalErrorHandler {
    public static boolean NO_CLUSTER = false;
    public static boolean DEBUG = false;
    int DEFAULT_CLUSTER_VERSION = 350;
    private ClusterBroadcast mbus = null;
    private static String MIN_JAVA_VERSION = "1.4";
    private PacketRouter pktrtr = null;
    private PacketRouter admin_pktrtr = null;
    private TransactionList tlist = null;
    private BrokerResources rb = null;
    private Version version = null;
    private Store store = null;
    private boolean clearProps = false;
    private LicenseBase license = null;
    private String licenseToUse = null;
    private Logger logger = null;
    private String adminKeyFile = null;
    private Hashtable debugAliases = null;
    public static boolean quiescent = false;
    public static boolean shuttingDown = false;
    public static boolean startupComplete = false;
    public static Thread shutdownHook = null;
    private static int exitStatus = 0;
    private static Object exitStatusLock = new Object();
    private static boolean isNTService = false;
    private static int diagInterval = -1;
    public static boolean silent = false;
    public static boolean force = false;
    public static boolean background = false;
    private static boolean removeInstance = false;
    private static boolean resetStore = false;
    private ByteBufferPool bytepool = null;
    private String dbPWProp = "imq.persist.jdbc.password";
    private String ldapPWProp = "imq.user_repository.ldap.password";
    private String keystorePWProp = "imq.keystore.password";
    private boolean dbPWOverride = false;
    private boolean ldapPWOverride = false;
    private boolean keystorePWOverride = false;
    static final String DEFAULT_PW_CONTENT = "admin:-2d5455c8583c24eec82c7a1e273ea02e:admin:1\nguest:-2c3c4a34aa2c392f39edd112333c230d:anonymous:1\n";
    static final String DEFAULT_ACL_CONTENT = "##########################################################\n# MQ access control file for JMQFileAccessControlModel\n##########################################################\n\nversion=JMQFileAccessControlModel/100\n\n########################################################\n# Please see the MQ Administration Guide for details\n# on how to customize access control\n#\n# (spaces in a rule are significant)\n########################################################\n\n# service connection access control\n##################################\n\nconnection.NORMAL.allow.user=*\nconnection.ADMIN.allow.group=admin\n\n# destination based access control\n##################################\n\nqueue.*.produce.allow.user=*\nqueue.*.consume.allow.user=*\nqueue.*.browse.allow.user=*\ntopic.*.produce.allow.user=*\ntopic.*.consume.allow.user=*\n\n\n# destination auto-create access control\n########################################\n\nqueue.create.allow.user=*\ntopic.create.allow.user=*\n\n# all permissions access control setup sample\n##############################################\n#connection.*.usernames=*\n#\n#queue.*.produce.allow.user=*\n#queue.*.consume.allow.user=*\n#queue.*.browse.allow.user=*\n#topic.*.produce.allow.user=*\n#topic.*.consume.allow.user=*\n\n#queue.create.allow.user=*\n#topic.create.allow.user=*\n##############################################\n";

    public Broker(String[] stringArray) {
        Object object;
        try {
            Object[] objectArray;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object[] objectArray2;
            Object object9;
            Object object10;
            PortMapper portMapper;
            Object object11;
            Object object12;
            this.version = Globals.getVersion();
            this.rb = Globals.getBrokerResources();
            object = this.parseArgs(stringArray);
            if (object != null) {
                Globals.init((Properties)object, this.clearProps);
            }
            this.logger = Globals.getLogger();
            String string = Globals.getInstanceDir();
            File file = new File(string);
            if (!file.exists()) {
                while (!file.exists() && (file = file.getParentFile()) != null) {
                    if (!file.exists() || file.canWrite() && file.canRead()) continue;
                    if (!silent) {
                        System.err.println(this.rb.getString("B3124", file, Globals.getConfigName()));
                    }
                    System.exit(12);
                }
            } else if (!file.canWrite() || !file.canRead()) {
                if (!silent) {
                    System.err.println(this.rb.getString("B3124", file, Globals.getConfigName()));
                }
                System.exit(12);
            }
            if (removeInstance) {
                Broker.removeInstance();
            }
            try {
                this.parsePassfile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.log(64, "B3037", fileNotFoundException);
                System.exit(1);
            }
            try {
                Debug.setDebug(Globals.getConfig(), "imq.debug.");
            }
            catch (Exception exception) {
                this.logger.log(16, "B2014", exception);
            }
            try {
                DiagManager.registerClasses(Globals.getConfig(), "imq.diag.");
            }
            catch (Exception exception) {
                this.logger.log(16, "B2071", exception);
            }
            BrokerConfig brokerConfig = Globals.getConfig();
            DiagManager.register(new VMDiagnostics());
            BrokerException brokerException = null;
            try {
                this.license = Globals.getCurrentLicense(this.licenseToUse);
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
            }
            String string2 = this.version.getBanner(false, 0) + this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home");
            this.logger.logToAll(8, BrokerResources.NL + string2);
            if (brokerException != null) {
                this.logger.log(32, brokerException.toString());
                System.exit(1);
            } else if (this.license.getExpirationDate() != null) {
                object12 = this.license.getExpirationDate();
                object11 = DateFormat.getDateInstance(2);
                System.out.println(this.rb.getString("B0007", ((DateFormat)object11).format((Date)object12)));
            }
            this.logger.log(8, this.rb.getString("B1138", this.license.getProperty("description")));
            if (Version.compareVersions(System.getProperty("java.specification.version"), MIN_JAVA_VERSION, true) < 0) {
                this.logger.logToAll(32, "B3154", System.getProperty("java.specification.version"), MIN_JAVA_VERSION);
                System.exit(1);
            }
            object12 = brokerConfig.getProperty("imq.hostname");
            Globals.setHostname((String)object12);
            if (object12 == null || ((String)object12).equals("*")) {
                try {
                    object11 = InetAddress.getLocalHost();
                    Globals.setBrokerInetAddress((InetAddress)object11);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.log(32, "B3152", unknownHostException);
                    this.logger.log(8, "B0010");
                    Broker.exit(1);
                }
            } else {
                try {
                    object11 = InetAddress.getByName((String)object12);
                    Globals.setBrokerInetAddress((InetAddress)object11);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.log(32, this.rb.getString("B3151", object12, "imq.hostname"), unknownHostException);
                    this.logger.log(8, "B0010");
                    Broker.exit(1);
                }
            }
            try {
                this.logger.logToAll(8, "   IMQ_HOME=" + new File(Globals.JMQ_HOME).getCanonicalPath());
                this.logger.logToAll(8, "IMQ_VARHOME=" + new File(Globals.JMQ_VAR_HOME).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.logToAll(8, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " " + Globals.getBrokerHostName() + " " + "(" + Runtime.getRuntime().availableProcessors() + " cpu) " + System.getProperty("user.name"));
            try {
                object11 = Rlimit.get(5);
                this.logger.logToAll(8, this.rb.getString("B1092"), ((Rlimit.Limits)object11).current == -3L ? "unlimited" : String.valueOf(((Rlimit.Limits)object11).current), ((Rlimit.Limits)object11).maximum == -3L ? "unlimited" : String.valueOf(((Rlimit.Limits)object11).maximum));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logToAll(8, this.rb.getString("B1086"), Long.toString(Runtime.getRuntime().maxMemory() / 1024L), Long.toString(Runtime.getRuntime().totalMemory() / 1024L));
            this.logger.logToAll(8, this.rb.getString("B1055"), this.argsToString(stringArray));
            this.bytepool = new ByteBufferPool();
            this.bytepool.setBlockSize(72);
            Packet.setBufferPool(this.bytepool);
            Globals.setGlobalErrorHandler(this);
            object11 = this.getAdminKey(this.adminKeyFile);
            String string3 = "imq.adminkey";
            if (object11 == null || ((String)object11).length() == 0) {
                brokerConfig.remove(string3);
            } else {
                try {
                    brokerConfig.updateProperty(string3, (String)object11);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = brokerConfig.getBooleanProperty("imq.cluster.failover", false);
            Globals.setHAEnabled(bl);
            if (bl) {
                Globals.setHAState(Globals.HA_STANDBY);
            }
            if ((portMapper = Globals.getPortMapper()).getServerSocket() == null) {
                System.err.println(this.rb.getString("B0010"));
                Broker.exit(1);
            }
            String string4 = Globals.getBrokerHostName() + ":" + portMapper.getPort();
            try {
                object10 = MQAddress.createMQAddress(string4);
                Globals.setMQAddress((MQAddress)object10);
            }
            catch (MalformedURLException malformedURLException) {
                this.logger.logStack(8, "B3157", string4, (Throwable)malformedURLException);
            }
            object10 = new Thread((Runnable)portMapper, "JMQPortMapper");
            ((Thread)object10).setDaemon(true);
            ((Thread)object10).start();
            LockFile lockFile = null;
            try {
                lockFile = LockFile.getLock(brokerConfig.getProperty("imq.varhome"), Globals.getConfigName(), portMapper.getHostname() == null || portMapper.getHostname().equals("") ? Globals.getBrokerHostName() : portMapper.getHostname(), portMapper.getPort());
            }
            catch (Exception exception) {
                object9 = new Object[]{LockFile.getLockFilePath(brokerConfig.getProperty("imq.varhome"), Globals.getConfigName()), exception.toString(), Globals.getConfigName()};
                this.logger.log(32, "B3086", (Object[])object9);
                Broker.exit(1);
            }
            if (!lockFile.isMyLock()) {
                objectArray2 = new Object[]{lockFile.getFilePath(), lockFile.getHost() + ":" + lockFile.getPort(), Globals.getConfigName()};
                this.logger.log(32, "B3087", objectArray2);
                Broker.exit(1);
            }
            if (!(objectArray2 = new File(Globals.getInstanceEtcDir())).exists()) {
                objectArray2.mkdir();
                object9 = brokerConfig.getProperty("imq.accesscontrol.file.filename", "accesscontrol.properties");
                object8 = new File(Globals.JMQ_ETC_HOME + File.separator + (String)object9);
                object7 = new File((File)objectArray2, (String)object9);
                object6 = brokerConfig.getProperty("imq.user_repository.file.filename", "passwd");
                object5 = new File(Globals.JMQ_ETC_HOME + File.separator + (String)object6);
                File file2 = new File((File)objectArray2, (String)object6);
                if (((File)object8).exists()) {
                    try {
                        object4 = new RandomAccessFile((File)object8, "r");
                        FileChannel fileChannel = ((RandomAccessFile)object4).getChannel();
                        object3 = new RandomAccessFile((File)object7, "rw");
                        object2 = ((RandomAccessFile)object3).getChannel();
                        ((FileChannel)object2).transferFrom(fileChannel, 0L, ((RandomAccessFile)object4).length());
                        fileChannel.close();
                        ((AbstractInterruptibleChannel)object2).close();
                        ((RandomAccessFile)object4).close();
                        ((RandomAccessFile)object3).close();
                        object4 = new RandomAccessFile((File)object5, "r");
                        fileChannel = ((RandomAccessFile)object4).getChannel();
                        object3 = new RandomAccessFile(file2, "rw");
                        object2 = ((RandomAccessFile)object3).getChannel();
                        ((FileChannel)object2).transferFrom(fileChannel, 0L, ((RandomAccessFile)object4).length());
                        fileChannel.close();
                        ((AbstractInterruptibleChannel)object2).close();
                        ((RandomAccessFile)object4).close();
                        ((RandomAccessFile)object3).close();
                        objectArray = new Object[]{object6, object9, Globals.JMQ_ETC_HOME};
                        this.logger.logToAll(8, "B1119", objectArray);
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "Failed to copy files from the " + Globals.JMQ_ETC_HOME + " directory:", iOException);
                        System.exit(1);
                    }
                } else {
                    try {
                        object4 = new FileOutputStream((File)object7);
                        ((FileOutputStream)object4).write(DEFAULT_ACL_CONTENT.getBytes());
                        ((FileOutputStream)object4).close();
                        object4 = new FileOutputStream(file2);
                        ((FileOutputStream)object4).write(DEFAULT_PW_CONTENT.getBytes());
                        ((FileOutputStream)object4).close();
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "Failed to create default files", iOException);
                        System.exit(1);
                    }
                }
            }
            if (resetStore) {
                Globals.getAuditSession().storeOperation(null, null, "reset store");
            }
            try {
                this.store = Globals.getStore();
            }
            catch (BrokerException brokerException3) {
                this.logger.log(32, "B3000", brokerException3);
                System.exit(1);
            }
            NO_CLUSTER = !this.license.getBooleanProperty("imq.enable_cluster", false);
            int n = this.license.getIntProperty("imq.max_broker_conns", -1);
            if (NO_CLUSTER) {
                this.mbus = new NoCluster();
            } else {
                try {
                    object8 = Class.forName("com.sun.messaging.jmq.jmsserver.multibroker.ClusterBroadcaster");
                    object7 = new Class[]{Integer.class, Integer.class};
                    object6 = ((Class)object8).getConstructor((Class<?>)object7);
                    object5 = new Object[]{new Integer(n), new Integer(this.DEFAULT_CLUSTER_VERSION)};
                    this.mbus = (ClusterBroadcast)((Constructor)object6).newInstance((Object[])object5);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.logStack(4, "B3100", "unable to use cluster broadcaster", (Throwable)classNotFoundException);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
                catch (InvocationTargetException invocationTargetException) {
                    object7 = invocationTargetException.getCause();
                    this.logger.logStack(8, "B3100", "unable to use cluster broadcaster", (Throwable)object7);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "B3100", "unable to use cluster broadcaster", (Throwable)exception);
                    this.logger.log(8, "B1137");
                    this.mbus = new NoCluster();
                }
            }
            Globals.setClusterBroadcast(this.mbus);
            Globals.setMyAddress(this.mbus.getMyAddress());
            if (!NO_CLUSTER && bl) {
                object8 = Globals.getClusterDiscoveryService();
                ((ClusterDiscoveryService)object8).addSelfAddress(this.mbus.getMyAddress());
                object7 = new Thread((Runnable)object8, "ClusterDiscoveryService");
                ((Thread)object7).setDaemon(true);
                ((Thread)object7).start();
            }
            if ((object8 = Globals.getConfig().getProperty("imq.authentication.type")) != null && ((String)(object7 = Globals.getConfig().getProperty("imq.authentication." + (String)object8 + ".user_repository"))).equals("ldap")) {
                object6 = Globals.getConfig().getProperty("imq.user_repository." + (String)object7 + ".principal");
                object5 = Globals.getConfig().getProperty("imq.user_repository." + (String)object7 + ".password");
                if (object6 != null && ((String)object6).trim().length() > 0 && (object5 == null || ((String)object5).trim().length() == 0)) {
                    boolean bl2;
                    object4 = null;
                    boolean bl3 = bl2 = object5 == null || ((String)object5).equals("");
                    for (int i = 0; object5 == null || ((String)object5).trim().equals("") && i < 5; ++i) {
                        object4 = new Password();
                        System.err.print(Globals.getBrokerResources().getString("B0031", object6));
                        System.err.flush();
                        object5 = ((Password)object4).getPassword();
                    }
                    if (object5 == null || ((String)object5).trim().equals("")) {
                        this.logger.log(16, "B2078", object5);
                        Globals.getConfig().put("imq.user_repository." + (String)object7 + ".principal", "");
                    } else if (bl2) {
                        Globals.getConfig().put("imq.user_repository." + (String)object7 + ".password", object5);
                    }
                }
            }
            object7 = new ConnectionManager(this.license.getIntProperty("imq.max_client_conns", -1));
            Globals.setConnectionManager((ConnectionManager)object7);
            this.tlist = new TransactionList(this.store);
            Globals.setTransactionList(this.tlist);
            if (!Globals.getHAEnabled()) {
                try {
                    Destination.init();
                    Subscription.initSubscriptions();
                    BrokerMonitor.init();
                }
                catch (BrokerException brokerException4) {
                    this.logger.logStack(16, "B3101", brokerException4);
                }
            }
            Selector.setConvertTypes(brokerConfig.getBooleanProperty("imq.selector.convertTypes", false));
            Selector.setShortCircuit(brokerConfig.getBooleanProperty("imq.selector.shortCircuit", true));
            this.pktrtr = new PacketRouter();
            object6 = new HelloHandler((ConnectionManager)object7);
            object5 = new GetLicenseHandler();
            GoodbyeHandler goodbyeHandler = new GoodbyeHandler((ConnectionManager)object7);
            object4 = new StartStopHandler();
            ConsumerHandler consumerHandler = new ConsumerHandler();
            object3 = new ProducerHandler();
            object2 = new DestinationHandler();
            objectArray = new QBrowseHandler();
            AuthHandler authHandler = new AuthHandler((ConnectionManager)object7);
            SessionHandler sessionHandler = new SessionHandler();
            PingHandler pingHandler = new PingHandler();
            DataHandler dataHandler = new DataHandler(this.tlist);
            AckHandler ackHandler = new AckHandler(this.tlist);
            RedeliverHandler redeliverHandler = new RedeliverHandler();
            DeliverHandler deliverHandler = new DeliverHandler();
            TransactionHandler transactionHandler = new TransactionHandler(this.tlist);
            VerifyDestinationHandler verifyDestinationHandler = new VerifyDestinationHandler();
            ClientIDHandler clientIDHandler = new ClientIDHandler();
            FlowHandler flowHandler = new FlowHandler();
            FlowPausedHandler flowPausedHandler = new FlowPausedHandler();
            GenerateUIDHandler generateUIDHandler = new GenerateUIDHandler();
            try {
                this.pktrtr.addHandler(10, (PacketHandler)object6);
                this.pktrtr.addHandler(12, authHandler);
                this.pktrtr.addHandler(76, (PacketHandler)object5);
                this.pktrtr.addHandler(14, consumerHandler);
                this.pktrtr.addHandler(16, consumerHandler);
                this.pktrtr.addHandler(18, (PacketHandler)object3);
                this.pktrtr.addHandler(20, (PacketHandler)object4);
                this.pktrtr.addHandler(22, (PacketHandler)object4);
                this.pktrtr.addHandler(24, ackHandler);
                this.pktrtr.addHandler(26, (PacketHandler)objectArray);
                this.pktrtr.addHandler(28, goodbyeHandler);
                this.pktrtr.addHandler(32, redeliverHandler);
                this.pktrtr.addHandler(34, (PacketHandler)object2);
                this.pktrtr.addHandler(36, (PacketHandler)object2);
                this.pktrtr.addHandler(40, verifyDestinationHandler);
                this.pktrtr.addHandler(42, deliverHandler);
                this.pktrtr.addHandler(44, transactionHandler);
                this.pktrtr.addHandler(46, transactionHandler);
                this.pktrtr.addHandler(48, transactionHandler);
                this.pktrtr.addHandler(56, transactionHandler);
                this.pktrtr.addHandler(58, transactionHandler);
                this.pktrtr.addHandler(60, transactionHandler);
                this.pktrtr.addHandler(50, clientIDHandler);
                this.pktrtr.addHandler(62, generateUIDHandler);
                this.pktrtr.addHandler(3, dataHandler);
                this.pktrtr.addHandler(2, dataHandler);
                this.pktrtr.addHandler(6, dataHandler);
                this.pktrtr.addHandler(27, dataHandler);
                this.pktrtr.addHandler(5, dataHandler);
                this.pktrtr.addHandler(4, dataHandler);
                this.pktrtr.addHandler(1, dataHandler);
                this.pktrtr.addHandler(52, flowHandler);
                this.pktrtr.addHandler(64, flowPausedHandler);
                this.pktrtr.addHandler(68, sessionHandler);
                this.pktrtr.addHandler(66, (PacketHandler)object3);
                this.pktrtr.addHandler(70, sessionHandler);
                this.pktrtr.addHandler(54, pingHandler);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "adding packet handlers", (Throwable)exception);
            }
            this.admin_pktrtr = new PacketRouter();
            AdminDataHandler adminDataHandler = new AdminDataHandler(this.tlist);
            try {
                this.admin_pktrtr.addHandler(10, (PacketHandler)object6);
                this.admin_pktrtr.addHandler(12, authHandler);
                this.admin_pktrtr.addHandler(76, (PacketHandler)object5);
                this.admin_pktrtr.addHandler(14, consumerHandler);
                this.admin_pktrtr.addHandler(16, consumerHandler);
                this.admin_pktrtr.addHandler(18, (PacketHandler)object3);
                this.admin_pktrtr.addHandler(20, (PacketHandler)object4);
                this.admin_pktrtr.addHandler(22, (PacketHandler)object4);
                this.admin_pktrtr.addHandler(24, ackHandler);
                this.admin_pktrtr.addHandler(26, (PacketHandler)objectArray);
                this.admin_pktrtr.addHandler(28, goodbyeHandler);
                this.admin_pktrtr.addHandler(32, redeliverHandler);
                this.admin_pktrtr.addHandler(34, (PacketHandler)object2);
                this.admin_pktrtr.addHandler(36, (PacketHandler)object2);
                this.admin_pktrtr.addHandler(40, verifyDestinationHandler);
                this.admin_pktrtr.addHandler(42, deliverHandler);
                this.admin_pktrtr.addHandler(44, transactionHandler);
                this.admin_pktrtr.addHandler(46, transactionHandler);
                this.admin_pktrtr.addHandler(48, transactionHandler);
                this.admin_pktrtr.addHandler(56, transactionHandler);
                this.admin_pktrtr.addHandler(58, transactionHandler);
                this.admin_pktrtr.addHandler(60, transactionHandler);
                this.admin_pktrtr.addHandler(50, clientIDHandler);
                this.admin_pktrtr.addHandler(62, generateUIDHandler);
                this.admin_pktrtr.addHandler(3, adminDataHandler);
                this.admin_pktrtr.addHandler(2, adminDataHandler);
                this.admin_pktrtr.addHandler(6, adminDataHandler);
                this.admin_pktrtr.addHandler(27, adminDataHandler);
                this.admin_pktrtr.addHandler(5, adminDataHandler);
                this.admin_pktrtr.addHandler(4, adminDataHandler);
                this.admin_pktrtr.addHandler(1, adminDataHandler);
                this.admin_pktrtr.addHandler(52, flowHandler);
                this.admin_pktrtr.addHandler(64, flowPausedHandler);
                this.admin_pktrtr.addHandler(68, sessionHandler);
                this.admin_pktrtr.addHandler(66, (PacketHandler)object3);
                this.admin_pktrtr.addHandler(70, sessionHandler);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "adding packet handlers to admin packet router", (Throwable)exception);
            }
            adminDataHandler.setPacketRouter(this.admin_pktrtr);
            PacketRouter[] packetRouterArray = new PacketRouter[]{this.pktrtr, this.admin_pktrtr};
            Globals.setPacketRouters(packetRouterArray);
            ServiceManager serviceManager = new ServiceManager((ConnectionManager)object7);
            Globals.setServiceManager(serviceManager);
            if (Globals.getHAEnabled()) {
                serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 1);
            } else {
                serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 1, false);
                if (this.mbus.waitForConfigSync()) {
                    serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 0, true);
                    this.logger.log(32, "B1073");
                } else {
                    serviceManager.updateServiceList(serviceManager.getAllActiveServiceNames(), 0, false);
                }
            }
            shutdownHook = Broker.addShutdownHook();
            if (shutdownHook == null) {
                this.logger.log(4, "B1050");
            } else {
                this.logger.log(4, "B1049");
            }
            Globals.getMemManager().startManagement();
            MetricManager metricManager = new MetricManager();
            Globals.setMetricManager(metricManager);
            metricManager.setParameters(Globals.getConfig());
            Properties properties = new Properties();
            properties.setProperty("imq.autocreate.queue", Globals.getConfig().getProperty("imq.autocreate.queue", "false"));
            properties.setProperty("imq.autocreate.topic", Globals.getConfig().getProperty("imq.autocreate.topic", "false"));
            int n2 = Queue.getDefaultMaxActiveConsumers();
            int n3 = Queue.getDefaultMaxFailoverConsumers();
            if (n2 == 1 && n3 == 0) {
                properties.setProperty("imq.queue.deliverypolicy", "single");
            }
            if (n2 == 1 && n3 != 0) {
                properties.setProperty("imq.queue.deliverypolicy", "failover");
            }
            if ((n2 == -1 || n2 > 1) && n3 == 0) {
                properties.setProperty("imq.queue.deliverypolicy", "round-robin");
            }
            this.mbus.setMatchProps(properties);
            this.mbus.startClusterIO();
            startupComplete = true;
            Globals.getAuditSession().brokerOperation(null, null, "broker startup");
            Object[] objectArray3 = new Object[]{Globals.getConfigName() + "@" + (portMapper.getHostname() == null || portMapper.getHostname().equals("") ? Globals.getBrokerHostName() : portMapper.getHostname()) + ":" + String.valueOf(portMapper.getPort())};
            this.logger.logToAll(8, "B1039", objectArray3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Globals.handleGlobalError(outOfMemoryError, this.rb.getKString("B0017"));
            System.exit(1);
        }
        if (diagInterval > 0) {
            object = Globals.getTimer();
            int n = diagInterval * 1000;
            ((JMQTimer)object).schedule((JMQTimerTask)new BrokerDiagTask(), n, (long)n);
        } else if (diagInterval == 0) {
            this.logger.log(8, DiagManager.allToString());
        }
    }

    private String argsToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private Properties parseArgs(String[] stringArray) {
        Properties properties = new Properties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-loglevel")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                try {
                    Logger.levelStrToInt(stringArray[i]);
                    properties.put("imq.log.level", stringArray[i]);
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(this.rb.getString("B0003"));
                    this.usage();
                }
                continue;
            }
            if (stringArray[i].equals("-shared")) {
                properties.put("imq.jms.threadpool_model", "shared");
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                if (!bl) {
                    properties.put("imq.log.level", "DEBUGHIGH");
                }
                if (this.enableDebug(stringArray[i], properties)) continue;
                this.usage();
                continue;
            }
            if (stringArray[i].equals("-dbuser")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.persist.jdbc.user", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-dbpassword")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put(this.dbPWProp, stringArray[i]);
                this.dbPWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-diag")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                try {
                    diagInterval = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.usage();
                }
                continue;
            }
            if (stringArray[i].equals("-name")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.instancename", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-port")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.portmapper.port", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-metrics")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.metrics.interval", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-password")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put(this.keystorePWProp, stringArray[i]);
                this.keystorePWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-ldappassword")) {
                this.printPasswordWarning(stringArray[i]);
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put(this.ldapPWProp, stringArray[i]);
                this.ldapPWOverride = true;
                continue;
            }
            if (stringArray[i].equals("-passfile")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (IOException iOException) {
                    this.usage();
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
                continue;
            }
            if (stringArray[i].equals("-backup")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.cluster.masterbroker.backup", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-restore")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.cluster.masterbroker.restore", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-cluster")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                properties.put("imq.cluster.brokerlist.manual", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-force")) {
                force = true;
                continue;
            }
            if (stringArray[i].equals("-silent") || stringArray[i].equals("-s")) {
                properties.put("imq.log.console.output", "NONE");
                silent = true;
                continue;
            }
            if (stringArray[i].equals("-tty")) {
                properties.put("imq.log.console.output", "ALL");
                continue;
            }
            if (stringArray[i].startsWith("-D")) {
                int n = 0;
                String string = null;
                String string2 = "";
                n = stringArray[i].indexOf(61);
                if (stringArray[i].length() <= 2) continue;
                if (n < 0) {
                    string = stringArray[i].substring(2);
                } else if (n == stringArray[i].length() - 1) {
                    string = stringArray[i].substring(2, n);
                } else {
                    string = stringArray[i].substring(2, n);
                    string2 = stringArray[i].substring(n + 1);
                }
                properties.put(string, string2);
                continue;
            }
            if (stringArray[i].equals("-varhome") || stringArray[i].equals("-jmqvarhome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-javahome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-jrehome")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-bgnd")) {
                background = true;
                continue;
            }
            if (stringArray[i].equals("-version") || stringArray[i].equals("-v")) {
                System.out.println(this.version.getBanner(true));
                System.out.println(this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
                System.out.println(this.rb.getString("B1054") + System.getProperty("java.class.path"));
                try {
                    System.out.println("   IMQ_HOME=" + new File(Globals.JMQ_HOME).getCanonicalPath());
                    System.out.println("IMQ_VARHOME=" + new File(Globals.JMQ_VAR_HOME).getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-ntservice")) {
                isNTService = true;
                continue;
            }
            if (stringArray[i].equals("-adminkeyfile")) {
                this.adminKeyFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-help") || stringArray[i].equals("-h")) {
                this.usage();
                continue;
            }
            if (stringArray[i].equals("-license")) {
                if (++i >= stringArray.length) {
                    this.printLicenses();
                    continue;
                }
                this.licenseToUse = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-remove")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                if (stringArray[i].equals("instance")) {
                    removeInstance = true;
                    properties.put("imq.persist.storeremove.all", "true");
                    continue;
                }
                System.err.println(this.rb.getString("B0028"));
                this.usage();
                continue;
            }
            if (stringArray[i].equals("-reset")) {
                if (++i >= stringArray.length) {
                    this.usage();
                }
                if (stringArray[i].equals("store")) {
                    properties.put("imq.persist.storereset.all", "true");
                    resetStore = true;
                    continue;
                }
                if (stringArray[i].equals("messages")) {
                    properties.put("imq.persist.storereset.messages", "true");
                    continue;
                }
                if (stringArray[i].equals("durables")) {
                    properties.put("imq.persist.storereset.durables", "true");
                    continue;
                }
                if (stringArray[i].equals("props")) {
                    this.clearProps = true;
                    continue;
                }
                System.err.println(this.rb.getString("B0009"));
                this.usage();
                continue;
            }
            if (stringArray[i].equals("-upgrade-store-nobackup")) {
                properties.put("imq.persist.storeupgrade.nobackup", "true");
                continue;
            }
            System.err.println(this.rb.getString("B3058", stringArray[i]));
            this.usage();
        }
        return properties;
    }

    private void printPasswordWarning(String string) {
        if (!silent) {
            System.err.println(this.rb.getString("B2088", string));
            System.err.println("");
        }
    }

    private String getAdminKey(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[256];
        File file = new File(string);
        FileInputStream fileInputStream = null;
        int n = 0;
        try {
            fileInputStream = new FileInputStream(file);
            n = fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.log(16, "B2064", (Object)string, (Throwable)fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            this.logger.log(16, "B2064", (Object)string, (Throwable)iOException);
            return null;
        }
        String string2 = null;
        try {
            string2 = new String(byArray, 0, n, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.log(16, "B3100", "Could not convert key to String using ASCII encoding ");
        }
        if (!file.delete()) {
            this.logger.log(16, "B2065", string);
        }
        return string2;
    }

    private synchronized boolean enableDebug(String string, Properties properties) {
        String string2;
        String string3 = "imq.debug.com.sun.messaging.jmq.";
        if (this.debugAliases == null) {
            this.debugAliases = new Hashtable();
            this.debugAliases.put("admin", string3 + "jmsserver.data.handlers.admin.AdminCmdHandler");
            this.debugAliases.put("pkt", "imq.packet.debug.all");
            this.debugAliases.put("pktin", "imq.packet.debug.in");
            this.debugAliases.put("pktout", "imq.packet.debug.out");
            this.debugAliases.put("cluster", "imq.cluster.debug.all");
            this.debugAliases.put("lock", "imq.cluster.debug.lock");
            this.debugAliases.put("clscon", "imq.cluster.debug.conn");
            this.debugAliases.put("clspkt", "imq.cluster.debug.packet");
        }
        if ((string2 = (String)this.debugAliases.get(string)) == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            properties.put(stringTokenizer.nextToken(), "true");
        }
        return true;
    }

    private void usage() {
        System.err.println(this.rb.getString("B0002"));
        System.exit(1);
    }

    private void printLicenses() {
        Globals.getLicenseManager();
        FileLicense[] fileLicenseArray = LicenseManager.loadFileLicenses();
        if (fileLicenseArray.length == 0) {
            System.out.println();
            System.out.println(this.rb.getString("B1143"));
            System.out.println();
        } else {
            System.out.println(this.rb.getString("B0005"));
            for (int i = 0; i < fileLicenseArray.length; ++i) {
                String string = fileLicenseArray[i].getProperty("imq.license_type");
                String string2 = fileLicenseArray[i].getProperty("description");
                System.out.println("\t" + string + "\t-  " + string2);
            }
            System.out.println("\tpe\t-  Sun Java(tm) System Message Queue 3.6 Platform Edition");
            System.out.println(this.rb.getString("B0006"));
        }
        System.exit(0);
    }

    public static Thread addShutdownHook() {
        Method method;
        Runtime runtime = Runtime.getRuntime();
        Class[] classArray = new Class[1];
        try {
            classArray[0] = Class.forName("java.lang.Thread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("addShutdownHook: can't find java.lang.Thread: " + classNotFoundException);
            return null;
        }
        try {
            method = runtime.getClass().getMethod("addShutdownHook", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Object[] objectArray = new Object[]{new brokerShutdownHook()};
        try {
            method.invoke((Object)runtime, objectArray);
        }
        catch (Exception exception) {
            System.err.println("addShutdownHook: could not call addShutdownHook: " + exception);
            return null;
        }
        return (Thread)objectArray[0];
    }

    public static boolean removeShutdownHook(Thread thread) {
        Method method;
        Runtime runtime = Runtime.getRuntime();
        Class[] classArray = new Class[1];
        try {
            classArray[0] = Class.forName("java.lang.Thread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("removeShutdownHook: can't find java.lang.Thread: " + classNotFoundException);
            return false;
        }
        try {
            method = runtime.getClass().getMethod("removeShutdownHook", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Object[] objectArray = new Object[]{thread};
        try {
            method.invoke((Object)runtime, objectArray);
        }
        catch (Exception exception) {
            System.err.println("removeShutdownHook: could not call removeShutdownHook: " + exception);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        new Broker(stringArray);
    }

    public static void removeInstance() {
        Object[] objectArray;
        BrokerResources brokerResources = Globals.getBrokerResources();
        Logger logger = Globals.getLogger();
        String string = Globals.getInstanceDir();
        if (!new File(string).exists()) {
            if (!silent) {
                System.err.println(brokerResources.getString("B3119", Globals.getConfigName()));
            }
            System.exit(10);
        }
        BrokerConfig brokerConfig = Globals.getConfig();
        LockFile lockFile = null;
        try {
            lockFile = LockFile.getLock(brokerConfig.getProperty("imq.varhome"), Globals.getConfigName(), "localhost", 0);
        }
        catch (Exception exception) {
            objectArray = new Object[]{LockFile.getLockFilePath(brokerConfig.getProperty("imq.varhome"), Globals.getConfigName()), exception.toString(), Globals.getConfigName()};
            logger.log(32, "B3086", objectArray);
            Broker.exit(14);
        }
        if (!lockFile.isMyLock()) {
            Object[] objectArray2 = new Object[]{lockFile.getFilePath(), lockFile.getHost() + ":" + lockFile.getPort(), Globals.getConfigName()};
            logger.log(32, "B3087", objectArray2);
            Broker.exit(11);
        }
        boolean bl = false;
        try {
            if (!force) {
                objectArray = brokerResources.getString("B0029");
                String string2 = brokerResources.getString("B0026");
                String string3 = brokerResources.getString("B0027");
                Object[] objectArray3 = new String[]{Globals.getConfigName(), string2, string3};
                System.out.print(brokerResources.getString("B0025", objectArray3));
                System.out.flush();
                String string4 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!string2.equalsIgnoreCase(string4) && !objectArray.equalsIgnoreCase(string4)) {
                    System.err.println(brokerResources.getString("B1097"));
                    System.exit(1);
                }
            }
            Globals.getAuditSession().brokerOperation(null, null, "remove instance");
            try {
                Globals.getStore();
            }
            catch (BrokerException brokerException) {
                logger.log(32, brokerException.toString());
                System.exit(13);
            }
            if (!silent) {
                System.out.println(brokerResources.getString("B1096"));
            }
            logger.close();
            bl = true;
            FileUtil.removeFiles(new File(string), true);
            System.exit(0);
        }
        catch (IOException iOException) {
            if (bl) {
                logger.open();
            }
            logger.log(32, iOException.toString());
            System.exit(14);
        }
    }

    public static void shutdownBroker(boolean bl) throws BrokerException {
        Broker.shuttingDownBroker();
        Thread thread = new Thread((Runnable)new shutdownRunnable(bl), "shutdown thread");
        thread.start();
    }

    public static synchronized void shuttingDownBroker() {
        if (quiescent) {
            return;
        }
        Globals.getMemManager().stopManagement();
        Destination.shutdown();
        Globals.getClusterBroadcast().stopClusterIO();
        try {
            Globals.getServiceManager().stopAllActiveServices(true);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(16, "B2066", exception);
        }
    }

    public static synchronized boolean quiesceBroker() {
        if (quiescent) {
            return true;
        }
        if (diagInterval == 0) {
            Globals.getLogger().log(8, DiagManager.allToString());
        }
        shuttingDown = true;
        Broker.shuttingDownBroker();
        try {
            ServiceManager serviceManager = Globals.getServiceManager();
            serviceManager.pauseAllActiveServices(0, false);
            serviceManager.pauseAllActiveServices(1, false);
            ConnectionManager connectionManager = Globals.getConnectionManager();
            Globals.getLogger().logToAll(8, "B1077");
            connectionManager.broadcastGoodbye();
            Globals.getLogger().logToAll(8, "B1078");
            connectionManager.flushControlMessages(1000L);
            serviceManager.stopAllActiveServices(true);
            Globals.releaseStore();
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(16, "B3100", "shutting down broker ", (Throwable)exception);
            return false;
        }
        quiescent = true;
        return true;
    }

    private void parsePassfile() throws FileNotFoundException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = null;
        String string2 = null;
        if (brokerConfig.getBooleanProperty("imq.passfile.enabled")) {
            string = brokerConfig.getProperty("imq.passfile.dirpath");
            string2 = string != null ? (string = StringUtil.expandVariables(string, brokerConfig)) : brokerConfig.getProperty("imq.etchome") + File.separator + "security";
            String string3 = string2 + File.separator + brokerConfig.getProperty("imq.passfile.name");
            File file = new File(string3);
            if (file.exists()) {
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(string3);
                    properties.load(fileInputStream);
                    if (this.dbPWOverride) {
                        properties.put(this.dbPWProp, brokerConfig.getProperty(this.dbPWProp));
                    }
                    if (this.ldapPWOverride) {
                        properties.put(this.ldapPWProp, brokerConfig.getProperty(this.ldapPWProp));
                    }
                    if (this.keystorePWOverride) {
                        properties.put(this.keystorePWProp, brokerConfig.getProperty(this.keystorePWProp));
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(32, this.rb.getKString("B4023"), iOException);
                }
                brokerConfig.putAll((Map)properties);
            } else {
                throw new FileNotFoundException(this.rb.getKString("B3020", string3));
            }
        }
    }

    public static void exit(int n) {
        Globals.getLogger().log(4, "Broker exiting with status=" + n);
        System.exit(n);
    }

    public boolean handleGlobalError(Throwable throwable, String string) {
        if (throwable instanceof OutOfMemoryError) {
            this.logger.logStack(32, "Received Out Of Memory Error [" + string + "]", throwable);
            Globals.getMemManager().forceRedState();
            return true;
        }
        return false;
    }

    class BrokerDiagTask
    extends JMQTimerTask {
        BrokerDiagTask() {
        }

        public void run() {
            String string = DiagManager.allToString();
            if (string != null) {
                Broker.this.logger.log(8, string);
            }
        }
    }
}

