/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap
implements Map {
    HashMap baseMap = new HashMap();
    private ReferenceQueue myqueue = new ReferenceQueue();
    private transient Collection values = null;
    private transient Set entrySet = null;

    private void cleanupMap() {
        Reference reference;
        while ((reference = this.myqueue.poll()) != null) {
            MyWeakValueReference myWeakValueReference = (MyWeakValueReference)reference;
            WeakReference weakReference = (WeakReference)this.baseMap.get(myWeakValueReference.getOriginalKey());
            if (!weakReference.isEnqueued()) continue;
            this.remove(myWeakValueReference.getOriginalKey());
        }
    }

    public int size() {
        this.cleanupMap();
        return this.baseMap.size();
    }

    public boolean isEmpty() {
        this.cleanupMap();
        return this.baseMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        WeakReference weakReference = (WeakReference)this.baseMap.get(object);
        return weakReference != null && !weakReference.isEnqueued();
    }

    public boolean containsValue(Object object) {
        this.cleanupMap();
        return this.baseMap.containsValue(object);
    }

    public Object get(Object object) {
        this.cleanupMap();
        Reference reference = (Reference)this.baseMap.get(object);
        return reference == null ? null : (reference.isEnqueued() ? null : reference.get());
    }

    public Object put(Object object, Object object2) {
        this.cleanupMap();
        MyWeakValueReference myWeakValueReference = new MyWeakValueReference(object, object2, this.myqueue);
        WeakReference weakReference = this.baseMap.put(object, myWeakValueReference);
        return weakReference == null ? null : (weakReference.isEnqueued() ? null : weakReference.get());
    }

    public Object remove(Object object) {
        this.cleanupMap();
        WeakReference weakReference = (WeakReference)this.baseMap.remove(object);
        return weakReference == null ? null : weakReference.get();
    }

    public void putAll(Map map) {
        this.cleanupMap();
        this.baseMap.putAll(map);
    }

    public void clear() {
        this.cleanupMap();
        this.baseMap.clear();
    }

    public Set keySet() {
        this.cleanupMap();
        return this.baseMap.keySet();
    }

    public Collection values() {
        this.cleanupMap();
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        this.cleanupMap();
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public boolean equals(Object object) {
        this.cleanupMap();
        if (object instanceof WeakValueHashMap) {
            return this.baseMap.equals(((WeakValueHashMap)object).baseMap);
        }
        return this.baseMap.equals(object);
    }

    public int hashCode() {
        this.cleanupMap();
        return this.baseMap.hashCode();
    }

    public static void main(String[] stringArray) {
        int n;
        WeakValueHashMap weakValueHashMap = new WeakValueHashMap();
        Object object = new Object();
        Object object2 = new Object();
        String string = new String("value1");
        String string2 = new String("value2");
        weakValueHashMap.put(object, string);
        weakValueHashMap.put(object2, string2);
        for (n = 0; n < 10; ++n) {
            System.gc();
        }
        System.out.println("K1 get " + weakValueHashMap.get(object));
        System.out.println("K2 get " + weakValueHashMap.get(object2));
        string2 = null;
        string = null;
        for (n = 0; n < 100; ++n) {
            System.gc();
        }
        System.out.println("K1 get " + weakValueHashMap.get(object));
        System.out.println("K2 get " + weakValueHashMap.get(object2));
    }

    class WeakValueEntry
    implements Map.Entry {
        Object key = null;
        Object value = null;

        public WeakValueEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException("not supported");
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }
            return super.equals(object);
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new newEntryIterator(WeakValueHashMap.this.baseMap.entrySet().iterator());
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return WeakValueHashMap.this.containsKey(entry.getKey());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return WeakValueHashMap.this.remove(entry.getKey()) != null;
        }

        public int size() {
            return WeakValueHashMap.this.size();
        }

        public void clear() {
            WeakValueHashMap.this.clear();
        }
    }

    private class newEntryIterator
    implements Iterator {
        Map.Entry nextentry = null;
        Iterator itr = null;

        public newEntryIterator(Iterator iterator) {
            this.itr = iterator;
        }

        public boolean hasNext() {
            if (this.nextentry != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            Map.Entry entry = (Map.Entry)this.itr.next();
            WeakReference weakReference = (WeakReference)entry.getValue();
            while (weakReference.isEnqueued()) {
                this.itr.remove();
                entry = (Map.Entry)this.itr.next();
                weakReference = (WeakReference)entry.getValue();
            }
            if (weakReference != null) {
                this.nextentry = new WeakValueEntry(entry.getKey(), weakReference.get());
            }
            return this.nextentry != null;
        }

        public Object next() {
            if (this.nextentry == null && !this.hasNext()) {
                return null;
            }
            Map.Entry entry = this.nextentry;
            this.nextentry = null;
            return entry;
        }

        public void remove() {
            this.itr.remove();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator(WeakValueHashMap.this.baseMap.values().iterator());
        }

        public int size() {
            return WeakValueHashMap.this.size();
        }

        public boolean contains(Object object) {
            return WeakValueHashMap.this.containsValue(object);
        }

        public void clear() {
            WeakValueHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class ValueIterator
    implements Iterator {
        WeakReference next = null;
        Iterator itr = null;

        public ValueIterator(Iterator iterator) {
            this.itr = iterator;
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            this.next = (WeakReference)this.itr.next();
            while (this.next.isEnqueued()) {
                this.itr.remove();
                this.next = (WeakReference)this.itr.next();
            }
            return this.next != null;
        }

        public Object next() {
            if (this.next == null && !this.hasNext()) {
                return null;
            }
            while (this.next.isEnqueued()) {
                this.itr.remove();
                this.next = null;
                if (this.hasNext()) continue;
            }
            Object var1_1 = this.next == null ? null : this.next.get();
            this.next = null;
            return var1_1;
        }

        public void remove() {
            this.itr.remove();
        }
    }

    static class MyWeakValueReference
    extends WeakReference {
        Object mykey = null;

        public MyWeakValueReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.mykey = object;
        }

        public int hashCode() {
            return this.mykey.hashCode();
        }

        public Object getOriginalKey() {
            return this.mykey;
        }
    }
}

