/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class EventBroadcastHelper
implements EventBroadcaster {
    Collection[] c = new Collection[EventType.EVENT_TYPE_NUM];
    boolean[] busy = new boolean[EventType.EVENT_TYPE_NUM];
    int[] start = null;
    int cnt = 0;
    boolean orderMaintained = true;

    public synchronized void setOrderMaintained(boolean bl) {
        this.orderMaintained = bl;
        if (!this.orderMaintained) {
            this.start = new int[EventType.EVENT_TYPE_NUM];
        }
    }

    public synchronized void clear() {
        this.c = new Collection[EventType.EVENT_TYPE_NUM];
        for (int i = 0; i < EventType.EVENT_TYPE_NUM; ++i) {
            this.busy[i] = false;
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println(this.toString());
    }

    public String toString() {
        String string = "EventBroadcastHelper {\n";
        for (int i = 0; i < this.c.length; ++i) {
            boolean bl = false;
            string = string + "\t" + i + " { ";
            if (this.c[i] == null) {
                string = string + "null";
            } else {
                Iterator iterator = this.c[i].iterator();
                boolean bl2 = true;
                int n = 0;
                while (iterator.hasNext()) {
                    ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                    bl = true;
                    if (!bl2) {
                        string = string + "\t    ";
                    }
                    bl2 = false;
                    string = string + n + ":  " + listenerInfo.getListener() + "\n\t        " + listenerInfo.getType() + "\n\t        " + listenerInfo.getReason() + "\n\t        " + listenerInfo.getUserData() + "\n";
                    ++n;
                }
            }
            string = bl ? string + "\t  }\n" : string + " }\n";
        }
        return string;
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) {
        return this.addEventListener(eventListener, eventType, null, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) {
        ListenerInfo listenerInfo = new ListenerInfo(eventListener, eventType, reason, object);
        int n = eventType.getEvent();
        EventBroadcastHelper eventBroadcastHelper = this;
        synchronized (eventBroadcastHelper) {
            if (this.c[n] == null) {
                this.c[n] = new ArrayList();
                this.c[n].add(listenerInfo);
            } else {
                ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.c[n]);
                arrayList.add(listenerInfo);
                this.c[n] = arrayList;
            }
            this.busy[n] = true;
            ++this.cnt;
        }
        return listenerInfo;
    }

    public synchronized Object removeEventListener(Object object) {
        if (object == null) {
            return null;
        }
        ListenerInfo listenerInfo = (ListenerInfo)object;
        int n = listenerInfo.getType().getEvent();
        Collection collection = this.c[n];
        if (collection == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(collection);
        arrayList.remove(listenerInfo);
        this.busy[n] = !arrayList.isEmpty();
        this.c[n] = arrayList;
        EventListener eventListener = listenerInfo.getListener();
        listenerInfo.clear();
        --this.cnt;
        return eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        ArrayList arrayList = null;
        EventBroadcastHelper eventBroadcastHelper = this;
        synchronized (eventBroadcastHelper) {
            arrayList = (ArrayList)this.c[eventType.getEvent()];
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            int n3 = arrayList.size();
            if (!this.orderMaintained && this.start != null && n3 > 1) {
                n = this.start[eventType.getEvent()];
                this.start[eventType.getEvent()] = n >= n3 - 1 ? 0 : n + 1;
            }
            for (int i = 0; i < n3; ++i) {
                n2 = n == 0 ? i : (i + n) % n3;
                ListenerInfo listenerInfo = (ListenerInfo)arrayList.get(n2);
                if (listenerInfo == null) continue;
                Reason reason2 = null;
                EventListener eventListener = null;
                Object object4 = null;
                ListenerInfo listenerInfo2 = listenerInfo;
                synchronized (listenerInfo2) {
                    eventListener = listenerInfo.getListener();
                    reason2 = listenerInfo.getReason();
                    object4 = listenerInfo.getUserData();
                }
                if (eventListener == null || reason2 != null && reason2 != reason) continue;
                eventListener.eventOccured(eventType, reason, object, object2, object3, object4);
            }
        }
    }

    public boolean hasListeners(EventType eventType) {
        return this.busy[eventType.getEvent()];
    }

    public synchronized boolean hasListeners() {
        return this.cnt > 0;
    }

    class ListenerInfo {
        EventListener l;
        EventType type;
        Object userData;
        Reason reason;

        public ListenerInfo(EventListener eventListener, EventType eventType, Reason reason, Object object) {
            this.l = eventListener;
            this.type = eventType;
            this.userData = object;
            this.reason = reason;
        }

        synchronized Reason getReason() {
            return this.reason;
        }

        synchronized Object getUserData() {
            return this.userData;
        }

        synchronized EventType getType() {
            return this.type;
        }

        synchronized EventListener getListener() {
            return this.l;
        }

        synchronized void clear() {
            this.l = null;
            this.userData = null;
            this.reason = null;
            this.type = null;
        }
    }
}

