/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ObjStorePasswdDialog
extends AdminDialog
implements ActionListener {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStore os;
    private JTextField principalText;
    private JTextField credentialsText;
    private Vector missingInfo;

    public ObjStorePasswdDialog(Frame frame) {
        super(frame, acr.getString("A1025"), 81);
        this.setHelpId("conndis_object_store");
    }

    public ObjStorePasswdDialog(Frame frame, int n) {
        super(frame, acr.getString("A1025"), n);
        this.setHelpId("conndis_object_store");
    }

    public JPanel createWorkPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        LabelledComponent[] labelledComponentArray = new LabelledComponent[2];
        this.principalText = new JTextField(20);
        this.principalText.addActionListener(this);
        labelledComponentArray[0] = new LabelledComponent("java.naming.security.principal:", this.principalText);
        this.credentialsText = new JPasswordField(20);
        this.credentialsText.addActionListener(this);
        labelledComponentArray[1] = new LabelledComponent("java.naming.security.credentials:", this.credentialsText);
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    public void doOK() {
        String string = this.principalText.getText().trim();
        if (string.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", "java.naming.security.principal"), acr.getString("A1025"), 0, 0, null, close, close[0]);
            this.principalText.requestFocus();
            return;
        }
        String string2 = this.credentialsText.getText().trim();
        if (string2.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", "java.naming.security.credentials"), acr.getString("A1025"), 0, 0, null, close, close[0]);
            this.credentialsText.requestFocus();
            return;
        }
        ObjStoreAttrs objStoreAttrs = this.os.getObjStoreAttrs();
        if (!objStoreAttrs.containsKey("java.naming.security.principal")) {
            this.os.addObjStoreAttr("java.naming.security.principal", string);
        }
        if (!objStoreAttrs.containsKey("java.naming.security.credentials")) {
            this.os.addObjStoreAttr("java.naming.security.credentials", string2);
        }
        ObjAdminEvent objAdminEvent = new ObjAdminEvent(this, 8);
        objAdminEvent.setObjStore(this.os);
        objAdminEvent.setObjStoreAttrs(objStoreAttrs);
        objAdminEvent.setMissingAuthInfo(this.missingInfo);
        objAdminEvent.setOKAction(true);
        this.fireAdminEventDispatched(objAdminEvent);
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doCancel() {
        this.hide();
    }

    public void doClose() {
        this.hide();
    }

    public void doClear() {
        this.principalText.setText("");
        this.credentialsText.setText("");
    }

    public void show(ObjStore objStore, Vector vector) {
        this.os = objStore;
        this.missingInfo = vector;
        this.doClear();
        ObjStoreAttrs objStoreAttrs = objStore.getObjStoreAttrs();
        if (objStoreAttrs.containsKey("java.naming.security.credentials")) {
            this.credentialsText.setText((String)objStoreAttrs.get("java.naming.security.credentials"));
        } else {
            this.credentialsText.requestFocus();
        }
        if (objStoreAttrs.containsKey("java.naming.security.principal")) {
            this.principalText.setText((String)objStoreAttrs.get("java.naming.security.principal"));
        } else {
            this.principalText.requestFocus();
        }
        this.setDefaultButton(1);
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.principalText) {
            this.credentialsText.requestFocus();
        } else if (actionEvent.getSource() == this.credentialsText) {
            this.doOK();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

