/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ObjStoreDialog
extends AdminDialog
implements ActionListener,
ListSelectionListener {
    protected JTextField osText;
    protected LabelValuePanel lvp;
    protected ObjStoreManager osMgr = null;
    protected Properties jndiProps = new Properties();
    protected JComboBox comboBox;
    protected JCheckBox checkBox;
    protected PropsTableModel model;
    protected JButton addButton;
    protected JButton delButton;
    protected JButton chgButton;
    protected boolean dirty = false;
    protected JTextField valueText;
    protected JTable table;
    protected JTextArea ta;
    private boolean editable;
    private JLabel urlLabel;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private static String[] columnNames;

    public ObjStoreDialog(Frame frame, String string, ObjStoreListCObj objStoreListCObj) {
        super(frame, string, 81);
        if (objStoreListCObj != null) {
            this.osMgr = objStoreListCObj.getObjStoreManager();
        }
    }

    public ObjStoreDialog(Frame frame, String string, int n, ObjStoreListCObj objStoreListCObj) {
        super(frame, string, n);
        if (objStoreListCObj != null) {
            this.osMgr = objStoreListCObj.getObjStoreManager();
        }
    }

    public JPanel createWorkPanel() {
        String[] stringArray = new String[]{"java.naming.factory.initial", "java.naming.factory.object", "java.naming.factory.state", "java.naming.factory.url.pkgs", "java.naming.provider.url", "java.naming.dns.url", "java.naming.authoritative", "java.naming.batchsize", "java.naming.referral", "java.naming.security.protocol", "java.naming.security.authentication", "java.naming.security.principal", "java.naming.security.credentials", "java.naming.language", "java.naming.applet"};
        boolean bl = false;
        if (this.getTitle().equals(acr.getString("A1309"))) {
            bl = true;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JLabel jLabel = new JLabel(acr.getString("A1310") + ":");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 12;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        this.osText = new JTextField(25);
        ObjStoreDocumentListener objStoreDocumentListener = new ObjStoreDocumentListener();
        this.osText.getDocument().addDocumentListener(objStoreDocumentListener);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagLayout2.setConstraints(this.osText, gridBagConstraints2);
        jPanel3.add(this.osText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.anchor = 17;
        jPanel2.add(jPanel3);
        this.checkBox = bl ? new JCheckBox(acr.getString("A1210"), true) : new JCheckBox(acr.getString("A1209"), true);
        this.checkBox.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.checkBox, gridBagConstraints);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel2.add(jSeparator);
        JLabel jLabel2 = new JLabel(acr.getString("A1312"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        LabelledComponent[] labelledComponentArray = new LabelledComponent[3];
        this.comboBox = new JComboBox<String>(stringArray);
        this.comboBox.addActionListener(this);
        labelledComponentArray[0] = new LabelledComponent(acr.getString("A1205") + ":", this.comboBox);
        this.valueText = new JTextField(40);
        this.valueText.getDocument().addDocumentListener(objStoreDocumentListener);
        labelledComponentArray[1] = new LabelledComponent(acr.getString("A1206") + ":", this.valueText);
        this.model = new PropsTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        labelledComponentArray[2] = new LabelledComponent(" ", jScrollPane);
        this.lvp = new LabelValuePanel(labelledComponentArray, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.lvp, gridBagConstraints);
        jPanel2.add(this.lvp);
        int n = this.valueText.getPreferredSize().width;
        Dimension dimension = jScrollPane.getPreferredSize();
        this.table.getRowHeight();
        this.table.setPreferredScrollableViewportSize(new Dimension(n, 8 * this.table.getRowHeight()));
        JPanel jPanel4 = new JPanel();
        this.addButton = new JButton(acr.getString("A1083"));
        this.addButton.addActionListener(this);
        this.delButton = new JButton(acr.getString("A1084"));
        this.delButton.addActionListener(this);
        this.delButton.setEnabled(false);
        this.chgButton = new JButton(acr.getString("A1085"));
        this.chgButton.addActionListener(this);
        this.chgButton.setEnabled(false);
        jPanel4.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel4.add(this.addButton);
        jPanel4.add(this.delButton);
        jPanel4.add(this.chgButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(labelledComponentArray[0].getPreferredSize().height + labelledComponentArray[1].getPreferredSize().height + 20, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel2.add(jPanel4);
        String string = acr.getString("A2000");
        this.ta = new JTextArea(string);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        Color color = jPanel2.getBackground();
        this.ta.setBackground(color);
        Color color2 = jLabel2.getForeground();
        this.ta.setForeground(color2);
        this.ta.setFont(jLabel2.getFont());
        int n2 = jLabel.getPreferredSize().width + 5 + this.osText.getPreferredSize().width;
        int n3 = this.lvp.getPreferredSize().width;
        if (n2 >= n3) {
            this.ta.setSize(n2, 1);
        } else {
            this.ta.setSize(n3, 1);
        }
        this.ta.setEditable(false);
        Dimension dimension2 = this.ta.getPreferredSize();
        this.ta.setSize(dimension2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(this.ta, gridBagConstraints);
        jPanel2.add(this.ta);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public void doOK() {
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doCancel() {
    }

    public void doClose() {
    }

    public void doClear() {
        this.jndiProps.clear();
        this.osText.setText("");
        this.checkBox.setSelected(true);
        this.comboBox.setSelectedIndex(0);
        this.valueText.setText("");
        this.delButton.setEnabled(false);
        this.chgButton.setEnabled(false);
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.osText.requestFocus();
        this.dirty = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.doAdd();
        } else if (object == this.delButton) {
            this.doDelete();
        } else if (object == this.chgButton) {
            this.doChange();
        } else if (object == this.comboBox) {
            this.doComboBox();
            this.dirty = true;
        } else if (object == this.checkBox) {
            this.dirty = true;
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        if (!bl) {
            if (listSelectionModel.isSelectionEmpty()) {
                this.delButton.setEnabled(false);
                this.chgButton.setEnabled(false);
            } else {
                int n3 = listSelectionModel.getMinSelectionIndex();
                String string = (String)this.model.getValueAt(n3, 0);
                this.comboBox.setSelectedItem(string);
                this.valueText.setText(this.jndiProps.getProperty(string));
                if (this.isEditable()) {
                    this.delButton.setEnabled(true);
                    this.chgButton.setEnabled(true);
                }
            }
        }
    }

    public void doAdd() {
        String string;
        String string2 = this.valueText.getText().trim();
        if (string2 == null || string2.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", (String)this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3001"), 0, 0, null, close, close[0]);
            this.valueText.requestFocus();
            return;
        }
        String string3 = this.jndiProps.getProperty((String)this.comboBox.getSelectedItem());
        if (string3 != null) {
            JOptionPane.showOptionDialog(this, acr.getString("A3003", (String)this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3003"), 0, 0, null, close, close[0]);
            return;
        }
        if (((String)this.comboBox.getSelectedItem()).equals("java.naming.provider.url")) {
            this.verifyProviderURL(string2);
        }
        this.jndiProps.setProperty((String)this.comboBox.getSelectedItem(), string2);
        int n = 0;
        Enumeration<?> enumeration = this.jndiProps.propertyNames();
        while (enumeration.hasMoreElements() && !(string = (String)enumeration.nextElement()).equals((String)this.comboBox.getSelectedItem())) {
            ++n;
        }
        this.model.fireTableRowsInserted(n, n);
        this.table.setRowSelectionInterval(n, n);
    }

    public void doDelete() {
        String string;
        int n = 0;
        Enumeration<?> enumeration = this.jndiProps.propertyNames();
        while (enumeration.hasMoreElements() && !(string = (String)enumeration.nextElement()).equals((String)this.comboBox.getSelectedItem())) {
            ++n;
        }
        this.jndiProps.remove((String)this.comboBox.getSelectedItem());
        this.model.fireTableRowsDeleted(n, n);
        this.delButton.setEnabled(false);
        this.chgButton.setEnabled(false);
        this.valueText.setText("");
    }

    public void doChange() {
        String string;
        String string2 = this.valueText.getText().trim();
        if (string2 == null || string2.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", (String)this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3001"), 0, 0, null, close, close[0]);
            this.valueText.requestFocus();
            return;
        }
        if (((String)this.comboBox.getSelectedItem()).equals("java.naming.provider.url")) {
            this.verifyProviderURL(string2);
        }
        int n = 0;
        Enumeration<?> enumeration = this.jndiProps.propertyNames();
        while (enumeration.hasMoreElements() && !(string = (String)enumeration.nextElement()).equals((String)this.comboBox.getSelectedItem())) {
            ++n;
        }
        this.jndiProps.setProperty((String)this.comboBox.getSelectedItem(), string2);
        this.model.fireTableRowsUpdated(n, n);
    }

    public void doComboBox() {
        String string = (String)this.comboBox.getSelectedItem();
        if (this.jndiProps == null) {
            this.valueText.setText("");
        }
        if (string != null) {
            String string2 = this.jndiProps.getProperty(string);
            this.valueText.setText(this.jndiProps.getProperty(string));
            if (string2 != null) {
                String string3;
                int n = 0;
                Enumeration<?> enumeration = this.jndiProps.propertyNames();
                while (enumeration.hasMoreElements() && !(string3 = (String)enumeration.nextElement()).equals(string)) {
                    ++n;
                }
                this.table.setRowSelectionInterval(n, n);
                if (this.isEditable()) {
                    this.addButton.setEnabled(false);
                    this.delButton.setEnabled(true);
                    this.chgButton.setEnabled(true);
                }
            } else if (this.isEditable()) {
                this.addButton.setEnabled(true);
                this.delButton.setEnabled(false);
                this.chgButton.setEnabled(false);
            }
        } else if (string == null && this.isEditable()) {
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
        }
    }

    protected int checkMandatoryProps() {
        String[] stringArray = new String[]{"java.naming.factory.initial", "java.naming.provider.url"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.jndiProps.getProperty(stringArray[i]);
            if (string == null) {
                JOptionPane.showOptionDialog(this, acr.getString("A3021", stringArray[i]), acr.getString("A1013") + ": " + acr.getString("A1218", "A3021"), 0, 0, null, close, close[0]);
                this.comboBox.setSelectedItem(stringArray[i]);
                this.valueText.requestFocus();
                return 0;
            }
            if (!stringArray[i].equals("java.naming.factory.initial")) continue;
            try {
                Class<?> clazz = Class.forName(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showOptionDialog(this, acr.getString("A3022", string, stringArray[i]), acr.getString("A1013") + ": " + acr.getString("A1218", "A3022"), 0, 0, null, close, close[0]);
                this.comboBox.setSelectedItem(stringArray[i]);
                this.valueText.requestFocus();
                return 0;
            }
        }
        return 1;
    }

    protected String getDefaultStoreName(String string) {
        if (this.osMgr.getStore(string) == null) {
            return string;
        }
        for (int i = 1; i < 1000; ++i) {
            String string2 = string + i;
            if (this.osMgr.getStore(string2) != null) continue;
            return string2;
        }
        return "";
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected void setEditable(boolean bl) {
        this.editable = bl;
        if (bl) {
            this.osText.setEditable(true);
            this.valueText.setEditable(true);
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(true);
            this.chgButton.setEnabled(true);
            this.ta.setText(acr.getString("A2000"));
        } else {
            this.osText.setEditable(false);
            this.valueText.setEditable(false);
            this.addButton.setEnabled(false);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
            this.ta.setText(acr.getString("A2001"));
        }
    }

    private void verifyProviderURL(String string) {
        boolean bl = false;
        File file = null;
        String string2 = this.jndiProps.getProperty("java.naming.factory.initial");
        if (string2 != null && !string2.equals("") && string2.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
            bl = true;
        }
        if (!bl && string.startsWith("file:")) {
            bl = true;
        }
        if (bl) {
            try {
                URI uRI = new URI(string);
                file = new File(uRI);
            }
            catch (Exception exception) {
                try {
                    file = new File(string);
                }
                catch (Exception exception2) {
                    file = null;
                }
            }
            if (file != null && !file.isDirectory()) {
                JOptionPane.showOptionDialog(this, acr.getString("A2004", "java.naming.provider.url", string), acr.getString("A1088") + ": " + acr.getString("A1516", "A2004"), 0, 2, null, close, close[0]);
            }
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[0] = acr.getString("A1205");
        stringArray2[1] = acr.getString("A1206");
        columnNames = stringArray2;
    }

    class ObjStoreDocumentListener
    implements DocumentListener {
        ObjStoreDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ObjStoreDialog.this.dirty = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ObjStoreDialog.this.dirty = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ObjStoreDialog.this.dirty = true;
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        PropsTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            if (ObjStoreDialog.this.jndiProps == null) {
                return 0;
            }
            return ObjStoreDialog.this.jndiProps.size();
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (ObjStoreDialog.this.jndiProps == null) {
                return "";
            }
            int n3 = 0;
            Enumeration<?> enumeration = ObjStoreDialog.this.jndiProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (n2 == 0 && n3 == n) {
                    return string;
                }
                if (n2 == 1 && n3 == n) {
                    return ObjStoreDialog.this.jndiProps.getProperty(string);
                }
                ++n3;
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

