/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerAddDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestAddDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerPasswdDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerQueryDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServicePropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ConsoleBrokerAdminManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BrokerAdminHandler
implements AdminEventListener {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static AdminResources ar = Globals.getAdminResources();
    private static String[] close;
    private static String BROKERLIST_FILENAME;
    public static final boolean JMQ_RECONNECT = false;
    public static final int JMQ_RECONNECT_RETRIES = 5;
    public static final long JMQ_RECONNECT_DELAY = 5000L;
    private AdminApp app;
    private AController controller;
    private BrokerAddDialog brokerAddDialog = null;
    private BrokerDestAddDialog brokerDestAddDialog = null;
    private BrokerDestPropsDialog brokerDestPropsDialog = null;
    private BrokerServicePropsDialog brokerSvcPropsDialog = null;
    private BrokerPropsDialog brokerBkrPropsDialog = null;
    private BrokerQueryDialog brokerBkrQueryDialog = null;
    private BrokerPasswdDialog brokerPasswdDialog = null;

    public BrokerAdminHandler(AdminApp adminApp, AController aController) {
        this.app = adminApp;
        this.controller = aController;
    }

    public void init() {
        this.loadBrokerList();
    }

    public void adminEventDispatched(AdminEvent adminEvent) {
        if (adminEvent instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)adminEvent);
        } else if (adminEvent instanceof BrokerAdminEvent) {
            this.handleBrokerAdminEvents((BrokerAdminEvent)adminEvent);
        } else if (adminEvent instanceof BrokerErrorEvent) {
            this.handleBrokerErrorEvents((BrokerErrorEvent)adminEvent);
        } else if (adminEvent instanceof BrokerCmdStatusEvent) {
            this.handleBrokerCmdStatusEvent((BrokerCmdStatusEvent)adminEvent);
        }
    }

    public void handleDialogEvents(DialogEvent dialogEvent) {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        int n = dialogEvent.getDialogType();
        switch (n) {
            case 0: {
                if (consoleObj instanceof BrokerListCObj) {
                    if (this.brokerAddDialog == null) {
                        this.brokerAddDialog = new BrokerAddDialog(this.app.getFrame(), (BrokerListCObj)consoleObj);
                        this.brokerAddDialog.addAdminEventListener(this);
                        this.brokerAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.brokerAddDialog.show();
                    break;
                }
                if (!(consoleObj instanceof BrokerDestListCObj)) break;
                if (this.brokerDestAddDialog == null) {
                    this.brokerDestAddDialog = new BrokerDestAddDialog(this.app.getFrame());
                    this.brokerDestAddDialog.addAdminEventListener(this);
                    this.brokerDestAddDialog.setLocationRelativeTo(this.app.getFrame());
                }
                this.brokerDestAddDialog.show();
                break;
            }
            case 1: {
                if (consoleObj instanceof BrokerCObj) {
                    this.doDeleteBroker((BrokerCObj)consoleObj);
                    break;
                }
                if (!(consoleObj instanceof BrokerDestCObj)) break;
                this.doDeleteDestination((BrokerDestCObj)consoleObj);
                break;
            }
            case 2: {
                if (!(consoleObj instanceof BrokerDestCObj)) break;
                this.doPurgeDestination((BrokerDestCObj)consoleObj);
                break;
            }
            case 3: {
                if (consoleObj instanceof BrokerDestCObj) {
                    BrokerDestCObj brokerDestCObj;
                    if (this.brokerDestPropsDialog == null) {
                        this.brokerDestPropsDialog = new BrokerDestPropsDialog(this.app.getFrame());
                        this.brokerDestPropsDialog.addAdminEventListener(this);
                        this.brokerDestPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!this.refreshBrokerDestCObj(brokerDestCObj = (BrokerDestCObj)consoleObj)) break;
                    this.app.getInspector().selectedObjectUpdated();
                    this.brokerDestPropsDialog.show(brokerDestCObj.getDestinationInfo(), brokerDestCObj.getDurables());
                    break;
                }
                if (consoleObj instanceof BrokerServiceCObj) {
                    BrokerServiceCObj brokerServiceCObj;
                    if (this.brokerSvcPropsDialog == null) {
                        this.brokerSvcPropsDialog = new BrokerServicePropsDialog(this.app.getFrame());
                        this.brokerSvcPropsDialog.addAdminEventListener(this);
                        this.brokerSvcPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!this.refreshBrokerServiceCObj(brokerServiceCObj = (BrokerServiceCObj)consoleObj)) break;
                    this.app.getInspector().selectedObjectUpdated();
                    this.brokerSvcPropsDialog.show(brokerServiceCObj.getServiceInfo());
                    break;
                }
                if (!(consoleObj instanceof BrokerCObj)) break;
                if (this.brokerBkrPropsDialog == null) {
                    this.brokerBkrPropsDialog = new BrokerPropsDialog(this.app.getFrame());
                    this.brokerBkrPropsDialog.addAdminEventListener(this);
                    this.brokerBkrPropsDialog.setLocationRelativeTo(this.app.getFrame());
                }
                BrokerCObj brokerCObj = (BrokerCObj)consoleObj;
                this.brokerBkrPropsDialog.setBrokerCObj(brokerCObj);
                this.brokerBkrPropsDialog.show();
                break;
            }
            case 8: {
                if (!(consoleObj instanceof BrokerCObj)) break;
                this.doConnectToBroker((BrokerCObj)consoleObj);
                break;
            }
            case 9: {
                if (!(consoleObj instanceof BrokerCObj)) break;
                this.doDisconnectFromBroker((BrokerCObj)consoleObj);
                break;
            }
            case 4: {
                if (!(consoleObj instanceof BrokerCObj)) break;
                this.doShutdownBroker((BrokerCObj)consoleObj);
                break;
            }
            case 5: {
                if (!(consoleObj instanceof BrokerCObj)) break;
                this.doRestartBroker((BrokerCObj)consoleObj);
                break;
            }
            case 6: {
                if (consoleObj instanceof BrokerServiceCObj) {
                    this.doPauseService((BrokerServiceCObj)consoleObj);
                    break;
                }
                if (consoleObj instanceof BrokerCObj) {
                    this.doPauseBroker((BrokerCObj)consoleObj);
                    break;
                }
                if (consoleObj instanceof BrokerDestCObj) {
                    this.doPauseDest((BrokerDestCObj)consoleObj);
                    break;
                }
                if (!(consoleObj instanceof BrokerDestListCObj)) break;
                this.doPauseAllDests((BrokerDestListCObj)consoleObj);
                break;
            }
            case 7: {
                if (consoleObj instanceof BrokerServiceCObj) {
                    this.doResumeService((BrokerServiceCObj)consoleObj);
                    break;
                }
                if (consoleObj instanceof BrokerCObj) {
                    this.doResumeBroker((BrokerCObj)consoleObj);
                    break;
                }
                if (consoleObj instanceof BrokerDestCObj) {
                    this.doResumeDest((BrokerDestCObj)consoleObj);
                    break;
                }
                if (!(consoleObj instanceof BrokerDestListCObj)) break;
                this.doResumeAllDests((BrokerDestListCObj)consoleObj);
                break;
            }
            case 10: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A1222"), acr.getString("A1223"), 0, 1, null, close, close[0]);
            }
        }
    }

    public void handleBrokerAdminEvents(BrokerAdminEvent brokerAdminEvent) {
        int n = brokerAdminEvent.getType();
        ConsoleBrokerAdminManager consoleBrokerAdminManager = this.app.getBrokerListCObj().getBrokerAdminManager();
        ConsoleObj consoleObj = this.app.getSelectedObj();
        switch (n) {
            case 1: {
                BrokerAdmin brokerAdmin;
                if (!(consoleObj instanceof BrokerListCObj)) break;
                try {
                    brokerAdmin = new BrokerAdmin(brokerAdminEvent.getHost(), brokerAdminEvent.getPort(), brokerAdminEvent.getUsername(), brokerAdminEvent.getPassword(), -1L, false, 5, 5000L);
                    brokerAdmin.setKey(brokerAdminEvent.getBrokerName());
                }
                catch (BrokerAdminException brokerAdminException) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3051", brokerAdminEvent.getBrokerName()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1016") + ": " + acr.getString("A1218", "A3051"), 0, 0, null, close, close[0]);
                    return;
                }
                catch (Exception exception) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3051", brokerAdminEvent.getBrokerName()) + exception.toString(), acr.getString("A1016") + ": " + acr.getString("A1218", "A3051"), 0, 0, null, close, close[0]);
                    return;
                }
                if (consoleBrokerAdminManager.exist(brokerAdmin.getKey())) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3025", brokerAdmin.getKey()), acr.getString("A1016") + ": " + acr.getString("A1218", "A3025"), 0, 0, null, close, close[0]);
                    return;
                }
                BrokerCObj brokerCObj = new BrokerCObj(brokerAdmin);
                consoleBrokerAdminManager.addBrokerAdmin(brokerAdmin);
                this.app.getExplorer().addBroker(brokerCObj);
                this.app.getInspector().refresh();
                this.saveBrokerList();
                if (!brokerAdminEvent.isOKAction()) break;
                this.brokerAddDialog.hide();
                break;
            }
            case 2: {
                if (!(consoleObj instanceof BrokerDestListCObj)) break;
                BrokerDestCObj brokerDestCObj = null;
                BrokerCObj brokerCObj = ((BrokerDestListCObj)consoleObj).getBrokerCObj();
                brokerDestCObj = this.addDestination(brokerCObj, brokerAdminEvent);
                if (brokerDestCObj == null) {
                    return;
                }
                this.app.getExplorer().addToParent(consoleObj, brokerDestCObj);
                this.app.getInspector().refresh();
                if (!brokerAdminEvent.isOKAction()) break;
                this.brokerDestAddDialog.hide();
                break;
            }
            case 3: {
                this.doUpdateLogin(brokerAdminEvent, consoleObj);
                break;
            }
            case 4: {
                this.doUpdateBroker(brokerAdminEvent, consoleObj);
                break;
            }
            case 5: {
                this.doDeleteDurable(brokerAdminEvent, consoleObj);
                break;
            }
            case 10: {
                this.doPurgeDurable(brokerAdminEvent, consoleObj);
                break;
            }
            case 6: {
                this.doUpdateService(brokerAdminEvent, consoleObj);
                break;
            }
            case 7: {
                this.doUpdateDestination(brokerAdminEvent, consoleObj);
                break;
            }
            case 8: {
                this.doQueryBroker(brokerAdminEvent, consoleObj);
                break;
            }
            case 9: {
                this.doUpdateBrokerEntry(brokerAdminEvent, consoleObj);
            }
        }
    }

    private void handleBrokerErrorEvents(BrokerErrorEvent brokerErrorEvent) {
        int n = brokerErrorEvent.getType();
        BrokerListCObj brokerListCObj = this.app.getBrokerListCObj();
        String string = brokerErrorEvent.getBrokerHost();
        String string2 = brokerErrorEvent.getBrokerPort();
        String string3 = brokerErrorEvent.getBrokerName();
        Object[] objectArray = new String[]{string, string2, string3};
        switch (n) {
            case 0: 
            case 1: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3047", objectArray), acr.getString("A1094") + ": " + acr.getString("A1218", "A3047"), 0, 0, null, close, close[0]);
                break;
            }
            case 2: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3048", objectArray), acr.getString("A1094") + ": " + acr.getString("A1218", "A3048"), 0, 0, null, close, close[0]);
            }
        }
        Enumeration<TreeNode> enumeration = brokerListCObj.children();
        while (enumeration.hasMoreElements()) {
            ConsoleObj consoleObj = (ConsoleObj)enumeration.nextElement();
            if (!(consoleObj instanceof BrokerCObj)) continue;
            BrokerCObj brokerCObj = (BrokerCObj)consoleObj;
            if (string3 == null || !string3.equals(brokerCObj.getExplorerLabel())) continue;
            brokerCObj.setBrokerProps(null);
            this.clearBroker(brokerCObj);
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.controller.setActions(brokerCObj);
        }
        this.app.getInspector().refresh();
    }

    private void handleBrokerCmdStatusEvent(BrokerCmdStatusEvent brokerCmdStatusEvent) {
        String string;
        int n = brokerCmdStatusEvent.getType();
        BrokerAdmin brokerAdmin = brokerCmdStatusEvent.getBrokerAdmin();
        boolean bl = brokerCmdStatusEvent.getSuccess();
        Exception exception = brokerCmdStatusEvent.getLinkedException();
        String string2 = brokerCmdStatusEvent.getDestinationName();
        String string3 = brokerCmdStatusEvent.getServiceName();
        String string4 = brokerCmdStatusEvent.getClientID();
        String string5 = brokerCmdStatusEvent.getDurableName();
        String string6 = brokerAdmin.getKey();
        DestinationInfo destinationInfo = brokerCmdStatusEvent.getDestinationInfo();
        ServiceInfo serviceInfo = brokerCmdStatusEvent.getServiceInfo();
        Object object = brokerAdmin.getAssociatedObj();
        if (n == 31) {
            int n2 = brokerCmdStatusEvent.getNumRetriesAttempted();
            int n3 = brokerCmdStatusEvent.getMaxNumRetries();
            long l = brokerCmdStatusEvent.getRetryTimeount();
            Object[] objectArray = new Object[]{Integer.toString(n2), Integer.toString(n3), Long.toString(l)};
            String string7 = ar.getString("A1350", objectArray);
            this.app.getStatusArea().appendText(string7 + "\n");
            return;
        }
        if (n == 1 || n == 7 || n == 17 || n == 11) {
            if (object instanceof BrokerCObj) {
                this.app.getExplorer().nodeChanged((DefaultMutableTreeNode)object);
                this.controller.setActions((BrokerCObj)object);
            }
            return;
        }
        int n4 = bl ? 1 : 0;
        String string8 = acr.getString("A1511");
        switch (n) {
            case 22: {
                if (bl) {
                    string = acr.getString("A6022", string6);
                    if (!(object instanceof BrokerCObj)) break;
                    BrokerCObj brokerCObj = (BrokerCObj)object;
                    brokerAdmin.setIsConnected(true);
                    if (!this.refreshBrokerServiceListCObj(brokerCObj.getBrokerServiceListCObj()) || !this.refreshBrokerDestListCObj(brokerCObj.getBrokerDestListCObj())) break;
                    this.app.getExplorer().nodeChanged(brokerCObj);
                    this.app.getInspector().refresh();
                    this.controller.setActions(brokerCObj);
                    break;
                }
                string = acr.getString("A3063", string6);
                break;
            }
            case 9: {
                if (bl) {
                    string = acr.getString("A6019", destinationInfo.name, string6);
                    if (!(object instanceof BrokerCObj)) break;
                    BrokerCObj brokerCObj = (BrokerCObj)object;
                    BrokerDestListCObj brokerDestListCObj = brokerCObj.getBrokerDestListCObj();
                    BrokerDestCObj brokerDestCObj = new BrokerDestCObj(brokerCObj, destinationInfo);
                    this.app.getExplorer().addToParent(brokerDestListCObj, brokerDestCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                string = acr.getString("A3069", destinationInfo.name, string6);
                break;
            }
            case 0: {
                if (bl) {
                    string = acr.getString("A6020", string2, string6);
                    if (!(object instanceof BrokerDestCObj)) break;
                    this.app.getExplorer().removeFromParent((BrokerDestCObj)object);
                    this.app.getInspector().refresh();
                    break;
                }
                string = acr.getString("A3058", string2, string6);
                break;
            }
            case 13: {
                if (bl) {
                    string = acr.getString("A6027", destinationInfo.name);
                    break;
                }
                string = acr.getString("A3072", destinationInfo.name);
                break;
            }
            case 10: {
                if (bl) {
                    string = acr.getString("A6021", string2, string6);
                    break;
                }
                string = acr.getString("A3060", string2, string6);
                break;
            }
            case 18: {
                if (bl) {
                    string = acr.getString("A6025", string5, string4);
                    if (!(object instanceof BrokerDestCObj)) break;
                    BrokerDestCObj brokerDestCObj = (BrokerDestCObj)object;
                    this.refreshBrokerDestCObj(brokerDestCObj, 5);
                    Vector vector = brokerDestCObj.getDurables();
                    if (vector == null) break;
                    this.brokerDestPropsDialog.refresh(vector);
                    break;
                }
                string = acr.getString("A3061", string5, string4);
                break;
            }
            case 8: {
                if (bl) {
                    BrokerDestListCObj brokerDestListCObj;
                    string = acr.getString("A6012", string6);
                    Object object2 = brokerCmdStatusEvent.getReturnedObject();
                    if (!(object2 instanceof Vector)) break;
                    Vector vector = (Vector)object2;
                    if (object instanceof BrokerDestListCObj) {
                        brokerDestListCObj = (BrokerDestListCObj)object;
                    } else if (object instanceof BrokerCObj) {
                        BrokerCObj brokerCObj = (BrokerCObj)object;
                        brokerDestListCObj = brokerCObj.getBrokerDestListCObj();
                    } else {
                        return;
                    }
                    this.refreshBrokerDestList(vector, brokerDestListCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                string = acr.getString("A3033");
                break;
            }
            case 3: {
                if (bl) {
                    BrokerServiceCObj brokerServiceCObj;
                    string = acr.getString("A6013", string3, string6);
                    if (!(object instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj(brokerServiceCObj = (BrokerServiceCObj)object)) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(brokerServiceCObj);
                    break;
                }
                string = acr.getString("A3027", string3);
                break;
            }
            case 5: {
                if (bl) {
                    BrokerServiceCObj brokerServiceCObj;
                    string = acr.getString("A6014", string3, string6);
                    if (!(object instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj(brokerServiceCObj = (BrokerServiceCObj)object)) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(brokerServiceCObj);
                    break;
                }
                string = acr.getString("A3028", string3);
                break;
            }
            case 14: {
                if (bl) {
                    string = acr.getString("A6026", serviceInfo.name);
                    if (!(object instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj((BrokerServiceCObj)object)) break;
                    this.app.getInspector().refresh();
                    break;
                }
                string = acr.getString("A3065", serviceInfo.name);
                break;
            }
            case 2: {
                if (bl) {
                    BrokerServiceListCObj brokerServiceListCObj;
                    string = acr.getString("A6011", string6);
                    Object object3 = brokerCmdStatusEvent.getReturnedObject();
                    if (!(object3 instanceof Vector)) break;
                    Vector vector = (Vector)object3;
                    if (object instanceof BrokerServiceListCObj) {
                        brokerServiceListCObj = (BrokerServiceListCObj)object;
                    } else if (object instanceof BrokerCObj) {
                        BrokerCObj brokerCObj = (BrokerCObj)object;
                        brokerServiceListCObj = brokerCObj.getBrokerServiceListCObj();
                    } else {
                        return;
                    }
                    this.refreshBrokerServiceList(vector, brokerServiceListCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                string = acr.getString("A3032");
                break;
            }
            case 4: {
                if (bl) {
                    BrokerCObj brokerCObj;
                    string = acr.getString("A6015", string6);
                    if (!(object instanceof BrokerCObj) || !this.refreshBrokerServiceListCObj((brokerCObj = (BrokerCObj)object).getBrokerServiceListCObj())) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(brokerCObj);
                    break;
                }
                string = acr.getString("A3029", string6);
                break;
            }
            case 6: {
                if (bl) {
                    BrokerCObj brokerCObj;
                    string = acr.getString("A6016", string6);
                    if (!(object instanceof BrokerCObj) || !this.refreshBrokerServiceListCObj((brokerCObj = (BrokerCObj)object).getBrokerServiceListCObj())) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(brokerCObj);
                    break;
                }
                string = acr.getString("A3030", string6);
                break;
            }
            case 12: {
                if (bl) {
                    string = acr.getString("A6024", string6);
                    break;
                }
                string = acr.getString("A3064", string6);
                break;
            }
            default: {
                string = acr.getString("A1512", string6);
            }
        }
        if (!bl) {
            string = exception instanceof BrokerAdminException ? string + "\n" + this.printBrokerAdminExceptionDetails((BrokerAdminException)exception) : string + "\n" + exception.toString();
        }
        JOptionPane.showOptionDialog(this.app.getFrame(), string, string8, 0, n4, null, close, close[0]);
    }

    private void doConnectToBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        brokerAdmin.setReconnect(false);
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerCObj);
        }
        boolean bl = false;
        if (brokerAdmin.getUserName().length() == 0) {
            bl = true;
        }
        if (brokerAdmin.getPassword().length() == 0) {
            bl = true;
        }
        if (bl) {
            if (this.brokerPasswdDialog == null) {
                this.brokerPasswdDialog = new BrokerPasswdDialog(this.app.getFrame());
                this.brokerPasswdDialog.addAdminEventListener(this);
                this.brokerPasswdDialog.setLocationRelativeTo(this.app.getFrame());
            }
            this.brokerPasswdDialog.show(brokerAdmin);
        } else if (this.connectToBroker(brokerAdmin)) {
            if (!this.refreshBrokerCObj(brokerCObj)) {
                return;
            }
            if (!this.populateBrokerServices(brokerCObj)) {
                return;
            }
            if (!this.populateBrokerDestinations(brokerCObj)) {
                return;
            }
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.app.getInspector().refresh();
            this.controller.setActions(brokerCObj);
        } else {
            return;
        }
    }

    private boolean connectToBroker(BrokerAdmin brokerAdmin) {
        return this.connectToBroker(brokerAdmin, null, null, false);
    }

    private boolean connectToBroker(BrokerAdmin brokerAdmin, String string, String string2, boolean bl) {
        try {
            if (bl) {
                brokerAdmin.connect(string, string2);
            } else {
                brokerAdmin.connect();
            }
            brokerAdmin.addAdminEventListener(this);
            brokerAdmin.setInitiator(false);
            brokerAdmin.sendHelloMessage();
            brokerAdmin.receiveHelloReplyMessage();
            if (brokerAdmin.isReconnect()) {
                this.app.getStatusArea().appendText(acr.getString("A6018", brokerAdmin.getKey()));
            } else {
                this.app.getStatusArea().appendText(acr.getString("A6022", brokerAdmin.getKey()));
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            if (11 == brokerAdminException.getType()) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3040"), acr.getString("A1026") + ": " + acr.getString("A1218", "A3040"), 0, 0, null, close, close[0]);
            } else if (12 == brokerAdminException.getType()) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3041"), acr.getString("A1026") + ": " + acr.getString("A1218", "A3041"), 0, 0, null, close, close[0]);
            } else {
                Object[] objectArray = new Object[]{brokerAdmin.getKey(), brokerAdmin.getBrokerHost(), brokerAdmin.getBrokerPort(), this.printBrokerAdminExceptionDetails(brokerAdminException)};
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3045", objectArray), acr.getString("A1026") + ": " + acr.getString("A1218", "A3045"), 0, 0, null, close, close[0]);
                if (this.brokerPasswdDialog != null) {
                    this.brokerPasswdDialog.hide();
                }
            }
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3063", brokerAdmin.getKey()) + exception.toString(), acr.getString("A1026") + ": " + acr.getString("A1218", "A3063"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doUpdateLogin(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        if (consoleObj instanceof BrokerCObj) {
            String string;
            String string2;
            BrokerCObj brokerCObj = (BrokerCObj)consoleObj;
            BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
            if (this.connectToBroker(brokerAdmin, string2 = brokerAdminEvent.getUsername(), string = brokerAdminEvent.getPassword(), true)) {
                if (!this.refreshBrokerCObj(brokerCObj)) {
                    return;
                }
                if (!this.populateBrokerServices(brokerCObj)) {
                    return;
                }
                if (!this.populateBrokerDestinations(brokerCObj)) {
                    return;
                }
            } else {
                return;
            }
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.app.getInspector().refresh();
            this.brokerPasswdDialog.hide();
            this.controller.setActions(brokerCObj);
        }
    }

    private void doUpdateBroker(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        Properties properties = brokerAdminEvent.getBrokerProps();
        if (!(consoleObj instanceof BrokerCObj)) {
            return;
        }
        BrokerCObj brokerCObj = (BrokerCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerCObj);
        }
        try {
            brokerAdmin.sendUpdateBrokerPropsMessage(properties);
            brokerAdmin.receiveUpdateBrokerPropsReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6024", brokerAdmin.getKey()));
            if (brokerAdminEvent.isOKAction()) {
                this.brokerBkrQueryDialog.hide();
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3064", brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1505") + ": " + acr.getString("A1218", "A3064"), 0, 0, null, close, close[0]);
        }
    }

    private void doDeleteDurable(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        String string = null;
        String string2 = null;
        if (!(consoleObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj brokerDestCObj = (BrokerDestCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestCObj);
        }
        string = brokerAdminEvent.getDurableName();
        string2 = brokerAdminEvent.getClientID();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5013", string, string2), acr.getString("A1514"), 0);
        if (n == 1) {
            return;
        }
        try {
            brokerAdmin.sendDestroyDurableMessage(string, string2);
            brokerAdmin.receiveDestroyDurableReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6025", string, string2));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3061", string, string2) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1514") + ": " + acr.getString("A1218", "A3061"), 0, 0, null, close, close[0]);
            return;
        }
        this.refreshBrokerDestCObj(brokerDestCObj, brokerAdminEvent.getType());
        Vector vector = brokerDestCObj.getDurables();
        if (vector != null) {
            this.brokerDestPropsDialog.refresh(vector);
        }
    }

    private void doPurgeDurable(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        String string = null;
        String string2 = null;
        if (!(consoleObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj brokerDestCObj = (BrokerDestCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestCObj);
        }
        string = brokerAdminEvent.getDurableName();
        string2 = brokerAdminEvent.getClientID();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5015", string, string2), acr.getString("A1515"), 0);
        if (n == 1) {
            return;
        }
        try {
            brokerAdmin.sendPurgeDurableMessage(string, string2);
            brokerAdmin.receivePurgeDurableReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6035", string, string2));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3074", string, string2) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1514") + ": " + acr.getString("A1218", "A3074"), 0, 0, null, close, close[0]);
            return;
        }
        this.refreshBrokerDestCObj(brokerDestCObj, brokerAdminEvent.getType());
        Vector vector = brokerDestCObj.getDurables();
        if (vector != null) {
            this.brokerDestPropsDialog.refresh(vector);
        }
    }

    private void doUpdateService(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        String string = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (!(consoleObj instanceof BrokerServiceCObj)) {
            return;
        }
        BrokerServiceCObj brokerServiceCObj = (BrokerServiceCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerServiceCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerServiceCObj);
        }
        string = brokerServiceCObj.getServiceInfo().name;
        n = brokerAdminEvent.getPort();
        n2 = brokerAdminEvent.getMinThreads();
        n3 = brokerAdminEvent.getMaxThreads();
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setName(string);
        serviceInfo.setPort(n);
        serviceInfo.setMinThreads(n2);
        serviceInfo.setMaxThreads(n3);
        try {
            brokerAdmin.sendUpdateServiceMessage(serviceInfo);
            brokerAdmin.receiveUpdateServiceReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6026", string));
            if (brokerAdminEvent.isOKAction()) {
                this.brokerSvcPropsDialog.hide();
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3065", string) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1409") + ": " + acr.getString("A1218", "A3065"), 0, 0, null, close, close[0]);
            return;
        }
        if (this.refreshBrokerServiceCObj(brokerServiceCObj)) {
            this.app.getInspector().selectedObjectUpdated();
            this.controller.setActions(brokerServiceCObj);
        }
    }

    private void doUpdateDestination(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        String string = null;
        int n = -1;
        if (!(consoleObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj brokerDestCObj = (BrokerDestCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestCObj);
        }
        string = brokerDestCObj.getDestinationInfo().name;
        n = brokerDestCObj.getDestinationInfo().type;
        DestinationInfo destinationInfo = brokerAdminEvent.getDestinationInfo();
        destinationInfo.setName(string);
        destinationInfo.setType(n);
        try {
            brokerAdmin.sendUpdateDestinationMessage(destinationInfo);
            brokerAdmin.receiveUpdateDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6027", string));
            if (brokerAdminEvent.isOKAction()) {
                this.brokerDestPropsDialog.hide();
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3072", string) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1408") + ": " + acr.getString("A1218", "A3072"), 0, 0, null, close, close[0]);
            return;
        }
        if (this.refreshBrokerDestCObj(brokerDestCObj, brokerAdminEvent.getType())) {
            this.app.getInspector().selectedObjectUpdated();
            this.controller.setActions(brokerDestCObj);
        }
    }

    private void doQueryBroker(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        BrokerCObj brokerCObj;
        if (!(consoleObj instanceof BrokerCObj)) {
            return;
        }
        if (this.brokerBkrQueryDialog == null) {
            this.brokerBkrQueryDialog = new BrokerQueryDialog(this.app.getFrame());
            this.brokerBkrQueryDialog.addAdminEventListener(this);
            this.brokerBkrQueryDialog.setLocationRelativeTo(this.app.getFrame());
        }
        if (this.refreshBrokerCObj(brokerCObj = (BrokerCObj)consoleObj)) {
            this.brokerBkrQueryDialog.show(brokerCObj);
        }
    }

    private void doUpdateBrokerEntry(BrokerAdminEvent brokerAdminEvent, ConsoleObj consoleObj) {
        ConsoleBrokerAdminManager consoleBrokerAdminManager = this.app.getBrokerListCObj().getBrokerAdminManager();
        String string = brokerAdminEvent.getBrokerName();
        if (!(consoleObj instanceof BrokerCObj)) {
            return;
        }
        BrokerCObj brokerCObj = (BrokerCObj)consoleObj;
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        String string2 = brokerAdmin.getKey();
        String string3 = brokerAdmin.getBrokerHost();
        String string4 = brokerAdmin.getBrokerPort();
        String string5 = brokerAdmin.getUserName();
        String string6 = brokerAdmin.getPassword();
        if (!string2.equals(string) && consoleBrokerAdminManager.exist(string)) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3025", string), acr.getString("A1410") + ": " + acr.getString("A1218", "A3025"), 0, 0, null, close, close[0]);
            return;
        }
        try {
            brokerAdmin.setKey(brokerAdminEvent.getBrokerName());
            brokerAdmin.setBrokerHost(brokerAdminEvent.getHost());
            brokerAdmin.setBrokerPort(Integer.toString(brokerAdminEvent.getPort()));
            brokerAdmin.setUserName(brokerAdminEvent.getUsername());
            brokerAdmin.setPassword(brokerAdminEvent.getPassword());
        }
        catch (BrokerAdminException brokerAdminException) {
            int n = brokerAdminException.getType();
            String string7 = brokerAdminException.getBadValue();
            String string8 = "A3038";
            try {
                brokerAdmin.setKey(string2);
                brokerAdmin.setBrokerHost(string3);
                brokerAdmin.setBrokerPort(string4);
                brokerAdmin.setUserName(string5);
                brokerAdmin.setPassword(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n) {
                case 9: {
                    string8 = "A3039";
                    break;
                }
                case 10: {
                    string8 = "A3038";
                }
            }
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString(string8, string7), acr.getString("A1410") + ": " + acr.getString("A1218", string8), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getExplorer().nodeChanged(consoleObj);
        this.app.getStatusArea().appendText(acr.getString("A6033", consoleObj.toString()));
        this.app.getInspector().selectedObjectUpdated();
        this.saveBrokerList();
        if (brokerAdminEvent.isOKAction()) {
            this.brokerBkrPropsDialog.hide();
        }
    }

    private boolean reconnectToBroker(BrokerCObj brokerCObj) throws BrokerAdminException {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        boolean bl = false;
        int n = 0;
        while (!bl && n < 5) {
            try {
                ++n;
                brokerAdmin.connect();
                brokerAdmin.sendHelloMessage();
                brokerAdmin.receiveHelloReplyMessage();
                bl = true;
                brokerAdmin.addAdminEventListener(this);
                brokerAdmin.setInitiator(false);
            }
            catch (BrokerAdminException brokerAdminException) {
                if (brokerAdminException.getType() == 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", brokerAdmin.getKey()) + interruptedException.toString(), acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                        this.app.getExplorer().nodeChanged(brokerCObj);
                        this.controller.setActions(brokerCObj);
                    }
                } else {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", brokerAdmin.getKey()) + brokerAdminException.toString(), acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                    this.app.getExplorer().nodeChanged(brokerCObj);
                    this.controller.setActions(brokerCObj);
                }
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", brokerAdmin.getKey()) + exception.toString(), acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                this.app.getExplorer().nodeChanged(brokerCObj);
                this.controller.setActions(brokerCObj);
            }
            if (n < 5) continue;
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3026"), acr.getString("A1026") + ": " + acr.getString("A1218", "A3026"), 0, 0, null, close, close[0]);
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.controller.setActions(brokerCObj);
        }
        return bl;
    }

    private void doDisconnectFromBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        if (brokerAdmin == null) {
            return;
        }
        if (brokerAdmin.isBusy()) {
            Object[] objectArray = new Object[]{brokerAdmin.getKey(), brokerAdmin.getBrokerHost(), brokerAdmin.getBrokerPort()};
            String string = acr.getString("A1513", objectArray);
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3070") + string, acr.getString("A1029"), 0, 0, null, close, close[0]);
            return;
        }
        brokerAdmin.removeAdminEventListener(this);
        brokerAdmin.setReconnect(false);
        if (brokerAdmin == null || !this.disconnectFromBroker(brokerAdmin)) {
            return;
        }
        brokerCObj.setBrokerProps(null);
        this.clearBroker(brokerCObj);
        this.app.getExplorer().nodeChanged(brokerCObj);
        this.app.getInspector().refresh();
        this.controller.setActions(brokerCObj);
    }

    private boolean disconnectFromBroker(BrokerAdmin brokerAdmin) {
        brokerAdmin.close();
        this.app.getStatusArea().appendText(acr.getString("A6023", brokerAdmin.getKey()));
        return true;
    }

    private boolean populateBrokerServices(BrokerCObj brokerCObj) {
        BrokerServiceListCObj brokerServiceListCObj = null;
        brokerServiceListCObj = brokerCObj.getBrokerServiceListCObj();
        return this.refreshBrokerServiceListCObj(brokerServiceListCObj);
    }

    private boolean refreshBrokerServiceListCObj(BrokerServiceListCObj brokerServiceListCObj) {
        Vector vector = null;
        BrokerCObj brokerCObj = brokerServiceListCObj.getBrokerCObj();
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerServiceListCObj);
        }
        try {
            brokerAdmin.sendGetServicesMessage(null);
            vector = brokerAdmin.receiveGetServicesReplyMessage();
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3032") + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1500") + ": " + acr.getString("A1218", "A3032"), 0, 0, null, close, close[0]);
            return false;
        }
        this.refreshBrokerServiceList(vector, brokerServiceListCObj);
        return true;
    }

    private void refreshBrokerServiceList(Vector vector, BrokerServiceListCObj brokerServiceListCObj) {
        BrokerCObj brokerCObj = brokerServiceListCObj.getBrokerCObj();
        if (vector != null) {
            if (brokerServiceListCObj != null) {
                brokerServiceListCObj.removeAllChildren();
            }
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ServiceInfo serviceInfo = (ServiceInfo)enumeration.nextElement();
                BrokerServiceCObj brokerServiceCObj = new BrokerServiceCObj(brokerCObj, serviceInfo);
                brokerServiceListCObj.insert(brokerServiceCObj, n++);
            }
        }
    }

    private boolean refreshBrokerServiceCObj(BrokerServiceCObj brokerServiceCObj) {
        ServiceInfo serviceInfo = brokerServiceCObj.getServiceInfo();
        BrokerAdmin brokerAdmin = brokerServiceCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerServiceCObj);
        }
        Vector vector = null;
        try {
            brokerAdmin.sendGetServicesMessage(serviceInfo.name);
            vector = brokerAdmin.receiveGetServicesReplyMessage(false);
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3034", serviceInfo.name) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1409") + ": " + acr.getString("A1218", "A3034"), 0, 0, null, close, close[0]);
            return false;
        }
        if (vector != null && vector.size() == 1) {
            Enumeration enumeration = vector.elements();
            ServiceInfo serviceInfo2 = (ServiceInfo)enumeration.nextElement();
            brokerServiceCObj.setServiceInfo(serviceInfo2);
            return true;
        }
        return false;
    }

    private boolean populateBrokerDestinations(BrokerCObj brokerCObj) {
        BrokerDestListCObj brokerDestListCObj = null;
        brokerDestListCObj = brokerCObj.getBrokerDestListCObj();
        return this.refreshBrokerDestListCObj(brokerDestListCObj);
    }

    private boolean refreshBrokerDestListCObj(BrokerDestListCObj brokerDestListCObj) {
        Vector vector = null;
        BrokerCObj brokerCObj = brokerDestListCObj.getBrokerCObj();
        BrokerAdmin brokerAdmin = brokerDestListCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestListCObj);
        }
        try {
            brokerAdmin.sendGetDestinationsMessage(null, -1);
            vector = brokerAdmin.receiveGetDestinationsReplyMessage();
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3033") + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1501") + ": " + acr.getString("A1218", "A3033"), 0, 0, null, close, close[0]);
            return false;
        }
        this.refreshBrokerDestList(vector, brokerDestListCObj);
        return true;
    }

    private void refreshBrokerDestList(Vector vector, BrokerDestListCObj brokerDestListCObj) {
        BrokerCObj brokerCObj = brokerDestListCObj.getBrokerCObj();
        if (vector != null) {
            if (brokerDestListCObj != null) {
                brokerDestListCObj.removeAllChildren();
            }
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                DestinationInfo destinationInfo = (DestinationInfo)enumeration.nextElement();
                if (DestType.isTemporary(destinationInfo.type) || "__JMQAdmin".equals(destinationInfo.name) || DestType.isInternal(destinationInfo.fulltype)) continue;
                BrokerDestCObj brokerDestCObj = new BrokerDestCObj(brokerCObj, destinationInfo);
                brokerDestListCObj.insert(brokerDestCObj, n++);
            }
        }
    }

    private boolean refreshBrokerDestCObj(BrokerDestCObj brokerDestCObj) {
        return this.refreshBrokerDestCObj(brokerDestCObj, -1);
    }

    private boolean refreshBrokerDestCObj(BrokerDestCObj brokerDestCObj, int n) {
        DestinationInfo destinationInfo = brokerDestCObj.getDestinationInfo();
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestCObj);
        }
        Vector vector = null;
        Vector vector2 = null;
        boolean bl = false;
        try {
            brokerAdmin.sendGetDurablesMessage(destinationInfo.name, null);
            vector2 = brokerAdmin.receiveGetDurablesReplyMessage(false);
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3036", destinationInfo.name) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1408") + ": " + acr.getString("A1218", "A3036"), 0, 0, null, close, close[0]);
            return false;
        }
        if (vector2.size() >= 0) {
            brokerDestCObj.setDurables(vector2);
            bl = true;
        }
        try {
            brokerAdmin.sendGetDestinationsMessage(destinationInfo.name, destinationInfo.type);
            vector = brokerAdmin.receiveGetDestinationsReplyMessage(false);
        }
        catch (BrokerAdminException brokerAdminException) {
            if (n == 5 || n == 7) {
                return false;
            }
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3035", destinationInfo.name) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1408") + ": " + acr.getString("A1218", "A3035"), 0, 0, null, close, close[0]);
            return false;
        }
        if (vector != null && vector.size() == 1) {
            Enumeration enumeration = vector.elements();
            DestinationInfo destinationInfo2 = (DestinationInfo)enumeration.nextElement();
            if (!(DestType.isTemporary(destinationInfo2.type) || DestType.isInternal(destinationInfo2.fulltype) || "__JMQAdmin".equals(destinationInfo2.name))) {
                brokerDestCObj.setDestinationInfo(destinationInfo2);
            }
            bl = true;
        }
        return bl;
    }

    private void clearBroker(BrokerCObj brokerCObj) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = brokerCObj.children();
        while (enumeration.hasMoreElements()) {
            ConsoleObj consoleObj = (ConsoleObj)enumeration.nextElement();
            if (consoleObj instanceof BrokerDestListCObj) {
                defaultMutableTreeNode = (BrokerDestListCObj)consoleObj;
                continue;
            }
            if (!(consoleObj instanceof BrokerServiceListCObj)) continue;
            defaultMutableTreeNode2 = (BrokerServiceListCObj)consoleObj;
        }
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.removeAllChildren();
        }
        if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode2.removeAllChildren();
        }
    }

    private void doDeleteBroker(BrokerCObj brokerCObj) {
        ConsoleBrokerAdminManager consoleBrokerAdminManager = this.app.getBrokerListCObj().getBrokerAdminManager();
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5004", brokerAdmin.getKey()), acr.getString("A1022"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            consoleBrokerAdminManager.deleteBrokerAdmin(brokerAdmin);
            this.saveBrokerList();
            brokerAdmin.close();
            this.app.getExplorer().removeFromParent(brokerCObj);
            this.controller.clearSelection();
        }
    }

    private void doPauseService(BrokerServiceCObj brokerServiceCObj) {
        BrokerAdmin brokerAdmin = brokerServiceCObj.getBrokerAdmin();
        ServiceInfo serviceInfo = brokerServiceCObj.getServiceInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5005", serviceInfo.name, brokerAdmin.getKey()), acr.getString("A1032"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerServiceCObj);
            }
            if (this.pauseService(brokerAdmin, serviceInfo.name)) {
                serviceInfo = this.queryServiceInfo(brokerAdmin, serviceInfo.name);
                if (serviceInfo != null) {
                    brokerServiceCObj.setServiceInfo(serviceInfo);
                    this.app.getInspector().selectedObjectUpdated();
                }
                this.controller.setActions(brokerServiceCObj);
            }
        }
    }

    private boolean pauseService(BrokerAdmin brokerAdmin, String string) {
        try {
            brokerAdmin.sendPauseMessage(string);
            brokerAdmin.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6013", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3027", string) + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1031") + ": " + acr.getString("A1218", "A3027"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeService(BrokerServiceCObj brokerServiceCObj) {
        BrokerAdmin brokerAdmin = brokerServiceCObj.getBrokerAdmin();
        ServiceInfo serviceInfo = brokerServiceCObj.getServiceInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5006", serviceInfo.name, brokerAdmin.getKey()), acr.getString("A1035"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerServiceCObj);
            }
            if (this.resumeService(brokerAdmin, serviceInfo.name)) {
                serviceInfo = this.queryServiceInfo(brokerAdmin, serviceInfo.name);
                if (serviceInfo != null) {
                    brokerServiceCObj.setServiceInfo(serviceInfo);
                    this.app.getInspector().selectedObjectUpdated();
                }
                this.controller.setActions(brokerServiceCObj);
            }
        }
    }

    private boolean resumeService(BrokerAdmin brokerAdmin, String string) {
        try {
            brokerAdmin.sendResumeMessage(string);
            brokerAdmin.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6014", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3028", string) + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1035") + ": " + acr.getString("A1218", "A3028"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPauseDest(BrokerDestCObj brokerDestCObj) {
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        DestinationInfo destinationInfo = brokerDestCObj.getDestinationInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5016", destinationInfo.name, brokerAdmin.getKey()), acr.getString("A1115"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerDestCObj);
            }
            if (this.pauseDest(brokerAdmin, destinationInfo.name, destinationInfo.type, 3)) {
                destinationInfo = this.queryDestinationInfo(brokerAdmin, destinationInfo.name, destinationInfo.type);
                if (destinationInfo != null) {
                    brokerDestCObj.setDestinationInfo(destinationInfo);
                    this.app.getInspector().selectedObjectUpdated();
                }
                this.controller.setActions(brokerDestCObj);
            }
        }
    }

    private void doPauseAllDests(BrokerDestListCObj brokerDestListCObj) {
        BrokerAdmin brokerAdmin = brokerDestListCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5018", brokerAdmin.getKey()), acr.getString("A1117"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerDestListCObj);
            }
            if (this.pauseAllDests(brokerAdmin, 1, 3)) {
                if (!this.populateBrokerDestinations((BrokerCObj)brokerDestListCObj.getParent())) {
                    return;
                }
                this.controller.setActions(brokerDestListCObj);
                this.app.getInspector().refresh();
            }
        }
    }

    private boolean pauseDest(BrokerAdmin brokerAdmin, String string, int n, int n2) {
        try {
            brokerAdmin.sendPauseMessage(string, n, n2);
            brokerAdmin.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6036", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3076", string) + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1115") + ": " + acr.getString("A1218", "A3076"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean pauseAllDests(BrokerAdmin brokerAdmin, int n, int n2) {
        try {
            brokerAdmin.sendPauseMessage(null, n, n2);
            brokerAdmin.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6038", brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3078") + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1117") + ": " + acr.getString("A1218", "A3078"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPauseBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5011", brokerAdmin.getKey()), acr.getString("A1031"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerCObj);
            }
            if (this.pauseBroker(brokerAdmin)) {
                Cloneable cloneable;
                Enumeration<TreeNode> enumeration = brokerCObj.children();
                BrokerServiceListCObj brokerServiceListCObj = null;
                while (enumeration.hasMoreElements()) {
                    cloneable = (ConsoleObj)enumeration.nextElement();
                    if (!(cloneable instanceof BrokerServiceListCObj)) continue;
                    brokerServiceListCObj = (BrokerServiceListCObj)cloneable;
                }
                cloneable = this.queryAllServiceInfo(brokerAdmin);
                if (cloneable != null) {
                    this.updateAllServiceInfo(brokerServiceListCObj, (Vector)cloneable);
                    this.controller.setActions(brokerCObj);
                    this.app.getInspector().refresh();
                }
            }
        }
    }

    private boolean pauseBroker(BrokerAdmin brokerAdmin) {
        try {
            brokerAdmin.sendPauseMessage(null);
            brokerAdmin.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6015", brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3029", brokerAdmin.getKey()) + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1031") + ": " + acr.getString("A1218", "A3029"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5007", brokerAdmin.getKey()), acr.getString("A1034"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerCObj);
            }
            if (this.resumeBroker(brokerAdmin)) {
                Cloneable cloneable;
                Enumeration<TreeNode> enumeration = brokerCObj.children();
                BrokerServiceListCObj brokerServiceListCObj = null;
                while (enumeration.hasMoreElements()) {
                    cloneable = (ConsoleObj)enumeration.nextElement();
                    if (!(cloneable instanceof BrokerServiceListCObj)) continue;
                    brokerServiceListCObj = (BrokerServiceListCObj)cloneable;
                }
                cloneable = this.queryAllServiceInfo(brokerAdmin);
                if (cloneable != null) {
                    this.updateAllServiceInfo(brokerServiceListCObj, (Vector)cloneable);
                    this.controller.setActions(brokerCObj);
                    this.app.getInspector().refresh();
                }
            }
        }
    }

    private boolean resumeBroker(BrokerAdmin brokerAdmin) {
        try {
            brokerAdmin.sendResumeMessage(null);
            brokerAdmin.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6016", brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3030", brokerAdmin.getKey()) + ".\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1034") + ": " + acr.getString("A1218", "A3030"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeAllDests(BrokerDestListCObj brokerDestListCObj) {
        BrokerAdmin brokerAdmin = brokerDestListCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5019", brokerAdmin.getKey()), acr.getString("A1118"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerDestListCObj);
            }
            if (this.resumeAllDests(brokerAdmin, 1)) {
                if (!this.populateBrokerDestinations((BrokerCObj)brokerDestListCObj.getParent())) {
                    return;
                }
                this.controller.setActions(brokerDestListCObj);
                this.app.getInspector().refresh();
            }
        }
    }

    private void doResumeDest(BrokerDestCObj brokerDestCObj) {
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        DestinationInfo destinationInfo = brokerDestCObj.getDestinationInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5017", destinationInfo.name, brokerAdmin.getKey()), acr.getString("A1116"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            if (!brokerAdmin.isBusy()) {
                brokerAdmin.setAssociatedObj(brokerDestCObj);
            }
            if (this.resumeDest(brokerAdmin, destinationInfo.name, destinationInfo.type)) {
                destinationInfo = this.queryDestinationInfo(brokerAdmin, destinationInfo.name, destinationInfo.type);
                if (destinationInfo != null) {
                    brokerDestCObj.setDestinationInfo(destinationInfo);
                    this.app.getInspector().selectedObjectUpdated();
                }
                this.controller.setActions(brokerDestCObj);
            }
        }
    }

    private boolean resumeAllDests(BrokerAdmin brokerAdmin, int n) {
        try {
            brokerAdmin.sendResumeMessage(null, n);
            brokerAdmin.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6039", brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3079") + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1118") + ": " + acr.getString("A1218", "A3079"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean resumeDest(BrokerAdmin brokerAdmin, String string, int n) {
        try {
            brokerAdmin.sendResumeMessage(string, n);
            brokerAdmin.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6037", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3077", string) + "\n" + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1116") + ": " + acr.getString("A1218", "A3077"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean refreshBrokerCObj(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        Properties properties = this.queryBrokerProps(brokerAdmin);
        if (properties != null) {
            brokerCObj.setBrokerProps(properties);
            return true;
        }
        return false;
    }

    private Properties queryBrokerProps(BrokerAdmin brokerAdmin) {
        Properties properties = null;
        try {
            brokerAdmin.sendGetBrokerPropsMessage();
            properties = brokerAdmin.receiveGetBrokerPropsReplyMessage(false);
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3052", brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1094") + ": " + acr.getString("A1218", "A3052"), 0, 0, null, close, close[0]);
        }
        return properties;
    }

    private ServiceInfo queryServiceInfo(BrokerAdmin brokerAdmin, String string) {
        ServiceInfo serviceInfo = null;
        try {
            brokerAdmin.sendGetServicesMessage(string);
            Vector vector = brokerAdmin.receiveGetServicesReplyMessage(false);
            if (vector != null && vector.size() == 1) {
                Enumeration enumeration = vector.elements();
                serviceInfo = (ServiceInfo)enumeration.nextElement();
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3053", string) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1094") + ": " + acr.getString("A1218", "A3053"), 0, 0, null, close, close[0]);
        }
        return serviceInfo;
    }

    private Vector queryAllServiceInfo(BrokerAdmin brokerAdmin) {
        Vector vector = null;
        try {
            brokerAdmin.sendGetServicesMessage(null);
            vector = brokerAdmin.receiveGetServicesReplyMessage();
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3054") + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1094") + ": " + acr.getString("A1218", "A3054"), 0, 0, null, close, close[0]);
        }
        return vector;
    }

    private void updateAllServiceInfo(BrokerServiceListCObj brokerServiceListCObj, Vector vector) {
        if (brokerServiceListCObj == null || vector == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = brokerServiceListCObj.children();
        while (enumeration.hasMoreElements()) {
            BrokerServiceCObj brokerServiceCObj = (BrokerServiceCObj)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                ServiceInfo serviceInfo = (ServiceInfo)vector.elementAt(i);
                if (!brokerServiceCObj.getServiceInfo().name.equals(serviceInfo.name)) continue;
                brokerServiceCObj.setServiceInfo((ServiceInfo)vector.elementAt(i));
            }
        }
    }

    private DestinationInfo queryDestinationInfo(BrokerAdmin brokerAdmin, String string, int n) {
        DestinationInfo destinationInfo = null;
        try {
            brokerAdmin.sendGetDestinationsMessage(string, n);
            Vector vector = brokerAdmin.receiveGetDestinationsReplyMessage(false);
            if (vector != null && vector.size() == 1) {
                Enumeration enumeration = vector.elements();
                destinationInfo = (DestinationInfo)enumeration.nextElement();
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3055", string) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1094") + ": " + acr.getString("A1218", "A3055"), 0, 0, null, close, close[0]);
        }
        return destinationInfo;
    }

    private void doShutdownBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5008", brokerAdmin.getKey()), acr.getString("A1036"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            brokerAdmin.setInitiator(true);
            brokerAdmin.setReconnect(false);
            if (this.shutdownBroker(brokerAdmin)) {
                this.clearBroker(brokerCObj);
                this.app.getExplorer().nodeChanged(brokerCObj);
                this.app.getInspector().refresh();
                this.controller.setActions(brokerCObj);
            }
        }
    }

    private boolean shutdownBroker(BrokerAdmin brokerAdmin) {
        try {
            brokerAdmin.sendShutdownMessage(false);
            brokerAdmin.receiveShutdownReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6017", brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3067", brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1036") + ": " + acr.getString("A1218", "A3067"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doRestartBroker(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5009", brokerAdmin.getKey()), acr.getString("A1037"), 0);
        if (n == 1) {
            return;
        }
        if (brokerAdmin != null) {
            brokerAdmin.setInitiator(true);
            brokerAdmin.setReconnect(true);
            this.restartBroker(brokerAdmin, brokerCObj);
        }
    }

    private boolean restartBroker(BrokerAdmin brokerAdmin, BrokerCObj brokerCObj) {
        try {
            brokerAdmin.sendShutdownMessage(true);
            brokerAdmin.receiveShutdownReplyMessage();
            this.clearBroker(brokerCObj);
            boolean bl = false;
            if (brokerAdmin.getUserName().length() == 0) {
                bl = true;
            }
            if (brokerAdmin.getPassword().length() == 0) {
                bl = true;
            }
            if (bl) {
                if (this.brokerPasswdDialog == null) {
                    this.brokerPasswdDialog = new BrokerPasswdDialog(this.app.getFrame());
                    this.brokerPasswdDialog.addAdminEventListener(this);
                    this.brokerPasswdDialog.setLocationRelativeTo(this.app.getFrame());
                }
                this.brokerPasswdDialog.show(brokerAdmin);
            } else {
                if (this.reconnectToBroker(brokerCObj)) {
                    if (!this.refreshBrokerCObj(brokerCObj)) {
                        return false;
                    }
                    if (!this.populateBrokerServices(brokerCObj)) {
                        return false;
                    }
                    if (!this.populateBrokerDestinations(brokerCObj)) {
                        return false;
                    }
                } else {
                    return false;
                }
                this.app.getExplorer().nodeChanged(brokerCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6018", brokerAdmin.getKey()));
                this.controller.setActions(brokerCObj);
            }
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3068", brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1037") + ": " + acr.getString("A1218", "A3068"), 0, 0, null, close, close[0]);
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.controller.setActions(brokerCObj);
            return false;
        }
        return true;
    }

    private BrokerDestCObj addDestination(BrokerCObj brokerCObj, BrokerAdminEvent brokerAdminEvent) {
        BrokerDestCObj brokerDestCObj;
        DestinationInfo destinationInfo = this.createDestination(brokerAdminEvent);
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerCObj);
        }
        String string = destinationInfo.name;
        try {
            brokerAdmin.sendCreateDestinationMessage(destinationInfo);
            brokerAdmin.receiveCreateDestinationReplyMessage();
            brokerDestCObj = new BrokerDestCObj(brokerCObj, destinationInfo);
            this.app.getStatusArea().appendText(acr.getString("A6019", destinationInfo.name, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3069", string, brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1017") + ": " + acr.getString("A1218", "A3069"), 0, 0, null, close, close[0]);
            return null;
        }
        return brokerDestCObj;
    }

    private DestinationInfo createDestination(BrokerAdminEvent brokerAdminEvent) {
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.setName(brokerAdminEvent.getDestinationName());
        destinationInfo.setType(brokerAdminEvent.getDestinationTypeMask());
        if (DestType.isQueue(brokerAdminEvent.getDestinationTypeMask())) {
            destinationInfo.setMaxActiveConsumers(brokerAdminEvent.getActiveConsumers());
            destinationInfo.setMaxFailoverConsumers(brokerAdminEvent.getFailoverConsumers());
        }
        destinationInfo.setMaxProducers(brokerAdminEvent.getMaxProducers());
        destinationInfo.setMaxMessageBytes(brokerAdminEvent.getMaxMesgBytes());
        destinationInfo.setMaxMessages(brokerAdminEvent.getMaxMesg());
        destinationInfo.setMaxMessageSize(brokerAdminEvent.getMaxPerMesgSize());
        return destinationInfo;
    }

    private void doDeleteDestination(BrokerDestCObj brokerDestCObj) {
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        if (!brokerAdmin.isBusy()) {
            brokerAdmin.setAssociatedObj(brokerDestCObj);
        }
        DestinationInfo destinationInfo = brokerDestCObj.getDestinationInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5010", destinationInfo.name, brokerAdmin.getKey()), acr.getString("A1023"), 0);
        if (n == 1) {
            return;
        }
        if (!this.deleteDestination(brokerAdmin, destinationInfo.name, destinationInfo.type)) {
            return;
        }
        BrokerDestListCObj brokerDestListCObj = (BrokerDestListCObj)brokerDestCObj.getParent();
        this.app.getExplorer().removeFromParent(brokerDestCObj);
        this.app.getExplorer().select(brokerDestListCObj);
        this.app.getInspector().refresh();
    }

    private boolean deleteDestination(BrokerAdmin brokerAdmin, String string, int n) {
        try {
            brokerAdmin.sendDestroyDestinationMessage(string, n);
            brokerAdmin.receiveDestroyDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6020", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3058", string, brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1023") + ": " + acr.getString("A1218", "A3058"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPurgeDestination(BrokerDestCObj brokerDestCObj) {
        BrokerAdmin brokerAdmin = brokerDestCObj.getBrokerAdmin();
        DestinationInfo destinationInfo = brokerDestCObj.getDestinationInfo();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5012", destinationInfo.name, brokerAdmin.getKey()), acr.getString("A1101"), 0);
        if (n == 1) {
            return;
        }
        if (!this.purgeDestination(brokerAdmin, destinationInfo.name, destinationInfo.type)) {
            return;
        }
        destinationInfo = this.queryDestinationInfo(brokerAdmin, destinationInfo.name, destinationInfo.type);
        if (destinationInfo != null) {
            brokerDestCObj.setDestinationInfo(destinationInfo);
            this.app.getInspector().selectedObjectUpdated();
        }
    }

    private boolean purgeDestination(BrokerAdmin brokerAdmin, String string, int n) {
        try {
            brokerAdmin.sendPurgeDestinationMessage(string, n);
            brokerAdmin.receivePurgeDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6021", string, brokerAdmin.getKey()));
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3060", string, brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1101") + ": " + acr.getString("A1218", "A3060"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private String printBrokerAdminExceptionDetails(BrokerAdminException brokerAdminException) {
        String string = null;
        String string2 = this.getBrokerAdminExceptionBasicMsg(brokerAdminException);
        String string3 = this.getBrokerAdminExceptionMsgDetail(brokerAdminException);
        if (string2 == null && string3 == null) {
            return acr.getString("A3050");
        }
        if (string2 != null) {
            string = string2;
        }
        if (string3 != null) {
            string = string == null ? string3 : string + "\n" + string3;
        }
        return string;
    }

    private String getBrokerAdminExceptionMsgDetail(BrokerAdminException brokerAdminException) {
        Exception exception = brokerAdminException.getLinkedException();
        String string = brokerAdminException.getBrokerErrorStr();
        String string2 = null;
        if (string != null) {
            string2 = string;
        }
        if (exception != null) {
            string2 = string2 != null ? string2 + exception.getMessage() : exception.getMessage();
        }
        return string2;
    }

    private String getBrokerAdminExceptionBasicMsg(BrokerAdminException brokerAdminException) {
        String string;
        int n = brokerAdminException.getType();
        BrokerAdmin brokerAdmin = brokerAdminException.getBrokerAdmin();
        switch (n) {
            case 1: {
                string = ar.getString("A3121");
                break;
            }
            case 2: {
                string = ar.getString("A3122");
                break;
            }
            case 3: {
                string = ar.getString("A3123");
                break;
            }
            case 4: {
                string = ar.getString("A3124");
                break;
            }
            case 5: {
                string = ar.getString("A3125");
                break;
            }
            case 6: {
                string = acr.getString("A3059");
                break;
            }
            case 7: {
                string = ar.getString("A3127");
                break;
            }
            case 14: {
                string = acr.getString("A3073");
                break;
            }
            case 13: {
                Object[] objectArray = new Object[3];
                String string2 = brokerAdmin.getKey();
                String string3 = brokerAdmin.getBrokerHost();
                String string4 = brokerAdmin.getBrokerPort();
                objectArray[0] = string2;
                objectArray[1] = string3;
                objectArray[2] = string4;
                string = acr.getString("A1513", objectArray);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private void loadBrokerList() {
        ConsoleBrokerAdminManager consoleBrokerAdminManager = this.app.getBrokerListCObj().getBrokerAdminManager();
        try {
            consoleBrokerAdminManager.setFileName(BROKERLIST_FILENAME);
            consoleBrokerAdminManager.readBrokerAdminsFromFile();
        }
        catch (Exception exception) {
            String string = acr.getString("A3056") + exception.getMessage();
            JOptionPane.showOptionDialog(this.app.getFrame(), string, acr.getString("A1520") + ": " + acr.getString("A1218", "A3056"), 0, 0, null, close, close[0]);
        }
        Vector vector = consoleBrokerAdminManager.getBrokerAdmins();
        for (int i = 0; i < vector.size(); ++i) {
            BrokerAdmin brokerAdmin = (BrokerAdmin)vector.get(i);
            BrokerCObj brokerCObj = new BrokerCObj(brokerAdmin);
            this.app.getExplorer().addBroker(brokerCObj);
        }
        this.app.getInspector().refresh();
    }

    private void saveBrokerList() {
        ConsoleBrokerAdminManager consoleBrokerAdminManager = this.app.getBrokerListCObj().getBrokerAdminManager();
        try {
            consoleBrokerAdminManager.setFileName(BROKERLIST_FILENAME);
            consoleBrokerAdminManager.writeBrokerAdminsToFile();
        }
        catch (Exception exception) {
            String string = acr.getString("A3057") + exception.getMessage();
            String[] stringArray = new String[2];
            stringArray[0] = acr.getString("A1081");
            stringArray[1] = acr.getString("A1086");
            String[] stringArray2 = stringArray;
            int n = JOptionPane.showOptionDialog(this.app.getFrame(), string, acr.getString("A1094") + ": " + acr.getString("A1218", "A3057"), 0, 0, null, close, close[0]);
        }
    }

    public void handleConsoleActionEvents(ConsoleActionEvent consoleActionEvent) {
        int n = consoleActionEvent.getType();
        switch (n) {
            case 5: {
                this.doRefresh();
                this.app.getInspector().refresh();
            }
        }
    }

    private void doRefresh() {
        BrokerDestCObj brokerDestCObj;
        BrokerCObj brokerCObj;
        BrokerDestListCObj brokerDestListCObj;
        ConsoleObj consoleObj = this.app.getSelectedObj();
        if (consoleObj instanceof BrokerCObj) {
            BrokerCObj brokerCObj2 = (BrokerCObj)consoleObj;
            if (this.refreshBrokerServiceListCObj(brokerCObj2.getBrokerServiceListCObj()) && this.refreshBrokerDestListCObj(brokerCObj2.getBrokerDestListCObj())) {
                this.app.getStatusArea().appendText(acr.getString("A6034", brokerCObj2.toString()));
            }
        } else if (consoleObj instanceof BrokerServiceListCObj) {
            BrokerServiceListCObj brokerServiceListCObj = (BrokerServiceListCObj)consoleObj;
            BrokerCObj brokerCObj3 = brokerServiceListCObj.getBrokerCObj();
            if (this.refreshBrokerServiceListCObj(brokerServiceListCObj)) {
                this.app.getStatusArea().appendText(acr.getString("A6011", brokerCObj3.toString()));
            }
        } else if (consoleObj instanceof BrokerServiceCObj) {
            BrokerServiceCObj brokerServiceCObj = (BrokerServiceCObj)consoleObj;
            BrokerCObj brokerCObj4 = brokerServiceCObj.getBrokerCObj();
            BrokerServiceListCObj brokerServiceListCObj = brokerCObj4.getBrokerServiceListCObj();
            if (this.refreshBrokerServiceListCObj(brokerServiceListCObj)) {
                this.app.getStatusArea().appendText(acr.getString("A6011", brokerCObj4.toString()));
            }
        } else if (consoleObj instanceof BrokerDestListCObj) {
            BrokerDestListCObj brokerDestListCObj2 = (BrokerDestListCObj)consoleObj;
            BrokerCObj brokerCObj5 = brokerDestListCObj2.getBrokerCObj();
            if (this.refreshBrokerDestListCObj(brokerDestListCObj2)) {
                this.app.getStatusArea().appendText(acr.getString("A6012", brokerCObj5.toString()));
            }
        } else if (consoleObj instanceof BrokerDestCObj && this.refreshBrokerDestListCObj(brokerDestListCObj = (brokerCObj = (brokerDestCObj = (BrokerDestCObj)consoleObj).getBrokerCObj()).getBrokerDestListCObj())) {
            this.app.getStatusArea().appendText(acr.getString("A6012", brokerCObj.toString()));
        }
    }

    private boolean isLatestBrokerAvailable(BrokerCObj brokerCObj) {
        BrokerAdmin brokerAdmin = brokerCObj.getBrokerAdmin();
        try {
            brokerAdmin.sendHelloMessage();
            brokerAdmin.receiveHelloReplyMessage();
            return true;
        }
        catch (BrokerAdminException brokerAdminException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3046", brokerAdmin.getKey()) + this.printBrokerAdminExceptionDetails(brokerAdminException), acr.getString("A1105") + ": " + acr.getString("A1218", "A3046"), 0, 0, null, close, close[0]);
            brokerAdmin.setIsConnected(false);
            brokerCObj.setBrokerProps(null);
            this.clearBroker(brokerCObj);
            this.app.getExplorer().nodeChanged(brokerCObj);
            this.app.getInspector().refresh();
            this.controller.setActions(brokerCObj);
            return false;
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        BROKERLIST_FILENAME = "brokerlist.properties";
    }
}

