/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class ActionManager {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int PREFERENCES = 4;
    public static final int EXIT = 8;
    public static final int ABOUT = 16;
    public static final int PROPERTIES = 32;
    public static final int SHUTDOWN = 64;
    public static final int RESTART = 128;
    public static final int PAUSE = 256;
    public static final int RESUME = 512;
    public static final int CONNECT = 1024;
    public static final int DISCONNECT = 2048;
    public static final int EXPAND_ALL = 4096;
    public static final int COLLAPSE_ALL = 8192;
    public static final int REFRESH = 16384;
    public static final int PURGE = 32768;
    public static final int QUERY_BROKER = 65536;
    private Hashtable actionTable = new Hashtable(20);
    private int currentlyActive = 0;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private EventListenerList aListeners = new EventListenerList();
    static /* synthetic */ Class class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener;

    public ActionManager() {
        this.initActions();
    }

    public Action getAction(int n) {
        Action action = (Action)this.actionTable.get(new Integer(n));
        return action;
    }

    public void setEnabled(int n, boolean bl) {
        Action action = this.getAction(n);
        if (action == null) {
            return;
        }
        if (bl) {
            if (this.isActive(this.currentlyActive, n)) {
                return;
            }
            action.setEnabled(bl);
            this.currentlyActive |= n;
        } else {
            if (!this.isActive(this.currentlyActive, n)) {
                return;
            }
            action.setEnabled(bl);
            this.currentlyActive &= ~n;
        }
    }

    public void setActiveActions(int n) {
        if (n == this.currentlyActive) {
            return;
        }
        this.matchActions(n, 1);
        this.matchActions(n, 2);
        this.matchActions(n, 32);
        this.matchActions(n, 64);
        this.matchActions(n, 128);
        this.matchActions(n, 256);
        this.matchActions(n, 512);
        this.matchActions(n, 1024);
        this.matchActions(n, 2048);
        this.matchActions(n, 16384);
        this.matchActions(n, 32768);
        this.matchActions(n, 65536);
    }

    private void matchActions(int n, int n2) {
        if (this.isActive(n, n2)) {
            this.setEnabled(n2, true);
        } else {
            this.setEnabled(n2, false);
        }
    }

    private boolean isActive(int n, int n2) {
        return (n & n2) == n2;
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.add(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = ActionManager.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.remove(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = ActionManager.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    private void fireAdminEventDispatched(AdminEvent adminEvent) {
        Object[] objectArray = this.aListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? ActionManager.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener") : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener)) continue;
            ((AdminEventListener)objectArray[i + 1]).adminEventDispatched(adminEvent);
        }
    }

    private void initActions() {
        AbstractAction abstractAction = new AbstractAction(acr.getString("A1012"), AGraphics.adminImages[20]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(0);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(1, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1018"), AGraphics.adminImages[21]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(1);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(2, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1001"), AGraphics.adminImages[22]){

            public void actionPerformed(ActionEvent actionEvent) {
                System.err.println("Preferences");
            }
        };
        this.addAction(4, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1002")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleActionEvent consoleActionEvent = new ConsoleActionEvent(this, 4);
                ActionManager.this.fireAdminEventDispatched(consoleActionEvent);
            }
        };
        this.addAction(8, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1011")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleActionEvent consoleActionEvent = new ConsoleActionEvent(this, 0);
                ActionManager.this.fireAdminEventDispatched(consoleActionEvent);
            }
        };
        this.addAction(16, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1005"), AGraphics.adminImages[25]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(3);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(32, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1036"), AGraphics.adminImages[28]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(4);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(64, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1037"), AGraphics.adminImages[27]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(5);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(128, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1030"), AGraphics.adminImages[23]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(6);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(256, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1033"), AGraphics.adminImages[24]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(7);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(512, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1024"), AGraphics.adminImages[31]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(8);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(1024, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1027"), AGraphics.adminImages[33]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(9);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(2048, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1007"), AGraphics.adminImages[29]){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleActionEvent consoleActionEvent = new ConsoleActionEvent(this, 2);
                ActionManager.this.fireAdminEventDispatched(consoleActionEvent);
            }
        };
        this.addAction(4096, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1008"), AGraphics.adminImages[30]){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleActionEvent consoleActionEvent = new ConsoleActionEvent(this, 3);
                ActionManager.this.fireAdminEventDispatched(consoleActionEvent);
            }
        };
        this.addAction(8192, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1009"), AGraphics.adminImages[26]){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleActionEvent consoleActionEvent = new ConsoleActionEvent(this, 5);
                ActionManager.this.fireAdminEventDispatched(consoleActionEvent);
            }
        };
        this.addAction(16384, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1038"), AGraphics.adminImages[35]){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogEvent dialogEvent = new DialogEvent(this);
                dialogEvent.setDialogType(2);
                ActionManager.this.fireAdminEventDispatched(dialogEvent);
            }
        };
        this.addAction(32768, abstractAction);
        abstractAction = new AbstractAction(acr.getString("A1505"), AGraphics.adminImages[36]){

            public void actionPerformed(ActionEvent actionEvent) {
                BrokerAdminEvent brokerAdminEvent = new BrokerAdminEvent(this, 8);
                ActionManager.this.fireAdminEventDispatched(brokerAdminEvent);
            }
        };
        this.addAction(65536, abstractAction);
    }

    private void addAction(int n, Action action) {
        this.actionTable.put(new Integer(n), action);
        this.currentlyActive |= n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

