/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class AToolBar
extends JToolBar {
    private ConsoleObj conObj = null;
    private ActionManager actionMgr;
    private boolean displayIcons;
    private boolean displayText;
    private boolean displayToolTip;
    JButton addButton;
    JButton deleteButton;
    JButton propsButton;
    JButton shutdownButton;
    JButton restartButton;
    JButton connectButton;
    JButton disconnectButton;
    JButton queryButton;
    JButton pauseButton;
    JButton resumeButton;
    JButton refreshButton;

    public AToolBar(ActionManager actionManager) {
        this(actionManager, true, false, true);
    }

    public AToolBar(ActionManager actionManager, boolean bl, boolean bl2, boolean bl3) {
        this.actionMgr = actionManager;
        this.displayIcons = bl;
        this.displayText = bl2;
        this.displayToolTip = bl3;
        this.initGui();
    }

    public void setConsoleObj(ConsoleObj consoleObj) {
        this.conObj = consoleObj;
        this.setLabels();
        this.setIcons();
    }

    private void initGui() {
        this.setFloatable(false);
        this.addButton = this.addOneAction(this.actionMgr.getAction(1));
        this.deleteButton = this.addOneAction(this.actionMgr.getAction(2));
        this.propsButton = this.addOneAction(this.actionMgr.getAction(32));
        this.addSeparator();
        this.connectButton = this.addOneAction(this.actionMgr.getAction(1024));
        this.disconnectButton = this.addOneAction(this.actionMgr.getAction(2048));
        this.addSeparator();
        this.queryButton = this.addOneAction(this.actionMgr.getAction(65536));
        this.pauseButton = this.addOneAction(this.actionMgr.getAction(256));
        this.resumeButton = this.addOneAction(this.actionMgr.getAction(512));
        this.restartButton = this.addOneAction(this.actionMgr.getAction(128));
        this.shutdownButton = this.addOneAction(this.actionMgr.getAction(64));
        this.addSeparator();
        this.refreshButton = this.addOneAction(this.actionMgr.getAction(16384));
    }

    private JButton addOneAction(Action action) {
        JButton jButton = this.add(action);
        if (!this.displayIcons) {
            jButton.setIcon(null);
        }
        if (!this.displayText) {
            jButton.setText("");
        }
        if (this.displayToolTip) {
            jButton.setToolTipText((String)action.getValue("Name"));
        }
        return jButton;
    }

    private void setLabels() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetLabel(1, this.addButton);
        this.checkAndSetLabel(256, this.pauseButton);
        this.checkAndSetLabel(512, this.resumeButton);
        this.checkAndSetLabel(1024, this.connectButton);
        this.checkAndSetLabel(2048, this.disconnectButton);
    }

    private void checkAndSetLabel(int n, JButton jButton) {
        String string = this.conObj.getActionLabel(n);
        if (string != null) {
            if (this.displayToolTip) {
                jButton.setToolTipText(string);
            }
            if (this.displayText) {
                jButton.setText(string);
            }
        }
    }

    private void setIcons() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetIcon(1024, this.connectButton);
        this.checkAndSetIcon(2048, this.disconnectButton);
    }

    private void checkAndSetIcon(int n, JButton jButton) {
        ImageIcon imageIcon = this.conObj.getActionIcon(n);
        if (imageIcon != null) {
            jButton.setDisabledIcon(null);
            jButton.setIcon(imageIcon);
        }
    }
}

