/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.servlet.DefaultTrustManager;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLinkTable;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocketFactory;

class HelperThread
extends Thread {
    private ServerSocket ss = null;
    private ServerLinkTable parent;
    private String servletName = null;
    private boolean closed = false;

    public HelperThread(int n, String string, int n2, ServerLinkTable serverLinkTable) throws IOException {
        this.parent = serverLinkTable;
        this.closed = false;
        if (string == null) {
            this.ss = new ServerSocket(n);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ss = new ServerSocket(n, 50, inetAddress);
        }
        this.ss.setSoTimeout(5000);
        if (n2 > 0) {
            this.ss.setReceiveBufferSize(n2);
        }
        this.setName("HttpTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + n + " ...");
    }

    public HelperThread(int n, String string, int n2, String string2, String string3, ServerLinkTable serverLinkTable) throws IOException {
        this.parent = serverLinkTable;
        this.closed = false;
        HelperThread.registerSSLProvider();
        SSLServerSocketFactory sSLServerSocketFactory = this.getServerSocketFactory(string2, string3);
        if (string == null) {
            this.ss = sSLServerSocketFactory.createServerSocket(n);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ss = sSLServerSocketFactory.createServerSocket(n, 50, inetAddress);
        }
        this.ss.setSoTimeout(5000);
        if (n2 > 0) {
            this.ss.setReceiveBufferSize(n2);
        }
        this.setName("HttpsTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpsTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + n + " ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.closed) {
            try {
                Socket socket = this.ss.accept();
                HelperThread helperThread = this;
                synchronized (helperThread) {
                    if (this.closed) {
                        socket.close();
                        break;
                    }
                    this.parent.addServer(socket);
                }
                this.parent.servletContext.log(this.servletName + ": accepted socket connection. rcvbuf = " + socket.getReceiveBufferSize());
            }
            catch (InterruptedIOException interruptedIOException) {
                this.parent.checkConnectionTimeouts();
            }
            catch (Exception exception) {
                this.parent.servletContext.log(this.servletName + ": accept(): " + exception.getMessage());
            }
        }
        this.parent.servletContext.log(this.servletName + ": listen socket closed");
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SSLServerSocketFactory getServerSocketFactory(String string, String string2) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException("Keystore does not exist - " + string);
            }
            char[] cArray = string2.toCharArray();
            SSLContext sSLContext = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            keyManagerFactory.init(keyStore, cArray);
            TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
            sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            return sSLServerSocketFactory;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static void registerSSLProvider() {
        try {
            Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Constructor<?> constructor = clazz.getConstructor(null);
            Provider provider = (Provider)constructor.newInstance(null);
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

