/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class Version {
    private String propname = "/com/sun/messaging/jmq/version.properties";
    private static String imqhome_propname = "imq.home";
    private static final String IMQ_HOME = System.getProperty(imqhome_propname, ".");
    private static final String PATCHIDFILE = IMQ_HOME + File.separator + "patches" + File.separator + "VERSION";
    private Properties props = null;
    private String miniCopyright = "Copyright \u00a9 2004 Sun Microsystems, Inc. All rights reserved.\nUse is subject to license terms.";
    private String shortCopyright = "Copyright \u00a9 2004 Sun Microsystems, Inc. All rights reserved. Sun Microsystems,\nInc. has intellectual property rights relating to technology embodied in the\nproduct that is described in this document. In particular, and without\nlimitation, these intellectual property rights may include one or more of the\nU.S. patents listed at http://www.sun.com/patents and one or more additional\npatents or pending patent applications in the U.S. and in other countries. U.S.\nGovernment Rights - Commercial software. Government users are subject to the Sun\nMicrosystems, Inc. standard license agreement and applicable provisions of the\nFAR and its supplements. Use is subject to license terms. This distribution may\ninclude materials developed by third parties. Sun, Sun Microsystems, the Sun logo,\nJava, Solaris and Sun[tm] ONE are trademarks or registered trademarks of Sun\nMicrosystems, Inc. in the U.S. and other countries. All SPARC trademarks are used\nunder license and are trademarks or registered trademarks of SPARC International,\nInc. in the U.S. and other countries. UNIX is a registered trademark in the U.S.\nand other countries, exclusively licensed through X/Open Company, Ltd.\n\nCopyright \u00a9 2004 Sun Microsystems, Inc. Tous droits r\u00e9serv\u00e9s. Sun Microsystems,\nInc. d\u00e9tient les droits de propri\u00e9t\u00e9 intellectuels relatifs \u00e0 la technologie\nincorpor\u00e9e dans le produit qui est d\u00e9crit dans ce document. En particulier, et\nce sans limitation, ces droits de propri\u00e9t\u00e9 intellectuelle peuvent inclure un ou\nplus des brevets am\u00e9ricains list\u00e9s \u00e0 l'adresse http://www.sun.com/patents et un\nou les brevets suppl\u00e9mentaires ou les applications de brevet en attente aux\nEtats - Unis et dans les autres pays. L'utilisation est soumise aux termes du\ncontrat de licence. Cette distribution peut comprendre des composants d\u00e9velopp\u00e9s\npar des tierces parties. Sun, Sun Microsystems, le logo Sun, Java, Solaris et\nSun[tm] ONE sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de Sun\nMicrosystems, Inc. aux Etats-Unis et dans d'autres pays. Toutes les marques\nSPARC sont utilis\u00e9es sous licence et sont des marques de fabrique ou des marques\nd\u00e9pos\u00e9es de SPARC International, Inc. aux Etats-Unis et dans d'autres pays. UNIX\nest une marque d\u00e9pos\u00e9e aux Etats-Unis et dans d'autres pays et licenci\u00e9e\nexlusivement par X/Open Company, Ltd.";
    private String longCopyright = "Copyright \u00a9 2004 Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,\nCalifornia 95054, U.S.A. All rights reserved. Sun Microsystems, Inc. has\nintellectual property rights relating to technology embodied in the product that\nis described in this document. In particular, and without limitation, these\nintellectual property rights may include one or more of the U.S. patents listed\nat http://www.sun.com/patents and one or more additional patents or pending\npatent applications in the U.S. and in other countries.U.S. Government Rights -\nCommercial software. Government users are subject to the Sun Microsystems, Inc.\nstandard license agreement and applicable provisions of the FAR and its\nsupplements. Use is subject to license terms. This distribution may include\nmaterials developed by third parties. Sun, Sun Microsystems, the Sun logo, Java,\nSolaris, Sun[tm] ONE, JDK, Java Naming and Directory Interface, JavaMail,\nJavaHelp and Javadoc are trademarks or registered trademarks of Sun\nMicrosystems, Inc. in the U.S. and other countries. All SPARC trademarks are\nused under license and are trademarks or registered trademarks of SPARC\nInternational, Inc. in the U.S. and other countries. Products bearing SPARC\ntrademarks are based upon architecture developed by Sun Microsystems, Inc. UNIX\nis a registered trademark in the U.S. and other countries, exclusively licensed\nthrough X/Open Company, Ltd. This product is covered and controlled by U.S. Export\nControl laws and may be subject to the export or import laws in other countries.\nNuclear, missile, chemical biological weapons or nuclear maritime end uses or end\nusers, whether direct or indirect, are strictly prohibited. Export or reexport to\ncountries subject to U.S. embargo or to entities identified on U.S. export\nexclusion lists, including, but not limited to, the denied persons and specially\ndesignated nationals lists is strictly prohibited.\n\nCopyright \u00a9 2004 Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,\nCalifornia 95054, Etats-Unis. Tous droits r\u00e9serv\u00e9s. Sun Microsystems, Inc.\nd\u00e9tient les droits de propri\u00e9t\u00e9 intellectuels relatifs \u00e0 la technologie\nincorpor\u00e9e dans le produit qui est d\u00e9crit dans ce document. En particulier, et\nce sans limitation, ces droits de propri\u00e9t\u00e9 intellectuelle peuvent inclure un ou\nplus des brevets am\u00e9ricains list\u00e9s \u00e0 l'adresse http://www.sun.com/patents et un\nou les brevets suppl\u00e9mentaires ou les applications de brevet en attente aux\nEtats - Unis et dans les autres pays. L'utilisation est soumise aux termes de la\nLicence. Cette distribution peut comprendre des composants d\u00e9velopp\u00e9s par des\ntierces parties. Sun, Sun Microsystems, le logo Sun, Java, Solaris, Sun[tm] ONE,\nJDK, Java Naming and Directory Interface, JavaMail, JavaHelp et Javadoc sont des\nmarques de fabrique ou des marques d\u00e9pos\u00e9es de Sun Microsystems, Inc. aux\nEtats-Unis et dans d'autres pays. Toutes les marques SPARC sont utilis\u00e9es sous\nlicence et sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de SPARC\nInternational, Inc. aux Etats-Unis et dans d'autres pays. Les produits portant\nles marques SPARC sont bas\u00e9s sur une architecture d\u00e9velopp\u00e9e par Sun\nMicrosystems, Inc. UNIX est une marque d\u00e9pos\u00e9e aux Etats-Unis et dans d'autres\npays et licenci\u00e9e exlusivement par X/Open Company, Ltd.Ce produit est soumis \u00e0\nla l\u00e9gislation am\u00e9ricaine en mati\u00e8re de contr\u00f4le des exportations et peut \u00eatre\nsoumis \u00e0 la r\u00e8glementation en vigueur dans d'autres pays dans le domaine des\nexportations et importations. Les utilisations, ou utilisateurs finaux, pour des\narmes nucl\u00e9aires,des missiles, des armes biologiques et chimiques ou du nucl\u00e9aire\nmaritime, directement ou indirectement, sont strictement interdites. Les\nexportations ou r\u00e9exportations vers les pays sous embargo am\u00e9ricain, ou vers des\nentit\u00e9s figurant sur les listes d'exclusion d'exportation am\u00e9ricaines, y compris,\nmais de mani\u00e8re non exhaustive, la liste de personnes qui font objet d'un ordre\nde ne pas participer, d'une fa\u00e7on directe ou indirecte, aux exportations des\nproduits ou des services qui sont r\u00e9gis  par la l\u00e9gislation am\u00e9ricaine en mati\u00e8re\nde contr\u00f4le des exportations et la liste de ressortissants sp\u00e9cifiquement\nd\u00e9sign\u00e9s, sont rigoureusement interdites.";
    public static final int MINI_COPYRIGHT = 0;
    public static final int SHORT_COPYRIGHT = 1;
    public static final int LONG_COPYRIGHT = 2;
    private static String thisPackage = "com.sun.messaging";
    private static SharedResources rb = SharedResources.getResources();

    public Version() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.propname);
            if (inputStream == null) {
                System.err.println(rb.getString("S3006"));
            }
            this.props = new Properties();
            this.props.load(inputStream);
        }
        catch (Exception exception) {
            System.err.println(rb.getString("S3007"));
            exception.printStackTrace();
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public String getProductVersion() {
        return this.props.getProperty("imq.product.version");
    }

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.major"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getMinorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.minor"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getVersionProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getBuildMilestone() {
        String string = this.props.getProperty("imq.build.milestone");
        if ("FCS".equals(string)) {
            return "";
        }
        return string;
    }

    public String getBuildDate() {
        return this.props.getProperty("imq.build.date");
    }

    public String getBuildVersion() {
        return this.props.getProperty("imq.product.version") + " " + this.getBuildMilestone() + " (Build " + this.props.getProperty("imq.build.number") + "-" + this.props.getProperty("imq.build.promotion") + ")";
    }

    public String getProductName() {
        return this.props.getProperty("imq.product.name");
    }

    public String getReleaseQID() {
        return this.props.getProperty("imq.product.releaseqid");
    }

    public String getAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev");
    }

    public String getShortProductName() {
        return this.props.getProperty("imq.product.name.short");
    }

    public String getProductCopyrightDate() {
        return this.props.getProperty("imq.product.copyright.date");
    }

    public String getProductCompanyName() {
        return this.props.getProperty("imq.product.companyname");
    }

    public String getVersionPackageName() {
        return this.props.getProperty("imq.version.package");
    }

    public String getImplementationVersion() {
        return this.props.getProperty("imq.api.version");
    }

    public String getProtocolVersion() {
        return this.props.getProperty("imq.protocol.version");
    }

    public String getTargetJMSVersion() {
        return this.props.getProperty("imq.jms.api.version");
    }

    public String getUserAgent() {
        return this.getShortProductName() + "/" + this.getProductVersion() + " " + "(JMS; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
    }

    public String toString() {
        return this.getBanner(false);
    }

    public String getHeader() {
        return this.getHeader(1);
    }

    public String getHeader(int n) {
        return rb.getString("S1000") + this.getProductName() + " " + this.getReleaseQID() + SharedResources.NL + this.getProductCompanyName() + SharedResources.NL + rb.getString("S1001") + this.getBuildVersion() + SharedResources.NL + rb.getString("S1002") + this.getBuildDate() + SharedResources.NL + SharedResources.NL + this.getCopyright(n) + SharedResources.NL + SharedResources.NL + rb.getString("S1008") + SharedResources.NL + rb.getString("S1000");
    }

    public String getCopyright(int n) {
        switch (n) {
            case 0: {
                return this.miniCopyright;
            }
            case 1: {
                return this.shortCopyright;
            }
            case 2: {
                return this.longCopyright;
            }
        }
        return this.shortCopyright;
    }

    public String[] getPatchIds() {
        String string;
        File file = new File(PATCHIDFILE);
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(PATCHIDFILE);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = this.getMajorVersion() + "." + this.getMinorVersion();
        String[] stringArray = new String[1000];
        int n = 0;
        for (int i = 1; i < stringArray.length && (string = properties.getProperty(string2 + "_" + i)) != null; ++i) {
            stringArray[n++] = string;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public String getPatchString() {
        String[] stringArray = this.getPatchIds();
        String string = "";
        if (stringArray == null) {
            string = "";
        } else if (stringArray.length == 0) {
            string = "";
        } else if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (string.equals("")) {
                    string = string + rb.getString("S1009") + stringArray[i] + SharedResources.NL;
                    continue;
                }
                if (stringArray[i] == null) continue;
                string = string + rb.getString("S1010") + stringArray[i] + SharedResources.NL;
            }
        }
        return string;
    }

    public String getJMSAdminSpiVersion() {
        return this.props.getProperty("imq.jmsadmin.spi.version");
    }

    public String getVersion() {
        return this.getVersionPackageName() + rb.getString("S1004") + rb.getString("S1005") + this.getImplementationVersion() + SharedResources.NL + rb.getString("S1006") + this.getProtocolVersion() + SharedResources.NL + rb.getString("S1007") + this.getTargetJMSVersion() + SharedResources.NL + this.getPatchString();
    }

    public String getBanner(boolean bl) {
        return this.getBanner(bl, 1);
    }

    public String getBanner(boolean bl, int n) {
        if (this.props == null) {
            return rb.getString("S3008") + thisPackage;
        }
        if (bl) {
            return this.getHeader(n) + this.getVersion();
        }
        return this.getHeader(n);
    }

    public static int[] getIntVersion(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer;
        int[] nArray = new int[4];
        String string2 = Version.stripTrailingLetters(string.toUpperCase().trim());
        String string3 = null;
        int n = string2.indexOf("-");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf("SP")) != -1) {
            int n2;
            int n3 = string2.length();
            for (n2 = n + 2; n2 < n3 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
            }
            if (n2 < n3) {
                string3 = string2.substring(n2).trim();
            }
            string2 = string2.substring(0, n).trim();
        }
        if ((n = string2.indexOf("_")) != -1) {
            if (string3 != null) {
                throw new NumberFormatException("Can't have _ and SP: " + string);
            }
            string3 = string2.substring(n + 1).trim();
            string2 = string2.substring(0, n).trim();
        }
        if ((stringTokenizer = new StringTokenizer(string2, ".")).hasMoreTokens()) {
            nArray[0] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[3] = Integer.parseInt(stringTokenizer.nextToken());
        } else if (string3 != null && string3.length() != 0) {
            nArray[3] = Integer.parseInt(Version.stripTrailingLetters(string3));
        }
        return nArray;
    }

    private static String stripTrailingLetters(String string) {
        boolean bl = false;
        int n = string.length() - 1;
        while (!Character.isDigit(string.charAt(n))) {
            --n;
        }
        if (n == string.length() - 1) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static int compareVersions(String string, String string2) {
        return Version.compareVersions(string, string2, true);
    }

    public static int compareVersions(String string, String string2, boolean bl) throws NumberFormatException {
        int[] nArray = Version.getIntVersion(string);
        int[] nArray2 = Version.getIntVersion(string2);
        if (bl) {
            nArray[3] = 0;
            nArray2[3] = 0;
        }
        return Version.compareVersions(nArray, nArray2);
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        int n = nArray.length > nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = nArray.length > i ? nArray[i] : 0;
            int n4 = n2 = nArray2.length > i ? nArray2[i] : 0;
            if (n3 > n2) {
                return 1;
            }
            if (n3 >= n2) continue;
            return -1;
        }
        return 0;
    }

    public static String toVersionString(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + nArray[i];
            if (i + 1 >= nArray.length) continue;
            string = string + ".";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Version version = new Version();
        System.out.println(version);
    }
}

