/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.ssl;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.PortMapperClient;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.DefaultTrustManager;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.jms.JMSException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLConnectionHandler
implements ConnectionHandler {
    private static boolean isRegistered = false;
    private static boolean debug = Debug.debug;
    private SSLSocket sslSocket = null;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;

    SSLConnectionHandler(Object object) throws JMSException {
        ConnectionImpl connectionImpl = (ConnectionImpl)object;
        this.directport = 0;
        try {
            this.doRegister(connectionImpl);
            this.host = connectionImpl.getProperty("imqBrokerHostName");
            this.baseport = Integer.parseInt(connectionImpl.getProperty("imqBrokerHostPort"));
            this.directport = Integer.parseInt(connectionImpl.getProperty("imqBrokerServicePort"));
            String string = connectionImpl.getProperty("imqBrokerServiceName");
            boolean bl = Boolean.valueOf(connectionImpl.getProperty("imqSSLIsHostTrusted"));
            if (this.directport == 0) {
                PortMapperClient portMapperClient = new PortMapperClient(connectionImpl);
                this.port = string != null && !"".equals(string) ? portMapperClient.getPortForService("tls", string) : portMapperClient.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = this.makeSSLSocket(this.host, this.port, bl);
        }
        catch (Exception exception) {
            connectionImpl.getExceptionHandler().handleConnectException(exception, this.host, this.port);
        }
    }

    SSLConnectionHandler(MQAddress mQAddress, ConnectionImpl connectionImpl) throws JMSException {
        ConnectionImpl connectionImpl2 = connectionImpl;
        try {
            this.doRegister(connectionImpl2);
            this.host = mQAddress.getHostName();
            this.directport = 0;
            if (mQAddress.isServicePortFinal()) {
                this.directport = mQAddress.getPort();
            }
            String string = mQAddress.getServiceName();
            boolean bl = true;
            bl = mQAddress.getIsSSLHostTrustedSet() ? Boolean.valueOf(mQAddress.getProperty("isHostTrusted")).booleanValue() : Boolean.valueOf(connectionImpl2.getProperty("imqSSLIsHostTrusted")).booleanValue();
            if (this.directport == 0) {
                PortMapperClient portMapperClient = new PortMapperClient(mQAddress, connectionImpl2);
                this.baseport = portMapperClient.getHostPort();
                this.port = string != null && !"".equals(string) ? portMapperClient.getPortForService("tls", string) : portMapperClient.getPortForProtocol("tls");
            } else {
                this.port = this.directport;
            }
            ConnectionImpl.checkHostPort(this.host, this.port);
            this.sslSocket = this.makeSSLSocket(this.host, this.port, bl);
        }
        catch (Exception exception) {
            connectionImpl2.getExceptionHandler().handleConnectException(exception, this.host, this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegister(ConnectionImpl connectionImpl) throws Exception {
        if (!isRegistered) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                String string = connectionImpl.getProperty("imqSSLProviderClassname");
                Provider provider = (Provider)Class.forName(string).newInstance();
                Security.addProvider(provider);
                isRegistered = true;
            }
        }
    }

    private SSLSocket makeSSLSocket(String string, int n, boolean bl) throws Exception {
        SSLSocketFactory sSLSocketFactory;
        if (bl) {
            sSLSocketFactory = this.getTrustSocketFactory();
            if (debug) {
                Debug.println("Broker is trusted ...");
            }
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (debug) {
            Debug.println("Create connection using SSL protocol ...");
            Debug.println("Broker Host: " + string);
            Debug.println("Broker Port: " + n);
        }
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        boolean bl2 = true;
        String string2 = System.getProperty("imqTcpNoDelay", "true");
        if (string2.equals("false")) {
            bl2 = false;
        } else {
            sSLSocket.setTcpNoDelay(bl2);
        }
        return sSLSocket;
    }

    private SSLSocketFactory getTrustSocketFactory() throws Exception {
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = SSLContext.getInstance((String)"TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
        sSLContext.init(null, trustManagerArray, null);
        sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }

    public InputStream getInputStream() throws IOException {
        return this.sslSocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sslSocket.getOutputStream();
    }

    public int getLocalPort() throws IOException {
        return this.sslSocket.getLocalPort();
    }

    public void close() throws IOException {
        this.sslSocket.close();
    }

    public String getBrokerHostName() {
        return this.host;
    }

    public int getBrokerPort() {
        return this.port;
    }

    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }
}

