/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class ConnectionRecover
implements Runnable {
    protected ConnectionImpl connection = null;
    protected ProtocolHandler protocolHandler = null;
    protected static final String iMQConnectionRecover = "iMQConnectionRecover-";
    private boolean debug = Debug.debug;

    public ConnectionRecover(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.init();
    }

    protected void init() {
        this.protocolHandler = this.connection.protocolHandler;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            thread.setDaemon(true);
        }
        thread.setName("iMQConnectionRecover--" + this.connection.getLocalID() + "-" + this.connection.getConnectionID());
        thread.start();
    }

    public void run() {
        this.recover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void recover() {
        block15: {
            block13: {
                block14: {
                    try {
                        try {
                            if (this.debug) {
                                Debug.println("BEGIN ConnectionRecover.recover()...");
                            }
                            this.protocolHandler.recoverThread = Thread.currentThread();
                            if (this.connection.isClosed) {
                                this.connection.setReconnecting(false);
                                Object var3_1 = null;
                                if (!this.debug) break block13;
                                break block14;
                            }
                            this.checkConnectionConsumers();
                            this.resetSessions();
                            this.connection.hello(true);
                            this.protocolHandler.resetClientID();
                            this.addSessions();
                            this.addConsumers();
                            this.addProducers();
                            if (!this.connection.isStopped) {
                                this.protocolHandler.start();
                            }
                            if (this.debug) {
                                Debug.println("ConnectionRecover.recover() SUCCESS!!!");
                            }
                            break block15;
                        }
                        catch (Exception exception) {
                            if (this.debug) {
                                Debug.println("Reconnect failed.");
                                Debug.printStackTrace(exception);
                            }
                            this.connection.abort();
                            Object var3_3 = null;
                            if (this.debug) {
                                Debug.println("END ConnectionRecover.recover()!!!");
                            }
                            this.protocolHandler.recoverThread = null;
                            this.connection.setReconnecting(false);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (this.debug) {
                            Debug.println("END ConnectionRecover.recover()!!!");
                        }
                        this.protocolHandler.recoverThread = null;
                        this.connection.setReconnecting(false);
                        throw throwable;
                    }
                }
                Debug.println("END ConnectionRecover.recover()!!!");
            }
            this.protocolHandler.recoverThread = null;
            this.connection.setReconnecting(false);
            return;
        }
        Object var3_2 = null;
        if (this.debug) {
            Debug.println("END ConnectionRecover.recover()!!!");
        }
        this.protocolHandler.recoverThread = null;
        this.connection.setReconnecting(false);
    }

    protected void checkConnectionConsumers() throws JMSException {
        if (this.connection.connectionConsumerTable.size() > 0) {
            String string = AdministeredObject.cr.getKString("C4061");
            throw new IllegalStateException(string, "C4061");
        }
    }

    protected void resetSessions() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            if (sessionImpl.getMessageListener() != null) {
                String string = AdministeredObject.cr.getKString("C4061");
                throw new IllegalStateException(string, "C4061");
            }
            sessionImpl.reset();
        }
    }

    protected void addSessions() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            sessionImpl.recreateSession();
        }
    }

    protected void addConsumers() throws JMSException {
        Object[] objectArray = this.connection.interestTable.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.protocolHandler.addInterest((Consumer)objectArray[i]);
        }
    }

    protected void addProducers() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            this.addSessionProducers(sessionImpl);
        }
    }

    protected void addSessionProducers(SessionImpl sessionImpl) throws JMSException {
        Enumeration enumeration = sessionImpl.producers.elements();
        while (enumeration.hasMoreElements()) {
            MessageProducerImpl messageProducerImpl = (MessageProducerImpl)enumeration.nextElement();
            messageProducerImpl.recreateProducer();
        }
    }
}

