/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.Bits;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SysMessageID
implements Cloneable {
    public static final int ID_SIZE = 32;
    protected int sequence;
    protected int port;
    protected long timestamp;
    protected IPAddress ip = new IPAddress();
    private String uniqueName = null;
    private boolean dirty = true;

    public SysMessageID() {
        this.clear();
    }

    public void clear() {
        this.port = 0;
        this.sequence = 0;
        this.timestamp = 0L;
        this.ip.clear();
        this.dirty = true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SysMessageID)) {
            return false;
        }
        SysMessageID sysMessageID = (SysMessageID)object;
        return this.sequence == sysMessageID.sequence && this.timestamp == sysMessageID.timestamp && this.port == sysMessageID.port && this.ip.equals(sysMessageID.ip);
    }

    public int hashCode() {
        return (int)this.timestamp * this.port * this.sequence;
    }

    public String toString() {
        return this.sequence + "-" + this.ip.toString() + "-" + this.port + "-" + this.timestamp;
    }

    public String getUniqueName() {
        if (this.uniqueName == null || this.dirty) {
            this.uniqueName = String.valueOf(this.sequence) + String.valueOf(this.timestamp) + String.valueOf(this.port) + IPAddress.rawIPToString(this.ip.getAddress(), false);
            this.dirty = false;
        }
        return this.uniqueName;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getIPAddress() {
        return this.ip.getAddress();
    }

    public void setSequence(int n) {
        this.dirty = true;
        this.sequence = n;
    }

    public void setPort(int n) {
        this.dirty = true;
        this.port = n;
    }

    public void setTimestamp(long l) {
        this.dirty = true;
        this.timestamp = l;
    }

    public void setIPAddress(byte[] byArray) throws IllegalArgumentException {
        this.ip.setAddress(byArray);
        this.dirty = true;
    }

    public void setIPAddress(byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        this.ip.setAddress(byArray);
        if (byArray2 != null && this.ip.getType() != 2) {
            this.ip.setMac(byArray2);
        }
        this.dirty = true;
    }

    public void writeID(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(this.timestamp);
        this.ip.writeAddress(dataOutputStream);
        dataOutputStream.writeInt(this.port);
        dataOutputStream.writeInt(this.sequence);
        dataOutputStream.flush();
    }

    public byte[] getRawID() {
        byte[] byArray = new byte[32];
        int n = 0;
        n = Bits.put(byArray, n, this.timestamp);
        n = Bits.put(byArray, n, this.ip.getAddressUnsafe());
        n = Bits.put(byArray, n, this.port);
        Bits.put(byArray, n, this.sequence);
        return byArray;
    }

    public void readID(DataInputStream dataInputStream) throws IOException {
        this.timestamp = dataInputStream.readLong();
        this.ip.readAddress(dataInputStream);
        this.port = dataInputStream.readInt();
        this.sequence = dataInputStream.readInt();
    }

    public Object clone() {
        try {
            SysMessageID sysMessageID = (SysMessageID)super.clone();
            sysMessageID.ip = (IPAddress)this.ip.clone();
            return sysMessageID;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("SysMessageID: Could not clone: " + cloneNotSupportedException);
            return null;
        }
    }
}

