/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.adapter;

import com.sun.cns.basicreg.adapter.Adapter;
import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.common.CommonUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.logging.Logger;

public class CCRAdapter
extends Adapter {
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$adapter$CCRAdapter == null ? (class$com$sun$cns$basicreg$adapter$CCRAdapter = CCRAdapter.class$("com.sun.cns.basicreg.adapter.CCRAdapter")) : class$com$sun$cns$basicreg$adapter$CCRAdapter).getName());
    private static String CONFIG_LOCATION = null;
    private static String CONFIG_LOCATION_DEFAULT = "/usr";
    private static String[] envp = new String[]{"LC_ALL=C"};
    private static String CONFIG_PKG_NAME = "SUNWccccr";
    public static String ASSET_ID = "cns.assetid";
    public static String HTTP_PROXY_IP = "cns.httpproxy.ipaddr";
    public static String HTTP_PROXY_PORT = "cns.httpproxy.port";
    public static String HTTP_PROXY_AUTH = "cns.httpproxy.auth";
    public static String PUBLIC_KEY = "cns.security.publickey";
    public static String PRIVATE_KEY = "cns.security.privatekey";
    public static String SERVER_URL = "cns.transport.serverurl";
    public static String PORTAL_MGMT_STATUS = "cns.service.swupPortalMgmt.status";
    public static String REG_REQUIRED = "cns.swup.regRequired";
    public static CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
    public static String PATCHPRO_PROXY_HOST = "patchpro.proxy.host";
    public static String PATCHPRO_PROXY_PORT = "patchpro.proxy.port";
    public static String PATCHPRO_PROXY_USER = "patchpro.proxy.user";
    public static String PATCHPRO_PROXY_PASSWD = "patchpro.proxy.passwd";
    public static String PATCHPRO_PATCH_SOURCE = "patchpro.patch.source";
    static /* synthetic */ Class class$com$sun$cns$basicreg$adapter$CCRAdapter;

    public static void setCSMAuthAdapter(CSMAuthAdapter csmAuth) {
        csmAuthAdapter = csmAuth;
    }

    public static String getValue(String key) {
        String result = "";
        String cmd = "/usr/lib/cc-ccr/bin/ccr -g " + key;
        Process proc = null;
        try {
            LOG.info("Running cmd := " + cmd);
            proc = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            result = input.readLine().trim();
            input.close();
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + cmd);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        LOG.info("" + key + " from CCR := " + result);
        return result;
    }

    public static void setValue(String key, String value) {
        Process proc = null;
        String cmd = "/usr/lib/cc-ccr/bin/ccr -p " + key + " -v " + value;
        try {
            LOG.info("Running cmd := " + cmd);
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + cmd);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        LOG.info("" + key + " in CCR set to := " + value);
    }

    public static String getValueThroughCSMAuth(String key) {
        String result = "";
        String cmd = CONFIG_LOCATION_DEFAULT + "/lib/cc-ccr/bin/ccr";
        Vector<String> args = new Vector<String>();
        args.add("ccr");
        args.add("-g");
        args.add(key);
        LOG.info("Running cmd := " + cmd + " " + args.toString());
        result = csmAuthAdapter.runCMD(cmd, args);
        return result;
    }

    public static void setValueThroughCSMAuth(String key, String value) {
        String result = null;
        String cmd = CONFIG_LOCATION_DEFAULT + "/lib/cc-ccr/bin/ccr";
        Vector<String> args = new Vector<String>();
        args.add("ccr");
        args.add("-p");
        args.add(key);
        args.add("-v");
        args.add(value);
        result = csmAuthAdapter.runCMD(cmd, args);
    }

    public static void generatePublicPrivateKeyThroughCSMAuth() {
        String result = null;
        String cmd = CONFIG_LOCATION_DEFAULT + "/lib/cc-ccr/bin/ccrKeyGen";
        Vector<String> args = new Vector<String>();
        args.add("ccrKeyGen");
        LOG.info("Running cmd := " + cmd + " " + args.toString());
        result = csmAuthAdapter.runCMD(cmd, args);
        if (result == null) {
            LOG.severe("failed to generate public/private key through CSMAuth");
        } else {
            LOG.info("successfully generated public/private key through CSMAuth := " + result);
        }
    }

    public static void removeValueThroughCSMAuth(String key) {
        String result = null;
        String cmd = CONFIG_LOCATION_DEFAULT + "/lib/cc-ccr/bin/ccr";
        Vector<String> args = new Vector<String>();
        args.add("ccr");
        args.add("-r");
        args.add(key);
        LOG.info("Running cmd := " + cmd + " " + args.toString());
        result = csmAuthAdapter.runCMD(cmd, args);
        LOG.info("" + key + " has been removed from CCR := " + result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

