/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.adapter;

import com.sun.cns.basicreg.BasicReg;
import com.sun.cns.basicreg.adapter.Adapter;
import com.sun.cns.basicreg.adapter.CCRAdapter;
import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.adapter.PatchProAdapter;
import com.sun.cns.basicreg.advertisement.SystemAdvertisement;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.util.ResponseBuilder;
import com.sun.cns.basicreg.util.XMLError;
import com.sun.cns.platform.asset.Asset;
import com.sun.cns.platform.asset.AssetManagementService_Impl;
import com.sun.cns.platform.asset.AssetMgmtServiceIF;
import com.sun.cns.platform.asset.ErrorMessage;
import com.sun.cns.platform.asset.PartialAssetDetailsResponse;
import com.sun.cns.platform.asset.RegisterResponse;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.rpc.Stub;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class AssetAdapter
extends Adapter {
    private CSMAuthAdapter csmAuthAdapter = null;
    private SystemAdvertisement sysAdv = null;
    static /* synthetic */ Class class$com$sun$cns$basicreg$adapter$AssetAdapter;

    public AssetAdapter(Document inDoc) {
        this.setLogger(Logger.getLogger((class$com$sun$cns$basicreg$adapter$AssetAdapter == null ? (class$com$sun$cns$basicreg$adapter$AssetAdapter = AssetAdapter.class$("com.sun.cns.basicreg.adapter.AssetAdapter")) : class$com$sun$cns$basicreg$adapter$AssetAdapter).getName()));
        this.setInitialURL("https://cns-services.sun.com/AssetManagementService/assetmanagement");
        this.reLoadURL("asset.url");
        this.reLoadProxyFromCCR();
        theDocument = inDoc;
        if (theDocument == null) {
            LOG.warning("Constructor doc object is null!!!");
            theDocument = new Document();
        }
        LOG.info("Using AssetAdapter endpoint := " + ENDPOINT);
    }

    private boolean startTransport() {
        String result = "";
        boolean success = true;
        String cmd = "/usr/lib/cc-cfw/framework/lib/cc-client-adm";
        Vector<String> args1 = new Vector<String>();
        args1.add("cc-client-adm");
        args1.add("enable");
        Vector<String> args2 = new Vector<String>();
        args2.add("cc-client-adm");
        args2.add("start");
        args2.add("&");
        try {
            LOG.info("Running cmd := " + cmd + " " + args1.toString());
            result = this.csmAuthAdapter.runCMD(cmd, args1);
            if (result != null) {
                LOG.info("transport has been enabled ! " + result);
                LOG.info("Running cmd := " + cmd + " " + args2.toString());
                result = this.csmAuthAdapter.runCMD(cmd, args2);
                if (result != null) {
                    LOG.info("transport has been started ! " + result);
                } else {
                    LOG.severe("transport has not been started " + cmd);
                    success = false;
                }
            } else {
                LOG.severe("transport has not been enabled ! " + cmd);
                success = false;
            }
        }
        catch (Exception e) {
            LOG.severe("Cannot exec transport cmd " + cmd);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
            success = false;
        }
        return success;
    }

    public Document registerXMLAsset(String authToken) {
        Document result = null;
        result = this.setCSMAuthAdapter();
        boolean sendFullSystemInfo = false;
        boolean sendLimitedSystemInfo = false;
        boolean addSubscriptionKeyOnly = false;
        if (result != null) {
            return result;
        }
        if (AssetAdapter.isWizardOutputFileFound("profile-output")) {
            LOG.info("processing registration mode");
            if (!AssetAdapter.findEntry("systeminfo").equals("")) {
                LOG.info("sending complete system information !");
                sendFullSystemInfo = true;
                sendLimitedSystemInfo = false;
            } else {
                LOG.info("sending limited system information !");
                sendFullSystemInfo = false;
                sendLimitedSystemInfo = true;
            }
        } else if (AssetAdapter.isWizardOutputFileFound("profile-solaris-output")) {
            LOG.info("processing solaris mode");
            if (!AssetAdapter.findEntry("systeminfo").equals("")) {
                LOG.info("sending complete system information !");
                sendFullSystemInfo = true;
                sendLimitedSystemInfo = false;
            } else {
                sendFullSystemInfo = false;
                sendLimitedSystemInfo = true;
            }
        } else if (AssetAdapter.isWizardOutputFileFound("profile-solaris-u1-output")) {
            LOG.info("processing solaris U1 mode");
            if (!AssetAdapter.findEntry("systeminfo").equals("")) {
                LOG.info("sending complete system information !");
                sendFullSystemInfo = true;
                sendLimitedSystemInfo = false;
            } else {
                sendFullSystemInfo = false;
                sendLimitedSystemInfo = true;
            }
        } else if (AssetAdapter.isWizardOutputFileFound("profile-subscription-output")) {
            LOG.info("processing subscription mode");
            if (!AssetAdapter.findEntry("systeminfo").equals("")) {
                LOG.info("sending complete system information !");
                sendFullSystemInfo = true;
                sendLimitedSystemInfo = false;
            } else {
                sendFullSystemInfo = false;
                sendLimitedSystemInfo = false;
            }
        } else if (AssetAdapter.isWizardOutputFileFound("profile-subscription1-output")) {
            LOG.info("processing subscription1");
            LOG.info("sending complete system information !");
            sendFullSystemInfo = true;
            sendLimitedSystemInfo = false;
            addSubscriptionKeyOnly = true;
        } else if (AssetAdapter.isWizardOutputFileFound("profile-enable-portal-output")) {
            LOG.info("processing enable portal mode");
            LOG.info("sending complete system information !");
            sendFullSystemInfo = true;
            sendLimitedSystemInfo = false;
        }
        result = this.registerXMLAsset(authToken, sendFullSystemInfo, sendLimitedSystemInfo, addSubscriptionKeyOnly);
        return result;
    }

    private String getCommonName(String assetId, String token) {
        String commonName = null;
        try {
            Stub stub = (Stub)new AssetManagementService_Impl().getAssetMgmtServiceIFPort();
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)ENDPOINT);
            AssetMgmtServiceIF assetmgmt = (AssetMgmtServiceIF)stub;
            long start_time = System.currentTimeMillis();
            PartialAssetDetailsResponse response = assetmgmt.getPartialAssetDetails(assetId);
            LOG.info("AssetAdapter getPartialAssetDetails call took : " + (System.currentTimeMillis() - start_time) + " ms.");
            if (response.getErrorMessage() == null) {
                Asset asset = response.getAsset();
                commonName = asset.getCommonName();
            } else {
                ErrorMessage theError = response.getErrorMessage();
                LOG.severe("common name was not able to be retrieved from web service");
                LOG.severe(theError.getMessage() + ":" + theError.getCode());
            }
        }
        catch (Exception ex) {
            LOG.severe("common name was not able to be retrieved from web service");
        }
        return commonName;
    }

    public Document registerXMLAsset(String authToken, boolean sendFullSystemInfo, boolean sendLimitedSystemInfo, boolean addSubscriptionKeyOnly) {
        XMLOutputter xout;
        Document result = null;
        String finalXML = null;
        this.sysAdv = BasicReg.getSystemAdvertisement();
        String publicKey = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PUBLIC_KEY);
        String privateKey = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PRIVATE_KEY);
        if (publicKey == null || publicKey.trim().equals("") || privateKey == null || privateKey.trim().equals("")) {
            if (publicKey != null && !publicKey.trim().equals("")) {
                LOG.info("removing public key");
                CCRAdapter.removeValueThroughCSMAuth(CCRAdapter.PUBLIC_KEY);
            } else if (privateKey != null && !privateKey.trim().equals("")) {
                LOG.info("removing private key");
                CCRAdapter.removeValueThroughCSMAuth(CCRAdapter.PRIVATE_KEY);
            }
            LOG.info("generating public/private key pair");
            CCRAdapter.generatePublicPrivateKeyThroughCSMAuth();
            publicKey = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PUBLIC_KEY);
            privateKey = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PRIVATE_KEY);
            if (publicKey == null || publicKey.trim().equals("") || privateKey == null || privateKey.trim().equals("")) {
                XMLError error = new XMLError("Exception in generating key pair", "system", "250", "F");
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "asset");
                return result;
            }
        }
        this.sysAdv.setCCRPublicKey(publicKey);
        this.sysAdv.setSubscriptionKey(AssetAdapter.findEntry("subKey"));
        this.sysAdv.setCommonName(AssetAdapter.findEntry("system"));
        this.sysAdv.setAssetId(CCRAdapter.getValueThroughCSMAuth(CCRAdapter.ASSET_ID));
        this.sysAdv.setPortalEnabled(AssetAdapter.findEntry("systemselect"));
        this.sysAdv.setEcrUserName(AssetAdapter.findEntry("username"));
        if (addSubscriptionKeyOnly) {
            LOG.info("getting common name now ...");
            String commonName = this.getCommonName(CCRAdapter.getValueThroughCSMAuth(CCRAdapter.ASSET_ID), authToken);
            if (commonName != null) {
                this.sysAdv.setCommonName(commonName);
            } else {
                XMLError error = null;
                error = new XMLError("Exception in web service communication", "system", "230", "F");
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "asset");
                return result;
            }
        }
        if (sendFullSystemInfo) {
            this.sysAdv.setPortalEnabled("true");
            xout = new XMLOutputter();
            finalXML = xout.outputString(this.sysAdv.getDocument(false));
        } else if (sendLimitedSystemInfo) {
            this.sysAdv.setPortalEnabled("false");
            xout = new XMLOutputter();
            finalXML = xout.outputString(this.sysAdv.getDocument(true));
        } else {
            xout = new XMLOutputter();
            finalXML = xout.outputString(this.sysAdv.getDocument(true));
        }
        LOG.info("=== system info start: ===\n" + finalXML);
        LOG.info("=== system info end: ===\n");
        try {
            Stub stub = (Stub)new AssetManagementService_Impl().getAssetMgmtServiceIFPort();
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)ENDPOINT);
            AssetMgmtServiceIF assetmgmt = (AssetMgmtServiceIF)stub;
            long start_time = System.currentTimeMillis();
            RegisterResponse response = assetmgmt.registerAsset(finalXML, authToken);
            LOG.info("AssetAdapter registerXMLAsset call took : " + (System.currentTimeMillis() - start_time) + " ms.");
            if (response.getErrorMessage() == null) {
                result = ResponseBuilder.buildResponseDocument(response.getAssetId(), "asset");
                CCRAdapter.setValueThroughCSMAuth(CCRAdapter.ASSET_ID, response.getAssetId());
                CCRAdapter.setValueThroughCSMAuth(CCRAdapter.SERVER_URL, response.getTransportURL());
                boolean success = true;
                PatchProAdapter patchProAdapter = new PatchProAdapter();
                if (!AssetAdapter.findEntry("server").equals("")) {
                    success = patchProAdapter.setPatchPro(CCRAdapter.PATCHPRO_PROXY_HOST, AssetAdapter.findEntry("server"));
                }
                if (!AssetAdapter.findEntry("port").equals("") && success) {
                    success = patchProAdapter.setPatchPro(CCRAdapter.PATCHPRO_PROXY_PORT, AssetAdapter.findEntry("port"));
                }
                if (!AssetAdapter.findEntry("proxyUser").equals("")) {
                    if (success) {
                        success = patchProAdapter.setPatchPro(CCRAdapter.PATCHPRO_PROXY_USER, AssetAdapter.findEntry("proxyUser"));
                    }
                    if (success) {
                        success = patchProAdapter.setPatchPro(CCRAdapter.PATCHPRO_PROXY_PASSWD, AssetAdapter.findEntry("proxyPass"));
                    }
                }
                if (success) {
                    if (sendFullSystemInfo && !(success = this.startTransport())) {
                        XMLError error = new XMLError("Exception in transport", "system", "270", "F");
                        ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                        errorList.add(error);
                        result = ResponseBuilder.buildResponseDocument(errorList, "transport");
                    }
                } else {
                    XMLError error = new XMLError("Exception in patchpro", "system", "280", "F");
                    ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                    errorList.add(error);
                    result = ResponseBuilder.buildResponseDocument(errorList, "patchpro");
                }
                LOG.info("asset id := " + response.getAssetId());
            } else {
                ErrorMessage theError = response.getErrorMessage();
                XMLError error = new XMLError(theError.getMessage(), "user", theError.getCode(), theError.getSeverity());
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "asset");
            }
        }
        catch (Exception e) {
            XMLError error = null;
            if (AssetAdapter.connectToSun()) {
                LOG.severe("Exception in web service communication");
                error = new XMLError("Exception in web service communication", "system", "230", "F");
            } else if (AssetAdapter.isProxyEnabled()) {
                LOG.severe("Exception in proxy communication");
                error = new XMLError("Exception in proxy communication", "system", "235", "F");
            } else {
                LOG.severe("Exception in internet communication");
                error = new XMLError("Exception in internet communication", "system", "245", "F");
            }
            ArrayList<XMLError> errorList = new ArrayList<XMLError>();
            errorList.add(error);
            result = ResponseBuilder.buildResponseDocument(errorList, "asset");
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    private Document setCSMAuthAdapter() {
        Document result = null;
        this.csmAuthAdapter = CSMAuthAdapter.getInstance();
        AssetAdapter assetAdapter = this;
        if (!assetAdapter.csmAuthAdapter.isAuthenticated()) {
            if (!this.csmAuthAdapter.authenticateUser()) {
                XMLError error = new XMLError("CSMAuth authentication failed", "user", "330", "F");
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "asset");
                LOG.severe("CSMAuth authentication failed");
                return result;
            }
            this.csmAuthAdapter.closeFrame();
        }
        CCRAdapter.setCSMAuthAdapter(this.csmAuthAdapter);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

