/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected ArrayList fRecognizedProperties;
    protected Hashtable fProperties;
    protected ArrayList fRecognizedFeatures = new ArrayList();
    protected Hashtable fFeatures;
    protected XMLComponentManager fParentSettings;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager parent) {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        this.fParentSettings = parent;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(featureId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getFeature(featureId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, featureId);
            }
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(propertyId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getProperty(propertyId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, propertyId);
            }
        }
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        Boolean state = (Boolean)this.fFeatures.get(featureId);
        if (state == null) {
            this.checkFeature(featureId);
            return false;
        }
        return state;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.checkFeature(featureId);
        this.fFeatures.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedFeatures(String[] featureIds) {
        int featureIdsCount = featureIds != null ? featureIds.length : 0;
        int i = 0;
        while (i < featureIdsCount) {
            String featureId = featureIds[i];
            if (!this.fRecognizedFeatures.contains(featureId)) {
                this.fRecognizedFeatures.add(featureId);
            }
            ++i;
        }
    }

    public void addRecognizedProperties(String[] propertyIds) {
        int propertyIdsCount = propertyIds != null ? propertyIds.length : 0;
        int i = 0;
        while (i < propertyIdsCount) {
            String propertyId = propertyIds[i];
            if (!this.fRecognizedProperties.contains(propertyId)) {
                this.fRecognizedProperties.add(propertyId);
            }
            ++i;
        }
    }

    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object propertyValue = this.fProperties.get(propertyId);
        if (propertyValue == null) {
            this.checkProperty(propertyId);
        }
        return propertyValue;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.checkProperty(propertyId);
        this.fProperties.put(propertyId, value);
    }
}

