/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMStringListImpl;
import com.sun.org.apache.xerces.internal.dom3.DOMConfiguration;
import com.sun.org.apache.xerces.internal.dom3.DOMErrorHandler;
import com.sun.org.apache.xerces.internal.dom3.DOMStringList;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XSAttributeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSConstraints;
import com.sun.org.apache.xerces.internal.impl.xs.XSDDescription;
import com.sun.org.apache.xerces.internal.impl.xs.XSDeclarationPool;
import com.sun.org.apache.xerces.internal.impl.xs.XSGrammarBucket;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.impl.xs.XSModelImpl;
import com.sun.org.apache.xerces.internal.impl.xs.models.CMBuilder;
import com.sun.org.apache.xerces.internal.impl.xs.models.CMNodeFactory;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDHandler;
import com.sun.org.apache.xerces.internal.util.DOMErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.DefaultErrorHandler;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarLoader;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.grammars.XSGrammar;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xs.LSInputList;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSLoader;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

public class XMLSchemaLoader
implements XMLGrammarLoader,
XMLComponent,
XSLoader,
DOMConfiguration {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/validation/schema/augment-psvi", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/standard-uri-conformant", "http://apache.org/xml/features/disallow-doctype-decl"};
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource", "http://apache.org/xml/properties/security-manager"};
    private ParserConfigurationSettings fLoaderConfig = new ParserConfigurationSettings();
    private SymbolTable fSymbolTable = null;
    private XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    private XMLEntityManager fEntityManager = null;
    private XMLEntityResolver fUserEntityResolver = null;
    private XMLGrammarPool fGrammarPool = null;
    private String fExternalSchemas = null;
    private String fExternalNoNSSchema = null;
    private Object fJAXPSource = null;
    private boolean fIsCheckedFully = false;
    private boolean fJAXPProcessed = false;
    private boolean fSettingsChanged = true;
    private XSDHandler fSchemaHandler;
    private XSGrammarBucket fGrammarBucket;
    private XSDeclarationPool fDeclPool = null;
    private SubstitutionGroupHandler fSubGroupHandler;
    private CMBuilder fCMBuilder;
    private XSDDescription fXSDDescription = new XSDDescription();
    private Hashtable fJAXPCache;
    private Locale fLocale = Locale.getDefault();
    private DOMStringList fRecognizedParameters = null;
    private DOMErrorHandlerWrapper fErrorHandler = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$xml$sax$InputSource;

    public XMLSchemaLoader() {
        this(new SymbolTable(), null, new XMLEntityManager(), null, null, null);
    }

    private void initGrammarBucket() {
        if (this.fGrammarPool != null) {
            Grammar[] initialGrammars = this.fGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int i = 0;
            while (i < initialGrammars.length) {
                if (!this.fGrammarBucket.putGrammar((SchemaGrammar)initialGrammars[i], true)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                }
                ++i;
            }
        }
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> v = new Vector<String>();
            v.add("validate");
            v.add(SYMBOL_TABLE);
            v.add(ERROR_REPORTER);
            v.add(ERROR_HANDLER);
            v.add(ENTITY_RESOLVER);
            v.add(XMLGRAMMAR_POOL);
            v.add(SCHEMA_LOCATION);
            v.add(SCHEMA_NONS_LOCATION);
            v.add(JAXP_SCHEMA_SOURCE);
            v.add(SCHEMA_FULL_CHECKING);
            v.add(CONTINUE_AFTER_FATAL_ERROR);
            v.add(ALLOW_JAVA_ENCODINGS);
            v.add(STANDARD_URI_CONFORMANT_FEATURE);
            this.fRecognizedParameters = new DOMStringListImpl(v);
        }
        return this.fRecognizedParameters;
    }

    public XMLSchemaLoader(SymbolTable symbolTable) {
        this(symbolTable, null, new XMLEntityManager(), null, null, null);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        boolean parser_settings;
        this.fGrammarBucket.reset();
        this.fSubGroupHandler.reset();
        try {
            parser_settings = componentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException e) {
            parser_settings = true;
        }
        if (!parser_settings || !this.fSettingsChanged) {
            this.initGrammarBucket();
            return;
        }
        this.fEntityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        boolean psvi = true;
        try {
            psvi = componentManager.getFeature(AUGMENT_PSVI);
        }
        catch (XMLConfigurationException e) {
            psvi = false;
        }
        if (!psvi) {
            this.fDeclPool.reset();
            this.fCMBuilder.setDeclPool(this.fDeclPool);
            this.fSchemaHandler.setDeclPool(this.fDeclPool);
        } else {
            this.fCMBuilder.setDeclPool(null);
            this.fSchemaHandler.setDeclPool(null);
        }
        try {
            this.fExternalSchemas = (String)componentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNSSchema = (String)componentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException e) {
            this.fExternalSchemas = null;
            this.fExternalNoNSSchema = null;
        }
        try {
            this.fJAXPSource = componentManager.getProperty(JAXP_SCHEMA_SOURCE);
            this.fJAXPProcessed = false;
        }
        catch (XMLConfigurationException e) {
            this.fJAXPSource = null;
            this.fJAXPProcessed = false;
        }
        try {
            this.fGrammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException e) {
            this.fGrammarPool = null;
        }
        this.initGrammarBucket();
        try {
            boolean fatalError = componentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, fatalError);
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            this.fIsCheckedFully = componentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException e) {
            this.fIsCheckedFully = false;
        }
        this.fSchemaHandler.reset(componentManager);
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fUserEntityResolver;
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        this.fUserEntityResolver = entityResolver;
        this.fLoaderConfig.setProperty(ENTITY_RESOLVER, entityResolver);
        this.fEntityManager.setProperty(ENTITY_RESOLVER, entityResolver);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, errorHandler);
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        return this.fLoaderConfig.getFeature(featureId);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.fSettingsChanged = true;
        if (featureId.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, state);
        }
        this.fLoaderConfig.setFeature(featureId, state);
    }

    private void processJAXPSchemaSource(Hashtable locationPairs) throws IOException {
        this.fJAXPProcessed = true;
        if (this.fJAXPSource == null) {
            return;
        }
        Class<?> componentType = this.fJAXPSource.getClass().getComponentType();
        XMLInputSource xis = null;
        String sid = null;
        if (componentType == null) {
            SchemaGrammar g;
            if ((this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(this.fJAXPSource)) != null) {
                this.fGrammarBucket.putGrammar(g);
                return;
            }
            this.fXSDDescription.reset();
            xis = this.xsdToXMLInputSource(this.fJAXPSource);
            sid = xis.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (sid != null) {
                this.fXSDDescription.setBaseSystemId(xis.getBaseSystemId());
                this.fXSDDescription.setLiteralSystemId(sid);
                this.fXSDDescription.setExpandedSystemId(sid);
                this.fXSDDescription.fLocationHints = new String[]{sid};
            }
            if ((g = this.loadSchema(this.fXSDDescription, xis, locationPairs)) != null) {
                if (this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) {
                    this.fJAXPCache.put(this.fJAXPSource, g);
                    if (this.fIsCheckedFully) {
                        XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
                    }
                }
                this.fGrammarBucket.putGrammar(g);
            }
            return;
        }
        if (componentType != (class$java$lang$Object == null ? (class$java$lang$Object = XMLSchemaLoader.class$("java.lang.Object")) : class$java$lang$Object) && componentType != (class$java$lang$String == null ? (class$java$lang$String = XMLSchemaLoader.class$("java.lang.String")) : class$java$lang$String) && componentType != (class$java$io$File == null ? (class$java$io$File = XMLSchemaLoader.class$("java.io.File")) : class$java$io$File) && componentType != (class$java$io$InputStream == null ? (class$java$io$InputStream = XMLSchemaLoader.class$("java.io.InputStream")) : class$java$io$InputStream) && componentType != (class$org$xml$sax$InputSource == null ? (class$org$xml$sax$InputSource = XMLSchemaLoader.class$("org.xml.sax.InputSource")) : class$org$xml$sax$InputSource)) {
            throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have an array of type {" + componentType.getName() + "}. Possible types of the array supported are Object, String, File, " + "InputStream, InputSource.");
        }
        Object[] objArr = (Object[])this.fJAXPSource;
        Vector<String> jaxpSchemaSourceNamespaces = new Vector<String>();
        int i = 0;
        while (i < objArr.length) {
            SchemaGrammar g;
            if ((objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(objArr[i])) != null) {
                this.fGrammarBucket.putGrammar(g);
            } else {
                this.fXSDDescription.reset();
                xis = this.xsdToXMLInputSource(objArr[i]);
                sid = xis.getSystemId();
                this.fXSDDescription.fContextType = (short)3;
                if (sid != null) {
                    this.fXSDDescription.setBaseSystemId(xis.getBaseSystemId());
                    this.fXSDDescription.setLiteralSystemId(sid);
                    this.fXSDDescription.setExpandedSystemId(sid);
                    this.fXSDDescription.fLocationHints = new String[]{sid};
                }
                String targetNamespace = null;
                SchemaGrammar grammar = this.fSchemaHandler.parseSchema(xis, this.fXSDDescription, locationPairs);
                if (this.fIsCheckedFully) {
                    XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
                }
                if (grammar != null) {
                    targetNamespace = grammar.getTargetNamespace();
                    if (jaxpSchemaSourceNamespaces.contains(targetNamespace)) {
                        throw new IllegalArgumentException(" When using array of Objects as the value of SCHEMA_SOURCE property , no two Schemas should share the same targetNamespace. ");
                    }
                    jaxpSchemaSourceNamespaces.add(targetNamespace);
                    if (objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) {
                        this.fJAXPCache.put(objArr[i], grammar);
                    }
                    this.fGrammarBucket.putGrammar(grammar);
                }
            }
            ++i;
        }
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    public Grammar loadGrammar(XMLInputSource source) throws IOException, XNIException {
        this.reset(this.fLoaderConfig);
        this.fSettingsChanged = false;
        XSDDescription desc = new XSDDescription();
        desc.fContextType = (short)3;
        desc.setBaseSystemId(source.getBaseSystemId());
        desc.setLiteralSystemId(source.getSystemId());
        Hashtable locationPairs = new Hashtable();
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNSSchema, locationPairs, this.fErrorReporter);
        SchemaGrammar grammar = this.loadSchema(desc, source, locationPairs);
        if (grammar != null && this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", this.fGrammarBucket.getGrammars());
            if (this.fIsCheckedFully && this.fJAXPCache.get(grammar) != grammar) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
            }
        }
        return grammar;
    }

    private XMLInputSource xsdToXMLInputSource(Object val) {
        if (val instanceof String) {
            String loc = (String)val;
            this.fXSDDescription.reset();
            this.fXSDDescription.setValues(null, loc, null, null);
            XMLInputSource xis = null;
            try {
                xis = this.fEntityManager.resolveEntity(this.fXSDDescription);
            }
            catch (IOException ex) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{loc}, (short)1);
            }
            if (xis == null) {
                return new XMLInputSource(null, loc, null);
            }
            return xis;
        }
        if (val instanceof InputSource) {
            return XMLSchemaLoader.saxToXMLInputSource((InputSource)val);
        }
        if (val instanceof InputStream) {
            return new XMLInputSource(null, null, null, (InputStream)val, null);
        }
        if (val instanceof File) {
            File file = (File)val;
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException ex) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{file.toString()}, (short)1);
            }
            return new XMLInputSource(null, null, null, is, null);
        }
        throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have a value of type {" + val.getClass().getName() + "}. Possible types of the value supported are String, File, InputStream, " + "InputSource OR an array of these types.");
    }

    private XMLInputSource dom2xmlInputSource(LSInput is) {
        XMLInputSource xis = null;
        xis = is.getStringData() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : (is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }

    private static XMLInputSource saxToXMLInputSource(InputSource sis) {
        String publicId = sis.getPublicId();
        String systemId = sis.getSystemId();
        Reader charStream = sis.getCharacterStream();
        if (charStream != null) {
            return new XMLInputSource(publicId, systemId, null, charStream, null);
        }
        InputStream byteStream = sis.getByteStream();
        if (byteStream != null) {
            return new XMLInputSource(publicId, systemId, null, byteStream, sis.getEncoding());
        }
        return new XMLInputSource(publicId, systemId, null);
    }

    public XSModel loadInputList(LSInputList is) {
        int length = is.getLength();
        if (length == 0) {
            return null;
        }
        SchemaGrammar[] gs = new SchemaGrammar[length];
        int i = 0;
        while (i < length) {
            try {
                gs[i] = (SchemaGrammar)this.loadGrammar(this.dom2xmlInputSource(is.item(i)));
            }
            catch (Exception e) {
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                return null;
            }
            ++i;
        }
        return new XSModelImpl(gs);
    }

    public XSModel loadURIList(StringList uriList) {
        int length = uriList.getLength();
        if (length == 0) {
            return null;
        }
        SchemaGrammar[] gs = new SchemaGrammar[length];
        int i = 0;
        while (i < length) {
            try {
                gs[i] = (SchemaGrammar)this.loadGrammar(new XMLInputSource(null, uriList.item(i), null));
            }
            catch (Exception e) {
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                return null;
            }
            ++i;
        }
        return new XSModelImpl(gs);
    }

    public XSModel loadURI(String uri) {
        try {
            Grammar g = this.loadGrammar(new XMLInputSource(null, uri, null));
            return ((XSGrammar)g).toXSModel();
        }
        catch (Exception e) {
            if (this.fErrorHandler != null) {
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
            return null;
        }
    }

    public XSModel load(LSInput is) {
        try {
            Grammar g = this.loadGrammar(this.dom2xmlInputSource(is));
            return ((XSGrammar)g).toXSModel();
        }
        catch (Exception e) {
            if (this.fErrorHandler != null) {
                DOMErrorImpl error = new DOMErrorImpl();
                error.fException = e;
                error.fMessage = e.getMessage();
                error.fSeverity = (short)3;
                this.fErrorHandler.getErrorHandler().handleError(error);
            }
            return null;
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        if (featureId.equals(AUGMENT_PSVI)) {
            return Boolean.TRUE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("error-handler") && this.fErrorHandler != null) {
            return this.fErrorHandler.getErrorHandler();
        }
        try {
            boolean feature = this.getFeature(name);
            return feature ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            try {
                Object property = this.getProperty(name);
                return property;
            }
            catch (Exception ex) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
        }
    }

    public Object getProperty(String propertyId) throws XMLConfigurationException {
        return this.fLoaderConfig.getProperty(propertyId);
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }

    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equals("validate") && state) {
                return;
            }
            try {
                this.setFeature(name, state);
            }
            catch (Exception e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            return;
        }
        if (name.equals("error-handler")) {
            if (value instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                    this.setErrorHandler(this.fErrorHandler);
                }
                catch (XMLConfigurationException e) {}
            } else {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            return;
        }
        try {
            this.setProperty(name, value);
        }
        catch (Exception ex) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
    }

    public void setProperty(String propertyId, Object state) throws XMLConfigurationException {
        this.fSettingsChanged = true;
        if (state != null) {
            this.fLoaderConfig.setProperty(propertyId, state);
        }
        if (propertyId.equals(JAXP_SCHEMA_SOURCE)) {
            this.fJAXPSource = state;
            this.fJAXPProcessed = false;
        } else if (propertyId.equals(XMLGRAMMAR_POOL)) {
            this.fGrammarPool = (XMLGrammarPool)state;
        } else if (propertyId.equals(SCHEMA_LOCATION)) {
            this.fExternalSchemas = (String)state;
        } else if (propertyId.equals(SCHEMA_NONS_LOCATION)) {
            this.fExternalNoNSSchema = (String)state;
        } else if (propertyId.equals(ENTITY_RESOLVER)) {
            this.fEntityManager.setProperty(ENTITY_RESOLVER, state);
        } else if (propertyId.equals(ERROR_REPORTER)) {
            this.fErrorReporter = (XMLErrorReporter)state;
            if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
            }
        }
    }

    public boolean canSetParameter(String name, Object value) {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            return name.equals("validate") || name.equals(SCHEMA_FULL_CHECKING) || name.equals(CONTINUE_AFTER_FATAL_ERROR) || name.equals(ALLOW_JAVA_ENCODINGS) || name.equals(STANDARD_URI_CONFORMANT_FEATURE);
        }
        return name.equals("error-handler") || name.equals(SYMBOL_TABLE) || name.equals(ERROR_REPORTER) || name.equals(ERROR_HANDLER) || name.equals(ENTITY_RESOLVER) || name.equals(XMLGRAMMAR_POOL) || name.equals(SCHEMA_LOCATION) || name.equals(SCHEMA_NONS_LOCATION) || name.equals(JAXP_SCHEMA_SOURCE);
    }

    public static boolean tokenizeSchemaLocationStr(String schemaStr, Hashtable locations) {
        if (schemaStr != null) {
            StringTokenizer t = new StringTokenizer(schemaStr, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = t.nextToken();
                if (!t.hasMoreTokens()) {
                    return false;
                }
                String location = t.nextToken();
                LocationArray la = (LocationArray)locations.get(namespace);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(namespace, la);
                }
                la.addLocation(location);
            }
        }
        return true;
    }

    public static void processExternalHints(String sl, String nsl, Hashtable locations, XMLErrorReporter er) {
        block7: {
            XSAttributeDecl attrDecl;
            if (sl != null) {
                try {
                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                    attrDecl.fType.validate(sl, null, null);
                    if (!XMLSchemaLoader.tokenizeSchemaLocationStr(sl, locations)) {
                        er.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sl}, (short)0);
                    }
                }
                catch (InvalidDatatypeValueException ex) {
                    er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
                }
            }
            if (nsl == null) break block7;
            try {
                attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                attrDecl.fType.validate(nsl, null, null);
                LocationArray la = (LocationArray)locations.get(XMLSymbols.EMPTY_STRING);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(XMLSymbols.EMPTY_STRING, la);
                }
                la.addLocation(nsl);
            }
            catch (InvalidDatatypeValueException ex) {
                er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
            }
        }
    }

    SchemaGrammar loadSchema(XSDDescription desc, XMLInputSource source, Hashtable locationPairs) throws IOException, XNIException {
        if (!this.fJAXPProcessed) {
            this.processJAXPSchemaSource(locationPairs);
        }
        SchemaGrammar grammar = this.fSchemaHandler.parseSchema(source, desc, locationPairs);
        return grammar;
    }

    XMLSchemaLoader(XMLErrorReporter errorReporter, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this(null, errorReporter, null, grammarBucket, sHandler, builder);
    }

    public static XMLInputSource resolveDocument(XSDDescription desc, Hashtable locationPairs, XMLEntityResolver entityResolver) throws IOException {
        String[] hints;
        String namespace;
        String ns;
        LocationArray tempLA;
        String loc = null;
        if ((desc.getContextType() == 2 || desc.fromInstance()) && (tempLA = (LocationArray)locationPairs.get(ns = (namespace = desc.getTargetNamespace()) == null ? XMLSymbols.EMPTY_STRING : namespace)) != null) {
            loc = tempLA.getFirstLocation();
        }
        if (loc == null && (hints = desc.getLocationHints()) != null && hints.length > 0) {
            loc = hints[0];
        }
        String expandedLoc = XMLEntityManager.expandSystemId(loc, desc.getBaseSystemId(), false);
        desc.setLiteralSystemId(loc);
        desc.setExpandedSystemId(expandedLoc);
        return entityResolver.resolveEntity(desc);
    }

    XMLSchemaLoader(SymbolTable symbolTable, XMLErrorReporter errorReporter, XMLEntityManager entityResolver, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this.fLoaderConfig.addRecognizedFeatures(RECOGNIZED_FEATURES);
        this.fLoaderConfig.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        if (symbolTable != null) {
            this.fLoaderConfig.setProperty(SYMBOL_TABLE, symbolTable);
        }
        if (errorReporter == null) {
            errorReporter = new XMLErrorReporter();
            errorReporter.setLocale(this.fLocale);
            errorReporter.setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = errorReporter;
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        this.fLoaderConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
        this.fEntityManager = entityResolver;
        if (this.fEntityManager != null) {
            this.fLoaderConfig.setProperty(ENTITY_MANAGER, this.fEntityManager);
        }
        this.fLoaderConfig.setFeature(AUGMENT_PSVI, true);
        if (grammarBucket == null) {
            grammarBucket = new XSGrammarBucket();
        }
        this.fGrammarBucket = grammarBucket;
        if (sHandler == null) {
            sHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        }
        this.fSubGroupHandler = sHandler;
        CMNodeFactory nodeFactory = new CMNodeFactory();
        if (builder == null) {
            builder = new CMBuilder(nodeFactory);
        }
        this.fCMBuilder = builder;
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
        this.fDeclPool = new XSDeclarationPool();
        this.fJAXPCache = new Hashtable();
        this.fSettingsChanged = true;
    }

    static class LocationArray {
        int length;
        String[] locations = new String[2];

        public int getLength() {
            return this.length;
        }

        LocationArray() {
        }

        public void resize(int oldLength, int newLength) {
            String[] temp = new String[newLength];
            System.arraycopy(this.locations, 0, temp, 0, Math.min(oldLength, newLength));
            this.locations = temp;
            this.length = Math.min(oldLength, newLength);
        }

        public String getFirstLocation() {
            return this.length > 0 ? this.locations[0] : null;
        }

        public String[] getLocationArray() {
            if (this.length < this.locations.length) {
                this.resize(this.locations.length, this.length);
            }
            return this.locations;
        }

        public void addLocation(String location) {
            if (this.length >= this.locations.length) {
                this.resize(this.length, Math.max(1, this.length * 2));
            }
            this.locations[this.length++] = location;
        }
    }
}

