/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.datacollector;

import com.sun.cns.datacollector.AMCPUStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataCollector {
    private static AMCPUStatus amcpu = new AMCPUStatus();
    private static String[] envp = new String[]{"LC_ALL=C"};
    static Logger LOG = Logger.getLogger((class$com$sun$cns$datacollector$DataCollector == null ? (class$com$sun$cns$datacollector$DataCollector = DataCollector.class$("com.sun.cns.datacollector.DataCollector")) : class$com$sun$cns$datacollector$DataCollector).getName());
    static final String BASEDIR = System.getProperty("datacollector.basedir", "/usr/lib/dc");
    static final File PROBE = new File(BASEDIR, "probe");
    static /* synthetic */ Class class$com$sun$cns$datacollector$DataCollector;

    public String[] getCPUStatus() {
        return amcpu.getCPUStatus();
    }

    public String getNumCPUs() {
        return amcpu.getNumCPUs();
    }

    public String getCPUSpeed() {
        return amcpu.getCPUSpeed();
    }

    public static String collectValue(String collectionID, String textKey) {
        String value = "";
        try {
            Process p = Runtime.getRuntime().exec(new String[]{PROBE.getPath(), "-cfdir", BASEDIR, "-class", "General", "-show", collectionID});
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = in.readLine();
            while (s != null) {
                if (s.startsWith(textKey)) {
                    value = s.substring(textKey.length() + 1).trim();
                    break;
                }
                s = in.readLine();
            }
            try {
                in.close();
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "Error closing input stream", ex);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error collecting " + collectionID + '/' + textKey, ex);
        }
        return value;
    }

    public HashMap collectPatches() {
        HashMap<String, String> PatchCollection = new HashMap<String, String>();
        String szKey = "";
        String szValue = "";
        String cmd = "/usr/lib/dc/probe -cfdir /usr/lib/dc -class Patch";
        LOG.info("Collect Patches");
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
            boolean bIDFound = false;
            while (s != null && !s.startsWith("ID")) {
                s = input.readLine();
                bIDFound = true;
            }
            int iSpaceIndex = 0;
            int iTabIndex = 0;
            while (s != null && bIDFound) {
                s = input.readLine();
                if (s == null || s.length() <= 0) continue;
                iSpaceIndex = s.indexOf(32);
                iTabIndex = s.indexOf(" \t");
                szKey = s.substring(iSpaceIndex + 1, iTabIndex);
                szKey = szKey.trim();
                szValue = s.substring(iTabIndex + 1);
                szValue = szValue.trim();
                PatchCollection.put(szKey, szValue);
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream from command: " + cmd);
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        return PatchCollection;
    }

    public HashMap[] collectCPUInfo() {
        HashMap[] result = null;
        return result;
    }

    public HashMap collectPackages() {
        HashMap<String, String> PKGCollection = new HashMap<String, String>();
        String szKey = "";
        String szValue = "";
        StringBuffer buff = new StringBuffer();
        LOG.info("Collect Packages");
        LOG.info("Collector harvesting packages");
        String cmd = "/usr/bin/pkginfo -l";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            int i = 0;
            s = input.readLine();
            while (s != null) {
                if ((s = s.trim()) != null && s.length() > 0) {
                    if (s.startsWith("PKGINST:")) {
                        i = s.indexOf(58);
                        szKey = s.substring(s.lastIndexOf(32), s.length()).trim();
                    } else if (s.startsWith("VERSION:")) {
                        i = s.indexOf(58);
                        buff.append(s.substring(0, i + 1) + s.substring(i + 3, s.length()) + "\t");
                    } else if (s.startsWith("INSTDATE:")) {
                        i = s.indexOf(58);
                        buff.append(s.substring(0, i + 1) + s.substring(i + 3, s.length()) + "\t");
                    } else if (s.startsWith("STATUS:")) {
                        i = s.indexOf(58);
                        buff.append(s.substring(0, i + 1) + s.substring(i + 3, s.length()));
                    }
                } else if (s.length() == 0) {
                    szValue = buff.toString();
                    szValue = szValue.trim();
                    PKGCollection.put(szKey, szValue);
                    buff.setLength(0);
                }
                s = input.readLine();
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream from command: " + cmd);
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        return PKGCollection;
    }

    public HashMap collectNICInfo() {
        HashMap<String, String> NICCollection = new HashMap<String, String>();
        String szKey = "";
        String szValue = "";
        String szValue1 = "";
        int startIndex = -1;
        int stopIndex = -1;
        boolean bRead = true;
        String szProtocol = "";
        String szIP = "";
        String szMAC = "";
        String szInet6 = "";
        String szStoredValue = "";
        LOG.info("Collect NIC Devices");
        LOG.info("Collector harvesting NIC devices");
        String cmd = "/usr/sbin/ifconfig -a";
        String resultValue = "";
        Vector<String> args = new Vector<String>();
        args.add("ifconfig");
        args.add("-a");
        Process proc = null;
        StringBuffer sb = new StringBuffer();
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
            BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            int b = 0;
            while ((b = input.read()) != -1) {
                sb.append((char)b);
            }
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
        }
        resultValue = sb.toString();
        LOG.info("resultValue:" + resultValue);
        if (resultValue != "" && resultValue != null) {
            startIndex = 0;
            stopIndex = resultValue.indexOf(10);
            bRead = stopIndex != -1;
            while (bRead && startIndex <= resultValue.length()) {
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    LOG.info("NIC val:" + szValue1);
                    startIndex = stopIndex + 1;
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                szValue1.trim();
                if (szValue1 == null || szValue1.length() <= 0 || szValue1.startsWith("lo") || szValue1.indexOf(": ") == -1) continue;
                szKey = szValue1.substring(0, szValue1.indexOf(58)).trim();
                int i = szValue1.indexOf("IPv");
                szProtocol = szValue1.substring(i, szValue1.indexOf(62, i)).trim();
                LOG.info("szProtocol=" + szProtocol);
                if (szProtocol.compareTo("IPv4") == 0) {
                    szProtocol = "v4";
                    stopIndex = resultValue.indexOf("\n", startIndex);
                    if (stopIndex != -1) {
                        szValue1 = resultValue.substring(startIndex, stopIndex);
                        startIndex = stopIndex + 1;
                        LOG.info("NIC val:" + szValue1);
                    } else {
                        szValue1 = resultValue.substring(startIndex, resultValue.length());
                        LOG.info("NIC val:" + szValue1);
                        bRead = false;
                    }
                    if (szValue1 != null && (i = szValue1.indexOf("inet ")) != -1) {
                        szIP = szValue1.substring(szValue1.indexOf(32, i), szValue1.indexOf("netmask")).trim();
                        LOG.info("szIP=" + szIP);
                    }
                    if ((stopIndex = resultValue.indexOf("\n", startIndex)) != -1) {
                        szValue1 = resultValue.substring(startIndex, stopIndex);
                        startIndex = stopIndex + 1;
                        LOG.info("NIC val:" + szValue1);
                    } else {
                        szValue1 = resultValue.substring(startIndex, resultValue.length());
                        LOG.info("NIC val:" + szValue1);
                        bRead = false;
                    }
                    if (szValue1 == null || (i = szValue1.indexOf("ether ")) == -1) continue;
                    LOG.info("NIC reading input=" + szValue1);
                    szMAC = szValue1.substring(i + 6, szValue1.length()).trim();
                    LOG.info("\nNIC name:" + szKey + "  szIP:" + szIP + "  szMAC:" + szMAC + "\n");
                    szValue = NICCollection.isEmpty() ? szProtocol + ":" + szIP + "\t" + "mac:" + szMAC + "\tprimary:true" : szProtocol + ":" + szIP + "\t" + "mac:" + szMAC + "\tprimary:false";
                    NICCollection.put(szKey, szValue);
                    LOG.info("Num NIC records: " + NICCollection.size());
                    continue;
                }
                if (szProtocol.compareTo("IPv6") != 0) continue;
                szProtocol = "v6";
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    startIndex = stopIndex + 1;
                    LOG.info("NIC val:" + szValue1);
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                if (szValue1 == null || szValue1.indexOf("ether ") == -1) continue;
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    startIndex = stopIndex + 1;
                    LOG.info("NIC val:" + szValue1);
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                if (szValue1 == null || (i = szValue1.indexOf("inet6 ")) == -1) continue;
                szInet6 = szValue1.substring(szValue1.indexOf(32, i), szValue1.indexOf(47, i)).trim();
                LOG.info("\nNIC name:" + szKey + "  szIP:" + szIP + "  szMAC:" + szMAC + "  szInet6:" + szInet6 + "\n");
                szStoredValue = NICCollection.get(szKey).toString();
                szValue = szStoredValue + "\t" + szProtocol + ":" + szInet6;
                NICCollection.put(szKey, szValue);
                LOG.info("NIC Stored key=" + szKey);
                LOG.info("NIC Stored value=" + NICCollection.get(szKey).toString());
                LOG.info("Num NIC records: " + NICCollection.size());
            }
        }
        return NICCollection;
    }

    public HashMap collectStorageDevices() {
        HashMap<String, String> StorageDeviceCollection = new HashMap<String, String>();
        String szKey = "";
        String szValue = "";
        StringBuffer buff = new StringBuffer();
        LOG.info("Collect Storage Devices");
        String cmd = "/usr/bin/iostat -En";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        String s1 = null;
        String s2 = null;
        String szPrd = null;
        try {
            int i = 0;
            int ven = 0;
            int prd = 0;
            boolean prdEnd = false;
            int rev = 0;
            int ser = 0;
            boolean serEnd = false;
            int siz = 0;
            boolean bDeviceFound = false;
            s = input.readLine();
            while (s != null && s.length() > 0) {
                if (!bDeviceFound && s.indexOf("Soft Errors:") != -1) {
                    szKey = s.substring(0, s.indexOf(32)).trim();
                    bDeviceFound = true;
                } else if (bDeviceFound) {
                    if (s.startsWith("Vendor:")) {
                        prd = s.indexOf("Product:");
                        rev = s.indexOf("Revision:");
                        szPrd = s.substring(prd + 8, rev).trim();
                        s1 = s.substring(0, prd + 8).replaceAll(" ", "");
                        s2 = s.substring(rev, s.length()).replaceAll(" ", "");
                        s = s1 + szPrd + s2;
                        ven = s.indexOf(58);
                        prd = s.indexOf("Product:");
                        rev = s.indexOf("Revision:");
                        ser = s.indexOf("SerialNo:");
                        buff.append(s.substring(0, prd).trim() + "\t");
                        buff.append(s.substring(prd, rev).trim() + "\t");
                        buff.append(s.substring(rev, ser).trim() + "\t");
                        buff.append(s.substring(ser, s.length()).trim() + "\t");
                    } else if (s.startsWith("Size:")) {
                        s = s.replaceAll(" ", "");
                        i = s.indexOf(58);
                        buff.append(s.substring(0, i + 1).trim());
                        siz = s.indexOf("B<");
                        buff.append(s.substring(i + 1, siz - 1) + "\t" + "Units:" + s.substring(siz - 1, siz + 1));
                        szValue = buff.toString().trim();
                        StorageDeviceCollection.put(szKey, szValue);
                        buff.setLength(0);
                        bDeviceFound = false;
                        s = input.readLine();
                        s = input.readLine();
                    }
                }
                s = input.readLine();
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream from command: " + cmd);
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        return StorageDeviceCollection;
    }

    public static void main(String[] args) {
        System.out.println(DataCollector.collectValue("hostaddrs", "Host Address(es)"));
        System.out.println(DataCollector.collectValue("nisdomain", "NIS Domain"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

