/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.memory;

import com.sun.database.simpleadapter.memory.FieldEntry;
import com.sun.database.simpleadapter.memory.IndexStatus;
import com.sun.database.simpleadapter.memory.RoutingEntry;
import com.sun.database.simpledatabase.BTree;
import com.sun.database.simpledatabase.BottomOfTreeException;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DuplicateAlreadyStoredException;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.ObjectStore;
import com.sun.database.util.HierarchicalField;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class MemoryBTree
extends BTree
implements Serializable {
    private static final String sccs_id = "1.6";
    static final int SIZEINCREMENT = 50;
    static final int BOOLEAN_T = 1;
    static final int BYTE_T = 2;
    static final int CHAR_T = 3;
    static final int DOUBLE_T = 4;
    static final int FLOAT_T = 5;
    static final int INT_T = 6;
    static final int LONG_T = 7;
    static final int SHORT_T = 8;
    static final int STRING_T = 9;
    static final int COMPARESHIGH = 1;
    static final int COMPARESLOW = -1;
    static final int COMPARESEQUAL = 0;
    static final int UPSIDE = 1;
    static final int DOWNSIDE = -1;
    static final int BALANCED = 0;
    static final int DUPLICATE = -2;
    static final int NOOBJECT = -1;
    ObjectStore objectStore;
    IndexStatus currentIndices;
    String keyFieldString;
    HierarchicalField keyField;
    Object keyValue;
    String keyFieldTypeString;
    int keyFieldTypeCode;
    Vector indexStore;
    boolean allowDuplicates = false;
    boolean duplicateInPlace = false;

    public MemoryBTree(ObjectStore objectStore, HierarchicalField hierarchicalField) throws NoSuchFieldException {
        this.objectStore = objectStore;
        this.keyField = hierarchicalField;
        this.keyFieldTypeString = this.keyField.getType().toString();
        this.keyFieldTypeCode = this.keyFieldTypeString.equals("boolean") ? 1 : (this.keyFieldTypeString.equals("byte") ? 2 : (this.keyFieldTypeString.equals("char") ? 3 : (this.keyFieldTypeString.equals("double") ? 4 : (this.keyFieldTypeString.equals("float") ? 5 : (this.keyFieldTypeString.equals("int") ? 6 : (this.keyFieldTypeString.equals("long") ? 7 : (this.keyFieldTypeString.equals("short") ? 8 : 9)))))));
        this.currentIndices = new IndexStatus();
        this.indexStore = new Vector();
    }

    public void destroyAccessMethod() throws IllegalAccessException {
        this.objectStore = null;
        this.indexStore = null;
    }

    public void insertLink(int n) throws DuplicateEntryException, ArrayIndexOutOfBoundsException, IllegalAccessException {
        Object object = this.objectStore.getObject(n);
        try {
            this.keyValue = this.keyField.get(object);
            try {
                this.findTreePosition(this.keyValue);
                if (!this.allowDuplicates) {
                    throw new DuplicateEntryException();
                }
                this.newDuplicate(this.currentIndices, n);
            }
            catch (BottomOfTreeException bottomOfTreeException) {
                this.insertIntoTree(this.keyValue, n);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DatabaseError("MemoryBTree.insertLink():Cannot access the database.");
        }
    }

    public int findLink(Object object) throws NoSuchObjectException {
        try {
            return this.findTreePosition(object);
        }
        catch (BottomOfTreeException bottomOfTreeException) {
            throw new NoSuchObjectException();
        }
    }

    public Enumeration findEnumeration(Object object) throws NoSuchObjectException {
        int n;
        try {
            n = this.findTreePosition(object);
        }
        catch (BottomOfTreeException bottomOfTreeException) {
            throw new NoSuchObjectException();
        }
        return this.retrieveDuplicates(n).elements();
    }

    public void removeLink(int n) {
        Object object = this.objectStore.getObject(n);
        try {
            this.keyValue = this.keyField.get(object);
            try {
                this.currentIndices.keepRoutingSlip = true;
                this.findTreePosition(this.keyValue);
                this.currentIndices.modifiedNode = this.currentIndices.currentNode;
                this.deleteFromTree(this.currentIndices);
                this.rebalanceTree(this.currentIndices);
            }
            catch (BottomOfTreeException bottomOfTreeException) {}
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DatabaseError("MemoryBTree.removeLink():Cannot access the database.");
        }
    }

    public void allowDuplicates(boolean bl) throws DuplicateAlreadyStoredException {
        if (!bl && this.duplicateInPlace) {
            throw new DuplicateAlreadyStoredException();
        }
        this.allowDuplicates = bl;
    }

    public boolean areDuplicatesAllowed() {
        return this.allowDuplicates;
    }

    private void moveUp(IndexStatus indexStatus) throws BottomOfTreeException {
        if (indexStatus.keepRoutingSlip) {
            indexStatus.routingSlip.push(new RoutingEntry(indexStatus.currentNode, 1));
        }
        indexStatus.modifiedNode = indexStatus.currentNode.btreeUp();
        if (indexStatus.modifiedNode == null) {
            throw new BottomOfTreeException();
        }
        if (indexStatus.modifiedNode.heavySide != 0) {
            indexStatus.parentNode = indexStatus.currentNode;
            indexStatus.focalNode = indexStatus.modifiedNode;
            indexStatus.heavyChildNode = indexStatus.modifiedNode.heavySide == 1 ? indexStatus.focalNode.btreeUp() : indexStatus.focalNode.down;
        }
        indexStatus.currentNode = indexStatus.modifiedNode;
    }

    private void newUp(IndexStatus indexStatus, int n) {
        indexStatus.modifiedNode = this.newRecord(indexStatus, n);
        indexStatus.currentNode.setUp(indexStatus.modifiedNode);
        this.rebalanceTree(indexStatus);
    }

    private void moveDown(IndexStatus indexStatus) throws BottomOfTreeException {
        if (indexStatus.keepRoutingSlip) {
            indexStatus.routingSlip.push(new RoutingEntry(indexStatus.currentNode, -1));
        }
        indexStatus.modifiedNode = indexStatus.currentNode.down;
        if (indexStatus.modifiedNode == null) {
            throw new BottomOfTreeException();
        }
        if (indexStatus.modifiedNode.heavySide != 0) {
            indexStatus.parentNode = indexStatus.currentNode;
            indexStatus.focalNode = indexStatus.modifiedNode;
            indexStatus.heavyChildNode = indexStatus.modifiedNode.heavySide == 1 ? indexStatus.focalNode.btreeUp() : indexStatus.focalNode.down;
        }
        indexStatus.currentNode = indexStatus.modifiedNode;
    }

    private void newDown(IndexStatus indexStatus, int n) {
        indexStatus.currentNode.down = indexStatus.modifiedNode = this.newRecord(indexStatus, n);
        this.rebalanceTree(indexStatus);
    }

    private void newDuplicate(IndexStatus indexStatus, int n) {
        FieldEntry fieldEntry = indexStatus.currentNode;
        FieldEntry fieldEntry2 = fieldEntry.up;
        indexStatus.modifiedNode = this.newRecord(indexStatus, n);
        if (fieldEntry2 != null && fieldEntry2.heavySide == -2) {
            fieldEntry = fieldEntry2;
            while (fieldEntry.down != null) {
                fieldEntry = fieldEntry.down;
            }
            fieldEntry.down = indexStatus.modifiedNode;
            indexStatus.modifiedNode.up = fieldEntry;
        } else {
            indexStatus.modifiedNode.up = fieldEntry.up;
            fieldEntry.up = indexStatus.modifiedNode;
        }
        indexStatus.modifiedNode.heavySide = -2;
        indexStatus.modifiedNode.down = null;
    }

    private void operateOnTree(Object object, int n, IndexStatus indexStatus) throws BottomOfTreeException {
        try {
            if (indexStatus.databaseSize == 0) {
                if (n == -1) {
                    throw new BottomOfTreeException();
                }
                indexStatus.parentOfTop.down = indexStatus.currentNode = this.newRecord(indexStatus, n);
            } else {
                int n2;
                indexStatus.parentNode = indexStatus.parentOfTop;
                indexStatus.currentNode = indexStatus.parentOfTop.down;
                indexStatus.focalNode = indexStatus.parentOfTop.down;
                block11: while ((n2 = this.compareAgainstRecord(object, indexStatus.currentNode.recordNumber)) != 0) {
                    switch (n2) {
                        case -1: {
                            try {
                                this.moveDown(indexStatus);
                            }
                            catch (BottomOfTreeException bottomOfTreeException) {
                                if (n == -1) {
                                    throw new BottomOfTreeException();
                                }
                                this.newDown(indexStatus, n);
                            }
                            continue block11;
                        }
                        case 1: {
                            try {
                                this.moveUp(indexStatus);
                            }
                            catch (BottomOfTreeException bottomOfTreeException) {
                                if (n == -1) {
                                    throw new BottomOfTreeException();
                                }
                                this.newUp(indexStatus, n);
                            }
                            continue block11;
                        }
                    }
                }
                if (indexStatus.keepRoutingSlip) {
                    indexStatus.routingSlip.push(new RoutingEntry(indexStatus.currentNode, 0));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DatabaseError("MemoryBTree.operatOnTree(): Requested non-existent index.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new DatabaseError("MemoryBTree.operatOnTree(): Ran out of memory.");
        }
    }

    private void getSymetricSuccessor(IndexStatus indexStatus) {
        FieldEntry fieldEntry = indexStatus.modifiedNode;
        indexStatus.routingSlip.pop();
        try {
            this.moveUp(indexStatus);
            while (true) {
                this.moveDown(indexStatus);
            }
        }
        catch (BottomOfTreeException bottomOfTreeException) {
            indexStatus.symetricSuccessor = indexStatus.currentNode;
            indexStatus.modifiedNode = fieldEntry;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new DatabaseError("MemoryBTree.getSymetricSuccessor(): Ran out of memory.");
        }
    }

    private void deleteFromTree(IndexStatus indexStatus) {
        if (indexStatus.modifiedNode.btreeUp() == null) {
            if (indexStatus.modifiedNode.down != null) {
                indexStatus.symetricSuccessor = indexStatus.modifiedNode.down;
                indexStatus.modifiedNode.heavySide = 0;
                this.replacePersistentNodes(indexStatus, true, true);
                int n = ((RoutingEntry)indexStatus.routingSlip.peek()).direction;
                if (n == 1) {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.setUp(null);
                } else {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.down = null;
                }
            } else {
                indexStatus.symetricSuccessor = null;
                indexStatus.routingSlip.pop();
                int n = ((RoutingEntry)indexStatus.routingSlip.peek()).direction;
                FieldEntry fieldEntry = ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep;
                if (n == 1) {
                    fieldEntry.setUp(null);
                } else {
                    fieldEntry.down = null;
                }
            }
        } else if (indexStatus.modifiedNode.btreeUp().down == null) {
            boolean bl = false;
            indexStatus.symetricSuccessor = indexStatus.modifiedNode.btreeUp();
            if (indexStatus.symetricSuccessor.getUp() == null) {
                bl = true;
                ((RoutingEntry)indexStatus.routingSlip.peek()).direction = 1;
            } else {
                --indexStatus.modifiedNode.heavySide;
                indexStatus.routingSlip.pop();
            }
            int n = ((RoutingEntry)indexStatus.routingSlip.peek()).direction;
            this.replacePersistentNodes(indexStatus, true, false);
            if (!bl) {
                if (n == -1) {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.down = indexStatus.currentNode;
                } else {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.setUp(indexStatus.currentNode);
                }
            }
        } else {
            try {
                int n = ((RoutingEntry)indexStatus.routingSlip.peek()).direction;
                FieldEntry fieldEntry = ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep;
                this.getSymetricSuccessor(indexStatus);
                this.replacePersistentNodes(indexStatus, false, false);
                if (n == 1) {
                    fieldEntry.setUp(indexStatus.symetricSuccessor);
                } else {
                    fieldEntry.down = indexStatus.symetricSuccessor;
                }
                RoutingEntry routingEntry = (RoutingEntry)indexStatus.routingSlip.pop();
                n = ((RoutingEntry)indexStatus.routingSlip.peek()).direction;
                if (n == 1) {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.setUp(null);
                } else {
                    ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep.down = null;
                }
            }
            catch (EmptyStackException emptyStackException) {
                throw new DatabaseError("MemoryBTree.deleteFromTree(): Ran off the stack.");
            }
        }
    }

    private void replacePersistentNodes(IndexStatus indexStatus, boolean bl, boolean bl2) {
        FieldEntry fieldEntry = ((RoutingEntry)indexStatus.routingSlip.peek()).thisStep;
        if (!bl) {
            if (indexStatus.symetricSuccessor.btreeUp() != null) {
                fieldEntry.down = indexStatus.symetricSuccessor.btreeUp();
            }
            indexStatus.symetricSuccessor.setUp(indexStatus.modifiedNode.btreeUp());
        }
        if (!bl2) {
            indexStatus.symetricSuccessor.down = indexStatus.modifiedNode.down;
        }
        indexStatus.symetricSuccessor.heavySide = indexStatus.modifiedNode.heavySide;
        indexStatus.currentNode = indexStatus.symetricSuccessor;
        this.replaceNodeOnStack(indexStatus.routingSlip, indexStatus.modifiedNode, indexStatus.symetricSuccessor);
        if (indexStatus.modifiedNode == indexStatus.focalNode) {
            indexStatus.focalNode = indexStatus.symetricSuccessor;
            indexStatus.parentNode = fieldEntry;
        }
        if (indexStatus.modifiedNode == indexStatus.parentNode) {
            indexStatus.parentNode = indexStatus.symetricSuccessor;
        }
    }

    private void insertIntoTree(Object object, int n) {
        try {
            this.operateOnTree(object, n, this.currentIndices);
        }
        catch (BottomOfTreeException bottomOfTreeException) {
            // empty catch block
        }
    }

    private int findTreePosition(Object object) throws BottomOfTreeException {
        this.operateOnTree(object, -1, this.currentIndices);
        return this.currentIndices.currentNode.recordNumber;
    }

    private Vector retrieveDuplicates(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        FieldEntry fieldEntry = (FieldEntry)this.indexStore.elementAt(n);
        vector.addElement(new Integer(fieldEntry.recordNumber));
        fieldEntry = fieldEntry.up;
        if (fieldEntry != null && fieldEntry.heavySide == -2) {
            vector.addElement(new Integer(fieldEntry.recordNumber));
            while (fieldEntry.down != null) {
                fieldEntry = fieldEntry.down;
                vector.addElement(new Integer(fieldEntry.recordNumber));
            }
        }
        return vector;
    }

    private void replaceNodeOnStack(Stack stack, FieldEntry fieldEntry, FieldEntry fieldEntry2) {
        Stack<RoutingEntry> stack2 = new Stack<RoutingEntry>();
        while (!stack.isEmpty()) {
            RoutingEntry routingEntry = (RoutingEntry)stack.pop();
            if (routingEntry.thisStep.recordNumber == fieldEntry.recordNumber) {
                routingEntry.thisStep = fieldEntry2;
                RoutingEntry routingEntry2 = (RoutingEntry)stack.peek();
                if (routingEntry2.direction == 1) {
                    routingEntry2.thisStep.setUp(fieldEntry2);
                } else {
                    routingEntry2.thisStep.down = fieldEntry2;
                }
                stack.push(routingEntry);
                break;
            }
            stack2.push(routingEntry);
        }
        while (!stack2.isEmpty()) {
            stack.push(stack2.pop());
        }
    }

    private void adjustHeavySides(IndexStatus indexStatus) {
        if (indexStatus.keepRoutingSlip) {
            while (!indexStatus.routingSlip.empty()) {
                RoutingEntry routingEntry = (RoutingEntry)indexStatus.routingSlip.peek();
                if (routingEntry.thisStep.heavySide == 0) {
                    indexStatus.focalNode = routingEntry.thisStep;
                    indexStatus.heavyChildNode = routingEntry.direction == 1 ? indexStatus.focalNode.down : indexStatus.focalNode.btreeUp();
                    break;
                }
                if (routingEntry.thisStep.heavySide == -routingEntry.direction) {
                    indexStatus.focalNode = routingEntry.thisStep;
                    indexStatus.heavyChildNode = routingEntry.direction == 1 ? indexStatus.focalNode.down : indexStatus.focalNode.btreeUp();
                    break;
                }
                routingEntry.thisStep.heavySide = 0;
                indexStatus.routingSlip.pop();
            }
        } else {
            if (this.compareAgainstRecord(this.keyValue, indexStatus.focalNode.recordNumber) == -1) {
                indexStatus.currentNode = indexStatus.focalNode.down;
            } else {
                indexStatus.currentNode = indexStatus.focalNode.btreeUp();
                if (indexStatus.currentNode != null && indexStatus.currentNode.heavySide == -2) {
                    indexStatus.currentNode = indexStatus.currentNode.btreeUp();
                }
            }
            indexStatus.heavyChildNode = indexStatus.currentNode;
            while (indexStatus.currentNode != indexStatus.modifiedNode) {
                if (this.compareAgainstRecord(this.keyValue, indexStatus.currentNode.recordNumber) == -1) {
                    indexStatus.currentNode.heavySide = -1;
                    indexStatus.currentNode = indexStatus.currentNode.down;
                    continue;
                }
                indexStatus.currentNode.heavySide = 1;
                indexStatus.currentNode = indexStatus.currentNode.btreeUp();
            }
        }
    }

    private void singleRotation(IndexStatus indexStatus, int n) {
        indexStatus.currentNode = indexStatus.heavyChildNode;
        if (n == 1) {
            indexStatus.focalNode.setUp(indexStatus.heavyChildNode.down);
            indexStatus.heavyChildNode.down = indexStatus.focalNode;
        } else {
            indexStatus.focalNode.down = indexStatus.heavyChildNode.btreeUp();
            indexStatus.heavyChildNode.setUp(indexStatus.focalNode);
        }
        indexStatus.focalNode.heavySide = 0;
        indexStatus.heavyChildNode.heavySide = 0;
    }

    private void doubleRotation(IndexStatus indexStatus, int n) {
        if (n == 1) {
            indexStatus.currentNode = indexStatus.heavyChildNode.down;
            indexStatus.heavyChildNode.down = indexStatus.currentNode.btreeUp();
            indexStatus.currentNode.setUp(indexStatus.heavyChildNode);
            indexStatus.focalNode.setUp(indexStatus.currentNode.down);
            indexStatus.currentNode.down = indexStatus.focalNode;
        } else {
            indexStatus.currentNode = indexStatus.heavyChildNode.btreeUp();
            indexStatus.heavyChildNode.setUp(indexStatus.currentNode.down);
            indexStatus.currentNode.down = indexStatus.heavyChildNode;
            indexStatus.focalNode.down = indexStatus.currentNode.btreeUp();
            indexStatus.currentNode.setUp(indexStatus.focalNode);
        }
        if (indexStatus.currentNode.heavySide == n) {
            indexStatus.focalNode.heavySide = -n;
            indexStatus.heavyChildNode.heavySide = 0;
        } else if (indexStatus.currentNode.heavySide == -n) {
            indexStatus.focalNode.heavySide = 0;
            indexStatus.heavyChildNode.heavySide = n;
        } else {
            indexStatus.focalNode.heavySide = 0;
            indexStatus.heavyChildNode.heavySide = 0;
        }
        indexStatus.currentNode.heavySide = 0;
    }

    private void cleanupRebalance(IndexStatus indexStatus) {
        if (indexStatus.focalNode == indexStatus.parentNode.btreeUp()) {
            indexStatus.parentNode.setUp(indexStatus.currentNode);
        } else {
            indexStatus.parentNode.down = indexStatus.currentNode;
        }
    }

    private void rebalanceTree(IndexStatus indexStatus) {
        if (indexStatus.keepRoutingSlip) {
            int n;
            boolean bl;
            this.adjustHeavySides(indexStatus);
            while (!indexStatus.routingSlip.empty() && !(bl = this.doAppropriateRotation(indexStatus, n = -((RoutingEntry)indexStatus.routingSlip.pop()).direction))) {
                try {
                    RoutingEntry routingEntry = (RoutingEntry)indexStatus.routingSlip.peek();
                    indexStatus.focalNode = routingEntry.thisStep;
                    indexStatus.heavyChildNode = routingEntry.direction == 1 ? indexStatus.focalNode.btreeUp() : indexStatus.focalNode.down;
                    routingEntry = (RoutingEntry)indexStatus.routingSlip.peek();
                    indexStatus.parentNode = routingEntry.thisStep;
                }
                catch (EmptyStackException emptyStackException) {}
            }
        } else {
            this.adjustHeavySides(indexStatus);
            int n = this.compareAgainstRecord(this.keyValue, indexStatus.focalNode.recordNumber) == -1 ? -1 : 1;
            this.doAppropriateRotation(indexStatus, n);
        }
        indexStatus.postBalance();
    }

    private boolean doAppropriateRotation(IndexStatus indexStatus, int n) {
        boolean bl = false;
        if (indexStatus.focalNode.heavySide == n) {
            bl = false;
            if (indexStatus.heavyChildNode.heavySide == n) {
                this.singleRotation(indexStatus, n);
            } else {
                this.doubleRotation(indexStatus, n);
            }
            this.cleanupRebalance(indexStatus);
        } else if (indexStatus.focalNode.heavySide == -n) {
            indexStatus.focalNode.heavySide = 0;
            bl = false;
        } else {
            indexStatus.focalNode.heavySide = n;
            bl = true;
        }
        return bl;
    }

    private int compareAgainstRecord(Object object, int n) {
        int n2;
        Object object2 = this.objectStore.getObjectFieldValue(this.keyField, n);
        switch (this.keyFieldTypeCode) {
            case 2: {
                n2 = this.compareByType(((Byte)object).longValue(), this.objectStore.getObjectFieldLong(this.keyField, n));
                break;
            }
            case 3: {
                n2 = this.compareByType((Character)object, this.objectStore.getObjectFieldChar(this.keyField, n));
                break;
            }
            case 4: {
                n2 = this.compareByType((Double)object, this.objectStore.getObjectFieldDouble(this.keyField, n));
                break;
            }
            case 5: {
                n2 = this.compareByType(((Float)object).doubleValue(), this.objectStore.getObjectFieldDouble(this.keyField, n));
                break;
            }
            case 6: {
                n2 = this.compareByType(((Integer)object).longValue(), this.objectStore.getObjectFieldLong(this.keyField, n));
                break;
            }
            case 7: {
                n2 = this.compareByType((Long)object, this.objectStore.getObjectFieldLong(this.keyField, n));
                break;
            }
            case 8: {
                n2 = this.compareByType(((Short)object).longValue(), this.objectStore.getObjectFieldLong(this.keyField, n));
                break;
            }
            default: {
                n2 = this.compareByType((String)object, (String)object2);
            }
        }
        return n2;
    }

    private int compareByType(long l, long l2) {
        if (l > l2) {
            return 1;
        }
        if (l < l2) {
            return -1;
        }
        return 0;
    }

    private int compareByType(Character c, char c2) {
        if (c.charValue() > c2) {
            return 1;
        }
        if (c.charValue() < c2) {
            return -1;
        }
        return 0;
    }

    private int compareByType(double d, double d2) {
        if (d > d2) {
            return 1;
        }
        if (d < d2) {
            return -1;
        }
        return 0;
    }

    private int compareByType(String string, String string2) {
        int n = string.compareTo(string2);
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    private FieldEntry newRecord(IndexStatus indexStatus, int n) {
        FieldEntry fieldEntry = null;
        ++indexStatus.databaseSize;
        if (n > indexStatus.databaseSize) {
            throw new DatabaseError("MemoryBTree.newRecord():index store database size out of sync with object store.");
        }
        if (this.indexStore.capacity() <= indexStatus.databaseSize) {
            this.indexStore.ensureCapacity(indexStatus.databaseSize + 50);
        }
        FieldEntry fieldEntry2 = new FieldEntry();
        fieldEntry2.recordNumber = n;
        try {
            this.indexStore.addElement(fieldEntry2);
            fieldEntry = (FieldEntry)this.indexStore.elementAt(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DatabaseError("MemoryBTree.newRecord(): caught unexpected exception, " + exception.getMessage() + ".");
        }
        return fieldEntry;
    }
}

