/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation.swing;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class MessageTextArea
extends JTextArea {
    private int iHeight = -1;

    public MessageTextArea() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    public MessageTextArea(String sString, int iReferenceWidth) {
        this();
        this.setText(sString);
        this.setHeight(this.calculateBestHeight(iReferenceWidth));
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getHeight() > -1) {
            d.height = this.getHeight();
        }
        return d;
    }

    public void setHeight(int iHeight) {
        this.iHeight = iHeight;
    }

    public int getHeight() {
        return this.iHeight;
    }

    private int calculateBestHeight(int iWidth) {
        JFrame frame = new JFrame();
        frame.setSize(iWidth, 1000);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this);
        contentPane.add(Box.createVerticalGlue());
        this.validateFrame(frame);
        int iHeight = this.getPreferredSize().height;
        contentPane.remove(this);
        frame.dispose();
        return iHeight;
    }

    private void validateFrame(JFrame frame) {
        Container parent = frame.getParent();
        if (parent != null && !parent.isDisplayable()) {
            parent.addNotify();
        }
        if (!frame.isDisplayable()) {
            frame.addNotify();
        }
        frame.validate();
    }
}

