/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GenericUpdate
implements Update {
    private String updateID = null;
    private Integer updateStatus = null;
    private Boolean restartRequired = new Boolean("false");
    private Boolean downloadOnly = new Boolean("false");
    private String name = null;
    private String description = null;
    private String category = null;
    private Integer size = null;
    private Date availableDate = null;
    private Date installationDate = null;
    private Boolean removable = new Boolean(false);
    private List requiredUpdates = null;
    private List obsoleteUpdates = null;
    private List removeDependency = null;
    private String[] requiredUpdateNames = null;
    private String[] obsoleteUpdateNames = null;
    private String installedRevision = null;
    private String readme = null;
    private int updateOperateStatus = -1;
    private PatchProWrapper ppro = PatchProWrapper.getInstance();
    private String updateOperateMessage = "";

    public static Update getInstance() {
        return new GenericUpdate();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUpdateID() {
        return this.updateID;
    }

    public void setUpdateID(String updateID) {
        this.updateID = updateID;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public Integer getUpdateStatus() {
        return this.updateStatus;
    }

    public void resetUpdateStatus() {
        this.updateStatus = null;
    }

    public void setUpdateStatus(Integer status) {
        this.updateStatus = status;
    }

    public void setRestartRequired(Boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    public Boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setDownloadOnly(Boolean downloadOnly) {
        this.downloadOnly = downloadOnly;
    }

    public Boolean isDownloadOnly() {
        return this.downloadOnly;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setAvailableDate(Date availableDate) {
        this.availableDate = availableDate;
    }

    public Date getAvailableDate() {
        return this.availableDate;
    }

    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public boolean isInstalled() {
        return this.installationDate != null;
    }

    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public Boolean isRemovable() {
        return this.removable;
    }

    public void addRequiredUpdate(Update update) {
        if (this.requiredUpdates == null) {
            this.requiredUpdates = new ArrayList();
        }
        if (!this.requiredUpdates.contains(update)) {
            this.requiredUpdates.add(update);
        }
    }

    public void removeRequiredUpdate(Update update) {
        this.requiredUpdates.remove(update);
    }

    public void addObsoleteUpdate(Update update) {
        if (this.obsoleteUpdates == null) {
            this.obsoleteUpdates = new ArrayList();
        }
        if (!this.obsoleteUpdates.contains(update)) {
            this.obsoleteUpdates.add(update);
        }
    }

    public Update[] getRequiredUpdates() {
        if (this.requiredUpdates != null) {
            int size = this.requiredUpdates.size();
            Update[] updateArray = new Update[size];
            for (int i = 0; i < size; ++i) {
                updateArray[i] = (Update)this.requiredUpdates.get(i);
            }
            return updateArray;
        }
        return null;
    }

    public List getRequiredUpdatesList() {
        return this.requiredUpdates;
    }

    public Update[] getObsoleteUpdates() {
        if (this.obsoleteUpdates != null) {
            int size = this.obsoleteUpdates.size();
            Update[] updateArray = new Update[size];
            for (int i = 0; i < size; ++i) {
                updateArray[i] = (Update)this.obsoleteUpdates.get(i);
            }
            return updateArray;
        }
        return null;
    }

    public void setRequiredUpdateNames(String[] names) {
        this.requiredUpdateNames = names;
    }

    public void setObsoleteUpdateNames(String[] names) {
        this.obsoleteUpdateNames = names;
    }

    public String[] getRequiredUpdateNames() {
        return this.requiredUpdateNames;
    }

    public String[] getObsoleteUpdateNames() {
        return this.obsoleteUpdateNames;
    }

    public void setInstalledRevision(String revision) {
        this.installedRevision = revision;
    }

    public String getInstalledRevision() {
        return this.installedRevision;
    }

    public void setUpdateReadme(String readme) {
        this.readme = readme;
    }

    public String getUpdateReadme() throws CMDExecutionException, NotAuthenticatedException {
        this.readme = this.ppro.getReadme(this.updateID);
        return this.readme;
    }

    public void setUpdateOperateStatus(int status) {
        this.updateOperateStatus = status;
    }

    public int getUpdateOperateStatus() {
        return this.updateOperateStatus;
    }

    public void resetUpdateOperateStatus() {
        this.updateOperateStatus = -1;
    }

    public void setUpdateOperateMessage(String message) {
        this.updateOperateMessage = message;
    }

    public String getUpdateOperateMessage() {
        return this.updateOperateMessage;
    }

    public void resetUpdateOperateMessage() {
        this.updateOperateMessage = "";
    }

    public void addRemoveDependency(Update update) {
        if (this.removeDependency == null) {
            this.removeDependency = new ArrayList();
        }
        this.removeDependency.add(update);
    }

    public void removeRemoveDependency(Update update) {
        this.removeDependency.remove(update);
    }

    public Update[] getRemoveDependency() {
        if (this.removeDependency != null) {
            int size = this.removeDependency.size();
            Update[] dependencyArray = new Update[size];
            for (int i = 0; i < size; ++i) {
                dependencyArray[i] = (Update)this.removeDependency.get(i);
            }
            return dependencyArray;
        }
        return null;
    }

    public List getRemoveDependencyList() {
        return this.removeDependency;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Update && ((Update)obj).getUpdateID().equals(this.updateID)) {
            equal = true;
        }
        return equal;
    }

    public String toString() {
        return this.updateID;
    }
}

