/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.ExpectSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.InteractiveSessionPrtl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class InteractiveSessionConsole
extends Thread {
    protected static final int BUFFERSIZE = 256;
    private BufferedReader subProcessStdOut;
    private BufferedReader subProcessStdErr;
    private InteractiveSessionPrtl interactiveSession;
    private ByteArrayOutputStream sessionBaos;
    private ByteArrayOutputStream sessionSummaryBaos;
    private Vector expectSessionList;
    private ExpectSession eS;
    private PatchProProperties properties;
    private boolean debug = false;
    private PatchProLog log;
    private String currentLine = "";
    private char[] charBuffer = new char[256];

    public InteractiveSessionConsole(InteractiveSessionPrtl interactiveSessionPrtl) {
        this.interactiveSession = interactiveSessionPrtl;
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public void run() {
        try {
            this.expectSessionList = this.interactiveSession.getExpectSessionList();
            this.subProcessStdOut = this.interactiveSession.getStdInputReader();
            this.subProcessStdErr = this.interactiveSession.getStdErrorReader();
            this.sessionBaos = this.interactiveSession.getArrayOutputStream();
            this.sessionSummaryBaos = this.interactiveSession.getSessionArrayOutputStream();
            while (true) {
                int n;
                Thread.sleep(100L);
                System.gc();
                if (this.interactiveSession.getTerminateStatus()) {
                    if (this.debug) {
                        System.out.println("*** Request to terminate Interactive Session Console detected ***");
                    }
                    break;
                }
                if (this.subProcessStdOut.ready()) {
                    this.subProcessStdOut.read(this.charBuffer);
                    this.currentLine = new String(this.charBuffer);
                }
                if (this.subProcessStdErr.ready()) {
                    this.subProcessStdErr.read(this.charBuffer);
                    this.currentLine = new String(this.charBuffer);
                }
                for (n = 0; n < 256; ++n) {
                    this.charBuffer[n] = '\u0000';
                }
                if (this.currentLine == null || this.currentLine.length() == 0) continue;
                if (this.debug) {
                    System.out.print(this.currentLine);
                }
                this.sessionBaos.write(this.currentLine.getBytes(), 0, this.currentLine.length());
                this.sessionSummaryBaos.write(this.currentLine.getBytes(), 0, this.currentLine.length());
                for (n = 0; n < this.expectSessionList.size(); ++n) {
                    this.eS = (ExpectSession)this.expectSessionList.elementAt(n);
                    if (this.currentLine.indexOf(this.eS.getPattern()) == -1 || this.eS.getResponse().equals("")) continue;
                    try {
                        this.interactiveSession.send(this.eS.getResponse());
                        continue;
                    }
                    catch (InteractiveSessionException interactiveSessionException) {
                        // empty catch block
                    }
                }
                this.currentLine = "";
            }
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            System.err.println("Error: " + exception.getMessage());
        }
    }
}

