/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.NextStateDecoder;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.State;
import com.sun.patchpro.util.StateAction;
import com.sun.patchpro.util.StateMachine;
import com.sun.patchpro.util.StateSynchronizer;

public class PatchProStateMachine
extends StateMachine {
    static final int BEGIN = 0;
    static final int RUNTARGETINFO = 1;
    static final int CREATEINTERPRETER = 2;
    static final int DOWNLOADDETECTORS = 3;
    static final int DOWNLOADPATCHDB = 4;
    static final int RUNBASEDATADETECTORS = 5;
    static final int RUNREALIZATIONDETECTORS = 6;
    static final int ASSEMBLEHOST = 7;
    static final int RUNSEQUENCER = 8;
    static final int DOWNLOADPATCHES = 9;
    static final int INSTALLPATCHES = 10;
    static final int DONE = 11;
    PatchProModel model;
    PatchProProperties properties;
    boolean forceHost = false;
    boolean forcePatchList = false;
    ReadOnlyHost forcedHost;
    StateAction begin = new StateAction(){
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "begin(): started");
            PatchProStateMachine.this.model.begin();
            this.actionState = 2;
            PatchProStateMachine.this.log.println(this, 7, "begin(): finished");
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runTargetInfo = new StateAction(){
        Host host;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): started");
            if (!PatchProStateMachine.this.forceHost) {
                try {
                    this.host = PatchProStateMachine.this.model.runTargetInfo();
                    this.actionState = 2;
                }
                catch (Throwable throwable) {
                    this.actionState = 3;
                    state.setThrowable(throwable);
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): finished");
                }
            } else {
                PatchProStateMachine.this.log.println(this, 7, "runTargetInfo(): host forced");
                this.actionState = 2;
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction createInterpreter = new StateAction(){
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "createInterpreter(): started");
            try {
                PatchProStateMachine.this.model.createInterpreter();
                this.actionState = 2;
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            finally {
                PatchProStateMachine.this.log.println(this, 7, "createInterpreter(): finished");
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadDetectors = new StateAction(){
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadDetectors(): started");
            try {
                PatchProStateMachine.this.model.downloadDetectors();
                this.actionState = 2;
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            finally {
                PatchProStateMachine.this.log.println(this, 7, "downloadDetectors(): finished");
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadPatchDB = new StateAction(){
        int actionState = 0;
        ReadOnlyHost host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): started");
            try {
                this.host = PatchProStateMachine.this.model.downloadPatchDB();
                this.actionState = 2;
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            finally {
                PatchProStateMachine.this.log.println(this, 7, "downloadPatchDB(): finished, returning " + this.host);
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runBaseDataDetectors = new StateAction(){
        PatchDB patchDB;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): host forced");
                this.actionState = 2;
            } else {
                try {
                    PatchProStateMachine.this.model.runBaseDataDetectors();
                    this.actionState = 2;
                }
                catch (Throwable throwable) {
                    this.actionState = 3;
                    state.setThrowable(throwable);
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runBaseDataDetectors(): finished");
                }
            }
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runRealizationDetectors = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): host forced");
                this.host = PatchProStateMachine.this.forcedHost;
                this.actionState = 2;
            } else {
                try {
                    if (stateMachine.getStateResult(3) != 2 || stateMachine.getActionResult(3) == null) {
                        PatchProStateMachine.this.log.println(this, 4, "runRealizationDetectors(): Detectors are not downloaded");
                        this.actionState = 4;
                    } else if (stateMachine.getStateResult(5) != 2 || stateMachine.getActionResult(5) == null) {
                        PatchProStateMachine.this.log.println(this, 4, "runRealizationDetectors(): Host is not up-to-date");
                        this.actionState = 4;
                    } else {
                        this.host = PatchProStateMachine.this.model.runRealizationDetectors();
                    }
                    this.actionState = 2;
                }
                catch (Throwable throwable) {
                    this.actionState = 3;
                    state.setThrowable(throwable);
                }
                finally {
                    PatchProStateMachine.this.log.println(this, 7, "runRealizationDetectors(): finished");
                }
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction assembleHost = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "assembleHost(): started");
            if (PatchProStateMachine.this.forceHost) {
                PatchProStateMachine.this.log.println(this, 7, "assembleHost(): host forced");
                this.host = PatchProStateMachine.this.forcedHost;
                this.actionState = 2;
            } else {
                this.host = (ReadOnlyHost)PatchProStateMachine.this.getActionResult(6);
                this.actionState = 2;
            }
            PatchProStateMachine.this.log.println(this, 7, "assembleHost(): finished");
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction runSequencer = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "runSequencer(): started");
            try {
                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no DOWNLOADPATCHDB");
                } else if (stateMachine.getStateResult(2) != 2 || stateMachine.getActionResult(2) == null) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no CREATEINTERPRETER");
                } else if (!(PatchProStateMachine.this.forceHost || stateMachine.getStateResult(6) == 2 && stateMachine.getActionResult(6) != null)) {
                    this.actionState = 4;
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): no RUNREALIZATIONDETECTORS");
                } else {
                    this.host = PatchProStateMachine.this.model.runSequencer();
                    PatchProStateMachine.this.log.println(this, 7, "runSequencer(): finished, returning " + this.host);
                    this.actionState = 2;
                }
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction downloadPatches = new StateAction(){
        ReadOnlyHost host = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): started");
            try {
                if (!(PatchProStateMachine.this.forcePatchList || stateMachine.getStateResult(8) == 2 && stateMachine.getActionResult(8) != null)) {
                    PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): No patch list supplied  and sequencer has not been run.");
                    this.actionState = 4;
                } else {
                    this.host = PatchProStateMachine.this.model.performPatchDownload();
                    PatchProStateMachine.this.log.println(this, 7, "downloadPatches(): finished, returning " + this.host);
                    this.actionState = 2;
                }
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            return this.host;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction installPatches = new StateAction(){
        ReadOnlyHost theHost = null;
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "installPatches(): started");
            try {
                if (!(PatchProStateMachine.this.forcePatchList || stateMachine.getStateResult(9) == 2 && stateMachine.getActionResult(9) != null)) {
                    this.actionState = 4;
                } else {
                    this.theHost = PatchProStateMachine.this.model.performPatchInstallation();
                    PatchProStateMachine.this.log.println(this, 7, "installPatches(): finished, returning " + this.theHost);
                    this.actionState = 2;
                }
            }
            catch (Throwable throwable) {
                this.actionState = 3;
                state.setThrowable(throwable);
            }
            return this.theHost;
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    StateAction done = new StateAction(){
        int actionState = 0;

        public Object run(StateMachine stateMachine, State state) {
            this.actionState = 1;
            PatchProStateMachine.this.log.println(this, 7, "done()");
            this.actionState = 2;
            return new Boolean(true);
        }

        public int actionStatus() {
            return this.actionState;
        }
    };
    NextStateDecoder baseIfAbbreviated = new NextStateDecoder(){

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = PatchProStateMachine.this.model.isAbbreviatedHost() ? new int[]{5} : (PatchProStateMachine.this.model.isBuildingDBOnly() ? new int[]{4} : new int[]{5, 3, 4});
            PatchProStateMachine.this.log.println(this, 7, "baseIfAbbreviated(): returning " + nArray[0]);
            return nArray;
        }
    };
    NextStateDecoder downloadOrStartOver = new NextStateDecoder(){
        int sequencerState;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray = new int[1];
            try {
                this.sequencerState = stateMachine.getStateResult(8);
                if (this.sequencerState == 2) {
                    nArray[0] = 9;
                } else {
                    this.sequencerState = stateMachine.getStateResult(8);
                    if (this.sequencerState == 4) {
                        nArray[0] = PatchProStateMachine.this.forceHost ? (stateMachine.getStateResult(4) == 2 ? 2 : 4) : (stateMachine.getStateResult(7) == 2 ? 2 : 0);
                    } else {
                        PatchProStateMachine.this.log.println(this, 3, "downloadOrStartOver(): runSequencer was neither complete nor inappropriate.");
                        nArray[0] = 0;
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                nArray[0] = 0;
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
            PatchProStateMachine.this.log.println(this, 7, "downloadOrStartOver(): returning " + nArray[0]);
            return nArray;
        }
    };
    NextStateDecoder installOrStartOver = new NextStateDecoder(){
        int downloadResult;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray;
            block8: {
                nArray = new int[1];
                try {
                    this.downloadResult = stateMachine.getStateResult(9);
                    if (this.downloadResult == 2) {
                        nArray[0] = 10;
                        break block8;
                    }
                    this.downloadResult = stateMachine.getStateResult(9);
                    if (this.downloadResult == 4) {
                        if (PatchProStateMachine.this.forceHost) {
                            try {
                                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                                    nArray[0] = 4;
                                    break block8;
                                }
                                nArray[0] = 2;
                            }
                            catch (NoResultException noResultException) {
                                nArray[0] = 4;
                                PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                            }
                            break block8;
                        }
                        nArray[0] = 0;
                        break block8;
                    }
                    PatchProStateMachine.this.log.println(this, 3, "installOrStartOver(): downloadPatches was neither complete nor inappropriate.");
                    nArray[0] = 0;
                }
                catch (NoSuchStateException noSuchStateException) {
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                }
            }
            PatchProStateMachine.this.log.println(this, 7, "installOrStartOver(): returning " + nArray[0]);
            return nArray;
        }
    };
    NextStateDecoder doneOrStartOver = new NextStateDecoder(){
        int installResult;

        public int[] getNextState(StateMachine stateMachine) {
            int[] nArray;
            block8: {
                nArray = new int[1];
                try {
                    this.installResult = stateMachine.getStateResult(10);
                    if (this.installResult == 2) {
                        nArray[0] = 11;
                        break block8;
                    }
                    this.installResult = stateMachine.getStateResult(10);
                    if (this.installResult == 4) {
                        if (PatchProStateMachine.this.forceHost) {
                            try {
                                if (stateMachine.getStateResult(4) != 2 || stateMachine.getActionResult(4) == null) {
                                    nArray[0] = 4;
                                    break block8;
                                }
                                nArray[0] = 2;
                            }
                            catch (NoResultException noResultException) {
                                nArray[0] = 4;
                                PatchProStateMachine.this.log.printStackTrace(this, 2, noResultException);
                            }
                            break block8;
                        }
                        nArray[0] = 0;
                        break block8;
                    }
                    PatchProStateMachine.this.log.println(this, 3, "doneOrStartOver(): installPatches was neither complete nor inappropriate.");
                    nArray[0] = 0;
                }
                catch (NoSuchStateException noSuchStateException) {
                    nArray[0] = 0;
                    PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
                }
            }
            PatchProStateMachine.this.log.println(this, 7, "doneOrStartOver(): returning " + nArray[0]);
            return nArray;
        }
    };
    StateSynchronizer hostNDetectorsReady = new StateSynchronizer(){

        public void synchronize(StateMachine stateMachine) {
            try {
                int n;
                int n2;
                PatchProStateMachine.this.log.println(this, 7, "hostNDetectorsReady: started");
                do {
                    n2 = stateMachine.getStateResult(5);
                    n = stateMachine.getStateResult(3);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                } while (n2 != 2 || n != 2);
                PatchProStateMachine.this.log.println(this, 7, "hostNDetectorsReady: finished with " + n2 + " & " + n);
                int[] nArray = new int[]{5, 3};
                while (!stateMachine.allDone(nArray)) {
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                PatchProStateMachine.this.log.println(this, 3, "hostNDetectorsReady: bad state number");
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
        }
    };
    StateSynchronizer hostNDownloadComplete = new StateSynchronizer(){

        public void synchronize(StateMachine stateMachine) {
            try {
                int[] nArray;
                int n;
                int n2;
                PatchProStateMachine.this.log.println(this, 7, "hostNDownloadComplete: started");
                do {
                    n2 = PatchProStateMachine.this.forceHost ? 2 : stateMachine.getStateResult(6);
                    n = stateMachine.getStateResult(4);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                } while (n2 != 2 || n != 2);
                PatchProStateMachine.this.log.println(this, 7, "hostNDownloadComplete: finished with " + n2 + " & " + n);
                if (PatchProStateMachine.this.forceHost) {
                    nArray = new int[]{4};
                } else {
                    nArray = new int[]{6, 4};
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        PatchProStateMachine.this.log.printStackTrace(this, 2, interruptedException);
                    }
                }
                while (!stateMachine.allDone(nArray)) {
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                PatchProStateMachine.this.log.println(this, 3, "hostNDownloadComplete: bad state number");
                PatchProStateMachine.this.log.printStackTrace(this, 2, noSuchStateException);
            }
        }
    };

    public PatchProStateMachine(PatchProProperties patchProProperties, PatchProModel patchProModel) {
        this.properties = patchProProperties;
        this.model = patchProModel;
    }

    public void initialize() {
        this.forceHost = false;
        this.forcePatchList = false;
        super.initialize();
    }

    public void forceHost(ReadOnlyHost readOnlyHost) {
        this.forceHost = true;
        this.forcedHost = readOnlyHost;
    }

    public void forcePatchList() {
        this.forcePatchList = true;
    }

    protected State[] buildStateTable() {
        State[] stateArray = new State[]{new State((StateMachine)this, true, this.begin, new int[]{1}), new State((StateMachine)this, false, this.runTargetInfo, this.baseIfAbbreviated), new State((StateMachine)this, false, this.createInterpreter, new int[]{8}), new State((StateMachine)this, false, this.downloadDetectors, new int[]{6}), new State((StateMachine)this, false, this.downloadPatchDB, new int[]{7}), new State((StateMachine)this, false, this.runBaseDataDetectors, new int[]{6}), new State((StateMachine)this, false, this.runRealizationDetectors, this.hostNDetectorsReady, new int[]{7}), new State((StateMachine)this, false, this.assembleHost, this.hostNDownloadComplete, new int[]{2}), new State((StateMachine)this, true, this.runSequencer, this.downloadOrStartOver), new State((StateMachine)this, true, this.downloadPatches, this.installOrStartOver), new State((StateMachine)this, true, this.installPatches, this.doneOrStartOver), new State(this, false, this.done)};
        return stateArray;
    }

    public String dumpState() {
        String string = "";
        try {
            string = new String("begin = " + State.stateStateToString(this.getStateResult(0)) + "\n" + "runTargetInfo = " + State.stateStateToString(this.getStateResult(1)) + "\n" + "downloadDetectors = " + State.stateStateToString(this.getStateResult(3)) + "\n" + "runBaseDataDetectors = " + State.stateStateToString(this.getStateResult(5)) + "\n" + "runSequencer = " + State.stateStateToString(this.getStateResult(8)) + "\n" + "downloadPatches = " + State.stateStateToString(this.getStateResult(9)) + "\n" + "installPatches = " + State.stateStateToString(this.getStateResult(10)) + "\n" + "done = " + State.stateStateToString(this.getStateResult(11)) + "\n");
        }
        catch (NoSuchStateException noSuchStateException) {
            this.log.printStackTrace(this, 2, noSuchStateException);
        }
        return string;
    }
}

