/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.NoMoreDetectorsException;
import com.sun.patchpro.cli.RenderInteractionSetImpl;
import com.sun.patchpro.cli.TTY;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchPropertyException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.GetOptException;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.ScheduleService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public final class PatchProSetup
implements PatchProListener {
    private static final String validArgs = "o:DW:M:s:Cd:b:q:P:a;A:m:p;Hx;c:z:u;U;hy:i:L=:@:!:";
    private static final String[] validPatchTypes = new String[]{"", "none", "standard", "rebootafter", "reconfigafter", "singleuser"};
    private static final String[] validInteractivePatchTypes = new String[]{"none", "standard", "rebootafter", "reconfigafter", "singleuser", "rebootimmediate", "reconfigimmediate", "interactive"};
    private static final String[] propertyNamesForList = new String[]{"patchpro.log.file", "patchpro.log.size", "patchpro.download.directory", "patchpro.patch.sequester.directory", "patchpro.proxy.host", "patchpro.proxy.port", "patchpro.patch.source"};
    private static File defaultConfFile;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private LocalizedMessages msgcat;
    private InstallationParameters instParms = null;
    boolean done = false;
    PatchPro patchPro;
    String associateStr = null;
    boolean hasAssociate = false;
    private BufferedReader stdin = null;

    public PatchProSetup() throws PatchProException {
        PatchProAccessor patchProAccessor = new PatchProAccessor();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.patchPro = patchProAccessor.getPatchPro();
        this.instParms = InstallationParameters.getInstance();
        String string = this.instParms.getUserConfigFilePath();
        defaultConfFile = new File(string);
        if (!defaultConfFile.exists()) {
            System.err.println(this.msgcat.getMessage("noConfigurationFile", "Configuration file was not found -") + " " + string);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        PatchProProperties patchProProperties = null;
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = null;
        PatchProSetup patchProSetup = null;
        Vector<String> vector = new Vector<String>();
        String string = "00:00";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        Vector<String> vector4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        boolean bl23 = false;
        boolean bl24 = false;
        boolean bl25 = false;
        boolean bl26 = false;
        boolean bl27 = false;
        try {
            String[] stringArray2;
            int n;
            while ((n = getOpt.getNextOption()) != -1) {
                stringArray2 = new Character((char)n);
                switch ((char)n) {
                    case 'D': {
                        if (bl10) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        bl = true;
                        bl10 = true;
                        break;
                    }
                    case 'W': {
                        if (bl11) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl = true;
                        bl11 = true;
                        break;
                    }
                    case 'M': {
                        if (bl13) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl = true;
                        bl13 = true;
                        break;
                    }
                    case 's': {
                        if (bl22) {
                            bl2 = true;
                            break;
                        }
                        if (string.compareTo("none") == 0) break;
                        string = getOpt.getOptionArg();
                        bl = true;
                        bl22 = true;
                        break;
                    }
                    case 'a': {
                        if (bl4) {
                            bl2 = true;
                            break;
                        }
                        string2 = getOpt.getOptionArg();
                        if (string2 == null) {
                            string2 = "";
                        }
                        bl4 = true;
                        break;
                    }
                    case 'C': {
                        if (bl9) {
                            bl2 = true;
                            break;
                        }
                        string = "none";
                        bl = true;
                        bl9 = true;
                        break;
                    }
                    case 'o': {
                        if (bl18) {
                            bl2 = true;
                            break;
                        }
                        string4 = getOpt.getOptionArg();
                        bl18 = true;
                        break;
                    }
                    case 'd': {
                        if (bl8) {
                            bl2 = true;
                            break;
                        }
                        string3 = getOpt.getOptionArg();
                        bl8 = true;
                        break;
                    }
                    case 'b': {
                        if (bl6) {
                            bl2 = true;
                            break;
                        }
                        string5 = getOpt.getOptionArg();
                        bl6 = true;
                        break;
                    }
                    case 'q': {
                        if (bl21) {
                            bl2 = true;
                            break;
                        }
                        string6 = getOpt.getOptionArg();
                        bl21 = true;
                        break;
                    }
                    case 'P': {
                        if (bl20) {
                            bl2 = true;
                            break;
                        }
                        string7 = getOpt.getOptionArg();
                        bl20 = true;
                        break;
                    }
                    case 'm': {
                        if (bl16 || bl12) {
                            bl2 = true;
                            break;
                        }
                        string9 = getOpt.getOptionArg();
                        bl12 = true;
                        break;
                    }
                    case 'A': {
                        if (bl19 || bl5) {
                            bl2 = true;
                            break;
                        }
                        string8 = getOpt.getOptionArg();
                        bl5 = true;
                        break;
                    }
                    case 'p': {
                        if (bl19 || bl5) {
                            bl2 = true;
                            break;
                        }
                        string8 = getOpt.getOptionArg();
                        bl19 = true;
                        break;
                    }
                    case 'i': {
                        if (bl16 || bl12) {
                            bl2 = true;
                            break;
                        }
                        string9 = getOpt.getOptionArg();
                        bl16 = true;
                        break;
                    }
                    case 'L': {
                        if (bl17) {
                            bl2 = true;
                            break;
                        }
                        bl17 = true;
                        break;
                    }
                    case 'H': {
                        if (bl14) {
                            bl2 = true;
                            break;
                        }
                        bl14 = true;
                        break;
                    }
                    case 'c': {
                        if (bl7) {
                            bl2 = true;
                            break;
                        }
                        string10 = getOpt.getOptionArg();
                        bl7 = true;
                        break;
                    }
                    case 'z': {
                        if (bl27) {
                            bl2 = true;
                            break;
                        }
                        String string14 = getOpt.getOptionArg();
                        bl3 = string14.equals("true");
                        bl27 = true;
                        break;
                    }
                    case 'x': {
                        if (bl25) {
                            bl2 = true;
                            break;
                        }
                        string11 = getOpt.getOptionArg();
                        bl25 = true;
                        break;
                    }
                    case 'u': {
                        if (bl23) {
                            bl2 = true;
                            break;
                        }
                        string13 = getOpt.getOptionArg();
                        if (string13 == null) {
                            string13 = "";
                        }
                        bl23 = true;
                        break;
                    }
                    case 'U': {
                        if (bl24) {
                            bl2 = true;
                            break;
                        }
                        string12 = getOpt.getOptionArg();
                        if (string12 == null) {
                            string12 = "";
                        }
                        bl24 = true;
                        break;
                    }
                    case 'y': {
                        if (bl26) {
                            bl2 = true;
                            break;
                        }
                        bl26 = true;
                        break;
                    }
                    case 'h': {
                        if (bl15) {
                            bl2 = true;
                            break;
                        }
                        bl15 = true;
                        break;
                    }
                    case '@': {
                        if (vector2 == null) {
                            vector2 = new Vector<String>();
                        }
                        vector2.add(getOpt.getOptionArg());
                        break;
                    }
                    case '=': {
                        if (vector3 == null) {
                            vector3 = new Vector<String>();
                        }
                        vector3.add(getOpt.getOptionArg());
                        break;
                    }
                    case '!': {
                        if (vector4 == null) {
                            vector4 = new Vector<String>();
                        }
                        vector4.add(getOpt.getOptionArg());
                        break;
                    }
                }
            }
            if (bl27) {
                PatchProProperties.freeInstance();
                string10 = "etc" + File.separator + "patchpro.conf";
                patchProProperties = PatchProProperties.getInstance(string10);
            } else {
                patchProProperties = PatchProProperties.getInstance();
                if (string10 != null) {
                    patchProProperties.useAlternate(string10);
                }
            }
            try {
                patchProSetup = new PatchProSetup();
                localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
            }
            catch (PatchProException patchProException) {
                System.err.println(patchProException.getLocalizedMessage());
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl2) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl15 || stringArray.length < 2 && bl26) {
                PatchProSetup.usage(localizedMessages);
                System.exit(0);
            }
            if (bl17 && (bl4 || bl6 || bl8 || bl9 || bl10 || bl11 || bl13 || bl14 || bl15 || bl16 || bl12 || bl18 || bl19 || bl20 || bl21 || bl22 || bl23 || bl25 || bl5 || vector3 != null || vector2 != null || vector4 != null)) {
                System.err.println(localizedMessages.getMessage("pprosetupmutexanyotheroption", "Option L is mutually exclusive with any other option except c"));
                PatchProSetup.usage(localizedMessages);
                System.exit(1);
            }
            if (bl10 && (bl11 || bl13) || bl11 && (bl10 || bl13) || bl13 && (bl10 || bl11)) {
                System.err.println(localizedMessages.getMessage("pprosetupmutexDWM", "Options D, W and M are mutually exclusive"));
                PatchProSetup.usage(localizedMessages);
                System.exit(1);
            }
            if (vector2 == null && !defaultConfFile.canWrite()) {
                System.err.println(localizedMessages.getMessage("cantWriteConfigurationFile", "Configuration file is not writable -") + " " + defaultConfFile);
                System.exit(1);
            }
            if (bl17) {
                patchProSetup.listProperties();
                System.exit(0);
            }
            if (bl18) {
                patchProSetup.associateStr = string4;
                patchProSetup.hasAssociate = true;
            }
            if (bl14) {
                patchProSetup.changeHardware();
            }
            if (bl19 || bl5) {
                patchProSetup.changePatchType(string8);
            }
            if (bl16 || bl12) {
                patchProSetup.changeInteractivePatchType(string9);
            }
            if (bl25) {
                patchProSetup.changeProxyServer(string11);
            }
            if (bl) {
                stringArray2 = new String[vector.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)vector.elementAt(i);
                }
                patchProSetup.changeSchedule(string, stringArray2, string10);
            }
            if (string2 != null) {
                patchProSetup.changeAdminEmail(string2);
            }
            if (string3 != null) {
                patchProSetup.changeDirectoryLocation(string3);
            }
            if (string5 != null) {
                patchProSetup.changeBackoutLocation(string5);
            }
            if (string6 != null) {
                patchProSetup.changeSequesterLocation(string6);
            }
            if (string7 != null) {
                patchProSetup.changePatchServer(string7);
            }
            if (string13 != null) {
                patchProSetup.changeUserName(string13);
            }
            if (string12 != null) {
                patchProSetup.changeProxyUserName(string12);
            }
            if (vector3 != null) {
                patchProSetup.setProperties(vector3);
            }
            if (vector2 != null) {
                patchProSetup.displayProperties(vector2);
            }
            if (vector4 != null) {
                patchProSetup.unsetProperties(vector4);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            if (bl3) {
                System.err.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        catch (GetOptException getOptException) {
            System.err.println(getOptException.getMessage());
            if (localizedMessages != null) {
                PatchProSetup.usage(localizedMessages);
            }
            if (bl3) {
                System.err.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        catch (PatchProException patchProException) {
            if (patchProException.getMessage().indexOf("in use") != -1) {
                System.err.println(localizedMessages.getMessage("inuse", "Error - PatchPro is in use by another process. Please try again later ..."));
            } else {
                System.err.println("Error: " + patchProException.getLocalizedMessage());
            }
            System.exit(1);
        }
        if (bl3) {
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosetupUsage", "usage:\tpprosetup [-a admin-email-addr] [-b backout-dir]\n\t[-c config-file] [-C] [-d download-dir]]\n\t[[-D | -M day-of-month | -W day-of-week]\n\t[-s hh:mm]] [-h] [-H] [-i [none | patch-property-list]]\n\t[-L] [-p [none | standard]] [-P patch-source] \n\t[-q sequester-dir] [-u user-name] [-U proxy-user-name]\n\t[-x host:port]\n\n\tWhere:\n"));
        System.err.println("\t-a\t" + localizedMessages.getMessage("usageAdminEmail", "Specifies the email address to use for event notification"));
        System.err.println("\t-b\t" + localizedMessages.getMessage("usageBackoutDirectory", "Specifies the directory in which patch backout data is\n\t\tstored"));
        System.err.println("\t-c\t" + localizedMessages.getMessage("usageAlternateConfig", "Specifies an alternate configuration file"));
        System.err.println("\t-C\t" + localizedMessages.getMessage("usageClearPatchService", "Clears the existing patch service schedule"));
        System.err.println("\t-d\t" + localizedMessages.getMessage("usageDownloadDirectory", "Specifies the directory in which patches are downloaded"));
        System.err.println("\t-D\t" + localizedMessages.getMessage("usageDailyPatchService", "Schedules the patch service to run on a daily basis"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-H\t" + localizedMessages.getMessage("usageHardware", "Establishes an interactive dialog to determine the\n\t\thardware attached to the host system"));
        System.err.println("\t-i\t" + localizedMessages.getMessage("usageInteractivePatchType", "Defines the patch installation policy for the type of\n\t\tpatches that are permitted to be installed in interactive\n\t\tmode. patch-property-list is a colon-separated list that\n\t\tcan include the following:\n\t\t\tinteractive\n\t\t\trebootafter\n\t\t\trebootimmediate\n\t\t\treconfigafter\n\t\t\treconfigimmediate\n\t\t\tsingleuser\n\t\t\tstandard"));
        System.err.println("\t-L\t" + localizedMessages.getMessage("usageListProperties", "Displays the configuration properties that can be updated\n\t\tby users"));
        System.err.println("\t-M\t" + localizedMessages.getMessage("usageMonthlyPatchService", "Schedules the patch service to run on a monthly basison\n\t\tday-of-month"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchType", "Specifies the patch types that can be scheduled for automatic\n\t\tinstallation: standard automatically installs only standard\n\t\tpatches and none automatically installs no patches"));
        System.err.println("\t-P\t" + localizedMessages.getMessage("usagePatchServer", "Specifies the URL of the server that provides the patches"));
        System.err.println("\t-q\t" + localizedMessages.getMessage("usageSequesterDirectory", "Specifies the directory in which uninstallable patches are\n\t\tstored"));
        System.err.println("\t-s\t" + localizedMessages.getMessage("usageSchedulePatchService", "Schedules the patch service to run at the specified time,\n\t\twhich is midnight, by default"));
        System.err.println("\t-u\t" + localizedMessages.getMessage("usageUserName", "Specifies the name of the Sunsolve user who can access\n\t\tcontract patches."));
        System.err.println("\t-U\t" + localizedMessages.getMessage("usageProxyUserName", "Specifies the user name required for authentication ofthe web proxy, if applicable"));
        System.err.println("\t-W\t" + localizedMessages.getMessage("usageWeeklyPatchService", "Schedules the patch service to run on a weekly basison\n\t\tday-of-week"));
        System.err.println("\t-x\t" + localizedMessages.getMessage("usageProxyServer", "Specifies the local web proxy server to use where host is\n\t\tthe host name and port is the port number"));
    }

    public void changeSchedule(String string, String[] stringArray, String string2) throws PatchProException {
        String string3 = this.instParms.getBinDirectoryPath();
        String string4 = this.properties.getProperty("patchpro.patch.install.patchtype");
        String string5 = string2 != null ? "pprosvc -c " + string2 + " -n -i" : "pprosvc -n -i";
        String string6 = string3 + File.separator + string5;
        int n = stringArray.length;
        String string7 = new String("com.sun.patchpro.util." + Host.getOSName() + "ScheduleService");
        try {
            Class<?> clazz = Class.forName(string7);
            ScheduleService scheduleService = (ScheduleService)clazz.newInstance();
            if (n != 0) {
                if (string.compareTo("none") == 0) {
                    throw new PatchProException("\"-C\" is incompatible with other schedule arguments.");
                }
                char c = stringArray[0].charAt(0);
                switch (c) {
                    case 'D': {
                        scheduleService.daily(string6, string);
                        break;
                    }
                    case 'W': {
                        scheduleService.weekly(string6, string, stringArray[1]);
                        break;
                    }
                    case 'M': {
                        scheduleService.monthly(string6, string, stringArray[1]);
                        break;
                    }
                    default: {
                        throw new PatchProException("Unknown option " + c);
                    }
                }
            } else if (string.compareTo("none") != 0) {
                scheduleService.begin(string6, string);
            } else {
                scheduleService.clear(string5);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException " + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            System.err.println("InstantiationException " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException " + illegalAccessException.getMessage());
        }
        catch (IOException iOException) {
            throw new PatchProException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PatchProException(illegalArgumentException);
        }
    }

    public void changeDirectoryLocation(String string) {
        String string2 = "patchpro.download.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalDownloadDirectory", "Specified download directory is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeDownloadDirectory", "Error - failed to change download directory location"));
        }
    }

    public void changeBackoutLocation(String string) {
        String string2 = "patchpro.backout.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalBackoutDirectory", "Specified backout directory is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeBackoutDirectory", "Error - failed to change backout directory location"));
        }
    }

    public void changeSequesterLocation(String string) {
        String string2 = "patchpro.patch.sequester.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalSequesterDirectory", "Specified sequester directory is identical to the one in effect - No action necessary."));
                boolean bl = false;
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeSequesterDirectory", "Error - failed to change sequester directory location"));
            boolean bl = false;
        }
    }

    public void changePatchServer(String string) {
        String string2 = "patchpro.patch.source";
        try {
            int n;
            String string3 = this.properties.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            try {
                n = string.indexOf(58);
                if (n == -1) {
                    System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                    System.exit(1);
                } else {
                    String string4 = "";
                    string4 = string.substring(0, n);
                    if (string4.compareTo("https") == 0 || string4.compareTo("http") == 0 || string4.compareTo("file") == 0) {
                        int n2 = n + 1;
                        int n3 = n + 3;
                        if (string.substring(n2, n3).compareTo("//") != 0) {
                            System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                            System.exit(1);
                        }
                    } else {
                        System.err.println(this.msgcat.getMessage("PatchProSetup.UNSUPPORTED_PROTOCOL", "Failed to change patch server URL - specified protocol not supported.)"));
                        System.exit(1);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(this.msgcat.getMessage("PatchProSetup.FAILED_CHANGING_PATCH_SERVER", "Failed to change patch server URL.)"));
                System.exit(1);
            }
            n = string.length();
            if (string.substring(n - 1, n).compareTo("/") != 0) {
                string = string + "/";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchServer", "Specified patch server is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeAdminEmail(String string) {
        String string2 = "patchpro.error.email";
        try {
            String string3 = this.properties.getProperty(string2);
            if (string3 != null) {
                if (string3.compareTo(string) != 0) {
                    try {
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.download.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.install.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                    }
                    catch (PatchPropertyException patchPropertyException) {
                        System.err.println(patchPropertyException.getMessage());
                    }
                } else {
                    System.out.println(this.msgcat.getMessage("isIdenticalAdminEmail", "Specified admin email address is identical to the one in effect - No action necessary."));
                }
            } else {
                System.err.println(this.msgcat.getMessage("errChangeAdminEmail", "Error - failed to change admin E-Mail."));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeMediaType() {
        System.out.println(this.msgcat.getMessage("media", "TBD - Change media type"));
    }

    public void changePatchType(String string) {
        String string2 = "patchpro.patch.install.patchtype";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidPatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            for (int i = 0; i < validPatchTypes.length; ++i) {
                System.err.println("\t\"" + validPatchTypes[i] + "\"");
            }
        }
    }

    public void changeInteractivePatchType(String string) {
        String string2 = "patchpro.install.types";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidInteractivePatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            for (int i = 0; i < validInteractivePatchTypes.length; ++i) {
                System.err.println("\t\"" + validInteractivePatchTypes[i] + "\"");
            }
        }
    }

    public void listProperties() {
        String string = null;
        for (int i = 0; i < propertyNamesForList.length; ++i) {
            String string2 = this.properties.getProperty(propertyNamesForList[i]);
            Object[] objectArray = new String[]{string2};
            string = propertyNamesForList[i].equals("patchpro.log.file") ? (string2.equals("system") ? "Log file location:\tSystem log file (consult /etc/syslog.conf for exact location)" : "Log file location:\t" + string2) : (propertyNamesForList[i].equals("patchpro.log.size") ? "Log file size:\t\t" + string2 : (propertyNamesForList[i].equals("patchpro.download.directory") ? "Download directory:\t" + string2 : (propertyNamesForList[i].equals("patchpro.patch.sequester.directory") ? "Sequester directory:\t" + string2 : (propertyNamesForList[i].equals("patchpro.proxy.host") ? "Proxy server name:\t" + string2 : (propertyNamesForList[i].equals("patchpro.proxy.port") ? "Proxy server port:\t" + string2 : "Server URL:\t\t" + string2)))));
            if (propertyNamesForList[i].equals("patchpro.log.file") && string2.equals("system")) {
                System.out.println(this.msgcat.getMessage(propertyNamesForList[i] + ".listing.label2", string));
                continue;
            }
            System.out.println(this.msgcat.getMessage(propertyNamesForList[i] + ".listing.label", objectArray, string));
        }
    }

    private boolean isValidPatchType(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < validPatchTypes.length; ++i) {
                if (!string.equals(validPatchTypes[i])) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isValidInteractivePatchType(String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        if (string.indexOf("none") != -1 && !string.equals("none")) {
            System.out.println(this.msgcat.getMessage("nonetypeusage", "\"none\" cannot be specified with other patch types."));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (string != null) {
            for (int i = 0; i < validInteractivePatchTypes.length; ++i) {
                vector.addElement(validInteractivePatchTypes[i]);
            }
            stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || vector.contains(string2)) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void changeHardware() {
        System.out.println(this.msgcat.getMessage("changeHwConfiguration", "Change Hardware Configuration"));
        RenderInteractionSetImpl renderInteractionSetImpl = new RenderInteractionSetImpl();
        try {
            this.patchPro.addListener(this);
            this.done = false;
            this.patchPro.generateAbbreviatedHost();
            System.out.println(this.msgcat.getMessage("analyzingComputer", "Analyzing this computer."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            this.patchPro.initializeInteractiveDetectors();
            while (true) {
                try {
                    while (true) {
                        InteractionSet interactionSet;
                        if ((interactionSet = this.patchPro.nextInteractiveDetector()) == null) {
                            System.out.println(this.msgcat.getMessage("nullXnSet", "Null Interaction Set."));
                            continue;
                        }
                        renderInteractionSetImpl.render(interactionSet);
                        this.patchPro.setInteractionSet(interactionSet);
                    }
                }
                catch (DetectorFailedException detectorFailedException) {
                    System.err.println(this.msgcat.getMessage("noHardware", "No hardware on your system."));
                    detectorFailedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (NoMoreDetectorsException noMoreDetectorsException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeProxyServer(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "patchpro.proxy.host";
        String string5 = "patchpro.proxy.port";
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.equals("")) {
            bl = true;
            bl2 = true;
        } else {
            int n;
            int n2 = string.indexOf(58);
            if (n2 != -1 && n2 == (n = string.lastIndexOf(58))) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
                bl2 = true;
                try {
                    long l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            String string6 = this.properties.getProperty(string4);
            String string7 = this.properties.getProperty(string5);
            this.setAppropriateProperty(string4, string2);
            this.setAppropriateProperty(string5, string3);
            try {
                this.properties.update(string4, string2);
                this.properties.update(string5, string3);
            }
            catch (PatchPropertyException patchPropertyException) {
                System.err.println(patchPropertyException.getMessage());
            }
        } else {
            System.err.println(this.msgcat.getMessage("wrongProxyServerFormat", "Proxy server format is incorrect."));
        }
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(this.msgcat.getMessage("patchProFailed", "Error: PatchPro failed: ") + throwable.getMessage());
        } else {
            System.err.println("Error: Event source not PatchProModel");
        }
        this.done = true;
    }

    public void changeUserName(String string) {
        String string2 = "patchpro.sun.user";
        String string3 = this.properties.getProperty(string2);
        if (string3 != null) {
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (PatchPropertyException patchPropertyException) {
                    System.err.println(patchPropertyException.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalUserName", "Specified user name is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangeUserName", "Error - failed to change user name."));
        }
    }

    private void setAppropriateProperty(String string, String string2) {
        if (this.hasAssociate) {
            this.properties.setClassSpecificProperty(this.associateStr, string, string2);
            this.properties.setHostSpecificProperty(this.associateStr, string, string2);
        } else {
            this.properties.setProperty(string, string2);
        }
    }

    public void changeProxyUserName(String string) {
        String string2 = "patchpro.proxy.user";
        String string3 = this.properties.getProperty(string2);
        if (string3 != null && string3.compareTo(string) == 0) {
            System.out.println(this.msgcat.getMessage("isIdenticalProxyUserName", "Specified proxy user name is identical to the one in effect - No action necessary."));
            return;
        }
        try {
            this.properties.update(string2, string);
            this.properties.setProperty(string2, string);
        }
        catch (PatchPropertyException patchPropertyException) {
            System.err.println(patchPropertyException.getMessage());
        }
    }

    private void setProperties(Vector vector) throws PatchProException {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3 = (String)enumeration.nextElement();
                int n = string3.indexOf(61);
                if (n >= 0) {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n + 1);
                } else {
                    string2 = string3;
                    PropertyInfo propertyInfo = this.properties.getPropertyInfo(string2);
                    if (TTY.isaTTY()) {
                        System.err.print(propertyInfo.getDescription() + ": ");
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOff();
                        }
                        string = this.readLine();
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOn();
                            System.err.println();
                        }
                    } else {
                        string = this.readLine();
                    }
                }
                this.properties.update(string2, string);
            }
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            throw new PatchProException(patchPropertyNotFoundException.getLocalizedMessage());
        }
    }

    private void displayProperties(Vector vector) throws PatchProException {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (string.equals("=")) {
                    object = this.properties.getAllPropertyInfos();
                    TreeSet<Object> treeSet = new TreeSet<Object>();
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (!((PropertyInfo)object[i]).getPublicFlag()) continue;
                        treeSet.add(object[i]);
                    }
                    PropertyInfo.report(System.out, treeSet);
                    continue;
                }
                object = this.properties.getPropertyInfo(string);
                System.out.println(((PropertyInfo)object).getEffectiveValueForDisplay());
            }
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            throw new PatchProException(patchPropertyNotFoundException.getLocalizedMessage());
        }
    }

    private void unsetProperties(Vector vector) throws PatchProException {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.properties.unUpdateProperty(string);
            }
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            throw new PatchProException(patchPropertyNotFoundException.getLocalizedMessage());
        }
    }

    private String readLine() throws PatchProException {
        if (this.stdin == null) {
            this.stdin = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            return this.stdin.readLine();
        }
        catch (IOException iOException) {
            throw new PatchProException(iOException);
        }
    }
}

