/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.HTMLWidget;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.ReflectionWidget;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.cli.CmdLineComboBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineController;
import com.sun.cns.basicreg.wizard.cli.CmdLineFieldWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineForm;
import com.sun.cns.basicreg.wizard.cli.CmdLineHTMLWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineHiddenWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineInformationWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineJumpWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineLinkWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineMessageWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLinePasswordWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineRadioBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineReflectionWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineTextIconLabelWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineUnknownWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.util.DocOutputter;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.MessageTable;
import com.sun.cns.basicreg.wizard.util.Response;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.XSLTransformer;

public class CmdLineWizard
implements Wizard {
    private String identifier;
    private String outputFile;
    private ArrayList forms;
    private int index = -1;
    private String cmdLineArgument;
    private String title;
    private ArrayList outForms;
    private boolean outAsset = false;
    private String assetId;
    private boolean requiredToWait = false;
    private boolean waitForOtherJobCompleted = false;
    private CmdLineGlobalObject globalObject = null;
    private boolean formReload = false;
    private static final String I18N_KEY_FLAG = "_i18n";
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$cli$CmdLineWizard == null ? (class$com$sun$cns$basicreg$wizard$cli$CmdLineWizard = CmdLineWizard.class$("com.sun.cns.basicreg.wizard.cli.CmdLineWizard")) : class$com$sun$cns$basicreg$wizard$cli$CmdLineWizard).getName());
    String location = null;
    boolean dateTimeStampBoolean = false;
    String fileNamePrefix = null;
    String fileNameSuffix = null;
    String filePattern = null;
    String dateTimeStamp = null;
    boolean forceToReload = false;
    private boolean AssetRegistrationFailed = false;
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$cli$CmdLineWizard;
    static /* synthetic */ Class class$org$jdom$Document;
    static /* synthetic */ Class class$java$lang$String;

    public CmdLineWizard(String identifier) {
        this.identifier = identifier;
        this.cmdLineArgument = "profile";
        this.initialize();
    }

    public CmdLineWizard(String identifier, String cmdLineArgument) {
        this.identifier = identifier;
        this.cmdLineArgument = cmdLineArgument;
        this.initialize();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean reloadFormIfNeeded(int indexForm) {
        LOG.info("RELOAD FORM " + indexForm + " ?");
        LOG.info("FORM SIZE = " + this.forms.size());
        Form form = null;
        if (!this.forms.isEmpty() && indexForm >= 0 && indexForm <= this.forms.size() - 1 && (form = (Form)this.forms.get(indexForm)).isReLoad()) {
            LOG.info("YES - RELOAD FORM  " + indexForm);
            this.fillInRequestedForm(form);
            CmdLineGlobalObject.forms.put(this.getFormIdentifier(indexForm), new Boolean(false));
            form.setReLoad(false);
            return true;
        }
        LOG.info("NO - RELOAD FORM " + indexForm);
        return false;
    }

    public boolean isFirstForm() {
        boolean result = false;
        if (!this.forms.isEmpty() && this.index == 0) {
            result = true;
        }
        return result;
    }

    public boolean isLastForm() {
        boolean result = false;
        if (!this.forms.isEmpty() && this.index == this.forms.size() - 1) {
            result = true;
        }
        return result;
    }

    public boolean isLastForm(Form form) {
        Form lastForm;
        boolean result = false;
        if (!this.forms.isEmpty() && (lastForm = (Form)this.forms.get(this.forms.size() - 1)).getFormIdentifier().equals(form.getFormIdentifier())) {
            result = true;
        }
        return result;
    }

    public Form getFirstForm() {
        Form firstForm = null;
        if (!this.forms.isEmpty()) {
            firstForm = (Form)this.forms.get(0);
            this.index = 0;
            this.processReflectionWidgets(firstForm, this.index);
            firstForm.setProcessed(true);
        }
        return firstForm;
    }

    public Form getLastForm() {
        Form lastForm = null;
        int lastIndex = this.forms.size() - 1;
        if (!this.forms.isEmpty()) {
            lastForm = (Form)this.forms.get(lastIndex);
            this.index = lastIndex;
            this.processReflectionWidgets(lastForm, this.index);
            lastForm.setProcessed(true);
        }
        return lastForm;
    }

    public Form getPreviousForm() {
        Form previousForm = null;
        int previousFormIndex = this.index - 1;
        if (!this.forms.isEmpty()) {
            if (previousFormIndex > -1) {
                previousForm = (Form)this.forms.get(previousFormIndex);
                this.index = previousFormIndex;
            } else {
                previousForm = (Form)this.forms.get(this.index);
            }
            this.processReflectionWidgets(previousForm, this.index);
            previousForm.setProcessed(true);
        }
        return previousForm;
    }

    public Form getCurrentForm() {
        Form currentForm = null;
        if (!this.forms.isEmpty()) {
            currentForm = (Form)this.forms.get(this.index);
            this.processReflectionWidgets(currentForm, this.index);
            currentForm.setProcessed(true);
        }
        return currentForm;
    }

    public Form getNextForm() {
        Form nextForm = null;
        int nextFormIndex = this.index + 1;
        if (!this.forms.isEmpty()) {
            if (nextFormIndex < this.forms.size()) {
                nextForm = (Form)this.forms.get(nextFormIndex);
                this.index = nextFormIndex;
                LOG.info("index = " + this.index);
                this.processReflectionWidgets(nextForm, this.index);
                nextForm.setProcessed(true);
            } else {
                nextForm = (Form)this.forms.get(this.index);
            }
        }
        if (this.forceToReload) {
            this.forceToReload = false;
            Form form = (Form)this.forms.get(0);
            this.fillInRequestedForm(form);
            CmdLineGlobalObject.forms.put(this.getFormIdentifier(0), new Boolean(false));
            form.setReLoad(false);
        }
        return nextForm;
    }

    public Form getNextFormForCLI() {
        Form nextForm = null;
        int nextFormIndex = this.index + 1;
        if (!this.forms.isEmpty()) {
            if (nextFormIndex < this.forms.size()) {
                nextForm = (Form)this.forms.get(nextFormIndex);
                this.index = nextFormIndex;
                this.processReflectionWidgets(nextForm, this.index);
                nextForm.setProcessed(true);
                if (nextForm.isReLoad() && nextForm.isProcessed()) {
                    this.reloadFormIfNeeded(this.index);
                }
            } else {
                nextForm = (Form)this.forms.get(this.index);
            }
        }
        return nextForm;
    }

    public Form getForm(String formIdentifier) {
        Form nextForm = null;
        int nextFormIndex = 0;
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            nextForm = (Form)i.next();
            String formId = nextForm.getFormIdentifier();
            if (formId != null && formId.equalsIgnoreCase(formIdentifier)) {
                this.index = nextFormIndex;
                this.processReflectionWidgets(nextForm, this.index);
                if (nextForm.isReLoad() && nextForm.isProcessed()) {
                    this.reloadFormIfNeeded(this.index);
                }
                nextForm.setProcessed(true);
                return nextForm;
            }
            ++nextFormIndex;
        }
        return null;
    }

    public Form getFormById(String formId) {
        if (formId == null) {
            return null;
        }
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            Form aForm = (Form)i.next();
            String aFormId = aForm.getFormIdentifier();
            if (aFormId == null || !aFormId.equals(formId)) continue;
            return aForm;
        }
        return null;
    }

    public String getFormIdentifier(int formIndex) {
        int nextFormIndex = 0;
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            Form aForm = (Form)i.next();
            String aFormId = aForm.getFormIdentifier();
            if (aFormId != null && nextFormIndex == formIndex) {
                return aFormId;
            }
            ++nextFormIndex;
        }
        return null;
    }

    public void setFormIndex(int index) {
        this.index = index;
    }

    public int getFormIndex(String formIdentifier) {
        Form nextForm = null;
        int nextFormIndex = 0;
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            nextForm = (Form)i.next();
            String formId = nextForm.getFormIdentifier();
            if (formId != null && formId.equalsIgnoreCase(formIdentifier)) {
                return nextFormIndex;
            }
            ++nextFormIndex;
        }
        System.out.println("ERROR:  unknown form identifier: " + formIdentifier);
        return -1;
    }

    private void fillInForm(Form form) {
        this.fillInRequestedForm(form);
    }

    private void fillInRequestedForm(Form form) {
        List widgets = form.getWidgets();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (!(widget instanceof ReflectionWidget) || !widget.isReload()) continue;
            Object result = null;
            ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
            try {
                Class<?> clazz = Class.forName(reflectWidget.getClassName());
                Constructor<?> constructor = clazz.getConstructor(null);
                Object object = constructor.newInstance(null);
                Method method = clazz.getMethod(reflectWidget.getMethodName(), null);
                result = method.invoke(object, null);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            String content = null;
            if (result == null) continue;
            if (result instanceof List) {
                List results = (List)result;
                Iterator j = results.iterator();
                while (j.hasNext()) {
                    StringReader stringReader;
                    content = j.next().toString();
                    LOG.finest("content = " + content);
                    this.reLoadWidget(form, this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
                    if (widget.getHTMLFormId() != null) {
                        stringReader = new StringReader(content);
                        this.convertXML2HTML(stringReader, widget.getHTMLFormId(), "F");
                    }
                    if (widget.getLimitedHTMLFormId() == null) continue;
                    stringReader = new StringReader(content);
                    this.convertXML2HTML(stringReader, widget.getLimitedHTMLFormId(), "P");
                }
                continue;
            }
            if (!(result instanceof Object)) continue;
            content = result.toString();
            LOG.finest("jaxta content = " + result.toString());
            this.reLoadWidget(form, this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
        }
    }

    private void reLoadWidget(Form form, Widget newWidget) {
        LOG.finest("==== inside reloadwidget =====");
        LOG.finest("==== new widget id =====" + newWidget.getId());
        LOG.finest("==== new widget text =====" + newWidget.getText());
        List widgets = form.getWidgets();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            LOG.finest("==== widget id =====" + widget.getId());
            if (!widget.isReload() || widget.getId() == null || !widget.getId().equals(newWidget.getId())) continue;
            widget.setText(newWidget.getText());
            LOG.finest("replacing widget with = " + newWidget.getText());
        }
    }

    private void fillInLastForm() {
        StringBuffer information = new StringBuffer();
        for (int index = 0; index < this.forms.size(); ++index) {
            if (index >= this.forms.size() - 1) continue;
            this.printForm((Form)this.forms.get(index), information);
        }
        this.printLastForm(information.toString());
    }

    private void printForm(Form form, StringBuffer textBuffer) {
        this.repeat("-", 80, textBuffer);
        textBuffer.append(form.getTitle() + "\n");
        textBuffer.append("\n");
        textBuffer.append("\n");
        List widgets = form.getWidgets();
        String widgetText = "";
        int index = 1;
        int printIndex = 1;
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (widget instanceof ResponseWidget) {
                textBuffer.append(printIndex++ + ". " + widget.getText() + ": " + ((ResponseWidget)((Object)widget)).getResponse() + "\n");
                ++index;
                continue;
            }
            if (widget instanceof SelectWidget) {
                if (((SelectWidget)widget).isSelected()) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineSelectWidget)widget).getText() + "\n");
                }
                ++index;
                continue;
            }
            if (widget instanceof HTMLWidget) {
                ++index;
                continue;
            }
            if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
                List widgetsBox = null;
                if (widget instanceof RadioBoxWidget) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineRadioBoxWidget)widget).getTitle());
                    widgetsBox = ((CmdLineRadioBoxWidget)widget).getWidgets();
                } else if (widget instanceof ComboBoxWidget) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineComboBoxWidget)widget).getTitle());
                    widgetsBox = ((CmdLineComboBoxWidget)widget).getWidgets();
                }
                textBuffer.append("\n");
                boolean indexBox = true;
                Iterator j = widgetsBox.iterator();
                while (j.hasNext()) {
                    Widget widgetInBox = (Widget)j.next();
                    if (!((SelectWidget)widgetInBox).isSelected()) continue;
                    widgetText = widgetInBox.getText() + " ";
                    textBuffer.append(widgetText + "\n");
                }
                widgetText = "";
                ++index;
                continue;
            }
            ++index;
        }
        textBuffer.append("\n");
        textBuffer.append("\n");
    }

    private void printLastForm(String text) {
        List widgets = this.getLastForm().getWidgets();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (!(widget instanceof CmdLineInformationWidget)) continue;
            ((CmdLineInformationWidget)widget).setText(text);
        }
    }

    private void repeat(String text, int times, StringBuffer textBuffer) {
        for (int i = 0; i < times; ++i) {
            textBuffer.append(text);
        }
        textBuffer.append("\n");
    }

    public Document run() {
        CmdLineController controller = new CmdLineController(this);
        return controller.run();
    }

    public ResponseError output(Form form) {
        ResponseError responseError;
        Object result = null;
        String outFormsData = form.getOutForms();
        if (outFormsData != null) {
            StringTokenizer st = new StringTokenizer(outFormsData, ",");
            this.outForms = new ArrayList();
            try {
                while (st.hasMoreElements()) {
                    String formEntity = (String)st.nextElement();
                    this.outForms.add(formEntity);
                }
            }
            catch (NoSuchElementException e) {
                LOG.severe(CommonUtil.getStackTrace((Throwable)e));
            }
            Document wizardDocument = this.output();
            String outCall = form.getOutCall();
            LOG.finest("outForms = " + this.outForms);
            LOG.finest("outCall = " + outCall);
            responseError = this.outCall(outCall, wizardDocument);
        } else {
            responseError = new ResponseError(null, null, "0", null);
        }
        return responseError;
    }

    private Document output() {
        Document wizardDocument = this.buildWizardDocument();
        return wizardDocument;
    }

    public ResponseError outCall(String outCall, Document wizardDocument) {
        Document theDocument = null;
        String result = null;
        ResponseError responseError = null;
        String code = null;
        String severity = "";
        String token = null;
        if (outCall.equalsIgnoreCase("1")) {
            theDocument = this.authenticateUser(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else if (this.outAsset) {
                token = response.getText();
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode() + "a";
                    severity = responseError.getSeverity();
                } else {
                    this.assetId = response.getText();
                    code = "0";
                    severity = "";
                }
                LOG.info("asset return code = " + code);
                if (code.equals("0")) {
                    this.assetId = response.getText();
                    CmdLineGlobalObject.assetRegistered = true;
                } else if (code != null) {
                    this.assetId = null;
                    result = MessageTable.getCode(code);
                    if (result == null) {
                        code = "9999";
                        severity = "F";
                    } else {
                        code = result;
                    }
                } else {
                    code = "9999";
                    severity = "F";
                    this.assetId = null;
                }
            } else {
                code = "0";
                severity = "";
            }
        } else if (outCall.equalsIgnoreCase("2")) {
            Response response;
            ArrayList errorList = null;
            if (this.AssetRegistrationFailed) {
                theDocument = this.authenticateUser(wizardDocument);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    theDocument = this.registerUser(wizardDocument);
                    response = this.constructResponse(theDocument);
                    errorList = response.getErrorList();
                }
            } else {
                theDocument = this.registerUser(wizardDocument);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
            }
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                code = "0";
                severity = "";
            }
            LOG.info("user return code = " + code);
            if (code.equals("0")) {
                token = response.getText();
            } else {
                code = MessageTable.getCode(code);
            }
            if (code != null && code.equals("0") && this.outAsset) {
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode();
                    severity = responseError.getSeverity();
                } else {
                    code = "0";
                    severity = "";
                    this.assetId = response.getText();
                }
                LOG.info("asset return code = " + code);
                if (code.equals("0")) {
                    this.assetId = response.getText();
                    this.AssetRegistrationFailed = false;
                    CmdLineGlobalObject.assetRegistered = true;
                } else {
                    this.AssetRegistrationFailed = true;
                    this.assetId = null;
                    result = MessageTable.getCode(code);
                    if (result == null) {
                        code = "9999";
                        severity = "F";
                    } else {
                        code = result;
                    }
                }
            } else if (code == null) {
                code = "9999";
                severity = "F";
            }
        } else if (outCall.equalsIgnoreCase("3")) {
            theDocument = this.storeLPS(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                code = "0";
                severity = "";
            }
        } else if (outCall.equalsIgnoreCase("4")) {
            theDocument = this.authenticateUser(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                token = response.getText();
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode() + "a";
                    severity = responseError.getSeverity();
                } else {
                    code = "0";
                    severity = "";
                }
            }
        } else {
            LOG.severe("Invalid outCall " + outCall);
            code = "9999";
            severity = "F";
        }
        LOG.info("message code = " + code);
        responseError = responseError != null ? new ResponseError(responseError.getText(), responseError.getType(), code, severity) : new ResponseError(null, "user", code, severity);
        return responseError;
    }

    private Document storeLPS(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.LPSAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(class$org$jdom$Document == null ? (class$org$jdom$Document = CmdLineWizard.class$("org.jdom.Document")) : class$org$jdom$Document);
            Object obj = cons.newInstance(initArgs);
            Method setURL = c.getMethod("setURL", null);
            result = (Document)setURL.invoke(obj, null);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private Document authenticateUser(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.eCRAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(class$org$jdom$Document == null ? (class$org$jdom$Document = CmdLineWizard.class$("org.jdom.Document")) : class$org$jdom$Document);
            Object obj = cons.newInstance(initArgs);
            Method authenticateUser = c.getMethod("authenticateUser", null);
            result = (Document)authenticateUser.invoke(obj, null);
        }
        catch (Exception ex) {
            LOG.severe("USER AUTHENTICATION FAILED: " + ex.toString());
        }
        return result;
    }

    private Document registerUser(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.eCRAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(class$org$jdom$Document == null ? (class$org$jdom$Document = CmdLineWizard.class$("org.jdom.Document")) : class$org$jdom$Document);
            Object obj = cons.newInstance(initArgs);
            Method registerUser = c.getMethod("registerUser", null);
            result = (Document)registerUser.invoke(obj, null);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private Document registerAsset(Document wizardDocument) {
        boolean isAuthenticated = false;
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.AssetAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(class$org$jdom$Document == null ? (class$org$jdom$Document = CmdLineWizard.class$("org.jdom.Document")) : class$org$jdom$Document);
            Object obj = cons.newInstance(initArgs);
            Method registerAsset = c.getMethod("registerAsset", null);
            result = (Document)registerAsset.invoke(obj, null);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private Document registerAsset(Document wizardDocument, String token) {
        boolean isAuthenticated = false;
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.AssetAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(class$org$jdom$Document == null ? (class$org$jdom$Document = CmdLineWizard.class$("org.jdom.Document")) : class$org$jdom$Document);
            Object obj = cons.newInstance(initArgs);
            initArgs = new Object[]{token};
            Method registerAsset = c.getMethod("registerXMLAsset", class$java$lang$String == null ? (class$java$lang$String = CmdLineWizard.class$("java.lang.String")) : class$java$lang$String);
            result = (Document)registerAsset.invoke(obj, initArgs);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    public void closeCSMAuthFrame() {
        try {
            Class<?> csmauthClass = Class.forName("com.sun.cns.basicreg.adapter.CSMAuthAdapter");
            Method getInstance = csmauthClass.getMethod("getInstance", null);
            Object csmauthObject = getInstance.invoke(null, null);
            Method closeFrame = csmauthClass.getMethod("closeFrame", null);
            closeFrame.invoke(csmauthObject, null);
            LOG.info("CSMAuth frame is closed");
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
    }

    private Response constructResponse(Document theDocument) {
        Response response = null;
        ArrayList<ResponseError> errorList = new ArrayList<ResponseError>();
        String result = "";
        ElementFilter filter = new ElementFilter("Response");
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                String type = element.getAttributeValue("type");
                String text = element.getText();
                response = new Response(text, type);
                ElementFilter errorFilter = new ElementFilter("Error");
                Iterator theErrorIter = theDocument.getDescendants((Filter)errorFilter);
                while (theErrorIter.hasNext()) {
                    try {
                        Element elementError = (Element)theErrorIter.next();
                        ResponseError responseError = new ResponseError(elementError.getText(), elementError.getAttributeValue("type"), elementError.getAttributeValue("code"), elementError.getAttributeValue("severity"));
                        errorList.add(responseError);
                    }
                    catch (NullPointerException npe) {}
                }
                response.setErrorList(errorList);
            }
            catch (NullPointerException npe) {}
        }
        return response;
    }

    private void initialize() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.identifier);
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build(inputStream);
        }
        catch (JDOMException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.forms = new ArrayList();
        if (document != null) {
            Element rootElm = document.getRootElement();
            this.outputFile = CmdLineWizard.getAttributeValue(rootElm, "outputFile");
            this.title = CmdLineWizard.getAttributeValue(rootElm, "title");
            List formElms = rootElm.getChildren("form");
            Iterator i = formElms.iterator();
            while (i.hasNext()) {
                this.forms.add(this.createForm((Element)i.next()));
            }
        }
        this.globalObject = CmdLineGlobalObject.getInstance();
        CmdLineGlobalObject.assetRegistered = false;
        String formId = null;
        Object storedFormReload = null;
        if (CmdLineGlobalObject.forms != null) {
            LOG.info("restore from global object");
            int formIndex = 0;
            Iterator i = this.forms.iterator();
            while (i.hasNext()) {
                Form form = (Form)i.next();
                if (form.isReLoad() && (formId = this.getFormIdentifier(formIndex)) != null) {
                    storedFormReload = CmdLineGlobalObject.forms.get(formId);
                    if (storedFormReload != null) {
                        this.formReload = storedFormReload;
                        form.setReLoad(this.formReload);
                    }
                }
                ++formIndex;
            }
        } else {
            CmdLineGlobalObject.forms = new HashMap();
            LOG.info("initialize global object");
            int formIndex = 0;
            Iterator i = this.forms.iterator();
            while (i.hasNext()) {
                Form form = (Form)i.next();
                CmdLineGlobalObject.forms.put(this.getFormIdentifier(formIndex), new Boolean(form.isReLoad()));
                ++formIndex;
            }
        }
    }

    private Form createForm(Element element) {
        CmdLineForm result = new CmdLineForm(this, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "popup"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "start"), CmdLineWizard.getAttributeValue(element, "finish"), CmdLineWizard.getAttributeValue(element, "confirm"), CmdLineWizard.getAttributeValue(element, "navigator"), CmdLineWizard.getAttributeValue(element, "backId"), CmdLineWizard.getAttributeValue(element, "nextId"), CmdLineWizard.getAttributeValue(element, "outcall"), CmdLineWizard.getAttributeValue(element, "outforms"));
        List widgetElms = element.getChildren();
        Iterator i = widgetElms.iterator();
        while (i.hasNext()) {
            result.addWidget(this.createWidget((Element)i.next(), result));
        }
        return result;
    }

    private Widget createWidget(Element element, Form form) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        String name = element.getName();
        result = name.equalsIgnoreCase(WidgetType.MESSAGE.toString()) ? new CmdLineMessageWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), "no", CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "columns"), CmdLineWizard.getAttributeValue(element, "rows"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc")) : (name.equalsIgnoreCase(WidgetType.FIELD.toString()) ? new CmdLineFieldWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "length"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.PASSWORD.toString()) ? new CmdLinePasswordWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "length"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.SELECT.toString()) ? new CmdLineSelectWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "slaveId"), CmdLineWizard.getAttributeValue(element, "slaveValue"), CmdLineWizard.getAttributeValue(element, "continueCheck"), CmdLineWizard.getAttributeValue(element, "selectType"), CmdLineWizard.getAttributeValue(element, "groupId"), CmdLineWizard.getAttributeValue(element, "selected"), CmdLineWizard.getAttributeValue(element, "nextFormIdIfSelected"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.RADIOBOX.toString()) ? new CmdLineRadioBoxWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), element, CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "orientation"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor")) : (name.equalsIgnoreCase(WidgetType.COMBOBOX.toString()) ? new CmdLineComboBoxWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), element, CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "load"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "size"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.INFORMATION.toString()) ? new CmdLineInformationWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "columns"), CmdLineWizard.getAttributeValue(element, "rows"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor")) : (name.equalsIgnoreCase(WidgetType.JUMP.toString()) ? new CmdLineJumpWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "toformid"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "showButton"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.LINK.toString()) ? new CmdLineLinkWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "url"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "showButton"), CmdLineWizard.getAttributeValue(element, "endsWizard"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic")) : (name.equalsIgnoreCase(WidgetType.TEXTICONLABEL.toString()) ? new CmdLineTextIconLabelWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "labeliconfilename"), CmdLineWizard.getAttributeValue(element, "labelicondescription"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc")) : (name.equalsIgnoreCase(WidgetType.HTML.toString()) ? new CmdLineHTMLWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "id")) : (name.equalsIgnoreCase(WidgetType.HIDDEN.toString()) ? new CmdLineHiddenWidget(CmdLineWizard.getText(element)) : (name.equalsIgnoreCase(WidgetType.REFLECTION.toString()) ? new CmdLineReflectionWidget(form, CmdLineWizard.getAttributeValue(element, "type"), CmdLineWizard.getChildText(element, "className"), CmdLineWizard.getChildText(element, "methodName"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "parentid"), CmdLineWizard.getAttributeValue(element, "asset"), CmdLineWizard.getAttributeValue(element, "htmlformid"), CmdLineWizard.getAttributeValue(element, "limitedhtmlformid")) : new CmdLineUnknownWidget(CmdLineWizard.getText(element))))))))))))));
        return result;
    }

    private Widget createWidget(WidgetType type, String text, String id, String parentId, boolean asset, boolean isReload, String htmlFormId, String limitedHtmlFormId) {
        CmdLineWidget result;
        String i18nText = CmdLineWizard.getI18NValue(text);
        if (type == WidgetType.MESSAGE) {
            result = new CmdLineMessageWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.FIELD) {
            result = new CmdLineFieldWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.PASSWORD) {
            result = new CmdLinePasswordWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.SELECT) {
            result = new CmdLineSelectWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.RADIOBOX) {
            result = new CmdLineRadioBoxWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.COMBOBOX) {
            result = new CmdLineComboBoxWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.INFORMATION) {
            result = new CmdLineInformationWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else if (type == WidgetType.HIDDEN) {
            result = new CmdLineHiddenWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(htmlFormId);
        } else {
            result = new CmdLineUnknownWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
        }
        return result;
    }

    private void processReflectionWidgets(Form form, int index) {
        if (form.isProcessed()) {
            return;
        }
        List widgets = form.getWidgets();
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (widget instanceof ReflectionWidget && !form.isReLoad() || widget instanceof ReflectionWidget && !widget.isReload()) {
                Object result = null;
                ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
                try {
                    Class<?> clazz = Class.forName(reflectWidget.getClassName());
                    Constructor<?> constructor = clazz.getConstructor(null);
                    Object object = constructor.newInstance(null);
                    Method method = clazz.getMethod(reflectWidget.getMethodName(), null);
                    result = method.invoke(object, null);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                if (result != null) {
                    if (result instanceof List) {
                        List results = (List)result;
                        Iterator j = results.iterator();
                        while (j.hasNext()) {
                            StringReader stringReader;
                            String content = j.next().toString();
                            newWidgets.add(this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
                            if (widget.getHTMLFormId() != null) {
                                stringReader = new StringReader(content);
                                this.convertXML2HTML(stringReader, widget.getHTMLFormId(), "F");
                            }
                            if (widget.getLimitedHTMLFormId() == null) continue;
                            stringReader = new StringReader(content);
                            this.convertXML2HTML(stringReader, widget.getLimitedHTMLFormId(), "P");
                        }
                        continue;
                    }
                    if (!(result instanceof Object)) continue;
                    newWidgets.add(this.createWidget(reflectWidget.getTargetType(), result.toString(), widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
                    continue;
                }
                newWidgets.add(this.createWidget(reflectWidget.getTargetType(), "", widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
                continue;
            }
            if (!(widget instanceof ReflectionWidget) || !widget.isReload()) continue;
            ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
            newWidgets.add(this.createWidget(reflectWidget.getTargetType(), "", widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId()));
            if (index != 0) continue;
            this.forceToReload = true;
        }
        i = newWidgets.iterator();
        while (i.hasNext()) {
            form.addWidget((Widget)i.next());
        }
    }

    private void convertXML2HTML(StringReader stringReader, String htmlFormId, String docControl) {
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build((Reader)stringReader);
        }
        catch (JDOMException e) {
            LOG.severe(e.getMessage());
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        if (document != null) {
            LOG.finest("it is ready to convert");
            Element rootElm = document.getRootElement();
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = docControl.equalsIgnoreCase("F") ? classLoader.getResourceAsStream("wizards/asset.xsl") : (docControl.equalsIgnoreCase("P") ? classLoader.getResourceAsStream("wizards/limitedasset.xsl") : classLoader.getResourceAsStream("wizards/asset.xsl"));
            Document outDocument = null;
            try {
                XSLTransformer transformer = new XSLTransformer(inputStream);
                outDocument = transformer.transform(document);
                if (new Boolean(this.globalObject.getPropertyValue("asset.enabled", "false")).booleanValue()) {
                    this.location = this.globalObject.getPropertyValue("asset.location", "/tmp/");
                    this.dateTimeStampBoolean = new Boolean(this.globalObject.getPropertyValue("asset.datetimestamp", "true"));
                    this.fileNamePrefix = this.globalObject.getPropertyValue("asset.filename.prefix", "asset-output");
                    this.fileNameSuffix = this.globalObject.getPropertyValue("asset.filename.suffix", ".html");
                    this.dateTimeStamp = CommonUtil.getDateTimeStamp();
                    this.filePattern = this.dateTimeStampBoolean ? this.location + this.fileNamePrefix + this.dateTimeStamp + this.fileNameSuffix : this.location + this.fileNamePrefix + this.fileNameSuffix;
                    DocOutputter.output(this.filePattern, outDocument);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DocOutputter.output(byteArrayOutputStream, outDocument);
                this.SetHTMLForForms(htmlFormId, byteArrayOutputStream.toString(), docControl.equalsIgnoreCase("P"));
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void SetHTMLForForms(String htmlFormId, String htmlText, boolean isLimited) {
        if (htmlFormId != null) {
            StringTokenizer st = new StringTokenizer(htmlFormId, ",");
            try {
                while (st.hasMoreElements()) {
                    String htmlFormEntity = (String)st.nextElement();
                    this.SetHTML(htmlFormEntity, htmlText, isLimited);
                }
            }
            catch (NoSuchElementException e) {
                LOG.severe(CommonUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private void SetHTML(String htmlFormId, String htmlText, boolean isLimited) {
        Form form = null;
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            form = (Form)i.next();
            if (form.getFormIdentifier() == null || !form.getFormIdentifier().equals(htmlFormId)) continue;
            List widgets = form.getWidgets();
            Iterator j = widgets.iterator();
            while (j.hasNext()) {
                Widget widget = (Widget)j.next();
                if (!(widget instanceof HTMLWidget)) continue;
                String htmlCleanText = htmlText;
                if (htmlText.startsWith("<?xml")) {
                    htmlCleanText = htmlText.substring(htmlText.indexOf(10) + 1);
                }
                LOG.finest("  >>>> SetHTML on html widget " + htmlFormId + " to: " + htmlCleanText);
                String i18nHtmlText = I18N.getI18NAssetInfoHTML(htmlCleanText, isLimited);
                widget.setText(i18nHtmlText);
            }
        }
    }

    public static String getAttributeValue(Element element, String attributeName) {
        String literalValue = element.getAttributeValue(attributeName);
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getText(Element element) {
        String literalValue = element.getText();
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getChildText(Element element, String childName) {
        String literalValue = element.getChildText(childName);
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getI18NValue(String literalValue) {
        if (literalValue == null) {
            return null;
        }
        if (literalValue.trim().startsWith(I18N_KEY_FLAG)) {
            return I18N.getXMLValueString(literalValue.trim());
        }
        return literalValue;
    }

    public Document getDocument() {
        Document wizardDocument = this.buildWizardDocument();
        if (wizardDocument != null && new Boolean(this.globalObject.getPropertyValue("profile.enabled", "false")).booleanValue()) {
            this.location = this.globalObject.getPropertyValue("profile.location", "/tmp/");
            this.dateTimeStampBoolean = new Boolean(this.globalObject.getPropertyValue("profile.datetimestamp", "true"));
            this.fileNamePrefix = this.globalObject.getPropertyValue("profile.filename.prefix", this.outputFile);
            if (this.fileNamePrefix.trim() == null || this.fileNamePrefix.trim().equals("")) {
                this.fileNamePrefix = this.outputFile;
            }
            this.fileNameSuffix = this.globalObject.getPropertyValue("profile.filename.suffix", ".xml");
            if (this.fileNameSuffix.trim() == null || this.fileNameSuffix.trim().equals("")) {
                this.fileNameSuffix = ".xml";
            }
            this.dateTimeStamp = CommonUtil.getDateTimeStamp();
            this.filePattern = this.dateTimeStampBoolean ? this.location + this.fileNamePrefix + this.dateTimeStamp + this.fileNameSuffix : this.location + this.fileNamePrefix + this.fileNameSuffix;
            DocOutputter.output(this.filePattern, wizardDocument);
        }
        return wizardDocument;
    }

    private Document buildWizardDocument() {
        this.outAsset = false;
        boolean outAssetID = false;
        Document result = null;
        Element wizardElm = null;
        Form form = null;
        Iterator i = this.forms.iterator();
        while (i.hasNext()) {
            form = (Form)i.next();
            if (!this.isInOutForms(form)) continue;
            if (!outAssetID) {
                result = new Document();
                wizardElm = this.createDoc();
                outAssetID = true;
            }
            wizardElm.addContent((Content)this.buildFormElement(form));
        }
        if (outAssetID) {
            result.setRootElement(wizardElm);
        }
        return result;
    }

    private Element createDoc() {
        Element wizardElm = new Element("wizard");
        wizardElm.setAttribute("outputfile", this.outputFile);
        Element formElm = new Element("form");
        formElm.setAttribute("title", "asset id information");
        Element widget = new Element("widget");
        widget.setAttribute("id", "assetId");
        Element response = new Element("response");
        CDATA data = new CDATA(this.assetId);
        response.addContent((Content)data);
        widget.addContent((Content)response);
        formElm.addContent((Content)widget);
        wizardElm.addContent((Content)formElm);
        return wizardElm;
    }

    private boolean isInOutForms(Form form) {
        String formId = form.getFormIdentifier();
        String outFormEntity = null;
        if (this.outForms == null) {
            return false;
        }
        Iterator i = this.outForms.iterator();
        while (i.hasNext()) {
            outFormEntity = (String)i.next();
            if (!outFormEntity.equals(formId)) continue;
            return true;
        }
        return false;
    }

    private Element buildFormElement(Form form) {
        Element result = new Element("form");
        result.setAttribute("id", form.getFormIdentifier());
        result.setAttribute("title", form.getTitle());
        List widgets = form.getWidgets();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (widget instanceof ReflectionWidget || !this.isBuildWidgetElement(widget, form)) continue;
            result.addContent((Content)this.buildWidgetElement(widget));
        }
        return result;
    }

    private boolean isBuildWidgetElement(Widget widget, Form form) {
        boolean outWidget;
        if (widget.getParentId() != null) {
            LOG.finest("parentid = " + widget.getParentId());
            LOG.finest("asset = " + widget.isAsset());
            if (this.checkParentStatus(widget.getParentId(), form)) {
                outWidget = true;
                if (widget.isAsset()) {
                    this.outAsset = true;
                }
            } else {
                outWidget = false;
            }
        } else {
            outWidget = true;
        }
        return outWidget;
    }

    private Element buildWidgetElement(Widget widget) {
        Element result = new Element("widget");
        result.setAttribute("type", widget.getType().toString());
        if (widget.getId() != null) {
            result.setAttribute("id", widget.getId());
        }
        CDATA text = new CDATA(widget.getText());
        Element textElm = new Element("text");
        textElm.setContent((Content)text);
        result.addContent((Content)textElm);
        if (widget instanceof ResponseWidget) {
            CDATA response = new CDATA(((ResponseWidget)((Object)widget)).getResponse());
            Element responseElm = new Element("response");
            responseElm.setContent((Content)response);
            result.addContent((Content)responseElm);
        } else if (widget instanceof SelectWidget) {
            Element selectedElm = new Element("response");
            selectedElm.setText(Boolean.toString(((SelectWidget)widget).isSelected()));
            result.addContent((Content)selectedElm);
        } else if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
            List widgetsBox = null;
            if (widget instanceof RadioBoxWidget) {
                widgetsBox = ((CmdLineRadioBoxWidget)widget).getWidgets();
            } else if (widget instanceof ComboBoxWidget) {
                widgetsBox = ((CmdLineComboBoxWidget)widget).getWidgets();
            }
            Iterator j = widgetsBox.iterator();
            while (j.hasNext()) {
                Widget widgetInBox = (Widget)j.next();
                if (!((SelectWidget)widgetInBox).isSelected()) continue;
                CDATA select = new CDATA(((CmdLineSelectWidget)widgetInBox).getText());
                Element selectedElm = new Element("response");
                selectedElm.setContent((Content)select);
                result.addContent((Content)selectedElm);
            }
        } else if (widget instanceof CmdLineHiddenWidget) {
            Element hiddenElm = new Element("response");
            hiddenElm.setText("NONE");
            result.addContent((Content)hiddenElm);
        }
        return result;
    }

    private boolean checkParentStatus(String id, Form form) {
        if (id.equals("$YES$")) {
            return true;
        }
        List widgets = form.getWidgets();
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (widget.getId() == null || !widget.getId().equals(id) || !(widget instanceof CmdLineSelectWidget)) continue;
            if (((CmdLineSelectWidget)widget).isSelected()) {
                LOG.finest("it is selected");
                return true;
            }
            LOG.finest("it is not selected");
            return false;
        }
        return false;
    }

    private void repeat(String text, int times) {
        for (int i = 0; i < times; ++i) {
            System.out.print(text);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

